/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.fi.ai.formplugin.FactorInfo;
import kd.fi.ai.formplugin.dao.AcctFactorReader;

public class AcctFactorList
extends AbstractFormPlugin
implements RowClickEventListener {
    public static final String FormId_AcctFactorList = "ai_acctfactorlist";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        if ("btnok".equalsIgnoreCase(evt.getItemKey())) {
            this.getView().returnDataToParent(this.getCurrentSelector());
            this.getView().close();
        } else if ("btncancel".equalsIgnoreCase(evt.getItemKey())) {
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject eo) {
        List<FactorInfo> factorList = null;
        String entitySetStr = (String)this.getView().getFormShowParameter().getCustomParam("EntitySet");
        if (StringUtils.isNotEmpty((String)entitySetStr)) {
            Set entitySet = (Set)SerializationUtils.fromJsonString((String)entitySetStr, Set.class);
            factorList = AcctFactorReader.LoadFactorList(entitySet);
        } else {
            factorList = AcctFactorReader.LoadFactorList();
        }
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow("entryentity", factorList.size());
        int rowIndex = 0;
        for (FactorInfo factorInfo : factorList) {
            model.setValue("fseq", (Object)(rowIndex + 1), rowIndex);
            model.setValue("fsrcentitynumber", (Object)factorInfo.getSrcEntityNumber(), rowIndex);
            model.setValue("fsrcentityname", (Object)factorInfo.getSrcEntityName(), rowIndex);
            model.setValue("fsrcpropkey", (Object)factorInfo.getSrcPropKey(), rowIndex);
            model.setValue("fsrcpropname", (Object)factorInfo.getSrcPropName(), rowIndex);
            model.setValue("ffactorname", (Object)factorInfo.getFactorName(), rowIndex);
            model.setValue("ftopclass", (Object)factorInfo.getTopClass(), rowIndex);
            model.setValue("fsubsystem", (Object)factorInfo.getSubSystem(), rowIndex);
            model.setValue("fbdtype", (Object)factorInfo.getBDType(), rowIndex);
            ++rowIndex;
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
    }

    private List<Map<String, String>> getCurrentSelector() {
        ArrayList<Map<String, String>> retList = new ArrayList<Map<String, String>>();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows != null && rows.length > 0) {
            for (int row : rows) {
                HashMap<String, String> ret = new HashMap<String, String>();
                ret.put("fsrcentitynumber", (String)this.getModel().getValue("fsrcentitynumber", row));
                ret.put("fsrcentityname", (String)this.getModel().getValue("fsrcentityname", row));
                ret.put("fbdtype", (String)this.getModel().getValue("fbdtype", row));
                retList.add(ret);
            }
        } else {
            return retList;
        }
        return retList;
    }

    public void entryRowClick(RowClickEvent arg0) {
    }
}

