/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.func.FuncSettingHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.FormulaException;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.threads.ThreadPools;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.VchReturnData;
import kd.fi.ai.formplugin.botp.ConditionEdit;
import kd.fi.ai.formplugin.botp.FormulaEditHelper;
import kd.fi.ai.util.AiEventMetaUtil;
import kd.fi.ai.util.BuildTree;
import kd.fi.ai.util.DapEntityTypeUtil;
import kd.fi.ai.util.EntityFieldUtil;

public class AiConditionEdit
extends ConditionEdit
implements TreeNodeQueryListener,
SearchEnterListener,
TabSelectListener {
    public static final String TREE_VIEW_ROOT_VISIBLE = "treeViewRootVisible";
    private static final String BUILD = "build";
    private static final String READ_CHILD = "readChild";
    private static final String INCLUDE_ID = "inCludeId";
    private static final String FALSE = "false";
    private static final String FDATASCOPEDESC = "fdatascopedesc";
    private static final String SEARCHFIELD = "searchfield";

    @Override
    public void initialize() {
        super.initialize();
        TreeView tv = (TreeView)this.getView().getControl("tv_fields");
        tv.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        Search search = (Search)this.getView().getControl(SEARCHFIELD);
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
        Tab c = (Tab)this.getView().getControl("tabap_condition");
        c.addTabSelectListener((TabSelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        String id = (String)this.getView().getFormShowParameter().getCustomParam(BUILD);
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("hideExpression") && ((Boolean)customParams.get("hideExpression")).booleanValue()) {
            Tab tab = (Tab)this.getControl("tabap_condition");
            tab.deleteControls(new String[]{"tabpageap_expression"});
        }
        String entityNumber = (String)customParams.get("entitynumber");
        boolean isevent = customParams.containsKey("isevent") && (Boolean)customParams.get("isevent") != false;
        List filterColumns = (List)customParams.get("filterColumns");
        if (filterColumns == null && StringUtils.isNotBlank((CharSequence)entityNumber)) {
            MainEntityType entityType = null;
            entityType = isevent ? AiEventMetaUtil.getEntityType((Object)Long.valueOf(entityNumber)) : EntityMetadataCache.getDataEntityType((String)entityNumber);
            filterColumns = DapEntityTypeUtil.getFilterColumnsAll((IDataEntityType)entityType);
        }
        if (filterColumns != null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("ffiltergrid");
            filterGrid.setFilterColumns(filterColumns);
            if (!isevent) {
                filterGrid.setEntityNumber(entityNumber);
            }
        }
    }

    private MainEntityType getEntityType() {
        String id = (String)this.getView().getFormShowParameter().getCustomParam(BUILD);
        String isEvent = (String)this.getView().getFormShowParameter().getCustomParam("event");
        MainEntityType srcMainET = BuildTree.getMainType((String)isEvent, (String)id);
        return srcMainET;
    }

    private boolean getBuildTreeParam(String param) {
        String value = this.getPageCache().get(param);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return true;
        }
        return !FALSE.equals(value);
    }

    private TreeNode getTreeNode() {
        TreeNode rootNode = BuildTree.buildSimpleTree((MainEntityType)this.getEntityType(), (String)FDATASCOPEDESC, (ExpressionType)ExpressionType.Condition, (boolean)this.getBuildTreeParam(READ_CHILD), null, (boolean)this.getBuildTreeParam(INCLUDE_ID));
        return rootNode;
    }

    @Override
    public void click(EventObject evt) {
        try {
            Control ctlSource;
            IDataModel model = this.getModel();
            MainEntityType type = this.getModel().getDataEntityType();
            if (!type.getName().equals("ai_condition")) {
                Field field = model.getClass().getSuperclass().getDeclaredField("mainEntityType");
                ReflectionUtils.makeAccessible((Field)field);
                field.set(model, null);
            }
            if ("btnok".equalsIgnoreCase((ctlSource = (Control)evt.getSource()).getKey())) {
                this.checkOutEntry();
            } else {
                this.getView().getFormShowParameter().setCustomParam("treenodes", (Object)this.getPageCache().get("treenodes"));
                super.click(evt);
            }
        }
        catch (Throwable e) {
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        CRCondition conditionObj;
        FilterCondition filterCondition;
        String id = (String)this.getView().getFormShowParameter().getCustomParam(BUILD);
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        String conditonJson = (String)this.getView().getFormShowParameter().getCustomParam("formula");
        if (StringUtils.isNotBlank((CharSequence)conditonJson) && (filterCondition = (conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)conditonJson, CRCondition.class)).getFilterCondition()) != null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("ffiltergrid");
            filterGrid.SetValue(filterCondition);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getProperty().getName().equalsIgnoreCase("fexpression")) {
            String expression = (String)this.getModel().getValue("fexpression");
            if (StringUtils.isBlank((CharSequence)expression)) {
                this.getModel().setValue("ftranexpr", (Object)"");
                this.getModel().setValue("fdescription", (Object)"");
                return;
            }
            String tranExpr = "";
            try {
                tranExpr = BuildTree.tranExpression((String)expression, (MainEntityType)this.getEntityType());
            }
            catch (FormulaException exp) {
                tranExpr = exp.getMessage();
            }
            catch (Throwable exp) {
                tranExpr = ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u89e3\u6790\u51fa\u9519\uff0c\u81ea\u52a8\u7ffb\u8bd1\u5931\u8d25\u3002", (String)"AiConditionEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]);
            }
            this.getModel().setValue("ftranexpr", (Object)tranExpr);
        }
    }

    @Override
    public void treeNodeClick(TreeNodeEvent e) {
        String nodeID = e.getNodeId().toString();
        String[] split = nodeID.replace("{", "").replace("}", "").split("#");
        String expression = split[split.length - 1];
        FormulaEditHelper.insertExpression(this.getView(), "tv_fields", "fexpression", expression);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        boolean isevent;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entityNumber = (String)customParams.get("entitynumber");
        boolean bl = isevent = customParams.containsKey("isevent") && (Boolean)customParams.get("isevent") != false;
        if (isevent) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            for (int i = 1; i < 10; ++i) {
                if (stackTrace[i].toString().indexOf("kd.bos.form.control.FilterGrid.getMainEntityType") != 0) continue;
                MainEntityType newEntityType = AiEventMetaUtil.getEntityType((Object)Long.valueOf(entityNumber));
                e.setNewEntityType(newEntityType);
                return;
            }
        }
    }

    private void checkOutEntry() {
        String conditonJson = "";
        CRFormula formulaObj = this.deserialize(conditonJson);
        this.getFormulaObj(formulaObj);
        try {
            if (StringUtils.isNotBlank((CharSequence)formulaObj.getExpression())) {
                FormulaEngine.extractVariables((String)formulaObj.getExpression());
            }
            String tranExpr = this.tranFormula(formulaObj);
            formulaObj.setExprTran(tranExpr);
        }
        catch (FormulaException exp) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u9519\u8bef\uff1a\u201c%s\u201d\u3002", (String)"AiConditionEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]), exp.getCause() != null ? exp.getCause().getMessage() : exp.getMessage()));
            return;
        }
        catch (Throwable exp) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u9519\u8bef\uff1a\u201c%s\u201d\u3002", (String)"AiConditionEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]), exp.getMessage()));
            return;
        }
        String currentFormId = (String)this.getView().getFormShowParameter().getCustomParam("ai_button_key");
        String entitynumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        String cacheValue = EntityFieldUtil.getCacheValueFromFormParameter((IFormView)this.getView());
        VchReturnData returnData = EntityFieldUtil.validateDiffEntry((Object)formulaObj, (String)currentFormId, (String)entitynumber, (String)cacheValue);
        if (returnData.isStatus()) {
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)returnData));
            this.getPageCache().remove("treenodes");
            this.getView().close();
        } else if (!returnData.isStatus() && StringUtils.isNotEmpty((CharSequence)returnData.getMessage())) {
            this.getView().showTipNotification(returnData.getMessage());
        }
    }

    @Override
    protected String tranFormula(CRFormula formulaObj) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        MainEntityType mainType = null;
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return BuildTree.tranExpression((String)formulaObj.getExpression(), mainType);
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        boolean isevent = customParams.containsKey("isevent") && (Boolean)customParams.get("isevent") != false;
        mainType = isevent ? AiEventMetaUtil.getEntityType((Object)Long.valueOf(entityNumber)) : EntityMetadataCache.getDataEntityType((String)entityNumber);
        String tranExpr = BuildTree.tranExpression((String)formulaObj.getExpression(), (MainEntityType)mainType);
        FilterCondition filterCondition = ((CRCondition)formulaObj).getFilterCondition();
        if (filterCondition != null && filterCondition.getFilterRow().size() > 0) {
            FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
            String[] scripts = filterBuilder.buildFilterScript();
            ArrayList<String> descs = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)scripts[1])) {
                descs.add(scripts[1]);
            }
            if (StringUtils.isNotBlank((CharSequence)tranExpr)) {
                descs.add(tranExpr);
            }
            tranExpr = StringUtils.join((Object[])descs.toArray(), (String)ResManager.loadKDString((String)"\u4e14", (String)"AiConditionEdit_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
        return tranExpr;
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        String json = this.getPageCache().get("treenodes");
        if (StringUtils.equals((CharSequence)SEARCHFIELD, (CharSequence)search.getKey()) && StringUtils.isNotBlank((CharSequence)json)) {
            String searchText = evt.getText();
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
            TreeView tree = (TreeView)this.getView().getControl("tv_fields");
            tree.updateNode(BuildTree.searchTree((String)searchText, (TreeNode)rootNode));
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent arg0) {
        TreeView treeView = (TreeView)arg0.getSource();
        String nodeId = (String)arg0.getNodeId();
        List treeNodes = BuildTree.buildSimpleLevelTree((MainEntityType)this.getEntityType(), (String)FDATASCOPEDESC, (ExpressionType)ExpressionType.Condition, (boolean)this.getBuildTreeParam(READ_CHILD), null, (boolean)this.getBuildTreeParam(INCLUDE_ID), (String)nodeId);
        treeView.addNodes(treeNodes);
    }

    public void tabSelected(TabSelectEvent arg0) {
        String key = arg0.getTabKey();
        if ("tabpageap_expression".equalsIgnoreCase(key)) {
            if (this.getPageCache().get("tabpageap_expression_inited") != null) {
                return;
            }
            MainEntityType srcMainET = this.getEntityType();
            if (this.getPageCache().get("treenodes") == null) {
                ThreadPools.executeOnceIncludeRequestContext((String)"AiConditionEdit.buildTree", () -> this.buildTreeNodes(srcMainET));
            }
            String conditonJson = (String)this.getView().getFormShowParameter().getCustomParam("formula");
            CRFormula formulaObj = this.deserialize(conditonJson);
            this.getModel().setValue("fexpression", (Object)formulaObj.getExpression());
            String tranExpr = BuildTree.tranExpression((String)formulaObj.getExpression(), (MainEntityType)srcMainET);
            this.getModel().setValue("ftranexpr", (Object)tranExpr);
            this.getModel().setValue("fdescription", (Object)formulaObj.getDescription());
            TreeNode treeNode = this.getTreeNode();
            TreeView treeView = (TreeView)this.getControl("tv_fields");
            treeView.addNode(treeNode);
            Boolean rootVisible = (Boolean)this.getView().getFormShowParameter().getCustomParam(TREE_VIEW_ROOT_VISIBLE);
            if (rootVisible != null) {
                treeView.setRootVisible(rootVisible.booleanValue());
            }
            this.getPageCache().put("tabpageap_expression_inited", "true");
        }
    }

    private void buildTreeNodes(MainEntityType srcMainET) {
        String srcMainEntityType = (String)this.getView().getFormShowParameter().getCustomParam("srcMainEntityType");
        TreeNode rootNode = new TreeNode();
        if ("expireDateSetHead".equals(srcMainEntityType)) {
            this.getPageCache().put(READ_CHILD, FALSE);
            this.getPageCache().put(INCLUDE_ID, FALSE);
            rootNode = BuildTree.buildTree((MainEntityType)srcMainET, (String)FDATASCOPEDESC, (ExpressionType)ExpressionType.Condition, (boolean)false, null, (boolean)false);
        } else if ("dateHead".equals(srcMainEntityType)) {
            this.getPageCache().put(READ_CHILD, FALSE);
            rootNode = BuildTree.buildTree((MainEntityType)srcMainET, (String)FDATASCOPEDESC, (ExpressionType)ExpressionType.Condition, (boolean)false, null, (boolean)true);
        } else if ("dateBody".equals(srcMainEntityType)) {
            rootNode = BuildTree.buildTree((MainEntityType)srcMainET, (String)FDATASCOPEDESC, (ExpressionType)ExpressionType.Condition, (boolean)true, null, (boolean)true);
        } else {
            this.getPageCache().put(INCLUDE_ID, FALSE);
            rootNode = BuildTree.buildTree((MainEntityType)srcMainET, (String)FDATASCOPEDESC, (ExpressionType)ExpressionType.Condition, (boolean)true, null, (boolean)false);
        }
        String jsonNode = SerializationUtils.toJsonString((Object)rootNode);
        this.getView().getFormShowParameter().setCustomParam("treenodes", (Object)jsonNode);
        this.getPageCache().put("treenodes", jsonNode);
    }

    @Override
    protected void showFuncSetting() {
        String jsonNode;
        String funcsXML = (String)this.getView().getFormShowParameter().getCustomParam("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML) && StringUtils.isBlank((CharSequence)(funcsXML = this.getPageCache().get("functiontypes")))) {
            FunctionTypes functionTypes = FunctionTypes.get();
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        if ((jsonNode = (String)this.getView().getFormShowParameter().getCustomParam("treenodes")) == null) {
            this.buildTreeNodes(this.getEntityType());
            jsonNode = (String)this.getView().getFormShowParameter().getCustomParam("treenodes");
        }
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "btnfunction");
        FuncSettingHelper.show((String)funcsXML, (String)entityNumber, (String)jsonNode, null, (IFormView)this.getView(), (CloseCallBack)closeCallBack);
    }
}

