/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.ai.enums.EventPagingEnum;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;
import kd.fi.v2.fah.utils.LicenseUtil;

public class AiEventEdit
extends AbstractBillPlugIn {
    private static final String CACHE_KEY = "AiEventEdit.cacheKey";
    private static final String EVENTCLASS = "eventclass";
    private static final String ORG = "org";
    private static final String EVENTDATA = "data";
    private static final String EVENT_NUMBER = "number";

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map eventClassData = e.getSourceData();
        String eventClassNumber = (String)eventClassData.get(EVENTCLASS);
        String orgNumber = (String)eventClassData.get(ORG);
        String eventNumber = (String)eventClassData.get(EVENT_NUMBER);
        if (StringUtils.isEmpty((String)eventClassNumber)) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u6a21\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AiEventEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if (StringUtils.isEmpty((String)orgNumber)) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4e1a\u52a1\u5355\u5143\u3002", (String)"AiEventEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if (StringUtils.isEmpty((String)eventNumber)) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AiEventEdit_4", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Object eventData = eventClassData.get(EVENTDATA);
        if (null == eventData || !(eventData instanceof Map) || ((Map)eventData).isEmpty()) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u672a\u5f55\u5165\u6570\u636e\u3002", (String)"AiEventEdit_5", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if (eventNumber.length() > 80) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u7f16\u7801\u957f\u5ea6\u4e0d\u53ef\u8d85\u8fc780\u4e2a\u5b57\u7b26\u3002", (String)"AiEventEdit_6", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        DynamicObject eventClassdDyn = this.getEventClass(eventClassNumber);
        if (eventClassdDyn == null) {
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u5916\u90e8\u6570\u636e\u6a21\u578b\u3002", (String)"AiEventEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]), eventClassNumber));
            e.setCancel(true);
            return;
        }
        if (!eventClassdDyn.getBoolean("enable")) {
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u6a21\u578b\u201c%s\u201d\u5df2\u7981\u7528\uff0c\u8bf7\u542f\u7528\u540e\u518d\u63a5\u5165\u6570\u636e\u3002", (String)"AiEventEdit_8", (String)"fi-ai-formplugin", (Object[])new Object[0]), eventClassNumber));
            e.setCancel(true);
            return;
        }
        if ("1".equals(eventClassdDyn.getString("appversion")) && !this.getLicense()) {
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u4f1a\u8ba1\u4e8b\u4ef6\u5e93\u6a21\u5757\u8bb8\u53ef\uff0c\u8bf7\u5148\u8d2d\u4e70\u8bb8\u53ef\u3002", (String)"AiEventEdit_7", (String)"fi-ai-formplugin", (Object[])new Object[0]), eventClassNumber));
            e.setCancel(true);
            return;
        }
        DynamicObject orgDyn = this.getOrg(orgNumber);
        if (orgDyn == null) {
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u4e1a\u52a1\u5355\u5143\u3002", (String)"AiEventEdit_3", (String)"fi-ai-formplugin", (Object[])new Object[0]), orgNumber));
            e.setCancel(true);
            return;
        }
        HashMap<String, Long> eventClassMap = new HashMap<String, Long>();
        eventClassMap.put("id", eventClassdDyn.getLong("id"));
        e.getSourceData().put(EVENTCLASS, eventClassMap);
        e.getSourceData().put("versionnum", eventClassdDyn.getInt("versionnum"));
        HashMap<String, String> orgMap = new HashMap<String, String>();
        orgMap.put(EVENT_NUMBER, orgNumber);
        e.getSourceData().put(ORG, orgMap);
        int maxEntrySize = this.getMaxEntrySize((Map)eventData, eventClassdDyn);
        e.getSourceData().put("entrycount", maxEntrySize);
        e.getSourceData().put(EVENTDATA, null);
        Object paging = eventClassData.get("paging");
        if (paging != null && (Boolean.parseBoolean(paging.toString()) || "uncommit".equals(paging.toString()))) {
            e.getSourceData().put("paging", EventPagingEnum.NO_COMMIT.getStatus());
        } else {
            e.getSourceData().put("paging", EventPagingEnum.COMMIT.getStatus());
        }
        Object saveDefault = eventClassData.get("savedefault");
        if (saveDefault != null) {
            ((Map)eventData).put("savedefault", Boolean.parseBoolean(saveDefault.toString()));
        }
        e.getSourceData().put("data_tag", SerializationUtils.toJsonString(eventData));
    }

    private DynamicObject getOrg(String orgNumber) {
        String cacheKey = "org_" + orgNumber;
        Function<String, DynamicObject> queryFunction = k -> QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter(EVENT_NUMBER, "=", (Object)orgNumber).toArray());
        return this.getOrgOrModelFromCache(cacheKey, queryFunction);
    }

    private DynamicObject getEventClass(String eventClassNumber) {
        String cacheKey = "eventclass_" + eventClassNumber;
        Function<String, DynamicObject> queryFunction = k -> DataModelDaoImpl.queryDataModelByNumberCommon((String)eventClassNumber);
        return this.getOrgOrModelFromCache(cacheKey, queryFunction);
    }

    private boolean getLicense() {
        String cacheKey = "license_fah";
        return (Boolean)ThreadCache.get((Object)cacheKey, LicenseUtil::hasFahLicense);
    }

    private DynamicObject getOrgOrModelFromCache(String cacheKey, Function<String, DynamicObject> queryFunction) {
        HashMap orgOrModelCache = (HashMap)ThreadCache.get((Object)CACHE_KEY, HashMap::new);
        return orgOrModelCache.computeIfAbsent(cacheKey, queryFunction);
    }

    private int getMaxEntrySize(Map<String, Object> data, DynamicObject eventClassdDyn) {
        int size = 0;
        ArrayList<String> entryNames = new ArrayList<String>();
        if ("entry".equals(eventClassdDyn.getString("fieldtype"))) {
            entryNames.add(eventClassdDyn.getString("fieldname"));
        }
        if (entryNames.isEmpty()) {
            return size;
        }
        for (String entryName : entryNames) {
            List list;
            if (data == null || !data.containsKey(entryName) || (list = (List)data.get(entryName)) == null || list.isEmpty()) continue;
            size = size > list.size() ? size : list.size();
        }
        return size;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }
}

