/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.v2.fah.dao.biz.ExtDataQueryHelper;

public class AiEventListProvider
extends ListDataProvider {
    private static final String VOUNCHERNUMBER = "vounchernumber";

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection rows = super.getData(start, limit);
        rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty(VOUNCHERNUMBER, String.class, (Object)""));
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DynamicObject row : rows) {
            ids.add((Long)row.getPkValue());
        }
        Map<String, String> idAndVouncherNumber = this.getVouncherNumber(ids);
        if (idAndVouncherNumber != null && idAndVouncherNumber.size() > 0) {
            for (DynamicObject row : rows) {
                row.set(VOUNCHERNUMBER, (Object)idAndVouncherNumber.get(row.getPkValue().toString()));
            }
        }
        return rows;
    }

    private Map<String, String> getVouncherNumber(List<Long> ids) {
        HashMap<String, String> voucherMap = new HashMap<String, String>();
        Map billTypeGroups = ExtDataQueryHelper.groupByBillType(ids);
        for (Map.Entry billTypeGroup : billTypeGroups.entrySet()) {
            List subIdList = (List)billTypeGroup.getValue();
            Map<String, String> subVoucherMap = this.getVoucherNumberByType((String)billTypeGroup.getKey(), subIdList);
            voucherMap.putAll(subVoucherMap);
        }
        return voucherMap;
    }

    private Map<String, String> getVoucherNumberByType(String billType, List<Long> ids) {
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("billtype.number", "=", (Object)billType));
        qFilters.add(new QFilter("sourcebillid", "in", ids));
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"ai_daptracker", (String)"voucherid,sourcebillid", (QFilter[])qFilters.toArray(new QFilter[0]));
        ArrayList<Long> voucherIds = new ArrayList<Long>();
        HashMap<String, List> idMap = new HashMap<String, List>(ids.size());
        for (Object dyn : dyns) {
            voucherIds.add(dyn.getLong("voucherid"));
            idMap.computeIfAbsent(dyn.getString("sourcebillid"), key -> new LinkedList()).add(dyn.getString("voucherid"));
        }
        DynamicObjectCollection vouchers = QueryServiceHelper.query((String)"gl_voucher", (String)"id,billno,vouchertype.name vouchertypename", (QFilter[])new QFilter("id", "in", voucherIds).toArray());
        for (DynamicObject voucher : vouchers) {
            map.put(voucher.getString("id"), voucher.getString("vouchertypename") + voucher.getString("billno"));
        }
        HashMap<String, String> vnMap = new HashMap<String, String>(ids.size());
        for (Map.Entry entry : idMap.entrySet()) {
            List vids = (List)entry.getValue();
            List<String> vnumbers = vids.stream().map(e -> (String)map.get(e)).collect(Collectors.toList());
            vnMap.put((String)entry.getKey(), String.join((CharSequence)",", vnumbers.toArray(new String[0])));
        }
        return vnMap;
    }
}

