/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.plugin.logbill.LogBillListPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.ai.formplugin.BuildReportDataProvider;
import kd.fi.ai.formplugin.dao.BuildReportReader;
import kd.fi.ai.formplugin.dao.GlVoucherReader;
import kd.fi.ai.util.ContextUtil;
import kd.fi.ai.util.TraceSingleVoucherUtil;

public class AiNewBuildReportList
extends LogBillListPlugin {
    private Log logger = LogFactory.getLog(AiNewBuildReportList.class);
    private static final String FormKey_GLVOUCHER = "gl_voucher";
    private static final String Key_ShowDetail = "showdetail";
    private static final String Key_Check = "check";
    private static final String[] hideBtns = new String[]{"check"};

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new BuildReportDataProvider(this.getView()));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setShortCuts();
        this.getView().setVisible(Boolean.valueOf(false), hideBtns);
    }

    private void setShortCuts() {
        JSONArray arrayItem = new JSONArray();
        JSONObject item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"shift+m");
        arrayItem.add((Object)item);
        IFormView formView = this.getView();
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        JSONArray action = new JSONArray();
        action.add((Object)arrayItem);
        clientViewProxy.addAction("setShortCuts", (Object)action);
    }

    public void customEvent(CustomEventArgs e) {
        String key;
        super.customEvent(e);
        if (e.getEventName().equalsIgnoreCase("shortCuts") && "[16,77]".equals(key = e.getEventArgs())) {
            this.getView().setVisible(Boolean.valueOf(true), hideBtns);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getOperationKey();
        ListView view = (ListView)this.getView();
        ListSelectedRowCollection selectedRows = view.getSelectedRows();
        String itemKey = evt.getItemKey();
        if (Key_Check.equals(itemKey)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("ai_checkdata");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setParentPageId(this.getView().getPageId());
            this.getView().showForm(showParameter);
        } else if (Key_ShowDetail.equals(key) && selectedRows != null) {
            if (selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u67e5\u770b\u3002", (String)"AiNewBuildReportList_01", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            if (selectedRows.size() == 1) {
                Long id = (Long)selectedRows.get(0).getPrimaryKeyValue();
                HashSet<Long> pks = new HashSet<Long>();
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"ai_newbuildreportentry", (String)"id", (QFilter[])new QFilter[]{new QFilter("buildreportheadid", "=", (Object)id)});
                if (collection == null || collection.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u660e\u7ec6\u5206\u5f55\u3002", (String)"AiNewBuildReportList_02", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                for (DynamicObject object : collection) {
                    pks.add((Long)object.get("id"));
                }
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("ai_newbuildreportentry");
                showParameter.setFormId("bos_list");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setShowFilter(true);
                showParameter.setShowQuickFilter(true);
                ArrayList<QFilter> list = new ArrayList<QFilter>();
                list.add(new QFilter("id", "in", pks));
                showParameter.setListFilterParameter(new ListFilterParameter(list, null));
                view.showForm((FormShowParameter)showParameter);
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        try {
            args.setCancel(true);
            HyperLinkClickEvent linkClivkEvent = args.getHyperLinkClickEvent();
            String fileldName = linkClivkEvent.getFieldName();
            if ("opdate".equals(fileldName)) {
                IFormView view = this.getView();
                ListSelectedRowCollection selectedRows = ((BillList)view.getControl("billlistap")).getSelectedRows();
                if (selectedRows.size() == 0) {
                    view.showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u51ed\u8bc1\u62a5\u544a\u3002", (String)"AiNewBuildReportList_03", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                int rowIndex = linkClivkEvent.getRowIndex();
                Long pkValue = this.getSelectRowId(selectedRows, rowIndex);
                if (null == pkValue || pkValue == 0L) {
                    view.showMessage(ResManager.loadKDString((String)"\u51ed\u8bc1\u62a5\u544a\u4e2d\u4e0d\u5b58\u5728\u6b64\u6761\u8bb0\u5f55\u3002", (String)"AiNewBuildReportList_04", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject loadBuildReport = BuildReportReader.loadBuildNewReportById(pkValue);
                if (null == loadBuildReport) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bfb\u53d6\u51ed\u8bc1\u62a5\u544a\u51fa\u9519\u3002", (String)"AiNewBuildReportList_05", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                }
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("ai_buildreport_dyn");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.getOpenStyle().setTargetKey("_submaintab_");
                showParameter.setParentPageId(this.getView().getPageId());
                showParameter.setCustomParam("id", (Object)pkValue);
                this.getView().showForm(showParameter);
            } else if ("glvoucherno".equals(fileldName)) {
                IFormView view = this.getView();
                ListSelectedRowCollection selectedRows = ((BillList)view.getControl("billlistap")).getSelectedRows();
                if (selectedRows.size() == 0) {
                    view.showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u51ed\u8bc1\u62a5\u544a\u3002", (String)"AiNewBuildReportList_03", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                int rowIndex = linkClivkEvent.getRowIndex();
                Long pkValue = this.getSelectRowId(selectedRows, rowIndex);
                if (null == pkValue || pkValue == 0L) {
                    view.showMessage(ResManager.loadKDString((String)"\u51ed\u8bc1\u62a5\u544a\u4e2d\u4e0d\u5b58\u5728\u6b64\u6761\u8bb0\u5f55\u3002", (String)"AiNewBuildReportList_04", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject loadBuildReport = BuildReportReader.loadBuildNewReportById(pkValue);
                if (null == loadBuildReport) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bfb\u53d6\u51ed\u8bc1\u62a5\u544a\u51fa\u9519\u3002", (String)"AiNewBuildReportList_05", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                }
                if (!GlVoucherReader.isExist(loadBuildReport.getLong("glvoucher"))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u51ed\u8bc1\u4e0d\u5b58\u5728\u3002", (String)"AiNewBuildReportList_06", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                }
                this.showBillFormEditForm(loadBuildReport.getLong("glvoucher"), FormKey_GLVOUCHER);
            } else if ("sourcebillno".equals(fileldName)) {
                IFormView view = this.getView();
                ListSelectedRowCollection selectedRows = ((BillList)view.getControl("billlistap")).getSelectedRows();
                if (selectedRows.size() == 0) {
                    view.showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u51ed\u8bc1\u62a5\u544a\u3002", (String)"AiNewBuildReportList_03", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                int rowIndex = linkClivkEvent.getRowIndex();
                Long pkValue = this.getSelectRowId(selectedRows, rowIndex);
                if (null == pkValue || pkValue == 0L) {
                    view.showMessage(ResManager.loadKDString((String)"\u51ed\u8bc1\u62a5\u544a\u4e2d\u4e0d\u5b58\u5728\u6b64\u6761\u8bb0\u5f55\u3002", (String)"AiNewBuildReportList_04", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject loadBuildReport = BuildReportReader.loadBuildNewReportById(pkValue);
                if (null == loadBuildReport) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bfb\u53d6\u51ed\u8bc1\u62a5\u544a\u51fa\u9519\u3002", (String)"AiNewBuildReportList_05", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                }
                this.showBillFormEditForm(loadBuildReport.getLong("fsourcebillid"), loadBuildReport.getString("sourcebillnumber"));
            } else if ("vchtemplateno".equals(fileldName)) {
                IFormView view = this.getView();
                ListSelectedRowCollection selectedRows = ((BillList)view.getControl("billlistap")).getSelectedRows();
                if (selectedRows.size() == 0) {
                    view.showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u51ed\u8bc1\u62a5\u544a\u3002", (String)"AiNewBuildReportList_03", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                int rowIndex = linkClivkEvent.getRowIndex();
                Long pkValue = this.getSelectRowId(selectedRows, rowIndex);
                if (null == pkValue || pkValue == 0L) {
                    view.showMessage(ResManager.loadKDString((String)"\u51ed\u8bc1\u62a5\u544a\u4e2d\u4e0d\u5b58\u5728\u6b64\u6761\u8bb0\u5f55\u3002", (String)"AiNewBuildReportList_04", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject loadBuildReport = BuildReportReader.loadBuildNewReportById(pkValue);
                if (null == loadBuildReport) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bfb\u53d6\u51ed\u8bc1\u62a5\u544a\u51fa\u9519\u3002", (String)"AiNewBuildReportList_05", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                }
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("ai_vchtemplateedit");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.getOpenStyle().setTargetKey("_submaintab_");
                showParameter.setParentPageId(this.getView().getPageId());
                showParameter.setCustomParam("status", (Object)OperationStatus.VIEW);
                showParameter.setCustomParam("isReport", (Object)"isReport");
                showParameter.setCustomParam("pkvalue", (Object)loadBuildReport.getString("vchtemplateid"));
                showParameter.setCustomParam("number", null);
                this.getView().showForm(showParameter);
            }
        }
        catch (Exception e) {
            this.logger.error("###########  \u51ed\u8bc1\u62a5\u544a\u8054\u67e5\u51ed\u8bc1\u62a5\u9519\uff1a" + e);
            throw new KDBizException(e.getMessage());
        }
    }

    private Long getSelectRowId(ListSelectedRowCollection selectedRows, int rowIndex) {
        for (int i = 0; i < selectedRows.size(); ++i) {
            ListSelectedRow listSelectedRow = selectedRows.get(i);
            int rowKey = listSelectedRow.getRowKey();
            if (rowIndex != rowKey) continue;
            return Long.parseLong(selectedRows.get(i).getPrimaryKeyValue() + "");
        }
        return null;
    }

    private void showBillFormEditForm(Object pk, String formid) {
        DynamicObject one = BusinessDataServiceHelper.loadSingle((Object)pk, (String)formid);
        this.logger.info("######showBillFormEditForm:" + pk);
        if (one != null) {
            String tipMsg = "";
            if (!("ai_buildreport".equals(formid) || "ai_event".equals(formid) || formid.startsWith("fah_e_") || "ai_newbuildreporthead".equals(formid))) {
                tipMsg = this.getTipMsg(one, formid);
            }
            if (!StringUtils.isEmpty((CharSequence)tipMsg)) {
                this.logger.info(tipMsg);
                throw new KDBizException(tipMsg);
            }
            if (FormKey_GLVOUCHER.equals(formid)) {
                TraceSingleVoucherUtil.showVoucher((Long)one.getLong("id"), (Long)one.getLong("org.id"), (IFormView)this.getView());
                return;
            }
            this.logger.info("#####");
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(formid);
            showParameter.setPkId(pk);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.getOpenStyle().setTargetKey("_submaintab_");
            showParameter.setBillStatus(BillOperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
            this.logger.info("#####showForm-----formid:" + formid + ";pk:" + pk);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u88ab\u5220\u9664\u3002", (String)"AiNewBuildReportList_07", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
    }

    private String getTipMsg(DynamicObject one, String formid) {
        MainEntityType bet = EntityMetadataCache.getDataEntityType((String)formid);
        Long orgId = 0L;
        if (FormKey_GLVOUCHER.equals(formid)) {
            orgId = one.getLong("org.id");
        } else {
            String mainOrg = bet.getMainOrg();
            if (null != mainOrg) {
                orgId = one.getDynamicObject(mainOrg).getLong("id");
            }
        }
        this.logger.info("######formid:" + formid + ";one:org=" + orgId + ";billid=" + one.getPkValue() + ";");
        String appId = AppMetadataCache.getAppInfo((String)bet.getAppId()).getId();
        int i = PermissionServiceHelper.checkPermission((long)ContextUtil.getUserId(), (String)"DIM_ORG", (long)orgId, (String)appId, (String)formid, (String)"47150e89000000ac");
        String billName = EntityMetadataCache.getDataEntityType((String)formid).getDisplayName().toString();
        String msg = "";
        if (i == 0) {
            BasedataEntityType bnt = (BasedataEntityType)bet;
            String billNo = one.getString(bnt.getNumberProperty());
            msg = String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%1$s\u201d\u201c%2$s\u201d\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"AiNewBuildReportList_08", (String)"fi-ai-formplugin", (Object[])new Object[0]), billName, billNo);
        }
        return msg;
    }
}

