/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.ai.GenVoucherMemoryMergeTask;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.builder.GLVoucherUnionType;
import kd.fi.ai.cache.CacheHelper;
import kd.fi.ai.cache.CacheModule;
import kd.fi.ai.cache.DistributeCache;
import kd.fi.ai.dap.MutexRequireUtil;
import kd.fi.ai.exception.DapException;
import kd.fi.ai.mservice.builder.BuildVchScheme;
import kd.fi.ai.mservice.builder.BuildVchServiceImpl;
import kd.fi.ai.mservice.builder.SelectedAcctBook;
import kd.fi.ai.mservice.builder.SelectedSourceBill;
import kd.fi.ai.mservice.service.MergeGLVoucherServiceUtil;
import kd.fi.ai.mservice.service.helper.SelectTemplateUtil;
import kd.fi.ai.util.EventVchTemplateUtil;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.utils.FahSerializeHelper;
import kd.fi.v2.fah.utils.StringUtils;

public class BuildVchProgress
extends AbstractFormPlugin
implements ProgresssListener {
    private static Log log = LogFactory.getLog(BuildVchProgress.class);
    public static final String AI_BUILDVCH_PROGRESS = "ai_buildvch_progress";
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private static final String KEY_LABELAP = "labelap";
    public static final String ERROR_MSG = "errorMsg";
    public static final String SUCCESS_MSG = "successMsg";
    public static final String IS_FINISH = "isFinish";
    public static final String IS_SUCCESS = "isSuccess";
    public static final String PROGRESS = "progress";
    public static final String SCHEME_BUILT_COUNT = "schemeBuiltCount";
    public static final String TASK_COUNT = "taskCount";
    public static final String TASK_DONE_COUNT = "taskDoneCount";
    public static final String PARAM_PAGE_ID = "pageId";
    public static final String PARAM_SCHEMA_COUNT = "schemaCount";
    public static final String PARAM_SCHEMA_LIST = "schemalist";
    public static final String PARAM_ERROR = "error";
    public static final String PARAM_SUCCESS = "success";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.start();
    }

    public void onProgress(ProgressEvent evt) {
        int curProgress;
        String pageId;
        DistributeCache distributeCache = CacheHelper.getDistributeCache((CacheModule)CacheModule.aiBuildVchWizard);
        String progressCache = distributeCache.get((pageId = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_PAGE_ID)) + PROGRESS);
        if (progressCache == null) {
            curProgress = 0;
            this.startTask(distributeCache, pageId);
        } else {
            boolean isFinish = ObjectConverterFactory.getBoolean((Object)distributeCache.get(pageId + IS_FINISH), (Boolean)false);
            if (isFinish) {
                curProgress = 100;
                this.finishTask(distributeCache, pageId);
            } else {
                curProgress = this.calcProgress(distributeCache, pageId, progressCache);
            }
        }
        evt.setProgress(curProgress);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String pageId = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_PAGE_ID);
        DistributeCache distributeCache = CacheHelper.getDistributeCache((CacheModule)CacheModule.aiBuildVchWizard);
        String isFinish = distributeCache.get(pageId + IS_FINISH);
        if (StringUtils.isNotEmpty((String)isFinish) && !ObjectConverterFactory.getBoolean((Object)isFinish, (Boolean)false).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u51ed\u8bc1\u751f\u6210\u4e2d\uff0c\u8bf7\u52ff\u5173\u95ed\u3002", (String)"BuildVchProgress_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    private void startTask(DistributeCache distributeCache, String pageId) {
        this.clearCache(distributeCache, pageId);
        distributeCache.put(pageId + IS_FINISH, Boolean.FALSE.toString());
        distributeCache.put(pageId + PROGRESS, "0");
        String schemaListStr = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_SCHEMA_LIST);
        if (StringUtils.isNotEmpty((String)schemaListStr)) {
            List schemaList = FahSerializeHelper.fromJsonArrayString((String)schemaListStr, BuildVchScheme.class);
            boolean isSingleBill = schemaList.size() == 1 && ((BuildVchScheme)schemaList.get(0)).getSelectedBooks().size() == 1 && ((SelectedAcctBook)((BuildVchScheme)schemaList.get(0)).getSelectedBooks().get(0)).getSelectedSourceBills().size() == 1;
            ThreadPools.executeOnce((String)AI_BUILDVCH_PROGRESS, () -> this.asyncBuildVch(schemaList, isSingleBill, pageId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void asyncBuildVch(List<BuildVchScheme> schemaList, boolean isSingleBill, String pageId) {
        block23: {
            cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.aiBuildVchWizard);
            builtCount = 0;
            var6_6 = schemaList.iterator();
            if (!var6_6.hasNext()) break block23;
            scheme = var6_6.next();
            scheme.setAsyncId(pageId);
            selectedSourceBill = (SelectedSourceBill)((SelectedAcctBook)scheme.getSelectedBooks().get(0)).getSelectedSourceBills().get(0);
            if (!isSingleBill || (billIds = selectedSourceBill.getBillIds()).size() != 1) ** GOTO lbl-1000
            billid = billIds.iterator().next();
            filterList = new ArrayList<QFilter>();
            filterList.add(new QFilter("sourcebillid", "=", billid));
            DapVoucherUtil.addBillTypeFilter((String)selectedSourceBill.getEntityNumber(), filterList);
            daptrackers = BusinessDataServiceHelper.load((String)"ai_daptracker", (String)"voucherid", (QFilter[])filterList.toArray(new QFilter[0]));
            vchids = new HashSet<E>(daptrackers.length);
            for (DynamicObject dtk : daptrackers) {
                vchids.add(dtk.getLong("voucherid"));
            }
            idFilter = new QFilter("id", "in", (Object)vchids);
            bookid = ((SelectedAcctBook)scheme.getSelectedBooks().get(0)).getBookId();
            bookFilter = new QFilter("book", "=", (Object)bookid);
            v = BusinessDataServiceHelper.loadSingle((String)"gl_voucher", (String)"id,billno", (QFilter[])new QFilter[]{idFilter, bookFilter});
            if (v != null) {
                cache.put(pageId + "errorMsg", String.format(ResManager.loadKDString((String)"\u5355\u636e\u5728\u8be5\u8d26\u7c3f\u4e0b\u5df2\u751f\u6210\u8fc7\u603b\u8d26\u51ed\u8bc1\u201c%s\u201d\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6210\u3002", (String)"BuildVchProgress_1", (String)"fi-ai-formplugin", (Object[])new Object[0]), new Object[]{v.getString("billno")}));
                cache.put(pageId + "isSuccess", Boolean.FALSE.toString());
            } else lbl-1000:
            // 2 sources

            {
                buildVchService = new BuildVchServiceImpl();
                try {
                    opts = EntityMetadataCache.getDataEntityOperate((String)selectedSourceBill.getEntityNumber());
                    hasGenerateVoucherOpt = false;
                    genVoucherOptName = "generatevoucher";
                    for (Map opt : opts) {
                        optKey = (String)opt.get("type");
                        if (!optKey.equalsIgnoreCase("generatevoucher")) continue;
                        hasGenerateVoucherOpt = true;
                        genVoucherOptName = (String)opt.get("key");
                    }
                    scheme.setOpr(genVoucherOptName);
                    scheme.setBuildType("C");
                    if (isSingleBill && hasGenerateVoucherOpt && selectedSourceBill.getUnionType() == GLVoucherUnionType.Single) {
                        op = OperateOption.create();
                        op.setVariableValue("scheme", SerializationUtils.toJsonString((Object)scheme));
                        op.setVariableValue("ai_buildvchwizard", "1");
                        op.setVariableValue("build_mode", "false");
                        result = OperationServiceHelper.executeOperate((String)genVoucherOptName, (String)selectedSourceBill.getEntityNumber(), (Object[])selectedSourceBill.getBillIds().toArray(), (OperateOption)op);
                        if (result.isSuccess()) {
                            cache.put(pageId + "successMsg", ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u6210\u529f\u3002", (String)"BuildVchProgress_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                            cache.put(pageId + "isSuccess", Boolean.TRUE.toString());
                        } else {
                            cache.put(pageId + "errorMsg", this.collectErrorResult(result));
                            cache.put(pageId + "isSuccess", Boolean.FALSE.toString());
                        }
                        break block23;
                    }
                    try {
                        this.getVchTemplateIds(scheme);
                        selectedBooks = scheme.getSelectedBooks();
                        ids = new HashSet<E>(16);
                        for (SelectedAcctBook selectedBook : selectedBooks) {
                            selectedSourceBills = selectedBook.getSelectedSourceBills();
                            for (SelectedSourceBill selectedBill : selectedSourceBills) {
                                bills = MutexRequireUtil.requireMutex((Set)selectedBill.getBillIds(), (String)selectedBill.getEntityNumber());
                                selectedBill.setBillIds(bills);
                                ids.addAll(bills.stream().map((Function<Object, Long>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$asyncBuildVch$1(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Long;)()).collect(Collectors.toSet()));
                            }
                        }
                        gvMemory = new GenVoucherMemoryMergeTask(UUID.randomUUID().toString(), ids, selectedSourceBill.getEntityNumber());
                        scheme.setGvMemory(gvMemory);
                        transId = buildVchService.BuildVoucher(scheme);
                        glVoucher_seq_entry = gvMemory.getGlVoucher_seq_entry();
                        mergeGLVouchers = MergeGLVoucherServiceUtil.mergeGLVouchers((List)gvMemory.getCurr_task_needMergeVoucher(), (String)selectedSourceBill.getEntityNumber(), (String)gvMemory.getVch_tpl_entry_sort(), (List)gvMemory.getTrackersNotToSave(), (Map)glVoucher_seq_entry);
                        this.getPageCache().put("trans", transId);
                    }
                    catch (Exception e) {
                        if (e instanceof DapException) {
                            DapVoucherUtil.generateNewExceptionReport((Exception)e, null, (String)ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u5f02\u5e38\u3002", (String)"BuildVchProgress_4", (String)"fi-ai-formplugin", (Object[])new Object[0]), null, null);
                        }
                        if (e instanceof KDException) {
                            cache.put(pageId + "errorMsg", e.getMessage());
                            cache.put(pageId + "isSuccess", Boolean.FALSE.toString());
                        } else {
                            cache.put(pageId + "errorMsg", ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u51ed\u8bc1\u751f\u6210\u62a5\u544a\u3002", (String)"BuildVchProgress_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                            cache.put(pageId + "isSuccess", Boolean.FALSE.toString());
                        }
                        DapVoucherUtil.generateNewExceptionReport((Exception)e, null, (String)ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u5f02\u5e38\u3002", (String)"BuildVchProgress_4", (String)"fi-ai-formplugin", (Object[])new Object[0]), null, null);
                    }
                    finally {
                        selectedBooks = scheme.getSelectedBooks();
                        for (SelectedAcctBook selectedBook : selectedBooks) {
                            selectedSourceBills = selectedBook.getSelectedSourceBills();
                            for (SelectedSourceBill selectedBill : selectedSourceBills) {
                                MutexRequireUtil.batchReleaseForScheme((Collection)selectedBill.getBillIds(), (String)selectedBill.getEntityNumber());
                            }
                        }
                    }
                }
                catch (RuntimeException e) {
                    BuildVchProgress.log.error((Throwable)e);
                    msg = e.getMessage();
                    if (msg.contains("RuntimeException:")) {
                        index = msg.indexOf("RuntimeException:");
                        msg = msg.substring(index + 18);
                    }
                    cache.put(pageId + "errorMsg", msg);
                    cache.put(pageId + "isSuccess", Boolean.FALSE.toString());
                }
                catch (Exception e) {
                    BuildVchProgress.log.error((Throwable)e);
                    cache.put(pageId + "errorMsg", e.getMessage());
                    cache.put(pageId + "isSuccess", Boolean.FALSE.toString());
                }
            }
        }
        cache.put(pageId + "isFinish", Boolean.TRUE.toString());
    }

    private int calcProgress(DistributeCache distributeCache, String pageId, String progressCache) {
        int progressCacheInt;
        int currentSchemeProgressInt;
        int schemeProgress;
        int count = (Integer)this.getView().getFormShowParameter().getCustomParam(PARAM_SCHEMA_COUNT);
        int builtCountInt = 0;
        String builtCount = distributeCache.get(pageId + SCHEME_BUILT_COUNT);
        if (null != builtCount) {
            builtCountInt = Integer.parseInt(builtCount);
        }
        int taskCountInt = 0;
        String taskCount = distributeCache.get(pageId + TASK_COUNT);
        if (null != taskCount) {
            taskCountInt = Integer.parseInt(taskCount);
        }
        int taskDoneInt = 0;
        String taskDone = distributeCache.get(pageId + TASK_DONE_COUNT);
        if (null != taskDone) {
            taskDoneInt = Integer.parseInt(taskDone);
        }
        if ((schemeProgress = 100 / count) < 1) {
            schemeProgress = 1;
        }
        if (taskCountInt == 0 || taskDoneInt == 0) {
            currentSchemeProgressInt = 0;
        } else if (taskCountInt == taskDoneInt) {
            currentSchemeProgressInt = schemeProgress;
        } else {
            BigDecimal ratio = new BigDecimal(taskDoneInt).divide(new BigDecimal(taskCountInt), 4, RoundingMode.HALF_UP);
            currentSchemeProgressInt = new BigDecimal(schemeProgress).multiply(ratio).intValue();
            if (currentSchemeProgressInt > schemeProgress) {
                currentSchemeProgressInt = schemeProgress;
            }
        }
        int progressInt = builtCountInt * schemeProgress + currentSchemeProgressInt;
        if (progressInt >= 100) {
            progressInt = 99;
        }
        if (progressInt < (progressCacheInt = ObjectConverterFactory.getInteger((Object)progressCache, (Integer)0).intValue())) {
            progressInt = progressCacheInt;
        }
        distributeCache.put(pageId + PROGRESS, progressInt + "");
        return progressInt;
    }

    private void finishTask(DistributeCache distributeCache, String pageId) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(PARAM_PAGE_ID, pageId);
        Boolean isSuccess = ObjectConverterFactory.getBoolean((Object)distributeCache.get(pageId + IS_SUCCESS), (Boolean)false);
        data.put(IS_SUCCESS, isSuccess.toString());
        if (isSuccess.booleanValue()) {
            String successMsg = distributeCache.get(pageId + SUCCESS_MSG);
            if (null != successMsg) {
                data.put(PARAM_SUCCESS, successMsg);
            }
        } else {
            String errorMsg = distributeCache.get(pageId + ERROR_MSG);
            if (null != errorMsg) {
                data.put(PARAM_ERROR, errorMsg);
            }
        }
        Label tipLabel = (Label)this.getView().getControl(KEY_LABELAP);
        tipLabel.setText(ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u7ed3\u675f\u3002", (String)"BuildVchProgress_5", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(data));
        this.clearCache(distributeCache, pageId);
        this.getView().close();
    }

    private void clearCache(DistributeCache distributeCache, String pageId) {
        distributeCache.remove(pageId + IS_FINISH);
        distributeCache.remove(pageId + IS_SUCCESS);
        distributeCache.remove(pageId + ERROR_MSG);
        distributeCache.remove(pageId + SUCCESS_MSG);
        distributeCache.remove(pageId + SCHEME_BUILT_COUNT);
        distributeCache.remove(pageId + TASK_COUNT);
        distributeCache.remove(pageId + TASK_DONE_COUNT);
        distributeCache.remove(pageId + PROGRESS);
    }

    private String collectErrorResult(OperationResult opResult) {
        if (opResult == null || opResult.isSuccess()) {
            return "";
        }
        StringBuilder errorCol = new StringBuilder();
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)opResult.getMessage())) {
            errorCol.append(opResult.getMessage());
        } else {
            List errorInfos = opResult.getAllErrorInfo();
            int i = 0;
            for (OperateErrorInfo errorInfo : errorInfos) {
                if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)errorInfo.getMessage())) {
                    if (errorInfo.getMessage().endsWith("\u3002") || errorInfo.getMessage().endsWith(",")) {
                        errorCol.append(errorInfo.getMessage());
                    } else if (i == errorInfos.size() - 1) {
                        errorCol.append(errorInfo.getMessage()).append("\u3002");
                    } else {
                        errorCol.append(errorInfo.getMessage()).append(",");
                    }
                }
                ++i;
            }
        }
        return errorCol.toString();
    }

    private void getVchTemplateIds(BuildVchScheme scheme) {
        List bookIds = scheme.getSelectedBooks().stream().map(SelectedAcctBook::getBookId).collect(Collectors.toList());
        Map bookTypeMap = BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (String)StringUtils.join((Object[])new String[]{"bookstype", "org"}, (String)","), (QFilter[])new QFilter[]{new QFilter("id", "in", bookIds)});
        for (SelectedAcctBook selectedBook : scheme.getSelectedBooks()) {
            DynamicObject accBook = (DynamicObject)bookTypeMap.get(selectedBook.getBookId());
            Long bookTypeId = Optional.ofNullable(accBook).map(b -> b.getDynamicObject("bookstype")).map(bt -> bt.getLong("id")).orElse(null);
            Long acctOrgId = Optional.ofNullable(accBook).map(b -> b.getDynamicObject("org")).map(org -> org.getLong("id")).orElse(null);
            if (bookTypeId == null || acctOrgId == null) continue;
            for (SelectedSourceBill selectedSourceBill : selectedBook.getSelectedSourceBills()) {
                String billEntityNumber = selectedSourceBill.getEntityNumber();
                QFilter billTypeFilter = new QFilter("fsourcebill", "=", (Object)billEntityNumber);
                QFilter bookTypeFilter = new QFilter("booktype.fbasedataid.masterid", "in", (Object)new Long[]{bookTypeId}).or(new QFilter("booktype.fbasedataid", "is null", null));
                QFilter enableFilter = new QFilter("enable", "!=", (Object)"0");
                List templateid = EventVchTemplateUtil.getTemplate((Long)acctOrgId, (String)"ai_vchtemplate");
                Object value = BaseDataServiceHelper.getBaseDataIdInFilter((String)"ai_vchtemplate", (Long)acctOrgId).getValue();
                if (value != null) {
                    Collection cc = (Collection)value;
                    templateid.addAll(cc);
                }
                QFilter filter = new QFilter("id", "in", (Object)templateid);
                ArrayList<QFilter> filterList = new ArrayList<QFilter>();
                filterList.add(billTypeFilter);
                filterList.add(enableFilter);
                filterList.add(filter);
                filterList.add(bookTypeFilter);
                List tps = null;
                Set billIds = selectedSourceBill.getBillIds();
                if (billIds == null || billIds.isEmpty()) continue;
                tps = SelectTemplateUtil.getTemplateToList((String)billEntityNumber, (Collection)billIds, filterList);
                LinkedList<Long> newtps = new LinkedList<Long>();
                if (tps.isEmpty()) {
                    log.info("####find the vchtemplate --QFilter:" + filterList + ";  org:" + acctOrgId);
                } else {
                    for (VCHTemplate t : tps) {
                        if (Objects.equals(t.getCreateOrgId(), acctOrgId)) {
                            newtps.addFirst(Long.valueOf(t.getId()));
                            continue;
                        }
                        newtps.addLast(Long.valueOf(t.getId()));
                    }
                }
                log.info("---BuildVchWizardEdit---newtps:" + newtps);
                selectedSourceBill.setTemplateIds(newtps);
            }
        }
    }

    private static /* synthetic */ Long lambda$asyncBuildVch$1(Object v) {
        return Long.parseLong(v.toString());
    }
}

