/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.ai.AppBookConfig;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.VchReturnData;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.accsys.AccSysUtil;
import kd.fi.ai.builder.BuildVoucherType;
import kd.fi.ai.builder.GLVoucherUnionType;
import kd.fi.ai.cache.CacheHelper;
import kd.fi.ai.cache.CacheModule;
import kd.fi.ai.cache.DistributeCache;
import kd.fi.ai.dap.DapBookHelper;
import kd.fi.ai.dap.DapCache;
import kd.fi.ai.dap.DapConfig;
import kd.fi.ai.enums.PermissonType;
import kd.fi.ai.formplugin.dao.VchTemplateReader;
import kd.fi.ai.mservice.builder.BuildVchScheme;
import kd.fi.ai.mservice.builder.SelectedAcctBook;
import kd.fi.ai.mservice.builder.SelectedSourceBill;
import kd.fi.ai.util.AccSysConfigsReader;
import kd.fi.ai.util.ContextUtil;
import kd.fi.ai.util.DapBuildVoucherCommonUtil;
import kd.fi.ai.util.DapUtil;
import kd.fi.ai.util.EntityFieldTreeOption;
import kd.fi.ai.util.EntityFieldTreeResult;
import kd.fi.ai.util.EntityTreeUtil;
import kd.fi.v2.fah.constant.FormBuilderConstant;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.utils.FahSerializeHelper;
import org.apache.commons.collections4.ListUtils;

public class BuildVchWizardEdit
extends AbstractFormPlugin
implements TreeNodeClickListener,
BeforeF7SelectListener {
    private static Log log = LogFactory.getLog(BuildVchWizardEdit.class);
    private static String Key_AcctBookEntity = "acctbookentity";
    private static String Key_SrcBillSubEntity = "srcbillsubentity";
    private static String Key_TVScheme = "tv_scheme";
    private static String Key_FSelectedBook = "fselectedbook";
    private static String Key_FAcctBook = "facctbook";
    private static String Key_FPeriod = "fperiod";
    private static String Key_FBuildType = "fbuildtype";
    private static final String KEY_BIZORG = "bizorg";
    private static final String KEY_ACCTORG = "acctorg";
    private static final String KEY_BOOKTYPE = "booktype";
    private static String Key_FSelectedBill = "fselectedbill";
    private static String Key_FSourceBill = "fsourcebill";
    private static String Key_FBillFilterDesc = "fbillfilterdesc";
    private static String Key_FBillFilter = "fbillfilter";
    private static String Key_FUnionType = "funiontype";
    private static String Key_FMatchFieldName = "fmatchfieldname";
    private static String Key_FMatchFieldKey = "fmatchfieldkey";
    private static String Key_btnBuild = "btnbuild";
    private static String SchemeId_Default = "default_scheme";
    private static String CacheKey_CurrSchemeId = "currschemeid";
    private static final String NON_FIELDS = "nonFields";

    public void initialize() {
        super.initialize();
        TreeView tView = (TreeView)this.getControl(Key_TVScheme);
        tView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{Key_FBillFilterDesc, Key_FMatchFieldName});
        Toolbar bar = (Toolbar)this.getControl("toolbarap");
        bar.addItemClickListener((ItemClickListener)this);
        BasedataEdit periodCtl = (BasedataEdit)this.getControl(Key_FPeriod);
        periodCtl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit acctOrgCtl = (BasedataEdit)this.getControl(KEY_ACCTORG);
        acctOrgCtl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit sourcebill = (BasedataEdit)this.getControl(Key_FSourceBill);
        sourcebill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizorg = (BasedataEdit)this.getControl(KEY_BIZORG);
        bizorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.fillSchemeList();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty p = e.getProperty();
        String pName = p.getName();
        ChangeData[] cdata = e.getChangeSet();
        ChangeData changeData = cdata[0];
        if (KEY_BIZORG.equalsIgnoreCase(pName)) {
            DynamicObject newBizOrg = (DynamicObject)changeData.getNewValue();
            if (newBizOrg == null) {
                this.getModel().setValue(KEY_ACCTORG, null, changeData.getRowIndex());
                this.getModel().setValue("facctbook", null, changeData.getRowIndex());
                this.getModel().setValue("fperiod", null, changeData.getRowIndex());
                return;
            }
            DynamicObjectCollection orgRels = AccSysConfigsReader.getAccOrgFromBizOrg((Long)newBizOrg.getLong("id"));
            Long acctOrgID = null;
            if (orgRels != null && orgRels.size() > 0) {
                acctOrgID = ((DynamicObject)orgRels.get(0)).getLong("toorg");
            } else if (newBizOrg.getBoolean("fisaccounting")) {
                acctOrgID = newBizOrg.getLong("id");
            }
            this.getModel().setValue(KEY_ACCTORG, (Object)acctOrgID, changeData.getRowIndex());
            QFilter h = new QFilter("org", "=", (Object)acctOrgID);
            QFilter k = new QFilter("bookstype.accounttype", "=", (Object)"1");
            DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"id,bookstype.id,curperiod.id", (QFilter[])new QFilter[]{h, k});
            if (books == null || books.size() == 0) {
                this.getModel().setValue("facctbook", null, changeData.getRowIndex());
                this.getModel().setValue("fperiod", null, changeData.getRowIndex());
            } else {
                this.getModel().setValue("facctbook", (Object)((DynamicObject)books.get(0)).getLong("id"), changeData.getRowIndex());
                this.getModel().setValue("fperiod", (Object)((DynamicObject)books.get(0)).getLong("curperiod.id"), changeData.getRowIndex());
                this.getModel().setValue(KEY_BOOKTYPE, (Object)((DynamicObject)books.get(0)).getLong("bookstype.id"), changeData.getRowIndex());
            }
            int billCount = this.getModel().getEntryRowCount(Key_SrcBillSubEntity);
            for (int i = 0; i < billCount; ++i) {
                this.getModel().setValue(Key_FBillFilterDesc, null, i, changeData.getRowIndex());
            }
        } else if (KEY_ACCTORG.equalsIgnoreCase(pName)) {
            QFilter k;
            DynamicObject newAcctOrg = (DynamicObject)changeData.getNewValue();
            if (newAcctOrg == null) {
                this.getModel().setValue("facctbook", null, changeData.getRowIndex());
                this.getModel().setValue("fperiod", null, changeData.getRowIndex());
                return;
            }
            QFilter h = new QFilter("org", "=", (Object)newAcctOrg.getLong("id"));
            DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"id,bookstype.id,curperiod.id", (QFilter[])new QFilter[]{h, k = new QFilter("bookstype.accounttype", "=", (Object)"1")});
            if (books == null || books.size() == 0) {
                this.getModel().setValue("facctbook", null, changeData.getRowIndex());
                this.getModel().setValue("fperiod", null, changeData.getRowIndex());
            } else {
                this.getModel().setValue("facctbook", (Object)((DynamicObject)books.get(0)).getLong("id"), changeData.getRowIndex());
                this.getModel().setValue("fperiod", (Object)((DynamicObject)books.get(0)).getLong("curperiod.id"), changeData.getRowIndex());
                this.getModel().setValue(KEY_BOOKTYPE, (Object)((DynamicObject)books.get(0)).getLong("bookstype.id"), changeData.getRowIndex());
            }
        } else if (KEY_BOOKTYPE.equalsIgnoreCase(pName)) {
            QFilter k;
            DynamicObject newBookType = (DynamicObject)changeData.getNewValue();
            if (newBookType == null) {
                this.getModel().setValue("facctbook", null, changeData.getRowIndex());
                this.getModel().setValue("fperiod", null, changeData.getRowIndex());
                return;
            }
            DynamicObject newAcctOrg = (DynamicObject)this.getModel().getValue(KEY_ACCTORG, changeData.getRowIndex());
            if (newAcctOrg == null) {
                return;
            }
            QFilter h = new QFilter("org", "=", (Object)newAcctOrg.getLong("id"));
            DynamicObject book = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"id,bookstype.id,curperiod.id", (QFilter[])new QFilter[]{h, k = new QFilter("bookstype", "=", (Object)newBookType.getLong("id"))});
            if (book == null) {
                this.getModel().setValue("facctbook", null, changeData.getRowIndex());
                this.getModel().setValue("fperiod", null, changeData.getRowIndex());
            } else {
                this.getModel().setValue("fperiod", (Object)book.getLong("curperiod.id"), changeData.getRowIndex());
                this.getModel().setValue("facctbook", (Object)book.getLong("id"), changeData.getRowIndex());
            }
        } else if (Key_FSourceBill.equalsIgnoreCase(pName)) {
            this.getModel().setValue(Key_FBillFilter, null, changeData.getRowIndex(), this.getModel().getEntryCurrentRowIndex(Key_AcctBookEntity));
            this.getModel().setValue(Key_FBillFilterDesc, null, changeData.getRowIndex(), this.getModel().getEntryCurrentRowIndex(Key_AcctBookEntity));
        } else if (Key_FMatchFieldName.equalsIgnoreCase(pName) && ObjectUtils.isEmpty((Object)changeData.getNewValue())) {
            this.getModel().setValue(Key_FMatchFieldKey, null, changeData.getRowIndex(), this.getModel().getEntryCurrentRowIndex(Key_AcctBookEntity));
        }
    }

    public void treeNodeClick(TreeNodeEvent arg0) {
        String currSchemeId;
        String nodeId = (String)arg0.getNodeId();
        if (nodeId.equalsIgnoreCase(currSchemeId = this.getPageCache().get(CacheKey_CurrSchemeId))) {
            return;
        }
        if (SchemeId_Default.equalsIgnoreCase(nodeId)) {
            this.fillAcctBooks();
        }
        this.getPageCache().put(CacheKey_CurrSchemeId, nodeId);
    }

    public void treeNodeDoubleClick(TreeNodeEvent arg0) {
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (Key_btnBuild.equals(key)) {
            this.doBuildVoucher();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control srcControl = (Control)evt.getSource();
        if (srcControl.getKey().equalsIgnoreCase(Key_btnBuild)) {
            this.doBuildVoucher();
        } else if (srcControl.getKey().equalsIgnoreCase(Key_FBillFilterDesc)) {
            ArrayList<QFilter> list;
            int currBillEntryRowIndex = this.getModel().getEntryCurrentRowIndex(Key_SrcBillSubEntity);
            DynamicObject billRow = this.getModel().getEntryRowEntity(Key_SrcBillSubEntity, currBillEntryRowIndex);
            if (null == billRow.getDynamicObject(Key_FSourceBill)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6765\u6e90\u5355\u636e\u3002", (String)"BuildVchWizardEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            String entityKey = (String)billRow.getDynamicObject(Key_FSourceBill).getPkValue();
            ListShowParameter para = new ListShowParameter();
            para.setLookUp(true);
            para.setBillFormId(this.getListEntityKey(entityKey));
            para.setFormId("bos_listf7");
            StyleCss css = new StyleCss();
            css.setWidth("1068");
            css.setHeight("648");
            para.getOpenStyle().setInlineStyleCss(css);
            para.getOpenStyle().setShowType(ShowType.Modal);
            para.setMultiSelect(true);
            para.setShowUsed(true);
            para.setShowTitle(false);
            para.setShowQuickFilter(true);
            para.setIsolationOrg(false);
            String billIdJson = (String)this.getModel().getValue(Key_FBillFilter);
            if (StringUtils.isNotBlank((CharSequence)billIdJson)) {
                // empty if block
            }
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(Key_AcctBookEntity);
            DynamicObject bizorg = (DynamicObject)this.getModel().getValue(KEY_BIZORG, entryCurrentRowIndex);
            DynamicObject accOrg = (DynamicObject)this.getModel().getValue(KEY_ACCTORG, entryCurrentRowIndex);
            DynamicObject period = (DynamicObject)this.getModel().getValue(Key_FPeriod, entryCurrentRowIndex);
            DynamicObject book = (DynamicObject)this.getModel().getValue(Key_FAcctBook, entryCurrentRowIndex);
            HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)"ai", (String)this.getView().getEntityId(), (String)PermissonType.CREATEVOUCHER.getPermId());
            if (bizorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5355\u5143\u3002", (String)"BuildVchWizardEdit_5", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!(result.hasAllOrgPerm() || null != result.getHasPermOrgs() && result.getHasPermOrgs().contains((Long)bizorg.getPkValue()))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143\u201c%s\u201d\u6ca1\u6709\u51ed\u8bc1\u751f\u6210\u6743\u9650\u3002", (String)"BuildVchWizardEdit_6", (String)"fi-ai-formplugin", (Object[])new Object[]{bizorg.getString("name")}));
                return;
            }
            if (accOrg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"BuildVchWizardEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            if (period == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"BuildVchWizardEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.getModel().getValue(KEY_BOOKTYPE, entryCurrentRowIndex) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"BuildVchWizardEdit_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            DapConfig cg = DapCache.getDapConfig((String)entityKey, (long)bizorg.getLong("id"));
            if (cg != null) {
                Set bizBookIds;
                list = new ArrayList<QFilter>();
                List orgFields = cg.getBizOrgFields();
                if (orgFields.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u672a\u8bbe\u7f6e\u51ed\u8bc1\u6a21\u677f\u3002", (String)"BuildVchWizardEdit_4", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (orgFields.size() == 1) {
                    list.add(new QFilter((String)orgFields.get(0), "=", bizorg.getPkValue()));
                } else {
                    ArrayList<QFilter> orgFilters = new ArrayList<QFilter>(orgFields.size());
                    for (String orgField : orgFields) {
                        orgFilters.add(new QFilter(orgField, "=", bizorg.getPkValue()));
                    }
                    QFilter[] ogFs = orgFilters.toArray(new QFilter[0]);
                    Object orgf = ogFs[0];
                    for (int m = 1; m < ogFs.length; ++m) {
                        orgf = orgf.or(ogFs[m]);
                    }
                    list.add((QFilter)orgf);
                }
                list.add(new QFilter("billstatus", ">=", (Object)Character.valueOf('C')));
                List vdateFields = cg.getVoucherDateFields();
                ArrayList<QFilter> vdateFilters = new ArrayList<QFilter>();
                for (String vdateField : vdateFields) {
                    if (!StringUtils.isNotBlank((CharSequence)vdateField)) continue;
                    QFilter bf = new QFilter(vdateField, ">=", (Object)period.getDate("begindate"));
                    QFilter ef = new QFilter(vdateField, "<=", (Object)period.getDate("enddate"));
                    vdateFilters.add(bf.and(ef));
                }
                QFilter[] vdFs = vdateFilters.toArray(new QFilter[0]);
                if (vdFs.length == 1) {
                    list.add(vdFs[0]);
                } else if (vdFs.length > 1) {
                    QFilter vdf = vdFs[0];
                    for (int m = 1; m < vdFs.length; ++m) {
                        vdf = vdf.or(vdFs[m]);
                    }
                    list.add(vdf);
                }
                String billBookTypeField = DapCache.getBillBookTypeField((String)entityKey);
                String billBookField = DapCache.getBillBookField((String)entityKey);
                if ((StringUtils.isNotBlank((CharSequence)billBookTypeField) && !billBookTypeField.contains(".") || StringUtils.isNotBlank((CharSequence)billBookField) && !billBookField.contains(".")) && (bizBookIds = DapBookHelper.getBizBooks((String)entityKey, (long)book.getLong("id"))) != null && bizBookIds.size() > 0) {
                    if (StringUtils.isBlank((CharSequence)billBookTypeField)) {
                        QFilter bookfilter = new QFilter(billBookField, "in", (Object)bizBookIds);
                        list.add(bookfilter);
                    } else if (StringUtils.isBlank((CharSequence)billBookField)) {
                        QFilter bookTypefilter = this.getBookTypeFilter(entityKey, billBookTypeField, bizBookIds);
                        list.add(bookTypefilter);
                    } else {
                        QFilter bookfilter = new QFilter(billBookField, "in", (Object)bizBookIds);
                        QFilter bookTypefilter = this.getBookTypeFilter(entityKey, billBookTypeField, bizBookIds);
                        list.add(bookfilter.or(bookTypefilter));
                    }
                }
                String dBRouteKey = EntityMetadataCache.getDataEntityType((String)entityKey).getDBRouteKey();
                if ("cas_paybill".equals(entityKey) || "cas_recbill".equals(entityKey) || "ar_finarbill".equals(entityKey) || "ap_finapbill".equals(entityKey) || "ar_busbill".equals(entityKey) || "ap_busbill".equals(entityKey) || "ap_adjexchbill".equals(entityKey) || "ap_verifyrecord".equals(entityKey) || "ar_liquidation".equals(entityKey) || "ap_liquidation".equals(entityKey) || "ap_settlerecord".equals(entityKey) || "ar_baddebtreserve".equals(entityKey) || "ar_revcfmbill".equals(entityKey) || "ar_settlerecord".equals(entityKey) || "ar_verifyrecord".equals(entityKey) || "ar_baddebtlossbill".equals(entityKey)) {
                    list.add(new QFilter("isvoucher", "=", (Object)"0"));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u672a\u8bbe\u7f6e\u51ed\u8bc1\u6a21\u677f\uff0c\u6216\u6838\u7b97\u4e3b\u4f53\u4e0d\u662f\u5b9e\u4f53\u8d26\u7c3f\u3002", (String)"BuildVchWizardEdit_7", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            para.getListFilterParameter().setQFilters(list);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, Key_FBillFilterDesc);
            para.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)para);
        } else if (srcControl.getKey().equalsIgnoreCase(Key_FMatchFieldName)) {
            this.matchFieldBeforeSelectListener(evt);
            this.showExpressionSetForm(Key_SrcBillSubEntity, Key_FMatchFieldKey, Key_FMatchFieldName);
        }
    }

    private Set<Long> getHasBuildVchBillids(String billType, long orgId) {
        HashSet<Long> ids = new HashSet<Long>(10000);
        QFilter billTypeQfilter = new QFilter("billtype", "=", (Object)billType);
        QFilter orgQfilter = new QFilter("org.id", "=", (Object)orgId);
        int i = 0;
        try (DataSet set = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.formplugin.BuildVchWizardEdit.getHasBuildVchBillids", (String)"ai_daptracker", (String)"sourcebillid", (QFilter[])new QFilter[]{billTypeQfilter, orgQfilter}, null);){
            for (Row row : set) {
                ids.add(row.getLong("sourcebillid"));
                if (++i < 10000) continue;
                HashSet<Long> hashSet = ids;
                return hashSet;
            }
        }
        return ids;
    }

    private QFilter getBookTypeFilter(String entityKey, String billBookTypeField, Set<Long> bizBookIds) {
        String appNumber = DapCache.getBillEntityAppNumber((String)entityKey);
        AppBookConfig appconfig = DapCache.appConfig.get(appNumber);
        DynamicObject[] bizbooks = BusinessDataServiceHelper.load((String)appconfig.bookEntity, (String)("id," + appconfig.bookEntityTypeField), (QFilter[])new QFilter[]{new QFilter("id", "in", bizBookIds)});
        HashSet<Long> bizBookTypeIDs = new HashSet<Long>(bizbooks.length);
        for (DynamicObject bizbook : bizbooks) {
            bizBookTypeIDs.add(bizbook.getLong(appconfig.bookEntityTypeField + ".id"));
        }
        QFilter bookTypefilter = new QFilter(billBookTypeField, "in", bizBookTypeIDs);
        return bookTypefilter;
    }

    private void matchFieldBeforeSelectListener(EventObject e) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(Key_SrcBillSubEntity);
        DynamicObject sourceBill = (DynamicObject)this.getModel().getValue(Key_FSourceBill, rowIndex);
        if (null == sourceBill) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6765\u6e90\u5355\u636e\u3002", (String)"BuildVchWizardEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
    }

    private String getListEntityKey(String entityKey) {
        if (entityKey.indexOf("er_tripreimbursebill") == 0) {
            return "er_layout_tripreimburse";
        }
        if (entityKey.indexOf("er_tripreqbill") == 0) {
            return "er_layout_tripreqbill";
        }
        if (entityKey.indexOf("er_dailyreimburse") == 0) {
            return "er_layout_dailyreimburse";
        }
        if (entityKey.indexOf("er_dailyloanbill") == 0) {
            return "er_layout_dailyloanbill";
        }
        if (entityKey.indexOf("er_publicreimbursebill") == 0) {
            return "er_layout_publicreimburse";
        }
        return entityKey;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map map;
        String data;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (Key_FBillFilterDesc.equalsIgnoreCase(actionId)) {
            ListSelectedRowCollection data2 = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (data2 != null) {
                int currBillEntryRowIndex = this.getModel().getEntryCurrentRowIndex(Key_SrcBillSubEntity);
                this.getModel().setValue(Key_FBillFilter, (Object)SerializationUtils.toJsonString((Object)data2.getPrimaryKeyValues()), currBillEntryRowIndex);
                this.getModel().setValue(Key_FBillFilterDesc, (Object)this.getFbillfilterdesc(data2.getPrimaryKeyValues()), currBillEntryRowIndex);
            }
        } else if (Key_FMatchFieldName.equalsIgnoreCase(actionId)) {
            this.receiveExpressionSet(closedCallBackEvent, Key_SrcBillSubEntity, Key_FMatchFieldKey, Key_FMatchFieldName);
        } else if ("ai_buildvch_progress".equalsIgnoreCase(actionId) && (data = (String)closedCallBackEvent.getReturnData()) != null && (map = (Map)SerializationUtils.fromJsonString((String)data, Map.class)) != null) {
            Boolean isSuccess = ObjectConverterFactory.getBoolean(map.get("isSuccess"), (Boolean)false);
            IFormView view = this.getView();
            String genResult = ResManager.loadKDString((String)"\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u8bf7\u67e5\u770b\u51ed\u8bc1\u751f\u6210\u62a5\u544a\u786e\u8ba4\u662f\u5426\u6210\u529f\u3002", (String)"BuildVchWizardEdit_13", (String)"fi-ai-formplugin", (Object[])new Object[0]);
            if (isSuccess.booleanValue()) {
                String successMsg = (String)map.get("success");
                if (StringUtils.isNotEmpty((CharSequence)successMsg)) {
                    genResult = successMsg;
                }
                view.showSuccessNotification(genResult);
            } else {
                String error = (String)map.get("error");
                if (StringUtils.isNotBlank((CharSequence)error)) {
                    genResult = error;
                }
                view.showTipNotification(genResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFbillfilterdesc(Object[] primaryKeyValues) {
        ArrayList<String> billNoArr = new ArrayList<String>(10);
        DynamicObject sourcebillObject = (DynamicObject)this.getModel().getValue(Key_FSourceBill);
        List<Object> aList = Arrays.asList(primaryKeyValues);
        Boolean cc = false;
        if (primaryKeyValues.length > 10) {
            aList = aList.subList(0, 10);
            cc = true;
        }
        String billType = sourcebillObject.getString("number");
        String billNo = DapBuildVoucherCommonUtil.getBillNoFormBill((String)billType);
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.formplugin.BuildVchWizardEdit", (String)billType, (String)billNo, (QFilter[])new QFilter("id", "in", aList).toArray(), null);){
            for (Row next : queryDataSet) {
                String q = (String)next.get(billNo);
                billNoArr.add(q);
            }
        }
        String billNums = String.join((CharSequence)",", billNoArr);
        if (cc.booleanValue()) {
            billNums = billNums + "...";
        }
        return billNums;
    }

    private boolean buildVchPreCheck() {
        int bookRowCount = this.getModel().getEntryRowCount(Key_AcctBookEntity);
        for (int row = 0; row < bookRowCount; ++row) {
            DynamicObject bizOrg = (DynamicObject)this.getModel().getValue(KEY_BIZORG, row);
            if (bizOrg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5355\u5143\u3002", (String)"BuildVchWizardEdit_5", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return false;
            }
            HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)"ai", (String)this.getView().getEntityId(), (String)PermissonType.CREATEVOUCHER.getPermId());
            if (!(result.hasAllOrgPerm() || null != result.getHasPermOrgs() && result.getHasPermOrgs().contains((Long)bizOrg.getPkValue()))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143\u201c%s\u201d\u6ca1\u6709\u51ed\u8bc1\u751f\u6210\u6743\u9650\u3002", (String)"BuildVchWizardEdit_6", (String)"fi-ai-formplugin", (Object[])new Object[]{bizOrg.getString("name")}));
                return false;
            }
            if (this.getModel().getValue(KEY_ACCTORG, row) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"BuildVchWizardEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (this.getModel().getValue(KEY_BOOKTYPE, row) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"BuildVchWizardEdit_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (this.getModel().getValue(Key_FPeriod, row) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"BuildVchWizardEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return false;
            }
            DynamicObject bookRowDO = this.getModel().getEntryRowEntity(Key_AcctBookEntity, row);
            DynamicObjectCollection billSubDOS = bookRowDO.getDynamicObjectCollection(Key_SrcBillSubEntity);
            for (DynamicObject billSubDO : billSubDOS) {
                if (billSubDO.getDynamicObject(Key_FSourceBill) != null) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u5206\u5f55\u7b2c\u201c%1$s\u201d\u884c\u7684\u6765\u6e90\u5355\u636e\u3002", (String)"BuildVchWizardEdit_10", (String)"fi-ai-formplugin", (Object[])new Object[0]), row + 1));
                return false;
            }
        }
        return true;
    }

    private void doBuildVoucher() {
        boolean allowBuild = this.buildVchPreCheck();
        if (!allowBuild) {
            return;
        }
        DistributeCache Cache2 = CacheHelper.getDistributeCache((CacheModule)CacheModule.generationvoucherfail);
        String cacheKeyId = UUID.randomUUID().toString();
        ArrayList resultList = new ArrayList();
        HashMap resultinfo = new HashMap();
        Cache2.put("generation-voucher-fail" + cacheKeyId, SerializationUtils.toJsonString(resultList));
        Cache2.put("generation-voucher-failinfo" + cacheKeyId, SerializationUtils.toJsonString(resultinfo));
        List<Object> schemalist = new ArrayList(8);
        try {
            schemalist = this.getBuildScheme(cacheKeyId);
            if (schemalist.isEmpty()) {
                return;
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u67e5\u770b\u3002", (String)"BuildVchWizardEdit_27", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            log.error((Throwable)e);
            log.error("##########  DAP\u51ed\u8bc1\u751f\u6210  doBuildVoucher()  #  \u6253\u5370\u65e5\u5fd7\u9519\u8bef\uff1a " + e.getMessage());
            return;
        }
        List nullBooks = schemalist.stream().filter(v -> v.getSelectedBooks().size() == 0).collect(Collectors.toList());
        if (!nullBooks.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u9700\u8981\u751f\u6210\u51ed\u8bc1\u7684\u8d26\u7c3f\u3001\u6838\u7b97\u7ec4\u7ec7\u3001\u671f\u95f4\u3001\u6765\u6e90\u5355\u636e\u3001\u5355\u636e\u8303\u56f4\u548c\u6c47\u603b\u65b9\u5f0f\u3002", (String)"BuildVchWizardEdit_9", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        String pageId = this.getPageCache().getPageId();
        FormShowParameter param = new FormShowParameter();
        param.setFormId("ai_buildvch_progress");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("pageId", (Object)pageId);
        param.setCustomParam("schemaCount", (Object)schemalist.size());
        param.setCustomParam("schemalist", (Object)FahSerializeHelper.toJsonString(schemalist));
        param.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "ai_buildvch_progress"));
        this.getView().showForm(param);
    }

    private void fillSchemeList() {
        TreeNode root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8\u65b9\u6848", (String)"BuildVchWizardEdit_14", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        root.setChildren(new ArrayList());
        TreeNode defScheme = new TreeNode("0", "default_scheme", ResManager.loadKDString((String)"\u9ed8\u8ba4\u65b9\u6848", (String)"BuildVchWizardEdit_15", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        root.addChild(defScheme);
        TreeView tree = (TreeView)this.getView().getControl(Key_TVScheme);
        tree.addNode(root);
        root.setIsOpened(true);
    }

    private void fillAcctBooks() {
        List bizOrgIds = AccSysUtil.getAcctOrgPkList((String)"gl_voucher", (boolean)false, (PermissonType)PermissonType.VIEW);
        HashMap<Long, DynamicObject> orgList = new HashMap<Long, DynamicObject>();
        for (Long bizid : bizOrgIds) {
            DynamicObject book = BusinessDataServiceHelper.loadSingle((String)"gl_accountbook", (String)"id,curperiod.id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)bizid)});
            if (book != null) {
                orgList.put(bizid, book);
                continue;
            }
            DynamicObjectCollection coll = AccSysConfigsReader.getAccOrgFromBizOrg((Long)bizid);
            if (coll == null || coll.size() <= 0) continue;
            DynamicObject accOrg = ((DynamicObject)coll.get(0)).getDynamicObject("toorg");
            DynamicObject bookInfo = AccSysConfigsReader.getBookFromAccSys((long)accOrg.getLong("id"));
            orgList.put(bizid, bookInfo);
        }
        DynamicObjectCollection vchTempObjs = VchTemplateReader.LoadVchTemplates();
        HashMap fitBills = new HashMap();
        HashSet<String> fitAllBills = new HashSet<String>();
        for (DynamicObject obj : vchTempObjs) {
            String srcBillId;
            DynamicObject srcBillObj = obj.getDynamicObject("fsourcebill");
            String string = srcBillId = srcBillObj == null ? "" : srcBillObj.getPkValue().toString();
            if (StringUtils.isBlank((CharSequence)srcBillId)) continue;
            DynamicObjectCollection acctBookRows = obj.getDynamicObjectCollection("facctbookid");
            if (acctBookRows == null || acctBookRows.size() == 0) {
                if (fitAllBills.contains(srcBillId)) continue;
                fitAllBills.add(srcBillId);
                continue;
            }
            for (DynamicObject row : acctBookRows) {
                HashSet fitBill;
                long acctBookId = row.getLong("fbasedataid_id");
                if (acctBookId <= 0L) continue;
                if (!fitBills.containsKey(acctBookId)) {
                    fitBills.put(acctBookId, new HashSet());
                }
                if ((fitBill = (HashSet)fitBills.get(acctBookId)).contains(srcBillId)) continue;
                fitBill.add(srcBillId);
            }
        }
        int rowCount = this.getModel().getEntryRowCount(Key_AcctBookEntity);
        if (orgList.size() > rowCount) {
            this.getModel().batchCreateNewEntryRow(Key_AcctBookEntity, orgList.size() - rowCount);
        }
        Set bizOrgs = orgList.entrySet();
        int acctBookRow = 0;
        HashSet<String> fitThisAcctBook = new HashSet<String>();
        for (Map.Entry ety : bizOrgs) {
            this.getModel().setValue(KEY_BIZORG, ety.getKey(), acctBookRow);
            this.getModel().setEntryCurrentRowIndex(Key_AcctBookEntity, acctBookRow);
            this.getModel().setValue(Key_FSelectedBook, (Object)Boolean.TRUE, acctBookRow);
            DynamicObject acctBookObj = (DynamicObject)orgList.get(ety.getKey());
            long acctBookId = (Long)acctBookObj.getPkValue();
            this.getModel().setValue(Key_FAcctBook, (Object)acctBookId, acctBookRow);
            DynamicObject currPeriod = (DynamicObject)acctBookObj.get("curperiod");
            if (currPeriod != null) {
                this.getModel().setValue(Key_FPeriod, currPeriod.getPkValue(), acctBookRow);
            }
            this.getModel().setValue(Key_FBuildType, (Object)"0", acctBookRow);
            Set bookSet = (Set)fitBills.get(acctBookId);
            if (bookSet != null && !bookSet.isEmpty()) {
                fitThisAcctBook.addAll(bookSet);
            }
            for (String srcBillId : fitAllBills) {
                if (fitThisAcctBook.contains(srcBillId)) continue;
                fitThisAcctBook.add(srcBillId);
            }
            if (fitThisAcctBook.size() > 0) {
                int billRowCount = this.getModel().getEntryRowCount(Key_SrcBillSubEntity);
                if (billRowCount < fitThisAcctBook.size()) {
                    this.getModel().batchCreateNewEntryRow(Key_SrcBillSubEntity, fitThisAcctBook.size() - billRowCount);
                }
                int srcBillRow = 0;
                for (String srcBill : fitThisAcctBook) {
                    this.getModel().setValue(Key_FSelectedBill, (Object)Boolean.TRUE, srcBillRow);
                    this.getModel().setValue(Key_FSourceBill, (Object)srcBill, srcBillRow);
                    this.getModel().setValue(Key_FBillFilterDesc, (Object)ResManager.loadKDString((String)"\u5168\u90e8", (String)"BuildVchWizardEdit_16", (String)"fi-ai-formplugin", (Object[])new Object[0]), srcBillRow);
                    this.getModel().setValue(Key_FBillFilter, (Object)"", srcBillRow);
                    this.getModel().setValue(Key_FUnionType, (Object)"0", srcBillRow);
                    this.getModel().setValue(Key_FMatchFieldName, (Object)"", srcBillRow);
                    this.getModel().setValue(Key_FMatchFieldKey, (Object)"", srcBillRow);
                    ++srcBillRow;
                }
            }
            ++acctBookRow;
            fitThisAcctBook.clear();
        }
    }

    private List<BuildVchScheme> getBuildScheme(String batchCacheId) {
        ArrayList<BuildVchScheme> result = new ArrayList<BuildVchScheme>(8);
        int currBookEntryRowIndex = this.getModel().getEntryCurrentRowIndex(Key_AcctBookEntity);
        int currBillEntryRowIndex = this.getModel().getEntryCurrentRowIndex(Key_SrcBillSubEntity);
        int bookRowCount = this.getModel().getEntryRowCount(Key_AcctBookEntity);
        for (int bookRowIndex = 0; bookRowIndex < bookRowCount; ++bookRowIndex) {
            HashMap acctOrg2acctOrgCache = new HashMap();
            HashMap bizBook2AcctBookCache = new HashMap();
            DapBookHelper bookHelper = new DapBookHelper(bizBook2AcctBookCache, acctOrg2acctOrgCache);
            BuildVchScheme scheme = new BuildVchScheme();
            scheme.setTransId(UUID.randomUUID().toString());
            scheme.setBatchCacheId(batchCacheId);
            result.add(scheme);
            boolean selectedBook = (Boolean)this.getModel().getValue(Key_FSelectedBook, bookRowIndex);
            if (!selectedBook) continue;
            this.getModel().setEntryCurrentRowIndex(Key_AcctBookEntity, bookRowIndex);
            DynamicObject bookRow = this.getModel().getEntryRowEntity(Key_AcctBookEntity, bookRowIndex);
            SelectedAcctBook acctBook = new SelectedAcctBook();
            long bizOrgID = (Long)bookRow.getDynamicObject(KEY_BIZORG).getPkValue();
            acctBook.setBizOrgId(bizOrgID);
            acctBook.setBookId(((Long)bookRow.getDynamicObject(Key_FAcctBook).getPkValue()).longValue());
            acctBook.setPeriodId(((Long)bookRow.getDynamicObject(Key_FPeriod).getPkValue()).longValue());
            acctBook.setCoverGLVoucher(false);
            String buildType = bookRow.getString(Key_FBuildType);
            if (String.valueOf(BuildVoucherType.OnlyBizVoucher.ordinal()).equals(buildType)) {
                acctBook.setBuildVoucherType(BuildVoucherType.OnlyBizVoucher);
            } else if (String.valueOf(BuildVoucherType.OnlyGLVoucher.ordinal()).equals(buildType)) {
                acctBook.setBuildVoucherType(BuildVoucherType.OnlyGLVoucher);
            } else if (DapBuildVoucherCommonUtil.getEnableBizVoucherSystemParam((Long)bizOrgID).booleanValue()) {
                acctBook.setBuildVoucherType(BuildVoucherType.BillToBizAndGLVoucher);
            } else {
                acctBook.setBuildVoucherType(BuildVoucherType.BizAndGLVoucher);
            }
            DynamicObject bookRowDO = this.getModel().getEntryRowEntity(Key_AcctBookEntity, bookRowIndex);
            DynamicObjectCollection billSubDOS = bookRowDO.getDynamicObjectCollection(Key_SrcBillSubEntity);
            for (DynamicObject billDO : billSubDOS) {
                String[] pops;
                boolean selectedBill = billDO.getBoolean(Key_FSelectedBill);
                if (!selectedBill) continue;
                String billEntityNumber = (String)billDO.getDynamicObject(Key_FSourceBill).getPkValue();
                String billIdString = billDO.getString(Key_FBillFilter);
                Set billIds = new HashSet();
                String billIdStringdesc = billDO.getString(Key_FBillFilterDesc);
                if (StringUtils.isEmpty((CharSequence)billIdString) || StringUtils.isEmpty((CharSequence)billIdStringdesc)) continue;
                billIds = (Set)SerializationUtils.fromJsonString((String)billIdString, Set.class);
                SelectedSourceBill sourceBill = new SelectedSourceBill();
                sourceBill.setEntityNumber(billEntityNumber);
                sourceBill.setBillIds(billIds);
                String unionType = billDO.getString(Key_FUnionType);
                if (String.valueOf(GLVoucherUnionType.UnionAll.getValue()).equals(unionType)) {
                    sourceBill.setUnionType(GLVoucherUnionType.UnionAll);
                } else if (String.valueOf(GLVoucherUnionType.UnionByFields.getValue()).equals(unionType)) {
                    sourceBill.setUnionType(GLVoucherUnionType.UnionByFields);
                } else if (String.valueOf(GLVoucherUnionType.UnionSpanBill.getValue()).equals(unionType)) {
                    sourceBill.setUnionType(GLVoucherUnionType.UnionSpanBill);
                } else {
                    sourceBill.setUnionType(GLVoucherUnionType.Single);
                }
                String unionFieldKeys = billDO.getString(Key_FMatchFieldKey);
                sourceBill.setUnionFields(unionFieldKeys);
                DapConfig cg = DapCache.getDapConfigCache((String)billEntityNumber);
                String billBookTypeField = DapCache.getBillBookTypeField((String)billEntityNumber);
                String billBookField = DapCache.getBillBookField((String)billEntityNumber);
                StringBuilder sbSel = new StringBuilder();
                String selector = "id," + DapBuildVoucherCommonUtil.getBillNoFormBill((String)billEntityNumber);
                sbSel.append(selector);
                for (String orgPropName : cg.getBizOrgFields()) {
                    sbSel.append(",");
                    sbSel.append(orgPropName);
                    String[] pops2 = orgPropName.split("\\.");
                    if (pops2.length <= 1) continue;
                    for (int i = 0; i < pops2.length - 1; ++i) {
                        sbSel.append(",");
                        if (i > 0) {
                            for (int j = 0; j < i; ++j) {
                                sbSel.append(pops2[j]);
                                sbSel.append(".");
                            }
                        }
                        sbSel.append(pops2[i]);
                        sbSel.append(".id");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)billBookField)) {
                    sbSel.append(",");
                    sbSel.append(billBookField);
                    pops = billBookField.split("\\.");
                    if (pops.length > 1) {
                        for (int i = 0; i < pops.length - 1; ++i) {
                            sbSel.append(",");
                            if (i > 0) {
                                for (int j = 0; j < i; ++j) {
                                    sbSel.append(pops[j]);
                                    sbSel.append(".");
                                }
                            }
                            sbSel.append(pops[i]);
                            sbSel.append(".id");
                        }
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)billBookTypeField)) {
                    sbSel.append(",");
                    sbSel.append(billBookTypeField);
                    pops = billBookTypeField.split("\\.");
                    if (pops.length > 1) {
                        for (int i = 0; i < pops.length - 1; ++i) {
                            sbSel.append(",");
                            if (i > 0) {
                                for (int j = 0; j < i; ++j) {
                                    sbSel.append(pops[j]);
                                    sbSel.append(".");
                                }
                            }
                            sbSel.append(pops[i]);
                            sbSel.append(".id");
                        }
                    }
                }
                ArrayList params2 = new ArrayList(sourceBill.getBillIds());
                List p2s = ListUtils.partition(params2, (int)500);
                p2s.forEach(e -> {
                    DynamicObjectCollection bills = QueryServiceHelper.query((String)billEntityNumber, (String)sbSel.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", e)});
                    for (DynamicObject bill : bills) {
                        bookHelper.getSingleBillAcctBook(billEntityNumber, cg.getBizOrgFields(), billBookField, billBookTypeField, bill);
                    }
                });
                acctBook.getSelectedSourceBills().add(sourceBill);
            }
            if (acctBook.getSelectedSourceBills().size() > 0) {
                scheme.getSelectedBooks().add(acctBook);
            }
            scheme.setAcctOrg2acctOrgCache(acctOrg2acctOrgCache);
            scheme.setBizBook2AcctBookCache(bizBook2AcctBookCache);
        }
        this.getModel().setEntryCurrentRowIndex(Key_AcctBookEntity, currBookEntryRowIndex);
        this.getModel().setEntryCurrentRowIndex(Key_SrcBillSubEntity, currBillEntryRowIndex);
        return result;
    }

    private void showExpressionSetForm(String entityKey, String expressionFldKey, String descFldKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ai_expression");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(entityKey);
        String expression = (String)this.getModel().getValue(expressionFldKey, rowIndex);
        String descFldValue = (String)this.getModel().getValue(descFldKey, rowIndex);
        VchTplExpression exprObj = new VchTplExpression();
        exprObj.setExprType(ExpressionType.DynamicText);
        exprObj.setExpression(expression);
        LocaleString description = new LocaleString();
        description.put(Lang.defaultLang().toString(), (Object)descFldValue);
        exprObj.setDescription(description);
        String exprJson = SerializationUtils.toJsonString((Object)exprObj);
        showParameter.setCustomParam("expression", (Object)exprJson);
        String entityNumber = (String)((DynamicObject)this.getModel().getValue(Key_FSourceBill, rowIndex)).getPkValue();
        String fieldNodes = this.findMatchFields(entityNumber);
        if (entityNumber != null) {
            showParameter.getCustomParams().put("entitynumber", entityNumber);
            showParameter.getCustomParams().put("build", entityNumber);
        }
        showParameter.setCustomParam("treenodes", (Object)fieldNodes);
        showParameter.setCustomParam(NON_FIELDS, (Object)this.getPageCache().get(NON_FIELDS));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, descFldKey);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void receiveExpressionSet(ClosedCallBackEvent closedCallBackEvent, String entityKey, String expressionFldKey, String descFldKey) {
        if (closedCallBackEvent.getReturnData() != null) {
            String str = (String)closedCallBackEvent.getReturnData();
            VchReturnData retData = (VchReturnData)SerializationUtils.fromJsonString((String)str, VchReturnData.class);
            int row = this.getModel().getEntryCurrentRowIndex(entityKey);
            if (StringUtils.isBlank((CharSequence)str)) {
                this.getModel().setValue(expressionFldKey, (Object)"", row);
                this.getModel().setValue(descFldKey, (Object)"", row);
            } else {
                VchTplExpression exprObj = (VchTplExpression)SerializationUtils.fromJsonString((String)retData.getDataStr(), VchTplExpression.class);
                this.getModel().setValue(expressionFldKey, (Object)exprObj.getExpression(), row);
                this.getModel().setValue(descFldKey, (Object)exprObj.getExprTran(), row);
            }
        }
    }

    private String findMatchFields(String entityNumber) {
        MainEntityType srcMainET = EntityMetadataCache.getDataEntityType((String)entityNumber);
        EntityFieldTreeOption option = EntityFieldTreeOption.create();
        option.setEntityType((IDataEntityType)srcMainET);
        option.setReadEntryEntity(false);
        option.setExprType(ExpressionType.DynamicText);
        EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
        this.getPageCache().put(NON_FIELDS, SerializationUtils.toJsonString((Object)result.getNonFields()));
        TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
        String toJson = SerializationUtils.toJsonString((Object)tree);
        return toJson;
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        HasPermOrgResult result;
        Object source = arg0.getSource();
        Control sourceCtl = (Control)source;
        String key = sourceCtl.getKey();
        int row = arg0.getRow();
        if (Key_FPeriod.equals(key)) {
            DynamicObject acctBook = (DynamicObject)this.getModel().getValue(Key_FAcctBook, row);
            if (acctBook == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u8d26\u7c3f\u8bbe\u7f6e\uff0c\u8bf7\u68c0\u67e5\u6838\u7b97\u4f53\u7cfb\u914d\u7f6e\u3002", (String)"BuildVchWizardEdit_26", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                arg0.setCancel(true);
            } else {
                ListShowParameter param = (ListShowParameter)arg0.getFormShowParameter();
                Long periodTypeID = acctBook.getLong("periodtype.id");
                ArrayList<QFilter> list = new ArrayList<QFilter>();
                list.add(new QFilter("periodtype", "=", (Object)periodTypeID));
                param.getListFilterParameter().setQFilters(list);
            }
        } else if (KEY_ACCTORG.equals(key)) {
            DynamicObject bizorg = (DynamicObject)this.getModel().getValue(KEY_BIZORG, row);
            if (bizorg == null) {
                arg0.setCancel(true);
                return;
            }
            DynamicObjectCollection orgRels = AccSysConfigsReader.getAccOrgFromBizOrg((Long)bizorg.getLong("id"));
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(bizorg.getLong("id"));
            for (DynamicObject orgRel : orgRels) {
                ids.add(orgRel.getLong("toorg"));
            }
            Set acctOrg = DapUtil.getAcctOrgIncludeSelf((long)bizorg.getLong("id"));
            acctOrg.addAll(ids);
            ListShowParameter param = (ListShowParameter)arg0.getFormShowParameter();
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            list.add(new QFilter("id", "in", (Object)acctOrg));
            param.getListFilterParameter().setQFilters(list);
        } else if (Key_FSourceBill.equals(key)) {
            ListShowParameter param = (ListShowParameter)arg0.getFormShowParameter();
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            list.add(new QFilter("id", "in", (Object)DapUtil.getDapBillEntitys()));
            list.add(new QFilter("bizappid", "<>", (Object)FormBuilderConstant.BIZ_APP_ID));
            param.getListFilterParameter().setQFilters(list);
        } else if (KEY_BIZORG.equals(key) && (result = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)"ai", (String)this.getView().getEntityId(), (String)PermissonType.CREATEVOUCHER.getPermId())) != null && !result.hasAllOrgPerm()) {
            List orgIds = result.getHasPermOrgs();
            ListShowParameter param = (ListShowParameter)arg0.getFormShowParameter();
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            if (orgIds != null && !orgIds.isEmpty()) {
                list.add(new QFilter("id", "in", (Object)orgIds));
            } else {
                list.add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
            }
            param.getListFilterParameter().setQFilters(list);
        }
    }
}

