/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.v2.fah.utils.StringUtils;

public class CheckRebillToDapTrackerData
extends AbstractFormPlugin {
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btn = (Button)this.getControl("check");
        btn.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "check": {
                Object size = this.checkData();
                this.getView().showMessage("success!   size:" + size);
            }
        }
    }

    private Object checkData() {
        IDataModel model = this.getModel();
        DynamicObject m = (DynamicObject)model.getValue("main");
        DynamicObject r = (DynamicObject)model.getValue("reloper");
        if (m == null || r == null) {
            this.getView().showErrorNotification("A!!!");
            return 0;
        }
        ArrayList<String> mainnocol = new ArrayList<String>(8);
        ArrayList<String> relopernocol = new ArrayList<String>(8);
        HashMap<String, String> mainAndreloper = new HashMap<String, String>(8);
        DynamicObjectCollection entries = model.getEntryEntity("entryentity");
        for (DynamicObject e : entries) {
            String mn = e.getString("mainno");
            String rn = e.getString("reloperno");
            if (StringUtils.isEmpty((String)mn) || StringUtils.isEmpty((String)rn)) continue;
            mainnocol.add(mn);
            relopernocol.add(rn);
            mainAndreloper.put(mn, rn);
        }
        HashMap<Long, String> mlcol = new HashMap<Long, String>(8);
        HashMap<String, Long> rlcol = new HashMap<String, Long>(8);
        Collection mls = BusinessDataServiceHelper.loadFromCache((String)m.getPkValue().toString(), (String)"id,billno", (QFilter[])new QFilter("billno", "in", mainnocol).toArray()).values();
        Collection rls = BusinessDataServiceHelper.loadFromCache((String)r.getPkValue().toString(), (String)"id,billno", (QFilter[])new QFilter("billno", "in", relopernocol).toArray()).values();
        HashSet<Long> sids = new HashSet<Long>(16);
        for (DynamicObject ml : mls) {
            mlcol.put(ml.getLong("id"), ml.getString("billno"));
            sids.add(ml.getLong("id"));
        }
        for (DynamicObject rl : rls) {
            rlcol.put(rl.getString("billno"), rl.getLong("id"));
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(rlcol.size());
        int i = 0;
        long[] tad = DB.genLongIds((String)"t_ai_daptracker", (int)(rlcol.size() + 8));
        if (sids.isEmpty()) {
            return 0;
        }
        SqlBuilder sbd = new SqlBuilder();
        sbd.append("select fvoucherid,fsourcebillid,fcreatedate,fvchtemplateid,forgid,fbooktypeid,fperiodid,foper from t_ai_daptracker where ", new Object[0]).appendIn("fsourcebillid", sids.toArray());
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.ai.formplugin.AiAddDaptrackerPlugin", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sbd);){
            for (Row next : queryDataSet) {
                Long sid = next.getLong("fsourcebillid");
                String mlnum = (String)mlcol.get(sid);
                String rlnum = (String)mainAndreloper.get(mlnum);
                params.add(new Object[]{tad[++i], next.get("fvoucherid"), rlcol.get(rlnum), next.get("fcreatedate"), next.get("fvchtemplateid"), next.get("forgid"), next.get("fbooktypeid"), next.get("fperiodid"), next.get("foper"), r.getPkValue().toString()});
            }
        }
        if (!params.isEmpty()) {
            String insertsql = "insert into t_ai_daptracker(fid,fvoucherid,fsourcebillid,fcreatedate,fvchtemplateid,forgid,fbooktypeid,fperiodid,foper,fbilltype) values (?,?,?,?,?,?,?,?,?,?)";
            int[] executeBatch = DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)insertsql, params);
            return params.size();
        }
        return 0;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }
}

