/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;

public class ClearDapWhiteDataPlugin
extends AbstractFormPlugin {
    private Log logger = LogFactory.getLog(ClearDapWhiteDataPlugin.class);

    public void initialize() {
        super.initialize();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setShortCuts();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap111"});
    }

    private void setShortCuts() {
        JSONArray arrayItem = new JSONArray();
        JSONObject item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"shift+m");
        arrayItem.add((Object)item);
        IFormView formView = this.getView();
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        JSONArray action = new JSONArray();
        action.add((Object)arrayItem);
        clientViewProxy.addAction("setShortCuts", (Object)action);
    }

    public void customEvent(CustomEventArgs e) {
        String key;
        super.customEvent(e);
        if (e.getEventName().equalsIgnoreCase("shortCuts") && "[16,77]".equals(key = e.getEventArgs())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap111"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button selectdapw = (Button)this.getControl("selectdapw");
        selectdapw.addClickListener((ClickListener)this);
        Button btndapw = (Button)this.getControl("btndapw");
        btndapw.addClickListener((ClickListener)this);
        Button btnexecute = (Button)this.getControl("btnexecute");
        btnexecute.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Object value = this.getModel().getValue("main");
        if (null == value) {
            this.getView().showMessage("billType can not be empty...");
            return;
        }
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "btnexecute": {
                this.executeSql();
                break;
            }
            case "selectdapw": {
                this.selectData();
                break;
            }
            case "btndapw": {
                this.truncateData();
            }
        }
    }

    private void selectData() {
        DynamicObject value = (DynamicObject)this.getModel().getValue("main");
        String pkValue = (String)value.getPkValue();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)pkValue);
        String alias = entityType.getAlias();
        String routeKey = entityType.getDBRouteKey();
        String table = alias + "_dapw";
        boolean exitsTable = DB.exitsTable((DBRoute)DBRoute.of((String)routeKey), (String)table);
        if (!exitsTable) {
            this.getView().showMessage("billType _dapw is not exist...");
            return;
        }
        String sql = "select count(1) count from " + table;
        try (DataSet queryDataSet = DB.queryDataSet((String)ClearDapWhiteDataPlugin.class.getName(), (DBRoute)DBRoute.of((String)routeKey), (String)sql);){
            for (Row row : queryDataSet) {
                Object count = row.get("count");
                this.getModel().setValue("billdapwcount", count);
            }
        }
    }

    private void truncateData() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u5220\u9664\u8be5\u5355\u636e\u7684dap\u767d\u540d\u5355\u5168\u8868\u6570\u636e\uff1f", (String)"ClearDapWhiteDataPlugin_01", (String)"fi-ai-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("clearDapw", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        MessageBoxResult result = evt.getResult();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            DynamicObject value = (DynamicObject)this.getModel().getValue("main");
            String pkValue = (String)value.getPkValue();
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)pkValue);
            String alias = entityType.getAlias();
            String routeKey = entityType.getDBRouteKey();
            String table = alias + "_dapw";
            boolean exitsTable = DB.exitsTable((DBRoute)DBRoute.of((String)routeKey), (String)table);
            if (!exitsTable) {
                this.getView().showMessage("billType _dapw is not exist...");
                return;
            }
            String sql = "truncate table " + table;
            DB.execute((DBRoute)DBRoute.of((String)routeKey), (String)sql);
            this.getView().showSuccessNotification("success...");
        }
    }

    private void executeSql() {
        String name = (String)this.getModel().getValue("name");
        String data = (String)this.getModel().getValue("data");
        if (StringUtils.isEmpty((CharSequence)name) || StringUtils.isEmpty((CharSequence)data)) {
            this.getView().showMessage("not support...");
            return;
        }
        if (name.startsWith("&&") && data.startsWith("&&")) {
            String rou = name.replace("&&", "");
            String sql = data.replace("&&", "");
            if (StringUtils.isNotEmpty((CharSequence)rou) && StringUtils.isNotEmpty((CharSequence)sql) && sql.contains("WHERE")) {
                this.logger.info("start execute :" + name + "xxx:" + data);
                DB.execute((DBRoute)DBRoute.of((String)rou), (String)sql);
                this.getView().showSuccessNotification("success...");
                this.logger.info("end sql execute");
            }
        }
    }
}

