/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ai.formplugin.MapTypeListDataProvider;
import kd.fi.ai.formplugin.service.TemplateConnectUtil;

public class DataMapListExport
extends AbstractListPlugin {
    private MapTypeListDataProvider provider = new MapTypeListDataProvider();

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)this.provider);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String errMsg = this.provider.getErrMsg();
        if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
            this.getView().showErrorNotification(errMsg);
        }
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        super.afterQueryOfExport(e);
        this.dealWithExportData(e.getQueryValues());
    }

    public void dealWithExportData(DynamicObject[] queryVals) {
        HashSet<Long> destMapingSet = new HashSet<Long>(16);
        for (DynamicObject queryVal : queryVals) {
            DynamicObjectCollection dyns = queryVal.getDynamicObjectCollection("entryentity");
            if (dyns.isEmpty() || null == queryVal.getDynamicObject("destbasedata")) continue;
            for (DynamicObject entryentity : dyns) {
                destMapingSet.add(entryentity.getLong("destdatamapping_id"));
            }
            DynamicObjectCollection baseimportEntity = queryVal.getDynamicObjectCollection("basedataimport");
            String destnumber = queryVal.getDynamicObject("destbasedata").getString("number");
            Map<Object, DynamicObject> destResults = this.getDynamicObjects(destnumber, destMapingSet);
            for (DynamicObject entryRow : dyns) {
                String bdInfoImport = entryRow.getString("bdinfoimport");
                if (!StringUtils.isNotEmpty((CharSequence)bdInfoImport)) continue;
                DynamicObject importRow = baseimportEntity.addNew();
                int size = importRow.getDynamicObjectType().getProperties().size() / 2;
                String[] bdInfoImportRow = bdInfoImport.split(",");
                int count = Math.min(size, bdInfoImportRow.length);
                for (int i = 0; i < count; ++i) {
                    String[] factor = bdInfoImportRow[i].split(":");
                    importRow.set("sourcenumber" + i, (Object)factor[0]);
                    if (factor.length <= 1) continue;
                    importRow.set("sourcevalue" + i, (Object)factor[1]);
                }
                importRow.set("destdatanumber0", (Object)destnumber);
                DynamicObject dynamicObject = destResults.get(entryRow.get("destdatamapping_id"));
                if (null == dynamicObject) continue;
                importRow.set("destdatavalue0", dynamicObject.get("number"));
            }
            dyns.clear();
        }
    }

    private Map<Object, DynamicObject> getDynamicObjects(String destnumber, Set<Long> set) {
        Map dynMap = BusinessDataServiceHelper.loadFromCache((Object[])set.toArray(new Object[0]), (String)destnumber);
        return dynMap;
    }

    public void itemClick(ItemClickEvent evt) {
        if ("tbltemplateconnect".equals(evt.getItemKey())) {
            TemplateConnectUtil templateUtil = new TemplateConnectUtil();
            templateUtil.showTemplateConnectEditView(this.getView(), this.getModel());
        }
    }
}

