/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.EventObject;
import java.util.Iterator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.ai.util.GLUtil;

public class EventFieldSelectorPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    public static final String PARAM_EVENTCLASS = "eventclass";
    public static final String PARAM_SHOWENTRY = "showentry";
    private static final String SOURCEBILL = "sourcebill";
    private static final String TARGETBILL = "targetbill";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        TreeView tree = (TreeView)this.getControl("tv_fields");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        String aiMappingEdit = (String)param.getCustomParam("AiMappingEdit");
        TreeView tree = (TreeView)this.getControl("tv_fields");
        if (StringUtils.isNotBlank((CharSequence)aiMappingEdit)) {
            tree.addNode(this.getRootAiMapping());
        } else {
            tree.addNode(this.getRoot());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(ctlSource.getKey())) {
            TreeView tree = (TreeView)this.getControl("tv_fields");
            if (tree.getTreeState() == null || tree.getTreeState().getFocusNodeId() == null || ((Boolean)tree.getTreeState().getFocusNode().get("isParent")).booleanValue()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5b57\u6bb5\u3002", (String)"EventFieldSelectorPlugin_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            String nodeId = tree.getTreeState().getFocusNodeId();
            if ("true".equals(this.getPageCache().get("isMapping"))) {
                String name = (String)tree.getTreeState().getFocusNode().get("text");
                nodeId = nodeId + "," + name;
                this.getPageCache().remove("isMapping");
            }
            this.getView().returnDataToParent((Object)nodeId);
            this.getView().close();
        } else if ("btncancel".equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        this.getView().returnDataToParent(evt.getNodeId());
        this.getView().close();
    }

    private TreeNode getRoot() {
        DynamicObject evtClass = this.getEventClass();
        TreeNode root = new TreeNode();
        root.setId(evtClass.getString("number"));
        if (StringUtils.isEmpty((CharSequence)evtClass.getString("name"))) {
            root.setText(ResManager.loadKDString((String)"\u6839\u8282\u70b9", (String)"EventFieldSelectorPlugin_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        } else {
            root.setText(evtClass.getString("name"));
        }
        root.setIsOpened(true);
        DynamicObjectCollection fields = evtClass.getDynamicObjectCollection("fieldentryentity");
        for (DynamicObject field : fields) {
            TreeNode node = new TreeNode();
            node.setId(field.getString("fieldname"));
            node.setText(field.getString("fieldalias"));
            node.setParentid(root.getId());
            if (field.getString("fieldtype") != null && field.getString("fieldtype").equals("entry")) continue;
            node.setLeaf(true);
            root.addChild(node);
        }
        return root;
    }

    private void addNode(IDataEntityProperty property, TreeNode node) {
        EntryProp entryProp = (EntryProp)property;
        DataEntityPropertyCollection entrycollection = entryProp._collectionItemPropertyType.getProperties();
        for (IDataEntityProperty propertyChild : entrycollection) {
            TreeNode nodeChild = new TreeNode();
            String idChild = propertyChild.getName();
            if (propertyChild instanceof SubEntryProp) {
                this.addNode(propertyChild, nodeChild);
            }
            if ("id".equals(idChild) || idChild.contains("_id")) continue;
            nodeChild.setId(idChild);
            if (propertyChild.getDisplayName() != null) {
                nodeChild.setText(propertyChild.getDisplayName().getLocaleValue());
            }
            node.addChild(nodeChild);
        }
    }

    private TreeNode getRootAiMapping() {
        FormShowParameter param = this.getView().getFormShowParameter();
        DynamicObject obj = null;
        if (SOURCEBILL.equals(param.getCustomParam("AiMappingEdit"))) {
            obj = (DynamicObject)GLUtil.fromSerializedString((String)((String)param.getCustomParam(SOURCEBILL)));
        } else if (TARGETBILL.equals(param.getCustomParam("AiMappingEdit"))) {
            obj = (DynamicObject)GLUtil.fromSerializedString((String)((String)param.getCustomParam(TARGETBILL)));
        }
        if (obj == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EventFieldSelectorPlugin_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return null;
        }
        TreeNode root = new TreeNode();
        root.setId(obj.getString("id"));
        root.setIsOpened(true);
        root.setText(obj.getString("name"));
        MainEntityType et = MetadataServiceHelper.getDataEntityType((String)obj.getString("id"));
        DataEntityPropertyCollection collection = et.getProperties();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            TreeNode node = new TreeNode();
            IDataEntityProperty property = (IDataEntityProperty)iterator.next();
            String id = property.getName();
            if (property instanceof EntryProp) {
                this.addNode(property, node);
            }
            if ("id".equals(id) || id.contains("_id")) continue;
            node.setId(id);
            if (property.getDisplayName() != null) {
                node.setText(property.getDisplayName().getLocaleValue());
            }
            root.addChild(node);
        }
        this.getPageCache().put("isMapping", "true");
        return root;
    }

    private DynamicObject getEventClass() {
        DynamicObject evtClass = null;
        FormShowParameter param = this.getView().getFormShowParameter();
        Object eventClassPk = param.getCustomParam(PARAM_EVENTCLASS);
        evtClass = eventClassPk == null ? this.getView().getParentView().getModel().getDataEntity(true) : BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(eventClassPk.toString()), (String)"ai_eventclass");
        return evtClass;
    }
}

