/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.func.FuncSettingHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.excel.FormulaException;
import kd.bos.lang.Lang;
import kd.bos.threads.ThreadPools;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.VchReturnData;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.util.BuildTree;
import kd.fi.ai.util.EntityFieldUtil;

public class ExpressionEdit
extends AbstractFormPlugin
implements TreeNodeQueryListener,
TreeNodeClickListener,
SearchEnterListener {
    public static final String FormId_Expression = "ai_expression";
    public static final String CustParamKey_ExpressionJson = "expression";
    public static final String CustParamKey_TreeNodes = "treenodes";
    private static final String Key_FDescription = "fdescription";
    private static final String Key_FExpression = "fexpression";
    private static final String Key_FTranExpr = "ftranexpr";
    private static final String Key_FJson = "fjson";
    private static final String Key_btnOK = "btnok";
    private static final String Key_btnCancel = "btncancel";
    private static final String Key_TreeView = "tv_fields";
    public static final String BUILD = "build";
    public static final String IS_HIDE_OPERATION = "isHideOperation";
    public static final String ADD_SPECIAL_NODES = "addSpecialNodes";
    public static final String ENTRY_FILTER_SET = "entryFilterSet";
    public static final String Key_btnFunction = "btnfunction";
    public static final String CustParamKey_EntityNumber = "entitynumber";
    public static final String CustParamKey_FunctionTypes = "functiontypes";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel});
        this.addClickListeners(new String[]{"btnadd", "btnsubtraction", "btnmultiplication", "btndivison", "btnequal", "btnnotequal", "btnlessthen", "btnmorethen", "btnlessequal", "btnmoreequal", "btnand", "btnor", "btnleft", "btnright", Key_btnFunction});
        TreeView tv = (TreeView)this.getView().getControl(Key_TreeView);
        tv.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getView().getControl("searchfield");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String str = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_ExpressionJson);
        if (StringUtils.isNotBlank((CharSequence)str)) {
            VchTplExpression exprObj = (VchTplExpression)SerializationUtils.fromJsonString((String)str, VchTplExpression.class);
            String description = exprObj.getDescription().getLocaleValue();
            String expression = exprObj.getExpression();
            if (StringUtils.isBlank((CharSequence)description)) {
                description = BuildTree.tranExpression((String)expression, (MainEntityType)this.getEntityType());
            }
            this.getModel().setValue(Key_FDescription, (Object)description);
            this.getModel().setValue(Key_FTranExpr, (Object)description);
            this.getModel().setValue(Key_FExpression, (Object)expression);
            this.getModel().setValue(Key_FJson, (Object)str);
        }
    }

    public void afterBindData(EventObject e) {
        String id;
        super.afterBindData(e);
        Boolean isHideOperation = (Boolean)this.getView().getFormShowParameter().getCustomParam(IS_HIDE_OPERATION);
        if (Boolean.TRUE.equals(isHideOperation)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"fs_operation"});
        }
        if (StringUtils.isBlank((CharSequence)(id = (String)this.getView().getFormShowParameter().getCustomParam(BUILD)))) {
            return;
        }
        String json = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_TreeNodes);
        TreeNode rootNode = null;
        if (StringUtils.isNotBlank((CharSequence)json)) {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
            this.getPageCache().put(CustParamKey_TreeNodes, SerializationUtils.toJsonString((Object)rootNode));
        } else {
            String srcMainEntityType = (String)this.getView().getFormShowParameter().getCustomParam("srcMainEntityType");
            MainEntityType srcMainET = this.getEntityType();
            if ("expressionForMatch".equals(srcMainEntityType)) {
                rootNode = BuildTree.buildTree((MainEntityType)srcMainET, (String)"fexplanation", (ExpressionType)ExpressionType.DynamicText, (boolean)false, null, (boolean)false);
                this.getPageCache().put(CustParamKey_TreeNodes, SerializationUtils.toJsonString((Object)rootNode));
            } else {
                String entrySetStr = (String)this.getView().getFormShowParameter().getCustomParam(ENTRY_FILTER_SET);
                Set entrySet = null;
                if (StringUtils.isNotEmpty((CharSequence)entrySetStr)) {
                    entrySet = (Set)SerializationUtils.deSerializeFromBase64((String)entrySetStr);
                }
                boolean addSpecialNodes = !Boolean.FALSE.equals(this.getView().getFormShowParameter().getCustomParam(ADD_SPECIAL_NODES));
                Set finalEntrySet = entrySet;
                ThreadPools.executeOnce((String)"expressionEditGetTree", () -> {
                    TreeNode buildTree = BuildTree.buildTree((MainEntityType)this.getEntityType(), (String)"fexplanation", (ExpressionType)ExpressionType.DynamicText, (boolean)true, null, (boolean)false, (Set)finalEntrySet);
                    this.getPageCache().put(CustParamKey_TreeNodes, SerializationUtils.toJsonString((Object)buildTree));
                });
                rootNode = BuildTree.buildSimpleTree((MainEntityType)srcMainET, (String)"fexplanation", (ExpressionType)ExpressionType.DynamicText, (boolean)true, null, (boolean)false, (Set)entrySet, (boolean)addSpecialNodes);
            }
        }
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        tree.addNode(rootNode);
        tree.expand(rootNode.getId());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (Key_btnOK.equalsIgnoreCase(ctlSource.getKey())) {
            String cacheValue;
            String entitynumber;
            String currentFormId;
            VchTplExpression exprObj = this.getExprObj();
            VchReturnData returnData = EntityFieldUtil.validateDiffEntry((Object)exprObj, (String)(currentFormId = (String)this.getView().getFormShowParameter().getCustomParam("ai_button_key")), (String)(entitynumber = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_EntityNumber)), (String)(cacheValue = EntityFieldUtil.getCacheValueFromFormParameter((IFormView)this.getView())));
            if (returnData.isStatus()) {
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)returnData));
                this.getPageCache().remove(CustParamKey_TreeNodes);
                this.getView().close();
            } else if (!returnData.isStatus() && StringUtils.isNotEmpty((CharSequence)returnData.getMessage())) {
                this.getView().showTipNotification(returnData.getMessage());
            }
        } else if (Key_btnCancel.equalsIgnoreCase(ctlSource.getKey())) {
            this.getPageCache().remove(CustParamKey_TreeNodes);
            this.getView().close();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ctlSource.getKey(), (CharSequence)Key_btnFunction)) {
            this.showFuncSetting();
        } else {
            this.clickCompareButton(ctlSource.getKey());
        }
    }

    public void treeNodeClick(TreeNodeEvent arg0) {
        String expression = (String)this.getModel().getValue(Key_FExpression);
        String[] split = arg0.getNodeId().toString().replace("{", "").replace("}", "").split("#");
        expression = expression + "{" + split[split.length - 1] + "}";
        this.getModel().setValue(Key_FExpression, (Object)expression);
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)Key_btnFunction)) {
            if (StringUtils.isBlank((Object)closedCallBackEvent.getReturnData())) {
                return;
            }
            this.receiveFuncSetting((String)closedCallBackEvent.getReturnData());
        }
    }

    private VchTplExpression getExprObj() {
        VchTplExpression exprObj;
        String oldJson = (String)this.getModel().getValue(Key_FJson);
        if (StringUtils.isBlank((CharSequence)oldJson)) {
            exprObj = new VchTplExpression();
            exprObj.setExprType(ExpressionType.Condition);
        } else {
            exprObj = (VchTplExpression)SerializationUtils.fromJsonString((String)oldJson, VchTplExpression.class);
        }
        String expression = (String)this.getModel().getValue(Key_FExpression);
        exprObj.setExpression(expression);
        String tranExpr = (String)this.getModel().getValue(Key_FTranExpr);
        exprObj.setExprTran(tranExpr);
        exprObj.setDescription(new LocaleString(Lang.get().toString(), tranExpr));
        return exprObj;
    }

    private void clickCompareButton(String compareKey) {
        String compareValue = "";
        switch (compareKey) {
            case "btnadd": {
                compareValue = "+";
                break;
            }
            case "btnsubtraction": {
                compareValue = "-";
                break;
            }
            case "btnmultiplication": {
                compareValue = "*";
                break;
            }
            case "btndivison": {
                compareValue = "/";
                break;
            }
            case "btnequal": {
                compareValue = "==";
                break;
            }
            case "btnnotequal": {
                compareValue = "<>";
                break;
            }
            case "btnlessthen": {
                compareValue = "<";
                break;
            }
            case "btnmorethen": {
                compareValue = ">";
                break;
            }
            case "btnlessequal": {
                compareValue = "<=";
                break;
            }
            case "btnmoreequal": {
                compareValue = ">=";
                break;
            }
            case "btnand": {
                compareValue = "and";
                break;
            }
            case "btnor": {
                compareValue = "or";
                break;
            }
            case "btnleft": {
                compareValue = "(";
                break;
            }
            case "btnright": {
                compareValue = ")";
                break;
            }
        }
        if (!StringUtils.isBlank((CharSequence)compareValue)) {
            String expression = (String)this.getModel().getValue(Key_FExpression);
            expression = expression + compareValue;
            this.getModel().setValue(Key_FExpression, (Object)expression);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equalsIgnoreCase(Key_FExpression)) {
            String expression = (String)this.getModel().getValue(Key_FExpression);
            String tranExpr = "";
            try {
                String json = this.getPageCache().get(CustParamKey_TreeNodes);
                MainEntityType etp = this.getEntityType();
                if (null == json) {
                    TreeNode buildTree = BuildTree.buildTree((MainEntityType)etp, (String)"fexplanation", (ExpressionType)ExpressionType.DynamicText, (boolean)false, null, (boolean)false);
                    json = SerializationUtils.toJsonString((Object)buildTree);
                    this.getPageCache().put(CustParamKey_TreeNodes, json);
                }
                tranExpr = BuildTree.tranExpression((String)expression, (MainEntityType)etp);
            }
            catch (FormulaException exp) {
                tranExpr = exp.getMessage();
            }
            catch (Throwable exp) {
                tranExpr = ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u89e3\u6790\u51fa\u9519\uff0c\u81ea\u52a8\u7ffb\u8bd1\u5931\u8d25\u3002", (String)"ExpressionEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]);
            }
            this.getModel().setValue(Key_FTranExpr, (Object)tranExpr);
        }
    }

    private void showFuncSetting() {
        String jsonNode;
        String funcsXML = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_FunctionTypes);
        if (StringUtils.isBlank((CharSequence)funcsXML) && StringUtils.isBlank((CharSequence)(funcsXML = this.getPageCache().get(CustParamKey_FunctionTypes)))) {
            FunctionTypes functionTypes = FunctionTypes.get();
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put(CustParamKey_FunctionTypes, funcsXML);
        }
        if (StringUtils.isBlank((CharSequence)(jsonNode = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_TreeNodes)))) {
            TreeNode rootNode = BuildTree.buildTree((MainEntityType)this.getEntityType(), (String)"fexplanation", (ExpressionType)ExpressionType.Formula, (boolean)true, null, (boolean)false);
            jsonNode = SerializationUtils.toJsonString((Object)rootNode);
        }
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_EntityNumber);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, Key_btnFunction);
        FuncSettingHelper.show((String)funcsXML, (String)entityNumber, (String)jsonNode, null, (IFormView)this.getView(), (CloseCallBack)closeCallBack);
    }

    private void receiveFuncSetting(String funcSetting) {
        FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)Key_btnFunction, (String)Key_FExpression, (String)("{" + funcSetting + "}"));
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        String json = this.getPageCache().get(CustParamKey_TreeNodes);
        if (StringUtils.equals((CharSequence)"searchfield", (CharSequence)search.getKey()) && StringUtils.isNotBlank((CharSequence)json)) {
            String searchText = evt.getText();
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
            TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
            tree.updateNode(BuildTree.searchTree((String)searchText, (TreeNode)rootNode));
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent arg0) {
        TreeView treeView = (TreeView)arg0.getSource();
        String nodeId = (String)arg0.getNodeId();
        List treeNodes = BuildTree.buildSimpleLevelTree((MainEntityType)this.getEntityType(), (String)"fexplanation", (ExpressionType)ExpressionType.DynamicText, (boolean)true, null, (boolean)false, (String)nodeId);
        treeView.addNodes(treeNodes);
    }

    private MainEntityType getEntityType() {
        String id = (String)this.getView().getFormShowParameter().getCustomParam(BUILD);
        String isEvent = (String)this.getView().getFormShowParameter().getCustomParam("event");
        MainEntityType srcMainET = BuildTree.getMainType((String)isEvent, (String)id);
        return srcMainET;
    }
}

