/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.fi.ai.VchReturnData;
import kd.fi.ai.VchTplMeasureUnit;
import kd.fi.ai.util.AiEventMetaUtil;
import kd.fi.ai.util.EntityFieldUtil;

public class MeasureUnitEdit
extends AbstractFormPlugin {
    private static final String Field_SourceType = "sourcetype";
    private static final String Field_SourceField = "sourcefield";
    private static final String Field_Const = "measureunit";
    private static final String MappingPanel = "mappingpanel";
    private static final String FixPanel = "fixpanel";
    public static final String MeasureUnitEditFormID = "ai_vchmeasureunit";
    public static final String CacheKey_VchMeasureUnitJson = "vchmeasureunitset";
    private static final String Key_btnOK = "btnok";
    private static final String Key_btnCancel = "btncancel";
    private static final String Cache_SourceFieldComboMap = "sourceComboList";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initSourceFieldCombo();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String str = (String)customParams.get(CacheKey_VchMeasureUnitJson);
        if (StringUtils.isNotBlank((CharSequence)str)) {
            VchTplMeasureUnit cashflow = (VchTplMeasureUnit)SerializationUtils.fromJsonString((String)str, VchTplMeasureUnit.class);
            this.setVchCashflow(cashflow);
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{FixPanel});
            this.getView().setVisible(Boolean.FALSE, new String[]{MappingPanel});
        }
    }

    private void setVchCashflow(VchTplMeasureUnit cashflow) {
        IDataModel model = this.getModel();
        model.setValue(Field_SourceType, (Object)(cashflow.getSourcetype() == null ? "fix" : cashflow.getSourcetype()));
        if (cashflow.getSourcetype() == null || "fix".equalsIgnoreCase(cashflow.getSourcetype())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FixPanel});
            this.getView().setVisible(Boolean.FALSE, new String[]{MappingPanel});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{MappingPanel});
            this.getView().setVisible(Boolean.FALSE, new String[]{FixPanel});
        }
        model.setValue(Field_Const, (Object)cashflow.getConstid());
        model.setValue(Field_SourceField, (Object)cashflow.getSourcefield());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (Key_btnOK.equalsIgnoreCase(ctlSource.getKey())) {
            String cacheValue;
            String entitynumber;
            String currentFormId;
            VchTplMeasureUnit cashflow = this.getVchMeasureUnit();
            VchReturnData returnData = EntityFieldUtil.validateDiffEntry((Object)cashflow, (String)(currentFormId = (String)this.getView().getFormShowParameter().getCustomParam("ai_button_key")), (String)(entitynumber = (String)this.getView().getFormShowParameter().getCustomParam("billEntityNumber")), (String)(cacheValue = EntityFieldUtil.getCacheValueFromFormParameter((IFormView)this.getView())));
            if (returnData.isStatus()) {
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)returnData));
                this.getView().close();
            } else if (!returnData.isStatus() && StringUtils.isNotEmpty((CharSequence)returnData.getMessage())) {
                this.getView().showTipNotification(returnData.getMessage());
            }
        } else if (Key_btnCancel.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    private VchTplMeasureUnit getVchMeasureUnit() {
        VchTplMeasureUnit measureUnit = new VchTplMeasureUnit();
        IDataModel model = this.getModel();
        String sourceType = model.getValue(Field_SourceType).toString();
        measureUnit.setSourcetype(sourceType);
        DynamicObject constcf = (DynamicObject)model.getValue(Field_Const);
        if (constcf != null) {
            measureUnit.setConstid(constcf.getLong("id"));
            if ("fix".equalsIgnoreCase(sourceType)) {
                measureUnit.setDescription(constcf.getString("number") + " " + constcf.getString("name"));
            }
        }
        if (model.getValue(Field_SourceField) != null) {
            Map comboMap;
            String combosStr;
            measureUnit.setSourcefield(model.getValue(Field_SourceField).toString());
            if ("bill".equalsIgnoreCase(sourceType) && StringUtils.isNotEmpty((CharSequence)(combosStr = this.getPageCache().get(Cache_SourceFieldComboMap))) && (comboMap = (Map)SerializationUtils.fromJsonString((String)combosStr, Map.class)) != null) {
                measureUnit.setDescription((String)comboMap.get(model.getValue(Field_SourceField).toString()));
            }
        }
        return measureUnit;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty prop = e.getProperty();
        ChangeData[] change = e.getChangeSet();
        if (prop.getName().equals(Field_SourceType)) {
            if ("fix".equalsIgnoreCase(change[0].getNewValue().toString())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{FixPanel});
                this.getView().setVisible(Boolean.FALSE, new String[]{MappingPanel});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{MappingPanel});
                this.getView().setVisible(Boolean.FALSE, new String[]{FixPanel});
            }
        }
    }

    private void initSourceFieldCombo() {
        FormShowParameter params = this.getView().getFormShowParameter();
        String sourceBill = (String)params.getCustomParam("billEntityNumber");
        boolean isevent = (Boolean)params.getCustomParam("isevent");
        MainEntityType srcMainEntityType = null;
        srcMainEntityType = isevent ? AiEventMetaUtil.getEntityType((Object)Long.valueOf(sourceBill)) : EntityMetadataCache.getDataEntityType((String)sourceBill);
        this.fillUnitFieldItems(srcMainEntityType);
    }

    private void fillUnitFieldItems(MainEntityType srcMainET) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        String currLCId = Lang.get().toString();
        if (srcMainET != null) {
            ArrayList<BasedataProp> unitProps = new ArrayList<BasedataProp>();
            this.searchUnitProps((IDataEntityType)srcMainET, unitProps);
            HashMap<String, String> sourceComboList = new HashMap<String, String>(unitProps.size());
            for (BasedataProp rateProp : unitProps) {
                ComboItem item = new ComboItem();
                String value = this.getFieldSelector((DynamicProperty)rateProp);
                item.setValue(value);
                String caption = this.buildPropCaption((DynamicProperty)rateProp);
                item.setCaption(new LocaleString(currLCId, caption));
                items.add(item);
                sourceComboList.put(value, caption);
            }
            this.getPageCache().put(Cache_SourceFieldComboMap, SerializationUtils.toJsonString(sourceComboList));
        }
        ComboEdit fieldEditor = (ComboEdit)this.getView().getControl(Field_SourceField);
        fieldEditor.setComboItems(items);
        if (items.size() > 0) {
            this.getModel().setValue(Field_SourceField, (Object)((ComboItem)items.get(0)).getValue());
        }
    }

    private void searchUnitProps(IDataEntityType entityType, List<BasedataProp> unitProps) {
        for (IDataEntityProperty prop : entityType.getProperties()) {
            BasedataProp bdProp;
            if (prop instanceof EntryProp) {
                this.searchUnitProps(((EntryProp)prop).getItemType(), unitProps);
                continue;
            }
            if (prop instanceof UnitProp && StringUtils.isNotBlank((CharSequence)prop.getAlias())) {
                unitProps.add((BasedataProp)((UnitProp)prop));
                continue;
            }
            if (!(prop instanceof BasedataProp) || !StringUtils.isNotBlank((CharSequence)prop.getAlias()) || !"bd_measureunits".equals((bdProp = (BasedataProp)prop).getBaseEntityId())) continue;
            unitProps.add(bdProp);
        }
    }

    private String buildPropCaption(DynamicProperty prop) {
        EntityType parentType = (EntityType)prop.getParent();
        String parentName = ResManager.loadKDString((String)"\u5355\u636e\u4f53", (String)"MeasureUnitEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]);
        if (parentType.getDisplayName() != null) {
            parentName = parentType.getDisplayName().toString();
        }
        String propName = prop.getDisplayName() != null ? prop.getDisplayName().toString() : this.getFieldSelector(prop);
        String caption = String.format("%s.%s", parentName, propName);
        return caption;
    }

    private String getFieldSelector(DynamicProperty rateProp) {
        String selector = rateProp.getName();
        if (rateProp.getParent() != null && rateProp.getParent().getParent() != null && rateProp.getParent().getParent().getParent() != null && rateProp.getParent().getParent().getParent().getParent() == null) {
            selector = rateProp.getParent().getParent().getName() + "." + rateProp.getParent().getName() + "." + selector;
        }
        return selector;
    }
}

