/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.SingleOrgContextHelper;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.enums.CheckBoxEnum;
import kd.fi.ai.formplugin.ReconciliationResultRptHelper;

public class ReconciliationUnRecordedBillPlugin
extends AbstractListPlugin
implements ClickListener,
RowClickEventListener,
ItemClickListener {
    public static final String FormId_UnRecordedBill = "ai_unrecordedbills";
    public static final String CACHEKEY_APPNUMBER = "appNumber";
    public static final String CACHEKEY_ACCTORGID = "acctorgId";
    public static final String CACHEKEY_ACCOUNTBOOKID = "accountBookId";
    public static final String CACHEKEY_isBuildVch = "isBuildVch";
    public static final String SOURCE_BILL_TYPE = "sourcebilltype";
    public static final String Key_Period = "period";
    public static final String Key_Reconciliation = "reconciliation";

    public void initialize() {
        super.initialize();
        this.initCacheValue(CACHEKEY_APPNUMBER);
        this.initCacheValue(CACHEKEY_ACCTORGID);
        this.initCacheValue(CACHEKEY_ACCOUNTBOOKID);
        this.initCacheValue(CACHEKEY_isBuildVch);
        this.initCacheValue(Key_Reconciliation);
        this.initCacheValue(Key_Period);
    }

    private void initCacheValue(String cacheKey) {
        String cacheValue = this.getPageCache().get(cacheKey);
        if (StringUtils.isEmpty((CharSequence)cacheValue)) {
            cacheValue = (String)this.getView().getFormShowParameter().getCustomParam(cacheKey);
            this.getPageCache().put(cacheKey, cacheValue);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FilterContainerInitEvent event = args.getFilterContainerInitEvent();
        List listFilterColumns = event.getCommonFilterColumns();
        listFilterColumns.clear();
        CommonFilterColumn stateCol = new CommonFilterColumn();
        stateCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b", (String)"ReconciliationUnRecordedBillPlugin_0", (String)"fi-ai-formplugin", (Object[])new Object[0])));
        stateCol.setFieldName("sourcebilltype.name");
        QFilter biznumber = new QFilter("number", "=", (Object)this.getPageCache().get(CACHEKEY_APPNUMBER));
        DynamicObject bizappObj = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_bizapp", (String)"id, name", (QFilter[])new QFilter[]{biznumber});
        Map<String, String> billsIdAndName = ReconciliationResultRptHelper.getBillsIdAndNameByBizapp(bizappObj.getString("id"));
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(billsIdAndName.size() + 1);
        list.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"ReconciliationUnRecordedBillPlugin_1", (String)"fi-ai-formplugin", (Object[])new Object[0])), ""));
        for (Map.Entry<String, String> ety : billsIdAndName.entrySet()) {
            list.add(new ComboItem(new LocaleString(ety.getValue()), ety.getKey()));
        }
        stateCol.setComboItems(list);
        listFilterColumns.add(stateCol);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                List qFilters = this.getQFilters();
                List<Object> billNumberList = new ArrayList(10);
                if (qFilters == null || qFilters.size() == 0 || qFilters.stream().anyMatch(q -> q.getProperty().equals("id") && q.getCP().equalsIgnoreCase("in"))) {
                    QFilter biznumber = new QFilter("number", "=", (Object)ReconciliationUnRecordedBillPlugin.this.getPageCache().get(ReconciliationUnRecordedBillPlugin.CACHEKEY_APPNUMBER));
                    DynamicObject bizappObj = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_bizapp", (String)"id, name", (QFilter[])new QFilter[]{biznumber});
                    billNumberList = ReconciliationResultRptHelper.getBuildVchBillsByBizapp(bizappObj.getString("id"));
                    ReconciliationUnRecordedBillPlugin.this.initEntity(rows, billNumberList, ++start);
                    if (qFilters != null && qFilters.size() > 0 && qFilters.stream().anyMatch(q -> q.getProperty().equals("id") && q.getCP().equalsIgnoreCase("in"))) {
                        HashSet<Long> billids = new HashSet<Long>(10);
                        Optional<QFilter> qFilter = qFilters.stream().filter(q -> q.getProperty().equals("id") && q.getCP().equalsIgnoreCase("in")).findFirst();
                        Object qfilterValue = qFilter.get().getValue();
                        if (qfilterValue instanceof Object[]) {
                            Object[] qfilterValue1;
                            for (Object o : qfilterValue1 = (Object[])qfilterValue) {
                                billids.add((Long)o);
                            }
                        }
                        Iterator iterator = rows.iterator();
                        while (iterator.hasNext()) {
                            DynamicObject row = (DynamicObject)iterator.next();
                            if (billids.contains(row.getLong("id"))) continue;
                            iterator.remove();
                        }
                    }
                } else {
                    ArrayList<QFilter> entityobjectQFilters = new ArrayList<QFilter>(10);
                    for (QFilter qFilter : qFilters) {
                        String qFilterProperty = qFilter.getProperty();
                        if (qFilter.getCP().equals("ftlike")) {
                            String value = (String)qFilter.getOriginValue();
                            qFilter.__setValue((Object)value.substring("sourcebilltype.".length()));
                            entityobjectQFilters.add(qFilter);
                            continue;
                        }
                        if (qFilterProperty.startsWith(ReconciliationUnRecordedBillPlugin.SOURCE_BILL_TYPE)) {
                            qFilter.__setProperty(qFilterProperty.substring("sourcebilltype.".length()));
                            entityobjectQFilters.add(qFilter);
                            continue;
                        }
                        entityobjectQFilters.add(qFilter);
                    }
                    entityobjectQFilters.add(new QFilter("modeltype", "=", (Object)"BillFormModel"));
                    entityobjectQFilters.add(new QFilter("voucher", "=", (Object)CheckBoxEnum.TRUE.getValue()));
                    DynamicObject[] entityobjects = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"id,number", (QFilter[])entityobjectQFilters.toArray(new QFilter[entityobjectQFilters.size()]));
                    if (entityobjects != null && entityobjects.length > 0) {
                        for (DynamicObject entityobject : entityobjects) {
                            billNumberList.add(entityobject.getString("number"));
                        }
                    }
                    ReconciliationUnRecordedBillPlugin.this.initEntity(rows, billNumberList, ++start);
                }
                return rows;
            }
        });
    }

    private void showBillEditForm(String sourceBillTypeId, Long billid) {
        if ("gl_acnotice".equals(sourceBillTypeId)) {
            ListShowParameter l = new ListShowParameter();
            l.setCustomParam("id", (Object)billid);
            l.setBillFormId(sourceBillTypeId);
            l.setFormId("bos_list");
            l.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)l);
        } else {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(sourceBillTypeId);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setPkId((Object)billid);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.getOpenStyle().setTargetKey("_submaintab_");
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void initEntity(DynamicObjectCollection rows, List<String> billNumberList, int start) {
        String isBuildVch;
        Object billMap = new HashMap<String, Map<String, Object>>();
        long acctorgId = Long.parseLong(this.getPageCache().get(CACHEKEY_ACCTORGID));
        long period = Long.parseLong(this.getPageCache().get(Key_Period));
        ArrayList<Long> billIdCol = new ArrayList<Long>(billNumberList.size());
        ReconciliationResultRptHelper reconciliationResultRptHelper = new ReconciliationResultRptHelper();
        for (String billNum : billNumberList) {
            List<Map<String, Object>> billObjs = reconciliationResultRptHelper.getBillIds(billNum, acctorgId, period);
            for (Map<String, Object> map : billObjs) {
                billMap.put(map.get("id") + "", map);
                billIdCol.add((Long)map.get("id"));
            }
        }
        for (Map.Entry entry : billMap.entrySet()) {
            billIdCol.add(Long.parseLong((String)entry.getKey()));
        }
        ArrayList<QFilter> glQFilterArr = new ArrayList<QFilter>();
        glQFilterArr.add(new QFilter("sourcebillid", "in", billIdCol));
        DynamicObject[] daptrackers = BusinessDataServiceHelper.load((String)"ai_daptracker", (String)"id,voucherid,sourcebillid", (QFilter[])glQFilterArr.toArray(new QFilter[0]));
        HashMap<Long, Long> vchMap = new HashMap<Long, Long>(daptrackers.length);
        for (DynamicObject track : daptrackers) {
            vchMap.put(track.getLong("voucherid"), track.getLong("sourcebillid"));
        }
        HashSet hashSet = new HashSet();
        if (vchMap.size() > 0) {
            QFilter glidFilter = new QFilter("id", "in", vchMap.keySet());
            QFilter glOrgFilter = new QFilter("org", "=", (Object)Long.parseLong(this.getPageCache().get(CACHEKEY_ACCTORGID)));
            List glids = QueryServiceHelper.queryPrimaryKeys((String)"gl_voucher", (QFilter[])new QFilter[]{glidFilter, glOrgFilter}, null, (int)vchMap.size());
            Iterator iterator = glids.iterator();
            while (iterator.hasNext()) {
                Object glid = iterator.next();
                hashSet.add(vchMap.get(glid));
            }
        }
        if (null != (isBuildVch = this.getPageCache().get(CACHEKEY_isBuildVch)) && isBuildVch.contains("yes")) {
            HashMap billMapIsBuild = new HashMap(hashSet.size());
            for (Long billid : hashSet) {
                billMapIsBuild.put(String.valueOf(billid), billMap.get(String.valueOf(billid)));
            }
            billMap = billMapIsBuild;
        } else {
            for (Long billid : hashSet) {
                billMap.remove(String.valueOf(billid));
            }
        }
        this.getPageCache().put("listDataMap", SerializationUtils.toJsonString(billMap));
        Collection ite = billMap.values();
        ORM orm = ORM.create();
        DynamicComplexProperty sourcebilltypeProp = (DynamicComplexProperty)rows.getDynamicObjectType().getProperty(SOURCE_BILL_TYPE);
        DynamicComplexProperty orgProp = (DynamicComplexProperty)rows.getDynamicObjectType().getProperty("bizorg");
        for (Map billObjet : ite) {
            DynamicObject unRecordedBillObj = ReconciliationUnRecordedBillPlugin.createDynamicObject(orm, rows);
            unRecordedBillObj.set("id", billObjet.get("id"));
            unRecordedBillObj.set("billno", billObjet.get("billno"));
            unRecordedBillObj.set("createtime", billObjet.get("vchDate"));
            DynamicObject sourcebilltype = BusinessDataServiceHelper.loadSingle(billObjet.get(SOURCE_BILL_TYPE), (DynamicObjectType)((DynamicObjectType)sourcebilltypeProp.getComplexType()));
            unRecordedBillObj.set(SOURCE_BILL_TYPE, (Object)sourcebilltype);
            if (StringUtils.isNotBlank(billObjet.get("bizorg")) && !SingleOrgContextHelper.isSingleOrgManageMode()) {
                DynamicObject bizorg = BusinessDataServiceHelper.loadSingle(billObjet.get("bizorg"), (DynamicObjectType)((DynamicObjectType)orgProp.getComplexType()));
                unRecordedBillObj.set("bizorg", (Object)bizorg);
            }
            rows.add((Object)unRecordedBillObj);
        }
    }

    private static DynamicObject createDynamicObject(ORM orm, DynamicObjectCollection template) {
        return orm.newDynamicObject(template.getDynamicObjectType());
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List listcontrol = args.getListColumns();
        for (int i = 0; i < listcontrol.size(); ++i) {
            IListColumn listcolumn = (IListColumn)listcontrol.get(i);
            String key = listcolumn.getListFieldKey();
            if (!"billno".equals(key)) continue;
            listcolumn.setHyperlink(true);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        HyperLinkClickEvent evt = args.getHyperLinkClickEvent();
        String fileldName = args.getHyperLinkClickEvent().getFieldName();
        if ("billno".equals(fileldName)) {
            int rowIndex = evt.getRowIndex();
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            if (selectedRows.size() == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"ReconciliationUnRecordedBillPlugin_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            long billid = this.getSelectRowId(selectedRows, rowIndex);
            String listDataMapStr = this.getPageCache().get("listDataMap");
            Map billMap = (Map)SerializationUtils.fromJsonString((String)listDataMapStr, Map.class);
            String sourceBillTypeId = String.valueOf(((Map)billMap.get(Long.toString(billid))).get(SOURCE_BILL_TYPE));
            this.showBillEditForm(sourceBillTypeId, billid);
        }
    }

    private Long getSelectRowId(ListSelectedRowCollection selectedRows, int rowIndex) {
        for (int i = 0; i < selectedRows.size(); ++i) {
            ListSelectedRow listSelectedRow = selectedRows.get(i);
            int rowKey = listSelectedRow.getRowKey();
            if (rowIndex != rowKey) continue;
            return Long.parseLong(selectedRows.get(i).getPrimaryKeyValue() + "");
        }
        return null;
    }
}

