/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ai.accsys.AccSysUtil;
import kd.fi.ai.accsys.AccountBookInfo;
import kd.fi.ai.enums.CheckBoxEnum;
import kd.fi.ai.enums.PermissonType;
import kd.fi.ai.enums.Voucher;
import kd.fi.ai.formplugin.ReconciliationResultRptHelper;
import kd.fi.ai.util.GLUtil;
import kd.fi.ai.util.PeriodUtil;

public class RecordedCenterPlugin
extends AbstractFormPlugin
implements ClickListener,
CellClickListener,
ProgresssListener {
    private static final Log log = LogFactory.getLog(RecordedCenterPlugin.class);
    private static String PERIOD = "curPeriodId";
    private static String ORG = "curOrgId";
    private static String ACCOUNTTABLE = "curAccountTableId";
    private static String BOOKTYPE = "curBookTypeId";
    private static String ISLEAF = "isLeaf";
    private static String SUBORG = "subOrg";
    private static String KEY_ENTRYENTITY = "entryentity";
    public static final String FormId_UnRecordedBill = "ai_unrecordedbills";
    public static final String CACHEKEY_APPNUMBER = "appNumber";
    public static final String CACHEKEY_ACCTORGID = "acctorgId";
    public static final String CACHEKEY_ACCOUNTBOOKID = "accountBookId";
    public static final String CACHEKEY_isBuildVch = "isBuildVch";
    public static final String Key_Period = "period";
    public static final String SOURCE_BILL_TYPE = "sourcebilltype";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"bizsysrecordednew"});
        this.addClickListeners(new String[]{"tempnum", "submittednum", "audittednum", "postednum"});
        AbstractGrid entryentity = (AbstractGrid)this.getControl("entryentity");
        entryentity.addCellClickListener((CellClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if ("orgid".equals(propertyName)) {
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            if (null == newValue || null == newValue.getPkValue()) {
                log.debug("\u5bf9\u8d26\u4e2d\u5fc3\uff1apropertyChanged\uff08\uff09\u65b9\u6cd5\u4e2d\uff0cnewValue\u503c\u4e3a\u7a7a");
                return;
            }
            this.initPageDataByOrg((Long)newValue.getPkValue());
            this.setInitView();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("bizsysrecordednew".equalsIgnoreCase(key)) {
            this.openBizSysRecordedNew();
        } else if ("tempnum".equals(key)) {
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)"A");
            this.goVoucherList(statusFilter, "A");
        } else if ("submittednum".equals(key)) {
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)"B");
            this.goVoucherList(statusFilter, "B");
        } else if ("audittednum".equals(key)) {
            QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
            this.goVoucherList(statusFilter, "C");
        } else if ("postednum".equals(key)) {
            QFilter postFilter = new QFilter("ispost", "=", (Object)Boolean.TRUE);
            this.goVoucherList(postFilter, null);
        }
    }

    private void goVoucherList(QFilter filter, String status) {
        RequestContext context = RequestContext.get();
        String userID = context.getUserId();
        String curPeriod = this.getPageCache().get(PERIOD);
        String org = this.getPageCache().get(ORG);
        if (org == null || org.trim().length() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u4e3b\u4f53\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"RecordedCenterPlugin_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)curPeriod) || Long.parseLong(curPeriod) <= 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u524d\u5f80\u6838\u7b97\u4f53\u7cfb\u8bbe\u7f6e\u3002", (String)"RecordedCenterPlugin_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(curPeriod), (String)"bd_period");
        QFilter periodFilter = new QFilter(Key_Period, "=", (Object)Long.valueOf(curPeriod));
        QFilter userFilter = new QFilter("submitter", "=", (Object)Long.valueOf(userID));
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.valueOf(org));
        QFilter booktypeFilter = new QFilter("booktype", "=", (Object)Long.valueOf(this.getPageCache().get(BOOKTYPE)));
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("gl_voucher");
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getOpenStyle().setTargetKey("_submaintab_");
        para.setCustomParam("source", (Object)"RecordedCenterPlugin");
        para.setCustomParam("org", (Object)this.getPageCache().get(ORG));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        para.setCustomParam("bookeddate", (Object)new Object[]{sdf.format(period.get("begindate")), sdf.format(period.get("enddate"))});
        if ("billstatus".equals(filter.getProperty())) {
            para.setCustomParam("status", filter.getValue());
            filter = filter.and(new QFilter("ispost", "=", (Object)Boolean.FALSE));
        }
        filter = filter.and(orgFilter).and(userFilter).and(periodFilter).and(booktypeFilter);
        para.setCustomParam("filter", (Object)filter.toSerializedString());
        this.getView().showForm((FormShowParameter)para);
    }

    private void openBizSysRecordedNew() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("orgid");
        if (null == org || (Long)org.getPkValue() == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5931\u6838\u7b97\u4e3b\u4f53\u6570\u636e\uff0c\u8bf7\u8bbe\u7f6e\u6838\u7b97\u4e3b\u4f53\u3002", (String)"RecordedCenterPlugin_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
        ListShowParameter para = new ListShowParameter();
        para.setLookUp(true);
        para.setBillFormId("bos_devportal_bizapp");
        para.setFormId("bos_listf7");
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        para.getOpenStyle().setInlineStyleCss(css);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setMultiSelect(true);
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(KEY_ENTRYENTITY);
        if (entryEntity != null && entryEntity.size() > 0) {
            ArrayList<String> selected = new ArrayList<String>();
            for (DynamicObject entityObj : entryEntity) {
                DynamicObject bizapp = (DynamicObject)entityObj.get("bizapp");
                String bizappid = (String)bizapp.getPkValue();
                selected.add(bizappid);
            }
            para.setSelectedRows((Object[])selected.toArray(new String[0]));
        }
        Set<String> dapConfigsBizAppIds = this.getDAPConfigsBizAppIds();
        ListFilterParameter listFilterParameter = para.getListFilterParameter();
        listFilterParameter.getQFilters().add(new QFilter("id", "in", dapConfigsBizAppIds));
        para.setListFilterParameter(listFilterParameter);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "advconap_add"));
        para.getPageId();
        this.getView().showForm((FormShowParameter)para);
    }

    public void cellClick(CellClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (KEY_ENTRYENTITY.equals(entryGrid.getEntryKey())) {
            Object org = this.getModel().getValue("orgid");
            if (org == null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"RecordedCenterPlugin_11", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            int rowIndex = evt.getRow();
            DynamicObject rowData = (DynamicObject)this.getModel().getEntryEntity(KEY_ENTRYENTITY).get(rowIndex);
            DynamicObject bizAppObj = rowData.getDynamicObject("bizapp");
            String key = evt.getFieldKey();
            if (key.contains("templabelap")) {
                String unBuildVchSum = rowData.getString("temptextfield");
                if (null == unBuildVchSum || "0".equals(unBuildVchSum)) {
                    return;
                }
                this.showBuildVchByHand(bizAppObj.getString("number"), "no");
            } else if (key.contains("submitlabelap")) {
                String buildVchSum = rowData.getString("submittedtextfield");
                if (null == buildVchSum || "0".equals(buildVchSum)) {
                    return;
                }
                this.showBuildVchByHand(bizAppObj.getString("number"), "yes");
            }
        }
    }

    public void cellDoubleClick(CellClickEvent evt) {
    }

    private void showBuildVchByHand(String appNumber, String isBuildVch) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("orgid");
        String bookTypeId = this.getPageCache().get(BOOKTYPE);
        String periodID = this.getPageCache().get(PERIOD);
        if (StringUtils.isBlank((CharSequence)bookTypeId) || Long.parseLong(bookTypeId) < 1L || StringUtils.isBlank((CharSequence)periodID) || Long.parseLong(periodID) < 1L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6709\u6743\u9650\u6838\u7b97\u4e3b\u4f53\u7684\u9ed8\u8ba4\u8d26\u7c3f\u53ca\u5176\u5f53\u524d\u671f\u95f4\u4e3a\u7a7a\uff0c\u8bf7\u524d\u5f80\u6838\u7b97\u4f53\u7cfb\u8bbe\u7f6e\u3002", (String)"RecordedCenterPlugin_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter parame = new ListShowParameter();
        parame.setBillFormId(FormId_UnRecordedBill);
        parame.setFormId("bos_list");
        parame.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parame.getOpenStyle().setTargetKey("tabap");
        parame.setCustomParam(CACHEKEY_APPNUMBER, (Object)appNumber);
        parame.setCustomParam(CACHEKEY_ACCTORGID, (Object)org.getPkValue().toString());
        parame.setCustomParam(CACHEKEY_ACCOUNTBOOKID, (Object)bookTypeId);
        parame.setCustomParam(CACHEKEY_isBuildVch, (Object)isBuildVch);
        if ("yes".equals(isBuildVch)) {
            parame.setCaption(ResManager.loadKDString((String)"\u5df2\u5165\u8d26\u5355\u636e", (String)"RecordedCenterPlugin_4", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
        parame.setCustomParam(Key_Period, (Object)periodID);
        this.getView().showForm((FormShowParameter)parame);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() == null) {
            return;
        }
        if ("advconap_add".equals(e.getActionId())) {
            List<String> pkList = this.getSelectedEntryPK(e);
            this.getPageCache().put("advconap_add", "modify");
            this.refreshEntryentity(pkList);
        }
    }

    private List<String> getSelectedEntryPK(ClosedCallBackEvent e) {
        ListSelectedRowCollection rowDataCol = (ListSelectedRowCollection)e.getReturnData();
        ArrayList<String> pk = new ArrayList<String>();
        for (int i = 0; i < rowDataCol.size(); ++i) {
            ListSelectedRow selectrow = rowDataCol.get(i);
            if (StringUtils.isBlank((Object)selectrow.getPrimaryKeyValue())) continue;
            pk.add((String)selectrow.getPrimaryKeyValue());
        }
        return pk;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"precontrastamt"});
        List orgList = AccSysUtil.getAcctOrgPkList((String)this.getView().getEntityId(), (boolean)Boolean.FALSE, (PermissonType)PermissonType.VIEW);
        BasedataEdit orgBd = (BasedataEdit)this.getControl("orgid");
        if (orgList.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6709\u6743\u9650\u7684\u6838\u7b97\u4e3b\u4f53\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RecordedCenterPlugin_5", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            orgBd.setQFilter(new QFilter("id", "in", new ArrayList()));
            this.clearData();
            return;
        }
        Long defaultAcctOrg = GLUtil.getDefaultAcctOrg((List)orgList);
        orgBd.setQFilter(new QFilter("id", "in", (Object)orgList));
        this.getModel().setValue("orgid", (Object)defaultAcctOrg);
        this.initPageDataByOrg(defaultAcctOrg);
        this.setInitViewDefault();
        this.setInitView();
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
        bar.start();
    }

    private void initPageDataByOrg(Long orgId) {
        this.processOrg(orgId);
        this.initAccountSysData(orgId);
    }

    private void setInitView() {
        this.myVoucher();
        this.endProcessTotal();
        this.entryentityProcess();
        this.processRankingEntryentity();
    }

    private void setInitViewDefault() {
        this.initEntryentityProcess();
    }

    private void initEntryentityProcess() {
        String org = this.getPageCache().get(ORG);
        Long orgId = StringUtils.isBlank((CharSequence)org) ? 0L : Long.parseLong(org);
        boolean isExit = this.checkRecordedSysOrgIsExit(orgId);
        List<String> loadSysFromRecordedSys = null;
        loadSysFromRecordedSys = isExit ? this.loadSysFromRecordedSys(orgId) : this.loadDefaultSys();
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        for (String bizappId : loadSysFromRecordedSys) {
            int rowIndex = model.createNewEntryRow("entryentity");
            model.setValue("bizapp", (Object)bizappId, rowIndex);
        }
    }

    private void processRankingEntryentity() {
        String bookTypeId = this.getPageCache().get(BOOKTYPE);
        String periodID = this.getPageCache().get(PERIOD);
        if (StringUtils.isBlank((CharSequence)bookTypeId) || Long.parseLong(bookTypeId) < 1L || StringUtils.isBlank((CharSequence)periodID) || Long.parseLong(periodID) < 1L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6709\u6743\u9650\u6838\u7b97\u4e3b\u4f53\u7684\u9ed8\u8ba4\u8d26\u7c3f\u53ca\u5176\u5f53\u524d\u671f\u95f4\u4e3a\u7a7a\uff0c\u8bf7\u524d\u5f80\u6838\u7b97\u4f53\u7cfb\u8bbe\u7f6e\u3002", (String)"RecordedCenterPlugin_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        Long[] orgList = this.getCacheSubOrg();
        String booktypeId = this.getPageCache().get(BOOKTYPE);
        QFilter statusFilter = new QFilter("billstatus", "in", (Object)new String[]{"B", "C"});
        StringBuilder selectField = new StringBuilder();
        selectField.append("id").append(',').append("billstatus").append(',').append("submitter");
        selectField.append(',').append("org");
        long[] orgs = Arrays.stream(orgList).mapToLong(t -> t).toArray();
        try (DataSet dataSet = Voucher.getDataSet((String)"RecordcenterPlugin", (String)selectField.toString(), (long[])orgs, (long)Long.parseLong(booktypeId), (long)Long.parseLong(periodID), (QFilter[])new QFilter[]{statusFilter}, null);){
            GroupbyDataSet groupByData = dataSet.groupBy(new String[]{"submitter", "org"});
            groupByData.count();
            DataSet countDataSet = groupByData.finish();
            DataSet orderBy = countDataSet.orderBy(new String[]{"count desc"});
            IDataModel model = this.getModel();
            model.deleteEntryData("progressentryentity");
            for (Row row : orderBy) {
                Integer count = row.getInteger("count");
                int rowIndex = model.createNewEntryRow("progressentryentity");
                model.setValue("user", (Object)row.getLong("submitter"), rowIndex);
                model.setValue("actorg", (Object)row.getLong("org"), rowIndex);
                model.setValue("addnewvchtotal", (Object)count, rowIndex);
                Integer usercCountLast = this.countUserProcessLast(row.getLong("submitter"));
                model.setValue("lastvchtotal", (Object)usercCountLast, rowIndex);
                int countRatioPercent = this.countRecordRatioPercent(usercCountLast, count);
                if (count - usercCountLast > 0) {
                    model.setValue("ratio", (Object)(countRatioPercent + "%\u2191"), rowIndex);
                    continue;
                }
                model.setValue("ratio", (Object)(countRatioPercent + "%\u2193"), rowIndex);
            }
            countDataSet.close();
        }
    }

    private Integer countUserProcessLast(Long userID) {
        String bookTypeId = this.getPageCache().get(BOOKTYPE);
        String periodID = this.getPageCache().get(PERIOD);
        if (StringUtils.isBlank((CharSequence)bookTypeId) || Long.parseLong(bookTypeId) < 1L || StringUtils.isBlank((CharSequence)periodID) || Long.parseLong(periodID) < 1L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6709\u6743\u9650\u6838\u7b97\u4e3b\u4f53\u7684\u9ed8\u8ba4\u8d26\u7c3f\u53ca\u5176\u5f53\u524d\u671f\u95f4\u4e3a\u7a7a\uff0c\u8bf7\u524d\u5f80\u6838\u7b97\u4f53\u7cfb\u8bbe\u7f6e\u3002", (String)"RecordedCenterPlugin_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return 0;
        }
        DynamicObject previousPeriod = PeriodUtil.getPreviousPeriod((Object)periodID);
        if (null == previousPeriod) {
            return 0;
        }
        long previousPeriodId = previousPeriod.getLong("id");
        Integer count = 0;
        Long[] orgList = this.getCacheSubOrg();
        String booktypeId = this.getPageCache().get(BOOKTYPE);
        QFilter userFilter = new QFilter("submitter", "=", (Object)userID);
        QFilter statusFilter = new QFilter("billstatus", "in", (Object)new String[]{"B", "C"});
        StringBuilder selectField = new StringBuilder();
        selectField.append("id").append(',').append("billstatus").append(',').append("submitter");
        selectField.append(',').append("org");
        long[] orgs = Arrays.stream(orgList).mapToLong(t -> t).toArray();
        try (DataSet dataSet = Voucher.getDataSet((String)"RecordcenterPlugin", (String)selectField.toString(), (long[])orgs, (long)Long.parseLong(booktypeId), (long)previousPeriodId, (QFilter[])new QFilter[]{userFilter, statusFilter}, null);){
            GroupbyDataSet groupByData = dataSet.groupBy(new String[]{"submitter"});
            groupByData.count();
            DataSet countDataSet = groupByData.finish();
            for (Row row : countDataSet) {
                count = row.getInteger("count");
            }
        }
        return count;
    }

    private void entryentityProcess() {
        String org = this.getPageCache().get(ORG);
        Long orgId = StringUtils.isBlank((CharSequence)org) ? 0L : Long.parseLong(org);
        boolean isExit = this.checkRecordedSysOrgIsExit(orgId);
        List<String> loadSysFromRecordedSys = null;
        loadSysFromRecordedSys = isExit ? this.loadSysFromRecordedSys(orgId) : this.loadDefaultSys();
        this.refreshEntryentity(loadSysFromRecordedSys);
    }

    private void refreshEntryentity(List<String> appPkList) {
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        for (String bizappId : appPkList) {
            int rowIndex = model.createNewEntryRow("entryentity");
            model.setValue("bizapp", (Object)bizappId, rowIndex);
            Map<String, Object> result = this.accountBuildVchByAuto(bizappId);
            model.setValue("temptextfield", result.get("unBuildVchSum"), rowIndex);
            model.setValue("submittedtextfield", result.get("buildVchSum"), rowIndex);
        }
        String advconapAdd = this.getPageCache().get("advconap_add");
        if (StringUtils.isNotEmpty((CharSequence)advconapAdd) && advconapAdd.equals("modify")) {
            this.getPageCache().remove("advconap_add");
            this.saveRecordedSys(appPkList);
        }
    }

    private Map<String, Object> accountBuildVchByAuto(String bizappId) {
        long period;
        String org = this.getPageCache().get(ORG);
        Long acctorgId = StringUtils.isBlank((CharSequence)org) ? 0L : Long.parseLong(org);
        int buildVchSum = 0;
        int unBuildVchSum = 0;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("buildVchSum", buildVchSum);
        result.put("unBuildVchSum", unBuildVchSum);
        String periodStr = this.getPageCache().get(PERIOD);
        long l = period = StringUtils.isBlank((CharSequence)periodStr) ? 0L : Long.parseLong(periodStr);
        if (period == 0L) {
            return result;
        }
        ReconciliationResultRptHelper reconciliationResultRptHelper = new ReconciliationResultRptHelper();
        HashSet<Long> billIds = new HashSet<Long>();
        List<String> entityIds = ReconciliationResultRptHelper.getBuildVchBillsByBizapp(bizappId);
        for (String entityId : entityIds) {
            List<Map<String, Object>> billObjs = reconciliationResultRptHelper.getBillIds(entityId, acctorgId, period);
            for (Map<String, Object> billObj : billObjs) {
                billIds.add((Long)billObj.get("id"));
            }
        }
        buildVchSum = ReconciliationResultRptHelper.getVchedBillCount(billIds, acctorgId);
        int nogenVchSum = ReconciliationResultRptHelper.getNoGenCount(billIds, entityIds, acctorgId);
        unBuildVchSum = billIds.size() - buildVchSum - nogenVchSum;
        result.put("buildVchSum", buildVchSum);
        result.put("unBuildVchSum", unBuildVchSum);
        return result;
    }

    private void saveRecordedSys(List<String> collection) {
        String org = this.getPageCache().get(ORG);
        Long orgId = StringUtils.isBlank((CharSequence)org) ? 0L : Long.parseLong(org);
        DynamicObject recordedSys = null;
        boolean isExit = this.checkRecordedSysOrgIsExit(orgId);
        if (isExit) {
            QFilter orgidFilter = new QFilter("org", "=", (Object)orgId);
            DynamicObject recordedSysOjb = BusinessDataServiceHelper.loadSingle((String)"ai_recorded_sys", (String)"id", (QFilter[])new QFilter[]{orgidFilter});
            recordedSys = BusinessDataServiceHelper.loadSingle((Object)recordedSysOjb.getLong("id"), (String)"ai_recorded_sys");
        } else {
            recordedSys = this.createRecordedSysObj();
            recordedSys.set("org", (Object)orgId);
        }
        DynamicObjectCollection dynamicObjectCollection = recordedSys.getDynamicObjectCollection("entryentity");
        dynamicObjectCollection.clear();
        for (String bizappId : collection) {
            DynamicObject entryObj = new DynamicObject(dynamicObjectCollection.getDynamicObjectType());
            entryObj.set("bizapp", (Object)bizappId);
            dynamicObjectCollection.add((Object)entryObj);
        }
        OperationResult operationResult = this.invokeOperationService("ai_recorded_sys", "save", new DynamicObject[]{recordedSys});
        if (!operationResult.isSuccess()) {
            this.getView().showOperationResult(operationResult);
        }
    }

    private OperationResult invokeOperationService(String entityNumber, String operKey, DynamicObject[] dataEntities) {
        Map op = EntityMetadataCache.getProvider().getDataEntityOperate(entityNumber, operKey);
        String type = (String)op.get("type");
        OperationResult rtn = OperationServiceHelper.executeOperate((String)type, (String)entityNumber, (DynamicObject[])dataEntities, (OperateOption)OperateOption.create());
        return rtn;
    }

    private DynamicObject createRecordedSysObj() {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"ai_recorded_sys");
        DynamicObject recordedSys = new DynamicObject((DynamicObjectType)type);
        return recordedSys;
    }

    private List<String> loadDefaultSys() {
        QFilter orgidFilter = new QFilter("number", "in", (Object)new String[]{"fa"});
        DynamicObject[] sysArr = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"id", (QFilter[])new QFilter[]{orgidFilter});
        ArrayList<String> appidSet = null;
        if (null != sysArr && sysArr.length > 0) {
            appidSet = new ArrayList<String>(sysArr.length);
            for (DynamicObject sys : sysArr) {
                appidSet.add(sys.getString("id"));
            }
        }
        return appidSet;
    }

    private List<String> loadSysFromRecordedSys(Long orgId) {
        ArrayList<String> appidSet = new ArrayList<String>();
        QFilter orgidFilter = new QFilter("org", "=", (Object)orgId);
        DynamicObject recordedSys = BusinessDataServiceHelper.loadSingle((String)"ai_recorded_sys", (String)"entryentity.bizapp", (QFilter[])new QFilter[]{orgidFilter});
        DynamicObjectCollection entity = recordedSys.getDynamicObjectCollection("entryentity");
        if (null == entity || entity.size() == 0) {
            return appidSet;
        }
        for (DynamicObject rowDataObj : entity) {
            DynamicObject bizapp = rowDataObj.getDynamicObject("bizapp");
            appidSet.add((String)bizapp.getPkValue());
        }
        return appidSet;
    }

    private boolean checkRecordedSysOrgIsExit(Long orgId) {
        QFilter orgidFilter = new QFilter("org", "=", (Object)orgId);
        return QueryServiceHelper.exists((String)"ai_recorded_sys", (QFilter[])new QFilter[]{orgidFilter});
    }

    private void endProcessTotal() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        this.countProcessTotal(map, "gl_autotrans", "2", "finish0", "total0");
        this.countProcessTotal(map, "gl_adjustexchangerate", "4", "finish1", "total1");
        this.countProcessTotal(map, "gl_voucheramortacheme", "5", "finish2", "total2");
        this.countProcessTotal(map, "gl_transplprogram", "3", "finish3", "total3");
        this.setLabelText(map);
        this.setProgressBar(map);
    }

    private void setProgressBar(Map<String, Integer> countMap) {
        if (countMap != null && !countMap.isEmpty()) {
            for (int i = 0; i < 4; ++i) {
                int finish = countMap.get("finish" + i);
                int total = countMap.get("total" + i);
                int parseInt = this.countRatioPercent(finish, total);
                ((ProgressBar)this.getControl("progressbarap" + i)).setPercent(parseInt, parseInt + "%");
            }
        }
    }

    private int countRatioPercent(int finushNum, int totalNum) {
        BigDecimal total = new BigDecimal(totalNum);
        BigDecimal endNum = new BigDecimal(finushNum);
        boolean notcalculate = total.compareTo(BigDecimal.ZERO) == 0 || endNum.compareTo(BigDecimal.ZERO) == 0;
        BigDecimal ratio = notcalculate ? BigDecimal.ZERO : endNum.divide(total, 2, 4);
        return ratio.multiply(new BigDecimal(100)).intValue();
    }

    private int countRecordRatioPercent(int lastNum, int num) {
        BigDecimal ratio = BigDecimal.ZERO;
        BigDecimal total = new BigDecimal(num);
        BigDecimal lastTotal = new BigDecimal(lastNum);
        if (lastTotal.compareTo(BigDecimal.ZERO) == 0 && total.compareTo(BigDecimal.ZERO) > 0) {
            ratio = BigDecimal.ONE;
        } else {
            boolean notcalculate = total.compareTo(BigDecimal.ZERO) == 0 || lastTotal.compareTo(BigDecimal.ZERO) == 0;
            ratio = notcalculate ? BigDecimal.ZERO : total.subtract(lastTotal).divide(lastTotal, 2, 4);
        }
        return ratio.multiply(new BigDecimal(100)).intValue();
    }

    private void countProcessTotal(Map<String, Integer> map, String sourceBillType, String type, String finishFlag, String totalFlag) {
        int defaultValue = 0;
        map.put(finishFlag, defaultValue);
        map.put(totalFlag, defaultValue);
        String org = this.getPageCache().get(ORG);
        Long orgId = StringUtils.isBlank((CharSequence)org) ? 0L : Long.parseLong(org);
        String period = this.getPageCache().get(PERIOD);
        Long periodID = StringUtils.isBlank((CharSequence)period) ? 0L : Long.parseLong(period);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)orgId));
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)sourceBillType, (String)"id", (QFilter[])filters.toArray(new QFilter[0]));
        if (null != datas) {
            map.put(totalFlag, datas.length);
            ArrayList<Long> ids = new ArrayList<Long>(datas.length);
            for (int i = 0; i < datas.length; ++i) {
                ids.add(datas[i].getLong("id"));
            }
            map.put(finishFlag, this.getFinishSizeFromVoucherRelation(type, periodID, ids));
        }
    }

    private int getFinishSizeFromVoucherRelation(String type, Long periodID, List<Long> ids) {
        ArrayList<QFilter> finishFilters = new ArrayList<QFilter>();
        finishFilters.add(new QFilter("type", "=", (Object)type));
        finishFilters.add(new QFilter(Key_Period, "=", (Object)periodID));
        finishFilters.add(new QFilter("srcentity", "in", ids));
        int finishSize = 0;
        DynamicObject[] finishDatas = BusinessDataServiceHelper.load((String)"gl_voucherrelation", (String)"id,billno,targentity,srcentity", (QFilter[])finishFilters.toArray(new QFilter[0]));
        if (null != finishDatas && finishDatas.length > 0) {
            HashSet<String> finishSet = new HashSet<String>(finishDatas.length);
            for (int i = 0; i < finishDatas.length; ++i) {
                DynamicObject voucherRelationObj = finishDatas[i];
                finishSet.add(voucherRelationObj.getString("srcentity"));
            }
            return finishSet.size();
        }
        return finishSize;
    }

    private void myVoucher() {
        Map<String, Integer> map = this.getMyVoucher();
        this.setLabelText(map);
    }

    private Map<String, Integer> getMyVoucher() {
        RequestContext context = RequestContext.get();
        String userID = context.getUserId();
        Map<String, Integer> map = this.getMyVoucherDefaultValue();
        String bookTypeId = this.getPageCache().get(BOOKTYPE);
        String periodID = this.getPageCache().get(PERIOD);
        if (StringUtils.isBlank((CharSequence)bookTypeId) || Long.parseLong(bookTypeId) < 1L || StringUtils.isBlank((CharSequence)periodID) || Long.parseLong(periodID) < 1L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6709\u6743\u9650\u6838\u7b97\u4e3b\u4f53\u7684\u9ed8\u8ba4\u8d26\u7c3f\u53ca\u5176\u5f53\u524d\u671f\u95f4\u4e3a\u7a7a\uff0c\u8bf7\u524d\u5f80\u6838\u7b97\u4f53\u7cfb\u8bbe\u7f6e\u3002", (String)"RecordedCenterPlugin_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return map;
        }
        Long[] orgList = this.getCacheSubOrg();
        String booktypeId = this.getPageCache().get(BOOKTYPE);
        QFilter userFilter = new QFilter("submitter", "=", (Object)Long.valueOf(userID));
        QFilter statusFilter = new QFilter("billstatus", "in", (Object)new String[]{"A", "B", "C"});
        StringBuilder selectField = new StringBuilder();
        selectField.append("id");
        selectField.append(',').append("billstatus");
        selectField.append(',').append("submitter");
        selectField.append(',').append("ispost");
        long[] orgs = Arrays.stream(orgList).mapToLong(t -> t).toArray();
        try (DataSet dataSet = Voucher.getDataSet((String)"RecordcenterPlugin", (String)selectField.toString(), (long[])orgs, (long)Long.parseLong(booktypeId), (long)Long.parseLong(periodID), (QFilter[])new QFilter[]{userFilter, statusFilter}, null);){
            GroupbyDataSet groupByData = dataSet.groupBy(new String[]{"ispost", "billstatus"});
            groupByData.count();
            DataSet countDataSet = groupByData.finish();
            for (Row row : countDataSet) {
                boolean isPost = row.getBoolean("ispost");
                if (isPost) {
                    String controlkey = this.getControlKeyByVoucherStatus("true");
                    Integer count = map.get(controlkey);
                    Integer newCount = row.getInteger("count") == null ? Integer.valueOf(0) : row.getInteger("count");
                    if (count == null) {
                        map.put(controlkey, newCount);
                        continue;
                    }
                    count = count + newCount;
                    map.put(controlkey, count);
                    continue;
                }
                String status = row.getString("billstatus");
                String controlkey = this.getControlKeyByVoucherStatus(status);
                map.put(controlkey, row.getInteger("count"));
            }
            countDataSet.close();
        }
        return map;
    }

    private Long[] getCacheSubOrg() {
        Long[] longArray;
        String orgStr = this.getPageCache().get(SUBORG);
        if (StringUtils.isNotBlank((CharSequence)orgStr)) {
            String[] orgArrays = orgStr.split(",");
            Long[] orgs = new Long[orgArrays.length];
            for (int i = 0; i < orgArrays.length; ++i) {
                if (!StringUtils.isNotBlank((CharSequence)orgArrays[i])) continue;
                orgs[i] = Long.valueOf(orgArrays[i]);
            }
            return orgs;
        }
        String org = this.getPageCache().get(ORG);
        if (StringUtils.isBlank((CharSequence)org)) {
            longArray = new Long[]{};
        } else {
            Long[] longArray2 = new Long[1];
            longArray = longArray2;
            longArray2[0] = Long.valueOf(org);
        }
        return longArray;
    }

    private String getControlKeyByVoucherStatus(String voucherStatus) {
        String controlKey = "postednum";
        switch (voucherStatus) {
            case "A": {
                controlKey = "tempnum";
                break;
            }
            case "B": {
                controlKey = "submittednum";
                break;
            }
            case "C": {
                controlKey = "audittednum";
            }
        }
        return controlKey;
    }

    private boolean initAccountSysData(long orgid) {
        try {
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)orgid, (String)"bos_org");
            String orgName = org.getString("name");
            AccountBookInfo accountBook = AccSysUtil.getDefaultBookFromAccSys((Long)orgid);
            if (accountBook == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u8d26\u7c3f\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u524d\u5f80\u6838\u7b97\u4f53\u7cfb\u8bbe\u7f6e\u3002", (String)"RecordedCenterPlugin_6", (String)"fi-ai-formplugin", (Object[])new Object[0]), orgName));
                return false;
            }
            long bookTypeId = accountBook.getBookTypeId();
            if (bookTypeId <= 0L) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u8d26\u7c3f\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u524d\u5f80\u6838\u7b97\u4f53\u7cfb\u8bbe\u7f6e\u3002", (String)"RecordedCenterPlugin_7", (String)"fi-ai-formplugin", (Object[])new Object[0]), orgName));
                return false;
            }
            long accounttable = accountBook.getAccountTableId();
            if (accounttable <= 0L) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u79d1\u76ee\u8868\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u524d\u5f80\u6838\u7b97\u4f53\u7cfb\u8bbe\u7f6e\u3002", (String)"RecordedCenterPlugin_8", (String)"fi-ai-formplugin", (Object[])new Object[0]), orgName));
                return false;
            }
            long curperiod = this.getCurPeriod(accountBook);
            if (curperiod <= 0L) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u5f53\u524d\u671f\u95f4\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u524d\u5f80\u6838\u7b97\u4f53\u7cfb\u8bbe\u7f6e\u3002", (String)"RecordedCenterPlugin_9", (String)"fi-ai-formplugin", (Object[])new Object[0]), orgName));
                return false;
            }
            this.getPageCache().put(BOOKTYPE, String.valueOf(bookTypeId));
            this.getPageCache().put(PERIOD, String.valueOf(curperiod));
            this.getPageCache().put(ACCOUNTTABLE, String.valueOf(accounttable));
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u6838\u7b97\u4e3b\u4f53\u7684\u8d26\u7c3f\u51fa\u9519\uff0c\u8bf7\u524d\u5f80\u8bbe\u7f6e\u3002", (String)"RecordedCenterPlugin_10", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private long getCurPeriod(AccountBookInfo accountBookInfo) {
        boolean isLeaf = "true".equals(this.getPageCache().get(ISLEAF));
        if (isLeaf) {
            return accountBookInfo.getCurPeriodId();
        }
        DynamicObject periodObj = GLUtil.getPeriodByDate((Date)new Date(), (long)accountBookInfo.getPeriodTypeId());
        if (periodObj == null) {
            return 0L;
        }
        return periodObj.getLong("id");
    }

    private void cacheSubOrg(Set<Long> subOrgSet) {
        if (subOrgSet == null || subOrgSet.isEmpty()) {
            this.getPageCache().remove(SUBORG);
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (long orgid : subOrgSet) {
            sb.append(orgid).append(',');
        }
        this.getPageCache().put(SUBORG, sb.substring(0, sb.length() - 1));
    }

    private void processOrg(Long orgId) {
        this.getPageCache().put(ORG, orgId.toString());
        this.getPageCache().put(ISLEAF, "true");
        HashSet<Long> subOrg = new HashSet<Long>();
        subOrg.add(orgId);
        this.cacheSubOrg(subOrg);
    }

    private void clearData() {
        Map<String, Integer> map = this.getMyVoucherDefaultValue();
        this.setLabelText(map);
        this.getPageCache().remove(BOOKTYPE);
        this.getPageCache().remove(PERIOD);
        this.getPageCache().remove(ACCOUNTTABLE);
    }

    private void setLabelText(Map<String, Integer> countMap) {
        if (countMap != null && !countMap.isEmpty()) {
            for (Map.Entry<String, Integer> ety : countMap.entrySet()) {
                Integer num = ety.getValue();
                ((Label)this.getView().getControl(ety.getKey())).setText(num == null ? "0" : num.toString());
            }
        }
    }

    private Map<String, Integer> getMyVoucherDefaultValue() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int defaultValue = 0;
        map.put("tempnum", defaultValue);
        map.put("submittednum", defaultValue);
        map.put("audittednum", defaultValue);
        map.put("postednum", defaultValue);
        return map;
    }

    public void onProgress(ProgressEvent evt) {
        int value = 12;
        this.setInitView();
        evt.setProgress(value);
    }

    private Set<String> getDAPConfigsBizAppIds() {
        HashSet<String> appIds = new HashSet<String>();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("modeltype", "=", (Object)"BillFormModel"));
        qFilters.add(new QFilter("voucher", "=", (Object)CheckBoxEnum.TRUE.getValue()));
        try (DataSet childDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bos_entityobject", (String)"id,bizappid", (QFilter[])qFilters.toArray(new QFilter[0]), null);){
            childDataSet.forEach(row -> appIds.add(row.getString("bizappid")));
        }
        return appIds;
    }
}

