/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.builder.GLVoucherUnionType;

public class SelectTemplFormPlugin
extends AbstractFormPlugin
implements ListRowClickListener {
    private static final String ALLSELECTEDROWINFO = "allSelectedRowInfo";

    public void afterCreateNewData(EventObject e) {
        BillList billList = (BillList)this.getControl("billlistap");
        String tempids = (String)this.getView().getFormShowParameter().getCustomParam("tempId");
        if (StringUtils.isNotBlank((CharSequence)tempids)) {
            Map ids = (Map)SerializationUtils.fromJsonString((String)tempids, Map.class);
            billList.getClientQueryFilterParameter().getQFilters().add(new QFilter("id", "in", ids.get("AllTempIDS")));
            this.initIdAndBookTypeids((List)ids.get("AllTempIDS"));
            this.getPageCache().put("sourcelist", SerializationUtils.toJsonString(ids.get("selectId")));
        }
    }

    private void initIdAndBookTypeids(List<Object> list) {
        Map templateMap = BusinessDataServiceHelper.loadFromCache((Object[])list.toArray(), (String)"ai_vchtemplate");
        HashMap map = new HashMap(list.size());
        for (DynamicObject template : templateMap.values()) {
            DynamicObjectCollection dyns = template.getDynamicObjectCollection("booktype");
            HashSet<Long> keys = new HashSet<Long>(16);
            for (DynamicObject dyn : dyns) {
                keys.add(dyn.getLong("fbasedataid_id"));
            }
            map.put(template.getString("id"), keys);
        }
        this.getPageCache().put(ALLSELECTEDROWINFO, SerializationUtils.serializeToBase64(map));
    }

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        String tempids = (String)this.getView().getFormShowParameter().getCustomParam("tempId");
        if (StringUtils.isNotBlank((CharSequence)tempids)) {
            Map ids = (Map)SerializationUtils.fromJsonString((String)tempids, Map.class);
            billList.getClientQueryFilterParameter().getQFilters().add(new QFilter("id", "in", ids.get("AllTempIDS")));
            this.getPageCache().put("sourcelist", SerializationUtils.toJsonString(ids.get("selectId")));
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"affirm"});
        super.registerListener(e);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addListRowClickListener((ListRowClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button button = (Button)evt.getSource();
        String key = button.getKey();
        if ("affirm".equalsIgnoreCase(key)) {
            BillList list = (BillList)this.getControl("billlistap");
            String tempids = (String)this.getView().getFormShowParameter().getCustomParam("tempId");
            String entityname = (String)this.getView().getFormShowParameter().getCustomParam("entityname");
            String operationKey = (String)this.getView().getFormShowParameter().getCustomParam("operationKey");
            String sourcelist = this.getPageCache().get("sourcelist");
            Map ids = (Map)SerializationUtils.fromJsonString((String)tempids, Map.class);
            HashMap selectTpl = new HashMap();
            selectTpl.put("useTemp", new ArrayList());
            for (ListSelectedRow row : list.getSelectedRows()) {
                ((List)selectTpl.get("useTemp")).add(row.getPrimaryKeyValue());
            }
            List selectIds = (List)ids.get("selectId");
            if (selectIds.size() > 1 && this.isCotainOneToOneTemp((List)selectTpl.get("useTemp")) && !this.getView().getFormShowParameter().getCustomParams().containsKey("operationKey")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u5bf9\u4e00\u7684\u51ed\u8bc1\u6a21\u677f\u4e0d\u652f\u6301\u591a\u5f20\u5355\u636e\u9884\u89c8\u3002", (String)"SelectTemplFormPlugin_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            String parentPageId = (String)this.getView().getFormShowParameter().getCustomParam("pageId");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("pageId", parentPageId);
            map.put("operationKey", operationKey);
            map.put("entityname", entityname);
            map.put("souandtemp", SerializationUtils.toJsonString(selectTpl));
            map.put("sourceid", sourcelist);
            map.put("create_mode", this.getView().getFormShowParameter().getCustomParam("create_mode"));
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(map));
            this.getView().close();
        }
    }

    private boolean isCotainOneToOneTemp(List<Object> list) {
        DynamicObject[] templates;
        for (DynamicObject vchTemplateinfo : templates = BusinessDataServiceHelper.load((String)"ai_vchtemplate", (String)"name,fxml,fxmllang", (QFilter[])new QFilter("id", "in", list).toArray())) {
            String json = vchTemplateinfo.getString("fxml");
            ILocaleValue langJsons = (ILocaleValue)vchTemplateinfo.get("fxmllang");
            VCHTemplate vchTemplate = null;
            vchTemplate = VCHTemplate.deserializeFromString((String)json, (Map)langJsons);
            if (vchTemplate.getUnionType() != GLVoucherUnionType.Single) continue;
            return true;
        }
        return false;
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRow selectedRow;
        super.listRowClick(evt);
        BillList billList = (BillList)this.getControl("billlistap");
        String allSelectedStr = this.getPageCache().get(ALLSELECTEDROWINFO);
        HashMap<String, Set<Long>> allSelectedRowInfo = new HashMap();
        if (!StringUtils.isEmpty((CharSequence)allSelectedStr)) {
            allSelectedRowInfo = (Map)SerializationUtils.deSerializeFromBase64((String)allSelectedStr);
        }
        if ((selectedRow = billList.getCurrentSelectedRowInfo()) == null) {
            this.getPageCache().remove("hasSelectRows");
            this.getPageCache().remove("tipcheck");
            return;
        }
        Long srowId = Long.parseLong(selectedRow.getPrimaryKeyValue() + "");
        int rowKey = selectedRow.getRowKey();
        String key = srowId + "-" + rowKey;
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        int[] rowKeys = selectedRows.getRowKeys();
        String tc = this.getPageCache().get("tipcheck");
        if (tc != null) {
            int[] tipcheck = (int[])SerializationUtils.fromJsonString((String)tc, int[].class);
            Arrays.sort(rowKeys);
            Arrays.sort(tipcheck);
            if (Arrays.equals(rowKeys, tipcheck)) {
                return;
            }
        }
        Map<String, Set<Long>> selectRows = new HashMap();
        String hsr = this.getPageCache().get("hasSelectRows");
        if (hsr != null) {
            selectRows = (Map)SerializationUtils.fromJsonString((String)hsr, Map.class);
        }
        if (Objects.equals(billList.getSelectedRows().size(), billList.getCurrentListAllRowCollection().size()) && billList.getSelectedRows().size() != 1) {
            Map<String, Set<Long>> afterDealSelectRows = this.dealSelectRows(selectRows, key, allSelectedRowInfo);
            this.dealData(afterDealSelectRows, billList);
            return;
        }
        if (selectRows.containsKey(key)) {
            String rkey = "";
            for (String v : selectRows.keySet()) {
                String[] split = v.split("-");
                int ccc = Integer.parseInt(split[1]);
                for (int c : rowKeys) {
                    if (Objects.equals(ccc, c)) continue;
                    rkey = v;
                }
            }
            selectRows.remove(rkey);
            this.dealData(selectRows, billList);
            return;
        }
        DynamicObject type = BusinessDataServiceHelper.loadSingleFromCache((Object)srowId, (String)"ai_vchtemplate");
        DynamicObjectCollection dyns = type.getDynamicObjectCollection("booktype");
        HashSet<Long> keys = new HashSet<Long>(16);
        for (DynamicObject dyn : dyns) {
            keys.add(dyn.getLong("fbasedataid_id"));
        }
        if (keys.isEmpty()) {
            selectRows.clear();
            selectRows.put(key, keys);
        } else {
            ArrayList<String> removeKey = new ArrayList<String>(selectRows.size());
            if (selectRows.isEmpty()) {
                selectRows.put(srowId + "-" + rowKey, keys);
                this.getPageCache().put("hasSelectRows", SerializationUtils.toJsonString(selectRows));
                return;
            }
            for (Map.Entry<String, Set<Long>> sr : selectRows.entrySet()) {
                HashSet value = new HashSet(sr.getValue());
                boolean ishave = false;
                for (Long k : keys) {
                    if (!value.contains(k)) continue;
                    ishave = true;
                    break;
                }
                if (ishave) {
                    removeKey.add(sr.getKey());
                    continue;
                }
                String key0 = sr.getKey();
                String[] stringArray = key0.split("-");
            }
            for (String rkey : removeKey) {
                selectRows.remove(rkey);
            }
            selectRows.put(key, keys);
        }
        Map<String, Set<Long>> afterDealSelectRows = this.dealSelectRows(selectRows, key, allSelectedRowInfo);
        this.dealData(afterDealSelectRows, billList);
    }

    private Map<String, Set<Long>> dealSelectRows(Map<String, Set<Long>> selectRows, String key, Map<String, Set<Long>> allSelectedRowInfo) {
        HashMap<String, Set<Long>> map = new HashMap<String, Set<Long>>();
        String templateId = key.split("\\-")[0];
        Set<Long> currentSet = allSelectedRowInfo.get(templateId);
        if (!currentSet.isEmpty()) {
            for (Map.Entry<String, Set<Long>> entry : selectRows.entrySet()) {
                HashSet tempSet = new HashSet(entry.getValue());
                if (tempSet.isEmpty()) continue;
                tempSet.retainAll(currentSet);
                if (!tempSet.isEmpty()) continue;
                map.put(entry.getKey(), new HashSet(entry.getValue()));
            }
        }
        map.put(key, currentSet);
        return map;
    }

    private void dealData(Map<String, Set<Long>> selectRows, BillList billList) {
        this.getPageCache().put("hasSelectRows", SerializationUtils.toJsonString(selectRows));
        int[] rows = new int[selectRows.size()];
        int index = 0;
        for (String i : selectRows.keySet()) {
            String[] split = i.split("-");
            rows[index++] = Integer.parseInt(split[1]);
        }
        billList.selectRows(rows);
        this.getPageCache().put("tipcheck", SerializationUtils.toJsonString((Object)rows));
    }
}

