/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ShowAiEventPlugin
extends AbstractBillPlugIn {
    private static final Log log = LogFactory.getLog(ShowAiEventPlugin.class);
    private static final String FIELDENTRYENTITY = "fieldentryentity";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTRY = "entry";
    private static final String FIELDTYPE = "fieldtype";
    private static final String FIELDNAME = "fieldname";
    private static final String FIELDALIAS = "fieldalias";
    private static final String ENTRYFIELDNAME = "entryfieldname";
    private static final String ENTRYFIELDALIAS = "entryfieldalias";
    private static final String BASEDATA = "basedata";
    private static final String ASSISTANT = "assistant";
    private LinkedHashMap<String, String> fieldmap = new LinkedHashMap();
    private static final String HEAD_FILED = "head_field";
    private static final String ENTRY_NAME = "entry_name";
    private static final String ENTRY_INFO = "entry_info";
    private static final String FLEXPANELAPBASE = "flexpanelapbase";
    private static final String ADVCONAP = "advconap";
    private static final String FLEXPANELAP = "flexpanelap";
    private static Map<String, MethodNameArgPair> fieldMethodMap = new HashMap<String, MethodNameArgPair>();
    private static Map<String, Method> methodCache = new HashMap<String, Method>();

    public ShowAiEventPlugin() {
        this.fieldmap.put("bill_eventclass", ResManager.loadKDString((String)"\u4e8b\u4ef6\u6a21\u578b", (String)"ShowAiEventPlugin_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        this.fieldmap.put("bill_number", ResManager.loadKDString((String)"\u4f1a\u8ba1\u4e8b\u4ef6\u53f7", (String)"ShowAiEventPlugin_9", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        this.fieldmap.put("bill_org", ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143", (String)"ShowAiEventPlugin_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        this.fieldmap.put("bill_sourcesys", ResManager.loadKDString((String)"\u6765\u6e90\u7cfb\u7edf", (String)"ShowAiEventPlugin_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        this.fieldmap.put("bill_description", ResManager.loadKDString((String)"\u63cf\u8ff0", (String)"ShowAiEventPlugin_4", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        this.fieldmap.put("bill_status", ResManager.loadKDString((String)"\u72b6\u6001", (String)"ShowAiEventPlugin_5", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        fieldMethodMap.put("number", new MethodNameArgPair("setTextAlign", new Object[]{"right"}));
        fieldMethodMap.put("date", new MethodNameArgPair("setTextAlign", new Object[]{"center"}));
        fieldMethodMap.put("boolean", new MethodNameArgPair("setTextAlign", new Object[]{"center"}));
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        BillShowParameter bsp = (BillShowParameter)e.getSource();
        Long eventId = Long.parseLong(bsp.getPkId() + "");
        Map<String, Object> eventClassInfo = this.getEventClassInfo(eventId);
        List headFields = (List)eventClassInfo.get(HEAD_FILED);
        List entryNames = (List)eventClassInfo.get(ENTRY_NAME);
        Map entryFields = (Map)eventClassInfo.get(ENTRY_INFO);
        bsp.setCustomParam(HEAD_FILED, (Object)SerializationUtils.serializeToBase64((Object)headFields));
        bsp.setCustomParam(ENTRY_NAME, (Object)SerializationUtils.serializeToBase64((Object)entryNames));
        bsp.setCustomParam(ENTRY_INFO, (Object)SerializationUtils.serializeToBase64((Object)entryFields));
        this.drawEntryHead(e, headFields, this.fieldmap);
        this.drawEntryGrid(e, entryNames, entryFields);
    }

    private Map<String, Map<String, Object>> getFiledAndEntityName(Long eventId) {
        HashMap<String, Map<String, Object>> filedAndEntityName = new HashMap<String, Map<String, Object>>();
        DynamicObject event = BusinessDataServiceHelper.loadSingleFromCache((Object)eventId, (String)"ai_event");
        Long eventClassId = event.getLong("eventclass.id");
        DynamicObject eventClass = BusinessDataServiceHelper.loadSingle((Object)eventClassId, (String)"ai_eventclass");
        DynamicObjectCollection fieldentryentity = eventClass.getDynamicObjectCollection(FIELDENTRYENTITY);
        for (DynamicObject fieldentity : fieldentryentity) {
            HashMap<String, String> map;
            if (BASEDATA.equals(fieldentity.get(FIELDTYPE))) {
                map = new HashMap<String, String>();
                map.put(BASEDATA, fieldentity.getString("refobj.id"));
                filedAndEntityName.put(fieldentity.getString(FIELDNAME), map);
                continue;
            }
            if (ASSISTANT.equals(fieldentity.get(FIELDTYPE))) {
                map = new HashMap();
                map.put(ASSISTANT, fieldentity.getString("assistant.id"));
                filedAndEntityName.put(fieldentity.getString(FIELDNAME), map);
                continue;
            }
            if (!ENTRY.equals(fieldentity.get(FIELDTYPE))) continue;
            DynamicObjectCollection entryentity = fieldentity.getDynamicObjectCollection(ENTRYENTITY);
            for (DynamicObject entity : entryentity) {
                HashMap<String, String> map2;
                if (BASEDATA.equals(entity.get("entryfieldtype"))) {
                    map2 = new HashMap<String, String>();
                    map2.put(BASEDATA, entity.getString("entryrefobj.id"));
                    filedAndEntityName.put(entity.getString(ENTRYFIELDNAME), map2);
                    continue;
                }
                if (!ASSISTANT.equals(entity.get("entryfieldtype"))) continue;
                map2 = new HashMap();
                map2.put(ASSISTANT, entity.getString("entryassistant.id"));
                filedAndEntityName.put(entity.getString(ENTRYFIELDNAME), map2);
            }
        }
        return filedAndEntityName;
    }

    private void drawEntryHead(LoadCustomControlMetasArgs e, List<DynamicObject> headFields, LinkedHashMap<String, String> map) {
        FlexPanelAp headAp = this.createDynamicPanel(map, headFields);
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", FLEXPANELAPBASE);
        mapHead.put("items", (String)headAp.createControl().get("items"));
        e.getItems().add(mapHead);
    }

    private void drawEntryGrid(LoadCustomControlMetasArgs e, List<DynamicObject> entryNames, Map<String, List<DynamicObject>> entryFields) {
        e.getSource();
        for (int i = 0; i < entryNames.size(); ++i) {
            List<DynamicObject> list = entryFields.get(entryNames.get(i).getString(FIELDNAME));
            if (CollectionUtils.isEmpty(list)) {
                return;
            }
            EntryAp entryAp = this.createDynamicEntryAp(list, i);
            this.setEntryStyle(entryAp);
            HashMap<String, String> mapEntry = new HashMap<String, String>();
            mapEntry.put("id", ENTRYENTITY + i);
            mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
            mapEntry.put("w", (String)new LocaleString(this.getWidth(list.size())));
            e.getItems().add(mapEntry);
        }
    }

    private void setEntryStyle(EntryAp entryAp) {
        entryAp.setShowSeq(true);
    }

    private String getWidth(int size) {
        return 100 / size + "%";
    }

    private FlexPanelAp createDynamicPanel(LinkedHashMap<String, String> map, List<DynamicObject> headFields) {
        TextField field;
        FieldAp fieldAp;
        String key;
        FlexPanelAp headPanelAp = new FlexPanelAp();
        headPanelAp.setKey(FLEXPANELAPBASE);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            key = entry.getKey();
            fieldAp = new FieldAp();
            fieldAp.setId(key);
            fieldAp.setKey(key);
            fieldAp.setName(new LocaleString(entry.getValue()));
            fieldAp.setBackColor("#FFFFFF");
            fieldAp.setLabelDirection("v");
            fieldAp.setLock("new,edit,view,submit,audit");
            field = new TextField();
            field.setId(key);
            field.setKey(key);
            fieldAp.setField((Field)field);
            headPanelAp.getItems().add(fieldAp);
        }
        for (DynamicObject headField : headFields) {
            key = headField.getString(FIELDNAME);
            fieldAp = new FieldAp();
            fieldAp.setId(key);
            fieldAp.setKey(key);
            fieldAp.setName(new LocaleString(headField.getString(FIELDALIAS)));
            fieldAp.setBackColor("#FFFFFF");
            fieldAp.setLabelDirection("v");
            fieldAp.setLock("new,edit,view,submit,audit");
            field = new TextField();
            field.setId(key);
            field.setKey(key);
            fieldAp.setField((Field)field);
            headPanelAp.getItems().add(fieldAp);
        }
        return headPanelAp;
    }

    private EntryAp createDynamicEntryAp(List<DynamicObject> list, int index) {
        String width = list.size() == 0 ? "" : this.getWidth(list.size());
        EntryAp entryAp = new EntryAp();
        entryAp.setKey("entryap" + index);
        for (int i = 0; i < list.size(); ++i) {
            DynamicObject dyn = list.get(i);
            EntryFieldAp fieldAp = new EntryFieldAp();
            fieldAp.setId(dyn.getString(ENTRYFIELDNAME));
            fieldAp.setKey(dyn.getString(ENTRYFIELDNAME));
            fieldAp.setName(new LocaleString(dyn.getString(ENTRYFIELDALIAS)));
            fieldAp.setLock("new,edit,view,submit,audit");
            fieldAp.setWidth(new LocaleString(width));
            TextField field = new TextField();
            field.setId(dyn.getString(ENTRYFIELDNAME));
            field.setKey(dyn.getString(ENTRYFIELDNAME));
            this.customStyle(fieldAp, dyn.getString("entryfieldtype"));
            fieldAp.setField((Field)field);
            entryAp.getItems().add(fieldAp);
        }
        return entryAp;
    }

    private void customStyle(EntryFieldAp fieldAp, String s) {
        try {
            MethodNameArgPair typeArgGroup = fieldMethodMap.get(s);
            if (typeArgGroup == null) {
                return;
            }
            Method method = this.getCustomStyleSetMethod(typeArgGroup);
            method.invoke((Object)fieldAp, typeArgGroup.args);
        }
        catch (Exception e) {
            log.error(String.format("\u5b57\u6bb5\uff1a\u3010%s\u3011 \u7c7b\u578b\uff1a\u3010%s\u3011\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u6837\u5f0f\u9519\u8bef \u5f02\u5e38\u7c7b\u578b\uff1a\u3010%s\u3011", fieldAp.getId(), s, e.getMessage()));
            throw new KDBizException(ResManager.loadKDString((String)"\u521b\u5efa\u9875\u9762\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u68c0\u67e5\u3002", (String)"ShowAiEventPlugin_6", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
    }

    private Method getCustomStyleSetMethod(MethodNameArgPair typeArgGroup) throws NoSuchMethodException {
        Method method = methodCache.get(typeArgGroup.name);
        if (method == null) {
            ArrayList argClassArr = new ArrayList(typeArgGroup.args.length);
            Arrays.stream(typeArgGroup.args).forEach(arg -> argClassArr.add(arg.getClass()));
            method = EntryFieldAp.class.getMethod(typeArgGroup.name, argClassArr.toArray(new Class[0]));
            methodCache.put(typeArgGroup.name, method);
        }
        return method;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        BillShowParameter bsp = (BillShowParameter)this.getView().getFormShowParameter();
        if (bsp.getCustomParam(HEAD_FILED) == null) {
            return;
        }
        List headFields = (List)SerializationUtils.deSerializeFromBase64((String)((String)bsp.getCustomParam(HEAD_FILED)));
        List entryNames = (List)SerializationUtils.deSerializeFromBase64((String)((String)bsp.getCustomParam(ENTRY_NAME)));
        Map entryFields = (Map)SerializationUtils.deSerializeFromBase64((String)((String)bsp.getCustomParam(ENTRY_INFO)));
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("ShowAiEventPlugin", exp.getMessage()), new Object[0]);
        }
        this.registDynamicProps(newMainType, headFields, entryFields, entryNames);
        e.setNewEntityType(newMainType);
    }

    private void registDynamicProps(MainEntityType newMainType, List<DynamicObject> headFields, Map<String, List<DynamicObject>> entryFields, List<DynamicObject> entryNames) {
        TextProp textProp;
        for (Map.Entry<String, String> entry : this.fieldmap.entrySet()) {
            textProp = new TextProp();
            textProp.setName(entry.getKey());
            textProp.setDisplayName(new LocaleString(entry.getValue()));
            textProp.setDbIgnore(true);
            textProp.setAlias("");
            newMainType.registerSimpleProperty((DynamicSimpleProperty)textProp);
        }
        for (DynamicObject headField : headFields) {
            textProp = new TextProp();
            textProp.setName(headField.getString(FIELDNAME));
            textProp.setDisplayName(new LocaleString(FIELDALIAS));
            textProp.setDbIgnore(true);
            textProp.setAlias("");
            newMainType.registerSimpleProperty((DynamicSimpleProperty)textProp);
        }
        int index = 0;
        for (DynamicObject entryName : entryNames) {
            String name = entryName.getString(FIELDNAME);
            List<DynamicObject> entryField = entryFields.get(name);
            EntryType entryType = (EntryType)newMainType.getAllEntities().get(ENTRYENTITY + index);
            for (DynamicObject entry : entryField) {
                TextProp textProp2 = new TextProp();
                textProp2.setName(entry.getString(ENTRYFIELDNAME));
                textProp2.setDisplayName(new LocaleString(entry.getString(ENTRYFIELDALIAS)));
                textProp2.setDbIgnore(true);
                textProp2.setAlias("");
                entryType.registerSimpleProperty((DynamicSimpleProperty)textProp2);
            }
            ++index;
        }
    }

    public void beforeBindData(EventObject e) {
        BillShowParameter bsp = (BillShowParameter)((BillView)e.getSource()).getFormShowParameter();
        List headFields = (List)SerializationUtils.deSerializeFromBase64((String)((String)bsp.getCustomParam(HEAD_FILED)));
        List entryNames = (List)SerializationUtils.deSerializeFromBase64((String)((String)bsp.getCustomParam(ENTRY_NAME)));
        Map entryFields = (Map)SerializationUtils.deSerializeFromBase64((String)((String)bsp.getCustomParam(ENTRY_INFO)));
        FlexPanelAp dynamicPanel = this.createDynamicPanel(this.fieldmap, headFields);
        Container myFldPanel = (Container)this.getView().getControl(FLEXPANELAPBASE);
        myFldPanel.getItems().addAll(((Container)dynamicPanel.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(myFldPanel.getItems());
        for (int i = 0; i < entryNames.size(); ++i) {
            EntryAp entryAp = this.createDynamicEntryAp((List)entryFields.get(((DynamicObject)entryNames.get(i)).getString(FIELDNAME)), i);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY + i);
            List fieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
            for (Control fieldEdit : fieldEdits) {
                fieldEdit.setView(this.getView());
                entryGrid.getItems().add(fieldEdit);
            }
        }
    }

    public void afterBindData(EventObject e) {
        BillShowParameter bsp = (BillShowParameter)((BillView)e.getSource()).getFormShowParameter();
        Long eventId = Long.parseLong(bsp.getPkId().toString());
        Map<String, Map<String, Object>> filedAndEntityName = this.getFiledAndEntityName(eventId);
        List headFields = (List)SerializationUtils.deSerializeFromBase64((String)((String)bsp.getCustomParam(HEAD_FILED)));
        List entryNames = (List)SerializationUtils.deSerializeFromBase64((String)((String)bsp.getCustomParam(ENTRY_NAME)));
        Map entryFields = (Map)SerializationUtils.deSerializeFromBase64((String)((String)bsp.getCustomParam(ENTRY_INFO)));
        Map map = (Map)SerializationUtils.fromJsonString((String)(this.getModel().getValue("data_tag") + ""), Map.class);
        this.changeTitleName(entryNames);
        this.setOldBillValue();
        this.setEventClassHeadValue(map, headFields, filedAndEntityName);
        this.setEventClassEntryValue(map, entryNames, entryFields, filedAndEntityName);
        this.hideEntry(entryNames.size());
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
    }

    private void setEventClassEntryValue(Map<String, Object> map, List<DynamicObject> entryNames, Map<String, List<DynamicObject>> entryFields, Map<String, Map<String, Object>> filedAndEntityName) {
        IDataModel model = this.getModel();
        for (int i = 0; i < entryNames.size(); ++i) {
            String fieldname = entryNames.get(i).getString(FIELDNAME);
            if (!map.containsKey(fieldname)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAP + (i + 1)});
                continue;
            }
            List<DynamicObject> entryField = entryFields.get(fieldname);
            List dataList = (List)map.get(fieldname);
            if (dataList.isEmpty()) continue;
            model.batchCreateNewEntryRow(ENTRYENTITY + i, dataList.size());
            for (int j = 0; j < dataList.size(); ++j) {
                Map dataMap = (Map)dataList.get(j);
                for (DynamicObject entry : entryField) {
                    String fieldName = entry.getString(ENTRYFIELDNAME);
                    if (filedAndEntityName.containsKey(fieldName)) {
                        String value = this.getNumber(filedAndEntityName.get(fieldName), dataMap.get(fieldName));
                        model.setValue(fieldName, (Object)value, j);
                        continue;
                    }
                    model.setValue(fieldName, dataMap.get(fieldName), j);
                }
            }
            this.getView().updateView(ENTRYENTITY + i);
        }
    }

    private void setEventClassHeadValue(Map<String, Object> map, List<DynamicObject> headFields, Map<String, Map<String, Object>> filedAndEntityName) {
        IDataModel model = this.getModel();
        for (DynamicObject headField : headFields) {
            String fieldName = headField.getString(FIELDNAME);
            if (filedAndEntityName.containsKey(fieldName)) {
                String value = this.getNumber(filedAndEntityName.get(fieldName), map.get(fieldName));
                model.setValue(fieldName, (Object)value);
                continue;
            }
            model.setValue(fieldName, map.get(headField.getString(FIELDNAME)));
        }
    }

    private String getNumber(Map<String, Object> map, Object object) {
        String number = null;
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        if (iterator.hasNext()) {
            String type;
            Map.Entry<String, Object> entry = iterator.next();
            Long id = 0L;
            if (object != null && !StringUtils.isEmpty((CharSequence)(object + ""))) {
                id = Long.parseLong(object + "");
            }
            if (BASEDATA.equals(type = entry.getKey())) {
                if (StringUtils.isBlank((CharSequence)this.getPageCache().get(entry.getValue() + "" + id + type))) {
                    DynamicObject[] dyns = BusinessDataServiceHelper.load((String)(entry.getValue() + ""), (String)"number", (QFilter[])new QFilter("id", "=", (Object)id).toArray());
                    if (dyns != null && dyns.length > 0) {
                        this.getPageCache().put(entry.getValue() + "" + id + type, dyns[0].getString("number"));
                        number = dyns[0].getString("number");
                    }
                } else {
                    number = this.getPageCache().get(entry.getValue() + "" + id + type);
                }
                return number;
            }
            QFilter groupFilter = new QFilter("group.id", "=", (Object)Long.parseLong(entry.getValue() + ""));
            QFilter numberFilter = new QFilter("masterid", "=", (Object)id);
            if (StringUtils.isBlank((CharSequence)this.getPageCache().get(entry.getValue() + "" + id + type))) {
                DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"bos_assistantdata_detail", (String)"number", (QFilter[])new QFilter[]{groupFilter, numberFilter});
                if (dyns != null && dyns.length > 0) {
                    this.getPageCache().put(entry.getValue() + "" + id + type, dyns[0].getString("number"));
                    number = dyns[0].getString("number");
                }
            } else {
                number = this.getPageCache().get(entry.getValue() + "" + id + type);
            }
            return number;
        }
        return null;
    }

    private void setOldBillValue() {
        IDataModel model;
        model.setValue("bill_eventclass", (Object)((model = this.getModel()).getValue("eventclass") == null ? "" : ((DynamicObject)model.getValue("eventclass")).getString("name")));
        model.setValue("bill_number", model.getValue("number"));
        model.setValue("bill_org", (Object)(model.getValue("org") == null ? "" : ((DynamicObject)model.getValue("org")).getString("name")));
        model.setValue("bill_sourcesys", model.getValue("sourcesys"));
        model.setValue("bill_description", model.getValue("description"));
        model.setValue("bill_status", (Object)this.getDesc(model.getValue("status") + ""));
    }

    private String getDesc(String value) {
        String desc = "";
        switch (value) {
            case "1": {
                desc = ResManager.loadKDString((String)"\u751f\u6548", (String)"ShowAiEventPlugin_7", (String)"fi-ai-formplugin", (Object[])new Object[0]);
                break;
            }
            case "2": {
                desc = ResManager.loadKDString((String)"\u5e9f\u5f03", (String)"ShowAiEventPlugin_8", (String)"fi-ai-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        return desc;
    }

    private void changeTitleName(List<DynamicObject> entryNames) {
        int size = entryNames.size();
        for (int i = 0; i < size; ++i) {
            HashMap<String, LocaleString> props = new HashMap<String, LocaleString>(1);
            props.put("text", new LocaleString(entryNames.get(i).getString(FIELDALIAS)));
            this.getView().updateControlMetadata(ADVCONAP + i, props);
        }
    }

    private void hideEntry(int size) {
        for (int i = size; i <= 8; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAP + (i + 1)});
        }
    }

    private Map<String, Object> getEventClassInfo(Long id) {
        HashMap<String, Object> eventClassInfo = new HashMap<String, Object>(3);
        ArrayList<DynamicObject> headFields = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> entryNames = new ArrayList<DynamicObject>(16);
        LinkedHashMap entryFields = new LinkedHashMap(16);
        DynamicObject event = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ai_event");
        DynamicObject dyn = event.getDynamicObject("eventclass");
        DynamicObjectCollection fieldEntrys = dyn.getDynamicObjectCollection(FIELDENTRYENTITY);
        for (DynamicObject fieldEntry : fieldEntrys) {
            if (!ENTRY.equals(fieldEntry.getString(FIELDTYPE))) {
                headFields.add(fieldEntry);
                continue;
            }
            entryNames.add(fieldEntry);
            DynamicObjectCollection entryentity = fieldEntry.getDynamicObjectCollection(ENTRYENTITY);
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(entryentity.size());
            for (DynamicObject entity : entryentity) {
                list.add(entity);
            }
            entryFields.put(fieldEntry.getString(FIELDNAME), list);
        }
        eventClassInfo.put(HEAD_FILED, headFields);
        eventClassInfo.put(ENTRY_NAME, entryNames);
        eventClassInfo.put(ENTRY_INFO, entryFields);
        return eventClassInfo;
    }

    private static class MethodNameArgPair {
        protected String name;
        protected Object[] args;

        private MethodNameArgPair(String name, Object ... args) {
            this.name = name;
            this.args = args;
        }
    }
}

