/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ai.AbstractVchTplItemMap;
import kd.fi.ai.TemplateInfo;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.VchTplAcctFactorMap;
import kd.fi.ai.VchTplBizGroup;
import kd.fi.ai.VchTplEntry;

public class TemplateConnectEditPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String QUERY_CONNECT = "SELECT FID,FXML,FNUMBER,FNAME FROM T_AI_VCHTEMPLATE ";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTITYNUMBER = "entitynumber";
    private static final String ID = "id";
    private static final String VCHID = "vchid";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String VCHNUMBER = "vchnumber";
    private static final String VCHNAME = "vchname";
    private static final String CONNECTDETAILS = "connectdetails";

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        List paramIds = (List)this.getView().getFormShowParameter().getCustomParam("ids");
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(ENTITYNUMBER);
        if (paramIds != null && entityNumber != null) {
            this.getModel().setValue(ENTITYNUMBER, (Object)entityNumber);
            List<TemplateInfo> list = new ArrayList<TemplateInfo>(paramIds.size());
            for (String id : paramIds) {
                Long longId = Long.valueOf(id);
                list = this.getVchTemplate(list, longId, entityNumber);
            }
            if (list.isEmpty()) {
                return;
            }
            this.getModel().deleteEntryData(ENTRYENTITY);
            int i = 0;
            for (TemplateInfo templateInfo : list) {
                String connectDetails = this.getConnectDetails(templateInfo);
                if (null == connectDetails) continue;
                this.getModel().createNewEntryRow(ENTRYENTITY);
                this.getModel().setValue(ID, (Object)templateInfo.getId(), i);
                this.getModel().setValue(VCHID, (Object)templateInfo.getVchid(), i);
                this.getModel().setValue(NUMBER, (Object)templateInfo.getNumber(), i);
                this.getModel().setValue(NAME, (Object)templateInfo.getName(), i);
                this.getModel().setValue(VCHNUMBER, (Object)templateInfo.getVchnumber(), i);
                this.getModel().setValue(VCHNAME, (Object)templateInfo.getVchname(), i);
                this.getModel().setValue(CONNECTDETAILS, (Object)connectDetails, i);
                ++i;
            }
        }
    }

    private String getConnectDetails(TemplateInfo templateInfo) {
        Long id = templateInfo.getId();
        String fxml = templateInfo.getFxml();
        if (null == id || StringUtils.isEmpty((CharSequence)fxml)) {
            return null;
        }
        VCHTemplate template = VCHTemplate.deserializeFromString((String)fxml, null);
        if (null != template && null != template.getBizGroups() && !template.getBizGroups().isEmpty() && template.getBizGroups().get(0) != null) {
            VchTplBizGroup vchTplBizGroup = (VchTplBizGroup)template.getBizGroups().get(0);
            List vchEntrys = vchTplBizGroup.getVchEntrys();
            StringBuilder sb = new StringBuilder();
            sb.append(ResManager.loadKDString((String)"\u5728\u51ed\u8bc1\u6a21\u677f", (String)"TemplateConnectEditPlugin_01", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            boolean flag = false;
            for (VchTplEntry vchEntry : vchEntrys) {
                if (!id.equals(vchEntry.getAcctsSet().getMappingid()) && !this.baseDataConnect(id, vchEntry) && !this.asstDataConnect(id, vchEntry)) continue;
                flag = true;
                String row = String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c", (String)"TemplateConnectEditPlugin_02", (String)"fi-ai-formplugin", (Object[])new Object[0]), vchEntry.getSeq());
                sb.append(row);
            }
            if (flag) {
                sb.append(ResManager.loadKDString((String)"\u5f15\u7528\u3002", (String)"TemplateConnectEditPlugin_03", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return sb.toString();
            }
        }
        if (fxml.contains("GetMappingBaseData")) {
            return ResManager.loadKDString((String)"\u5728\u51ed\u8bc1\u6a21\u677f\u9664\u79d1\u76ee\u3001\u6838\u7b97\u7ef4\u5ea6\u3001\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u548c\u4e3b\u8868\u6838\u7b97\u7ef4\u5ea6\u4e4b\u5916\u5f15\u7528\u3002", (String)"TemplateConnectEditPlugin_04", (String)"fi-ai-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private boolean asstDataConnect(Long id, VchTplEntry vchEntry) {
        List itemMaps;
        if (!vchEntry.getAsst().getItemClassMaps().isEmpty()) {
            itemMaps = vchEntry.getAsst().getItemClassMaps();
            for (AbstractVchTplItemMap itemMap : itemMaps) {
                if (!id.equals(itemMap.getAsstDimMapID())) continue;
                return true;
            }
        }
        if (!vchEntry.getMainAsst().getItemClassMaps().isEmpty()) {
            itemMaps = vchEntry.getMainAsst().getItemClassMaps();
            for (AbstractVchTplItemMap itemMap : itemMaps) {
                if (!id.equals(itemMap.getAsstDimMapID())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean baseDataConnect(Long id, VchTplEntry vchEntry) {
        if (!vchEntry.getAcctsSet().getFactorMaps().isEmpty()) {
            List factorMaps = vchEntry.getAcctsSet().getFactorMaps();
            for (VchTplAcctFactorMap factorMap : factorMaps) {
                if (!id.equals(factorMap.getMapping())) continue;
                return true;
            }
        }
        return "mapping".equalsIgnoreCase(vchEntry.getCashflow().getSourcetype()) && (id.equals(vchEntry.getCashflow().getFieldmappingid()) || id.equals(vchEntry.getCashflow().getSupmappingid())) || vchEntry.getCashflow().getExp().contains(String.valueOf(id)) || vchEntry.getCashflow().getSupexp().contains(String.valueOf(id));
    }

    private List<TemplateInfo> getVchTemplate(List<TemplateInfo> list, Long id, String entityNumber) {
        DBRoute of = DBRoute.of((String)"ai");
        int value = DB.getDBType((DBRoute)of).getValue();
        StringBuilder sb = new StringBuilder(QUERY_CONNECT);
        if (20 != value) {
            sb.append("WHERE FXML LIKE '%").append(id).append("%'");
        }
        try (DataSet qd = DB.queryDataSet((String)TemplateConnectEditPlugin.class.getName(), (DBRoute)of, (String)sb.toString());){
            DynamicObject dynamic = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)entityNumber, (String)"number,name");
            for (Row row : qd) {
                if (20 == value) {
                    String xml = row.getString("FXML");
                    if (!StringUtils.isNotBlank((CharSequence)xml) || !xml.contains(id.toString())) continue;
                    TemplateInfo templateInfo = new TemplateInfo();
                    templateInfo.setId(id);
                    templateInfo.setNumber(dynamic.getString(NUMBER));
                    templateInfo.setName(dynamic.getString(NAME));
                    templateInfo.setVchid(row.getLong("FID"));
                    templateInfo.setVchnumber(row.getString("FNUMBER"));
                    templateInfo.setVchname(row.getString("FNAME"));
                    templateInfo.setFxml(xml);
                    list.add(templateInfo);
                    continue;
                }
                TemplateInfo templateInfo = new TemplateInfo();
                templateInfo.setId(id);
                templateInfo.setNumber(dynamic.getString(NUMBER));
                templateInfo.setName(dynamic.getString(NAME));
                templateInfo.setVchid(row.getLong("FID"));
                templateInfo.setVchnumber(row.getString("FNUMBER"));
                templateInfo.setVchname(row.getString("FNAME"));
                templateInfo.setFxml(row.getString("FXML"));
                list.add(templateInfo);
            }
        }
        return list;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String key = evt.getFieldName();
        int rowIndex = evt.getRowIndex();
        String entityNumber = (String)this.getModel().getValue(ENTITYNUMBER);
        if (NUMBER.equals(key)) {
            this.showConnectBaseData(rowIndex, entityNumber);
        }
        if (VCHNUMBER.equals(key)) {
            this.showVchTemplate(rowIndex);
        }
    }

    private void showConnectBaseData(int rowIndex, String entityNumber) {
        IDataModel model = this.getModel();
        long id = (Long)model.getValue(ID, rowIndex);
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(entityNumber);
        showParameter.setPkId((Object)id);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submaintab_");
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.setStatusValue(2);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showVchTemplate(int rowIndex) {
        IDataModel model = this.getModel();
        long vchid = (Long)model.getValue(VCHID, rowIndex);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ai_vchtemplateedit");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submaintab_");
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.setCustomParam("status", (Object)OperationStatus.VIEW);
        showParameter.setCustomParam("isReport", (Object)"isReport");
        showParameter.setCustomParam("pkvalue", (Object)String.valueOf(vchid));
        this.getView().showForm(showParameter);
    }
}

