/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.ai.VchReturnData;
import kd.fi.ai.VchTplAcccounts;
import kd.fi.ai.VchTplAccount;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.cache.CacheBuildTree;
import kd.fi.ai.formplugin.service.AccountMapTypeService;
import kd.fi.ai.function.DapFunctionTypes;
import kd.fi.ai.util.BuildTree;
import kd.fi.ai.util.EntityFieldUtil;

public class VchAccountSetEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public static final String FormId_VchDcSet = "ai_accountset";
    public static final String CacheKey_VchAcctJson = "vchacctset";
    private static String Key_VchGrpEntry = "vchgrpentry";
    private static String Key_Accout = "account";
    private static String Key_AccoutNumber = "accountnumber";
    private static String Key_FFilterDescription = "ffilterdescription";
    private static String Key_FFilter = "ffilter";
    private static String Key_btnOK = "btnok";
    private static String Key_btnCancel = "btncancel";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel, Key_FFilterDescription});
        BasedataEdit accttableEdit = (BasedataEdit)this.getControl(Key_Accout);
        accttableEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        CacheBuildTree.setPageCacheByType((FormShowParameter)this.getView().getFormShowParameter(), (IPageCache)this.getPageCache());
        Long accttableid = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("accttableid").toString());
        Long orgid = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("orgid").toString());
        boolean isHandInput = Boolean.parseBoolean((String)this.getView().getFormShowParameter().getCustomParam("handinput"));
        if (!isHandInput) {
            this.setAccountFilter(accttableid, orgid);
        }
        this.getView().setVisible(Boolean.valueOf(isHandInput), new String[]{Key_AccoutNumber});
        this.getView().setVisible(Boolean.valueOf(!isHandInput), new String[]{Key_Accout});
        String str = (String)this.getView().getFormShowParameter().getCustomParam(CacheKey_VchAcctJson);
        if (!StringUtils.isEmpty((CharSequence)str)) {
            VchTplAcccounts vchTplAcccounts = (VchTplAcccounts)SerializationUtils.fromJsonString((String)str, VchTplAcccounts.class);
            this.setVchGroupSet(vchTplAcccounts, isHandInput);
        }
    }

    private void setAccountFilter(Long accttableid, Long orgid) {
        QFilter qFilter = new QFilter("accounttable", "=", (Object)accttableid);
        qFilter = qFilter.and(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
        qFilter = qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgid));
        BasedataEdit acct = (BasedataEdit)this.getControl("account");
        acct.setQFilter(qFilter);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (Key_btnOK.equalsIgnoreCase(ctlSource.getKey())) {
            VchTplAcccounts vchTplAcccounts = this.getVchGroupSet();
            if (vchTplAcccounts != null) {
                String cacheValue;
                String entitynumber;
                String currentFormId = (String)this.getView().getFormShowParameter().getCustomParam("ai_button_key");
                VchReturnData returnData = EntityFieldUtil.validateDiffEntry((Object)vchTplAcccounts, (String)currentFormId, (String)(entitynumber = (String)this.getView().getFormShowParameter().getCustomParam("billEntityNumber")), (String)(cacheValue = EntityFieldUtil.getCacheValueFromFormParameter((IFormView)this.getView())));
                if (returnData.isStatus()) {
                    this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)returnData));
                    this.getView().close();
                } else if (!returnData.isStatus() && StringUtils.isNotEmpty((CharSequence)returnData.getMessage())) {
                    this.getView().showTipNotification(returnData.getMessage());
                }
            }
        } else if (Key_btnCancel.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        } else if (Key_FFilterDescription.equalsIgnoreCase(ctlSource.getKey())) {
            this.showConditionForm();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (Key_FFilterDescription.equalsIgnoreCase(actionId) && closedCallBackEvent.getReturnData() != null) {
            String returnStr = (String)closedCallBackEvent.getReturnData();
            VchReturnData retData = (VchReturnData)SerializationUtils.fromJsonString((String)returnStr, VchReturnData.class);
            this.receiveFilter(retData.getDataStr());
        }
    }

    private void setVchGroupSet(VchTplAcccounts vchTplAcccounts, boolean isHandInput) {
        int rowCount = this.getModel().getEntryRowCount(Key_VchGrpEntry);
        if (rowCount < vchTplAcccounts.getItems().size()) {
            this.getModel().batchCreateNewEntryRow(Key_VchGrpEntry, vchTplAcccounts.getItems().size() - rowCount);
        }
        MainEntityType mainEntityType = this.getMainEntityType();
        for (int i = 0; i < vchTplAcccounts.getItems().size(); ++i) {
            VchTplAccount vchTplAccount = (VchTplAccount)vchTplAcccounts.getItems().get(i);
            VchTplExpression filterObj = vchTplAccount.getFilterSet();
            if (isHandInput) {
                this.getModel().setValue(Key_AccoutNumber, (Object)vchTplAccount.getAccountNumber(), i);
            } else {
                this.getModel().setValue(Key_Accout, (Object)vchTplAccount.getAccountid(), i);
            }
            this.getModel().setValue(Key_FFilter, (Object)SerializationUtils.toJsonString((Object)filterObj), i);
            String dsp = BuildTree.multiLangDesc((String)filterObj.getDescription().toString(), (String)filterObj.getExprTran(), () -> BuildTree.tranVchTplFormula((CRCondition)filterObj, (MainEntityType)mainEntityType));
            if (StringUtils.isBlank((CharSequence)dsp)) {
                dsp = filterObj.getExprTran();
            }
            this.getModel().setValue(Key_FFilterDescription, (Object)dsp, i);
        }
    }

    private VchTplAcccounts getVchGroupSet() {
        VchTplAcccounts vchTplAccounts = new VchTplAcccounts();
        boolean isHandInput = Boolean.parseBoolean((String)this.getView().getFormShowParameter().getCustomParam("handinput"));
        int rowCount = this.getModel().getEntryRowCount(Key_VchGrpEntry);
        for (int row = 0; row < rowCount; ++row) {
            VchTplAccount vchTplAccount = new VchTplAccount();
            String filter = (String)this.getModel().getValue(Key_FFilter, row);
            if (!StringUtils.isBlank((CharSequence)filter)) {
                VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)filter, VchTplExpression.class);
                vchTplAccount.setFilterSet(filterObj);
            }
            if (isHandInput) {
                String accountNumber = this.getModel().getValue(Key_AccoutNumber, row) + "";
                if (StringUtils.isEmpty((CharSequence)accountNumber)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u7b2c\u201c%s\u201d\u884c\u8f93\u5165\u79d1\u76ee\u7f16\u7801\u3002", (String)"VchAccountSetEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]), row + 1 + ""));
                    return null;
                }
                QFilter numberFilter = new QFilter("number", "=", (Object)accountNumber);
                Long orgId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("orgid") + "");
                numberFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId));
                numberFilter.and(new QFilter("enable", "=", (Object)1));
                DynamicObject dyn = QueryServiceHelper.queryOne((String)"bd_accountview", (String)"id,name,number,isleaf,fullname", (QFilter[])numberFilter.toArray());
                if (dyn == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u4e0d\u5b58\u5728\u6b64\u79d1\u76ee\u7f16\u7801\u3002", (String)"VchAccountSetEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return null;
                }
                if (!"true".equals(dyn.getString("isleaf"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u7f16\u7801\u4e3a\u975e\u660e\u7ec6\u79d1\u76ee\u7f16\u7801\u3002", (String)"VchAccountSetEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return null;
                }
                vchTplAccount.setAccountNumber(accountNumber);
                vchTplAccount.setAcctName(dyn.getString("fullname"));
            } else if (this.getModel().getValue(Key_Accout, row) != null) {
                Long accountid = ((DynamicObject)this.getModel().getValue(Key_Accout, row)).getLong("id");
                vchTplAccount.setAccountid(accountid.longValue());
                String accountName = ((DynamicObject)this.getModel().getValue(Key_Accout, row)).getString("fullname");
                vchTplAccount.setAcctName(accountName);
                String accountNumber = ((DynamicObject)this.getModel().getValue(Key_Accout, row)).getString("number");
                vchTplAccount.setAccountNumber(accountNumber);
            }
            vchTplAccounts.getItems().add(vchTplAccount);
        }
        return vchTplAccounts;
    }

    private void showConditionForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ai_condition");
        int row = this.getModel().getEntryCurrentRowIndex(Key_VchGrpEntry);
        String conditionJson = (String)this.getModel().getValue(Key_FFilter, row);
        showParameter.getCustomParams().put("formula", conditionJson);
        boolean isEvent = (Boolean)this.getView().getFormShowParameter().getCustomParam("isevent");
        showParameter.getCustomParams().put("isevent", isEvent);
        showParameter.getCustomParams().put("entitynumber", this.getView().getFormShowParameter().getCustomParam("billEntityNumber"));
        showParameter.getCustomParams().put("treenodes", this.getView().getFormShowParameter().getCustomParam("treenodes"));
        showParameter.setCustomParam("ai_button_key", this.getView().getFormShowParameter().getCustomParam("ai_button_key"));
        showParameter.setCustomParam("ai_vchtemplatecachekey", this.getView().getFormShowParameter().getCustomParam("ai_vchtemplatecachekey"));
        String funcsXML = this.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = DapFunctionTypes.get((String)(isEvent ? "event" : "type"));
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        CacheBuildTree.setBuildByType((FormShowParameter)showParameter, (IPageCache)this.getPageCache());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, Key_FFilterDescription));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveFilter(String filterJson) {
        int row = this.getModel().getEntryCurrentRowIndex(Key_VchGrpEntry);
        if (StringUtils.isBlank((CharSequence)filterJson)) {
            this.getModel().setValue(Key_FFilter, (Object)"", row);
            this.getModel().setValue(Key_FFilterDescription, (Object)"", row);
        } else {
            VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)filterJson, VchTplExpression.class);
            this.getModel().setValue(Key_FFilter, (Object)filterJson, row);
            String dsp = filterObj.getDescription().toString();
            if (StringUtils.isBlank((CharSequence)dsp)) {
                dsp = filterObj.getExprTran();
            }
            this.getModel().setValue(Key_FFilterDescription, (Object)dsp, row);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        Object source = arg0.getSource();
        Control sourceCtl = (Control)source;
        String key = sourceCtl.getKey();
        if (key != null && key.startsWith(Key_Accout)) {
            ListShowParameter param = (ListShowParameter)arg0.getFormShowParameter();
            AccountMapTypeService typeService = new AccountMapTypeService();
            param.getTreeFilterParameter().getQFilters().add(new QFilter("accounttype", "not in", typeService.getAccountType()));
            Long acctTableId = Long.parseLong(this.getView().getFormShowParameter().getCustomParam("accttableid").toString());
            List customQFilters = arg0.getCustomQFilters();
            customQFilters.add(new QFilter("accounttype", "in", typeService.getAccountTypeIds(acctTableId)));
        }
    }

    private MainEntityType getMainEntityType() {
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam("billEntityNumber");
        Boolean isEvent = (Boolean)this.getView().getFormShowParameter().getCustomParam("isevent");
        return BuildTree.getMainEntityType((String)sourceBill, (boolean)(isEvent != null ? isEvent : false));
    }
}

