/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.VchReturnData;
import kd.fi.ai.VchSingleFlexMapping;
import kd.fi.ai.VchTplAcccounts;
import kd.fi.ai.VchTplAccount;
import kd.fi.ai.VchTplAcctFactorMap;
import kd.fi.ai.VchTplAccts;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.cache.CacheBuildTree;
import kd.fi.ai.formplugin.FactorInfo;
import kd.fi.ai.function.DapFunctionTypes;
import kd.fi.ai.util.AiEventMetaUtil;
import kd.fi.ai.util.BuildTree;
import kd.fi.ai.util.DapBuildVoucherCommonUtil;
import kd.fi.ai.util.DapUtil;
import kd.fi.ai.util.EntityFieldTreeOption;
import kd.fi.ai.util.EntityFieldTreeResult;
import kd.fi.ai.util.EntityFieldUtil;
import kd.fi.ai.util.EntityTreeUtil;
import kd.fi.ai.util.FlexMappingCommonUtil;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.dao.sys.SysBasePropDataDaoImpl;
import kd.fi.v2.fah.models.flex.FlexFieldCfg;
import kd.fi.v2.fah.utils.FahEntityMetaHelper;

public class VchAcctEdit
extends AbstractFormPlugin {
    private static final String Key_FFactorName = "ffactorname";
    private static final String Key_FFactorSource = "ffactorsource";
    private static final String Key_FFactorKey = "ffactorkey";
    private static final String Key_FactorEntity = "factorentity";
    private static final String Key_Accountset = "ai_accountset";
    private static final String ACCOUNT = "account";
    private static final String ACCOUNTNUMBER = "accountnumber";
    public static final String HANDINPUT = "handinput";
    public static final String CacheKey_acctsJson = "vchaccounts";
    public static final String CacheKey_acctJson = "vchaccount";
    public static final String CacheKey_OrgID = "orgid";
    private static final String MAPPING_MAP = "MappingMap";
    private static final String FieldMapData_MAP = "FieldMapData";
    private static final String DEST_SET = "DestSet";
    private static final String Key_FieldMapping = "fieldmapping";
    private static final String Key_btnOK = "btnok";
    private static final String Key_btnCancel = "btncancel";
    private static final String EXP = "expval";
    private static final String EXP_DESC = "expdesc";
    private static final String EXPCON_DESC = "expcondesc";
    private static final String ENTITY_EXP = "expvalentity";
    private static final String ENTITY_EXP_DESC = "expdescentity";
    private static final String Flex_Mapping_Entry = "flexmappingentry";
    private static final String Flex_MappingType = "mappingtype";
    private static final String Flex_MappingName = "mappingname";
    private static final String Flex_MappingIsmustInput = "ismustinput";
    private static final String Flex_MappingSourcefield = "sourcefield";
    private static final String Flex_MappingExpstr = "mappingexpstr";
    private static final String Flex_MappingExp = "mappingexp";
    private static final String Flex_CommonMapping = "accountcommonmap";
    private static final String NON_FIELDS = "nonFields";
    private String sourceBill;
    private Map<String, String> sourceTypeMap = new HashMap<String, String>();
    private Log logger = LogFactory.getLog(VchAcctEdit.class);
    static final String MUTEX_DATAOBJID = "dataObjId";
    static final String MUTEX_GROUPID = "groupId";
    static final String MUTEX_ENTITYKEY = "entityKey";
    static final String MUTEX_OPERATIONKEY = "operationKey";
    static final String MUTEX_ISSTRICT = "isStrict";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{EXP_DESC, ENTITY_EXP_DESC, EXPCON_DESC, Flex_MappingExpstr});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel});
    }

    public void afterCreateNewData(EventObject e) {
        Object accttableidObj;
        Object orgIdObj;
        super.afterCreateNewData(e);
        this.loadMappingData();
        Object booktypeObj = this.getView().getFormShowParameter().getCustomParam("booktypeid");
        if (booktypeObj != null) {
            this.getPageCache().put("booktypeid", String.valueOf(booktypeObj));
        }
        if ((orgIdObj = this.getView().getFormShowParameter().getCustomParam(CacheKey_OrgID)) != null) {
            Long orgid = Long.parseLong(orgIdObj.toString());
            this.getModel().setValue("org", (Object)orgid);
        }
        if (null != (accttableidObj = this.getView().getFormShowParameter().getCustomParam("accttableid"))) {
            Long accttableid = Long.parseLong(accttableidObj.toString());
            Long orgid = null;
            if (orgIdObj != null) {
                orgid = Long.parseLong(orgIdObj.toString());
            }
            this.changeAccountFiler(accttableid, orgid);
            String booktypeidstr = this.getView().getFormShowParameter().getCustomParam("booktypeid").toString();
            this.sourceBill = (String)this.getView().getFormShowParameter().getCustomParam("sourcebill");
            this.changeAccountMapFiler(accttableid, orgid, Long.parseLong(booktypeidstr));
        }
        String accttableidtr = accttableidObj == null ? "0" : accttableidObj.toString();
        boolean isHandInput = Long.parseLong(accttableidtr) == 0L;
        this.getPageCache().put(HANDINPUT, String.valueOf(isHandInput));
        this.getView().setVisible(Boolean.valueOf(isHandInput), new String[]{ACCOUNTNUMBER});
        this.getView().setVisible(Boolean.valueOf(!isHandInput), new String[]{ACCOUNT});
        String str = (String)this.getView().getFormShowParameter().getCustomParam(CacheKey_acctsJson);
        if (StringUtils.isNotBlank((CharSequence)str)) {
            VchTplAccts vchTempAccts = (VchTplAccts)SerializationUtils.fromJsonString((String)str, VchTplAccts.class);
            this.getPageCache().put(CacheKey_acctsJson, str);
            if ("fix".equals(vchTempAccts.getSourcetype())) {
                vchTempAccts = this.transObj(vchTempAccts);
            }
            this.setVchTempAccts(vchTempAccts);
        } else {
            this.acctTypeChange("conditionexp", isHandInput);
        }
        CacheBuildTree.setPageCache((FormShowParameter)this.getView().getFormShowParameter(), (IPageCache)this.getPageCache());
    }

    private VchTplAccts transObj(VchTplAccts vchTempAccts) {
        VchTplAccts vchTplAccts = new VchTplAccts();
        vchTplAccts.setAcctName(vchTempAccts.getAcctName());
        vchTplAccts.setHandinput("0");
        vchTplAccts.setSourcetype("conditionexp");
        VchTplAcccounts vchTplAcccounts = new VchTplAcccounts();
        VchTplAccount vchTplAccount = new VchTplAccount();
        vchTplAccount.setAccountid(vchTempAccts.getConstid());
        vchTplAccount.setAcctName(vchTempAccts.getAcctName());
        ArrayList<VchTplAccount> items = new ArrayList<VchTplAccount>();
        items.add(vchTplAccount);
        vchTplAcccounts.setItems(items);
        vchTplAccts.setVchTplAcccounts(vchTplAcccounts);
        return vchTplAccts;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam("sourcebill");
        if (StringUtils.isNotBlank((CharSequence)sourceBill)) {
            MainEntityType srcMainEntityType = this.getMainEntityType();
            this.fillAcctItemExprFields(srcMainEntityType);
        }
        this.fillSourceFields();
    }

    private void fillAcctItemExprFields(MainEntityType srcMainET) {
        if (srcMainET == null) {
            this.getPageCache().put(EXP_DESC, "");
        } else {
            EntityFieldTreeOption option = EntityFieldTreeOption.create();
            option.setEntityType((IDataEntityType)srcMainET);
            option.setReadEntryEntity(true);
            option.setExprType(ExpressionType.Formula);
            option.setIncludeID(true);
            EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
            this.getPageCache().put(NON_FIELDS, SerializationUtils.toJsonString((Object)result.getNonFields()));
            TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
            String toJson = SerializationUtils.toJsonString((Object)tree);
            this.getPageCache().put(EXP_DESC, toJson);
        }
    }

    private void changeAccountMapFiler(Long accttableid, Long orgid, long bookTypeId) {
        DynamicObject[] maps;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (accttableid != 0L) {
            QFilter b = new QFilter("mulaccttable.fbasedataid", "=", (Object)accttableid);
            qFilters.add(b);
        }
        HashSet<Long> pks = new HashSet<Long>();
        block0: for (DynamicObject map : maps = SysBasePropDataDaoImpl.queryBaseDataObjects((String)"ai_accountmaptype", (Long)orgid, (String)"id,billtypes", (QFilter[])qFilters.toArray(new QFilter[0]))) {
            DynamicObjectCollection billtypes = map.getDynamicObjectCollection("billtypes");
            if (billtypes.size() == 0) {
                pks.add(map.getLong("id"));
                continue;
            }
            for (DynamicObject billtype : billtypes) {
                String billtypeid = billtype.getString("fbasedataid_id");
                this.sourceBill = (String)this.getView().getFormShowParameter().getCustomParam("sourcebill");
                if (!this.sourceBill.equalsIgnoreCase(billtypeid)) continue;
                pks.add(map.getLong("id"));
                continue block0;
            }
        }
        BasedataEdit acct = (BasedataEdit)this.getControl("accountmap");
        acct.setQFilter(new QFilter("id", "in", pks));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (ctlSource.getKey().equalsIgnoreCase(Key_btnOK)) {
            String cacheValue;
            String entitynumber;
            String message = this.validateVchTempAccts();
            if (message != null && message.trim().length() > 0) {
                this.getView().showErrorNotification(message);
                return;
            }
            VchTplAccts vchTempAccts = this.getVchTempAccts();
            if (vchTempAccts == null) {
                return;
            }
            String currentFormId = (String)this.getView().getFormShowParameter().getCustomParam("ai_button_key");
            VchReturnData returnData = EntityFieldUtil.validateDiffEntry((Object)vchTempAccts, (String)currentFormId, (String)(entitynumber = (String)this.getView().getFormShowParameter().getCustomParam("sourcebill")), (String)(cacheValue = EntityFieldUtil.getCacheValueFromFormParameter((IFormView)this.getView())));
            if (returnData.isStatus()) {
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)returnData));
                this.getView().close();
            } else if (!returnData.isStatus() && StringUtils.isNotEmpty((CharSequence)returnData.getMessage())) {
                this.getView().showTipNotification(returnData.getMessage());
            }
        } else if (ctlSource.getKey().equalsIgnoreCase(Key_btnCancel)) {
            this.getView().close();
        } else if (ctlSource.getKey().equalsIgnoreCase(EXP_DESC)) {
            this.showFormulaForm(EXP, EXP_DESC);
        } else if (ctlSource.getKey().equalsIgnoreCase(ENTITY_EXP_DESC)) {
            this.showFormulaForm(ENTITY_EXP, ENTITY_EXP_DESC);
        } else if (ctlSource.getKey().equalsIgnoreCase(EXPCON_DESC)) {
            this.showVchAccout(EXPCON_DESC);
        } else if (ctlSource.getKey().equalsIgnoreCase(Flex_MappingExpstr)) {
            this.showFormulaForm(Flex_MappingExp, Flex_MappingExpstr);
        }
    }

    private void showVchAccout(String expconDesc) {
        VchTplAccts vchTempAccts;
        FormShowParameter showParameter = this.getFormShowParameter();
        showParameter.setFormId(Key_Accountset);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String vchAcctJson = this.getPageCache().get(CacheKey_acctJson);
        String acctExp = "";
        if (!StringUtils.isEmpty((CharSequence)vchAcctJson)) {
            acctExp = vchAcctJson;
        } else if (!StringUtils.isBlank((CharSequence)vchAcctJson) && (vchTempAccts = (VchTplAccts)SerializationUtils.fromJsonString((String)vchAcctJson, VchTplAccts.class)) != null) {
            VchTplAcccounts vchTplAcccounts = vchTempAccts.getVchTplAcccounts();
            acctExp = SerializationUtils.toJsonString((Object)vchTplAcccounts);
        }
        showParameter.setCustomParam("accttableid", this.getView().getFormShowParameter().getCustomParam("accttableid"));
        showParameter.setCustomParam(CacheKey_OrgID, this.getView().getFormShowParameter().getCustomParam(CacheKey_OrgID));
        showParameter.setCustomParam("vchacctset", (Object)acctExp);
        CacheBuildTree.setBuild((FormShowParameter)showParameter, (IPageCache)this.getPageCache());
        showParameter.setCustomParam(HANDINPUT, (Object)this.getPageCache().get(HANDINPUT));
        showParameter.setCustomParam("ai_button_key", this.getView().getFormShowParameter().getCustomParam("ai_button_key"));
        showParameter.setCustomParam("ai_vchtemplatecachekey", this.getView().getFormShowParameter().getCustomParam("ai_vchtemplatecachekey"));
        showParameter.getCustomParams().put("treenodes", this.getView().getFormShowParameter().getCustomParam("treenodes"));
        showParameter.getCustomParams().put("accttablelist", this.getView().getFormShowParameter().getCustomParam("accttablelist"));
        showParameter.getCustomParams().put(HANDINPUT, this.getPageCache().get(HANDINPUT));
        showParameter.getCustomParams().put("isevent", this.getView().getFormShowParameter().getCustomParam("isevent"));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, expconDesc);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private FormShowParameter getFormShowParameter() {
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam("sourcebill");
        if (StringUtils.isBlank((CharSequence)sourceBill)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6765\u6e90\u5355\u636e\u3002", (String)"VchAcctEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("billEntityNumber", (Object)sourceBill);
        showParameter.setCustomParam("entitynumber", (Object)sourceBill);
        showParameter.setCustomParam("sourcebill", (Object)sourceBill);
        return showParameter;
    }

    private void showFormulaForm(String exp, String expdesc) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ai_formula");
        String expression = (String)this.getModel().getValue(exp);
        String descFldValue = (String)this.getModel().getValue(expdesc);
        VchTplExpression exprObj = new VchTplExpression();
        exprObj.setExprType(ExpressionType.Formula);
        exprObj.setExpression(expression);
        LocaleString description = new LocaleString();
        description.put(Lang.defaultLang().toString(), (Object)descFldValue);
        exprObj.setDescription(description);
        String formulaJson = SerializationUtils.toJsonString((Object)exprObj);
        showParameter.setCustomParam("ai_vchtemplatecachekey", (Object)EntityFieldUtil.getCacheValueFromFormParameter((IFormView)this.getView()));
        showParameter.setCustomParam("ai_button_key", (Object)"ai_vchacct-faccountdesc");
        showParameter.getCustomParams().put("formula", formulaJson);
        CacheBuildTree.setBuild((FormShowParameter)showParameter, (IPageCache)this.getPageCache());
        this.sourceBill = (String)this.getView().getFormShowParameter().getCustomParam("sourcebill");
        showParameter.getCustomParams().put("entitynumber", this.sourceBill);
        boolean isEvent = (Boolean)this.getView().getFormShowParameter().getCustomParam("isevent");
        String funcsXML = this.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = DapFunctionTypes.get((String)(isEvent ? "event" : "type"));
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, expdesc));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (EXP_DESC.equalsIgnoreCase(actionId)) {
            this.receiveExpressionSet(closedCallBackEvent);
        } else if (ENTITY_EXP_DESC.equalsIgnoreCase(actionId)) {
            this.receiveEntryExpressionSet(closedCallBackEvent);
        } else if (EXPCON_DESC.equalsIgnoreCase(actionId)) {
            this.receiveAcctExpressionSet(closedCallBackEvent);
        } else if (Flex_MappingExpstr.equalsIgnoreCase(actionId)) {
            this.receiveEntryCommonExpressionSet(closedCallBackEvent);
        }
    }

    private void receiveAcctExpressionSet(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() != null) {
            String str = (String)closedCallBackEvent.getReturnData();
            if (StringUtils.isBlank((CharSequence)str)) {
                this.getModel().setValue(EXPCON_DESC, (Object)"");
            } else {
                VchReturnData retData = (VchReturnData)SerializationUtils.fromJsonString((String)str, VchReturnData.class);
                VchTplAcccounts vchTplAcccounts = (VchTplAcccounts)SerializationUtils.fromJsonString((String)retData.getDataStr(), VchTplAcccounts.class);
                this.getPageCache().put(CacheKey_acctJson, retData.getDataStr());
                if (vchTplAcccounts.getItems().size() == 0) {
                    this.getModel().setValue(EXPCON_DESC, (Object)"");
                } else {
                    StringBuilder sBuilder = new StringBuilder();
                    int i = 0;
                    for (VchTplAccount vchTplAccount : vchTplAcccounts.getItems()) {
                        if (StringUtils.isEmpty((CharSequence)vchTplAccount.getAcctName())) continue;
                        if (i > 0) {
                            sBuilder.append('/');
                        }
                        sBuilder.append(vchTplAccount.getAccountNumber()).append(vchTplAccount.getAcctName());
                        ++i;
                    }
                    this.getModel().setValue(EXPCON_DESC, (Object)sBuilder.toString());
                    this.getModel().setValue(EXP, (Object)str);
                }
            }
        }
    }

    private void receiveExpressionSet(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() != null) {
            String str = (String)closedCallBackEvent.getReturnData();
            if (StringUtils.isBlank((CharSequence)str)) {
                this.getModel().setValue(EXP, (Object)"");
                this.getModel().setValue(EXP_DESC, (Object)"");
            } else {
                VchReturnData retData = (VchReturnData)SerializationUtils.fromJsonString((String)str, VchReturnData.class);
                VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)retData.getDataStr(), VchTplExpression.class);
                this.getModel().setValue(EXP, (Object)filterObj.getExpression());
                String desp = filterObj.getDescription().toString();
                if (StringUtils.isEmpty((CharSequence)desp)) {
                    desp = filterObj.getExprTran();
                }
                this.getModel().setValue(EXP_DESC, (Object)desp);
            }
        }
    }

    private void receiveEntryExpressionSet(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() != null) {
            IDataModel model = this.getModel();
            int index = model.getEntryCurrentRowIndex(Key_FactorEntity);
            String returnStr = (String)closedCallBackEvent.getReturnData();
            if (StringUtils.isBlank((CharSequence)returnStr)) {
                model.setValue(ENTITY_EXP, (Object)"", index);
                model.setValue(ENTITY_EXP_DESC, (Object)"", index);
            } else {
                VchReturnData retData = (VchReturnData)SerializationUtils.fromJsonString((String)returnStr, VchReturnData.class);
                VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)retData.getDataStr(), VchTplExpression.class);
                model.setValue(ENTITY_EXP, (Object)filterObj.getExpression(), index);
                String desp = filterObj.getDescription().toString();
                if (StringUtils.isEmpty((CharSequence)desp)) {
                    desp = filterObj.getExprTran();
                }
                this.getModel().setValue(ENTITY_EXP_DESC, (Object)desp, index);
            }
        }
    }

    private void receiveEntryCommonExpressionSet(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() != null) {
            IDataModel model = this.getModel();
            int index = model.getEntryCurrentRowIndex(Flex_Mapping_Entry);
            String returnStr = (String)closedCallBackEvent.getReturnData();
            if (StringUtils.isBlank((CharSequence)returnStr)) {
                model.setValue(Flex_MappingExp, (Object)"", index);
                model.setValue(Flex_MappingExpstr, (Object)"", index);
            } else {
                VchReturnData retData = (VchReturnData)SerializationUtils.fromJsonString((String)returnStr, VchReturnData.class);
                VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)retData.getDataStr(), VchTplExpression.class);
                model.setValue(Flex_MappingExp, (Object)filterObj.getExpression(), index);
                String desp = filterObj.getDescription().toString();
                if (StringUtils.isEmpty((CharSequence)desp)) {
                    desp = filterObj.getExprTran();
                }
                this.getModel().setValue(Flex_MappingExpstr, (Object)desp, index);
            }
        }
    }

    private String validateVchTempAccts() {
        int rowCount = this.getModel().getEntryRowCount(Key_FactorEntity);
        for (int row = 0; row < rowCount; ++row) {
            String factorKey = (String)this.getModel().getValue(Key_FFactorKey, row);
            String factorSource = (String)this.getModel().getValue(Key_FFactorSource, row);
            String entityexpdesc = (String)this.getModel().getValue(ENTITY_EXP_DESC, row);
            if (!StringUtils.isNotBlank((CharSequence)factorKey) || !StringUtils.isBlank((CharSequence)factorSource) || !StringUtils.isBlank((CharSequence)entityexpdesc)) continue;
            return ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u79d1\u76ee\u5f71\u54cd\u56e0\u7d20\u6765\u6e90\uff0c\u79d1\u76ee\u5f71\u54cd\u56e0\u7d20\u7684\u6765\u6e90\u5b57\u6bb5\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"VchAcctEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]);
        }
        return this.checkFlexmappingEntry();
    }

    private void setVchTempAccts(VchTplAccts vchTempAccts) {
        IDataModel model = this.getModel();
        String sourceType = vchTempAccts.getSourcetype();
        if (sourceType == null) {
            sourceType = "conditionexp";
        }
        model.setValue("sourcetype", (Object)sourceType);
        boolean isHandInput = "1".equals(vchTempAccts.getHandinput());
        this.acctTypeChange(sourceType, isHandInput);
        if ("fix".equalsIgnoreCase(sourceType)) {
            if (isHandInput) {
                model.setValue(ACCOUNTNUMBER, (Object)vchTempAccts.getAcctNumber());
            } else {
                model.setValue(ACCOUNT, (Object)vchTempAccts.getConstid());
            }
        } else if ("exp".equalsIgnoreCase(sourceType)) {
            model.setValue(EXP, (Object)vchTempAccts.getExp());
            if (StringUtils.isEmpty((CharSequence)vchTempAccts.getAcctName())) {
                String expDesc = BuildTree.tranExpression((String)vchTempAccts.getExp(), (MainEntityType)this.getMainEntityType());
                model.setValue(EXP_DESC, (Object)expDesc);
            } else {
                model.setValue(EXP_DESC, (Object)vchTempAccts.getAcctName());
            }
        } else if ("mapping".equalsIgnoreCase(sourceType) && vchTempAccts.getMappingid() != 0L) {
            model.setValue("accountmap", (Object)vchTempAccts.getMappingid());
            HashMap<Object, FactorInfo> factorList = new HashMap<Object, FactorInfo>();
            String destSetStr = this.getPageCache().get(DEST_SET);
            Set destSet = (Set)SerializationUtils.fromJsonString((String)destSetStr, HashSet.class);
            DynamicObject acctMapping = BusinessDataServiceHelper.loadSingle((Object)vchTempAccts.getMappingid(), (String)"ai_accountmaptype");
            int row = 0;
            for (DynamicObject mapEntry : acctMapping.getDynamicObjectCollection("fieldmapentry")) {
                String entityID = mapEntry.getString("entityid");
                if (factorList.containsKey(entityID)) continue;
                FactorInfo factorInfo = new FactorInfo();
                factorInfo.setSrcEntityNumber(entityID);
                factorInfo.setSrcEntityName(mapEntry.getString("fieldname"));
                if (destSet.contains(entityID)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{Key_FieldMapping});
                }
                factorList.put(entityID, factorInfo);
            }
            int rowCount = model.getEntryRowCount(Key_FactorEntity);
            if (rowCount < factorList.size()) {
                model.batchCreateNewEntryRow(Key_FactorEntity, factorList.size() - rowCount);
            }
            HashMap<String, VchTplAcctFactorMap> factorMap = new HashMap<String, VchTplAcctFactorMap>(vchTempAccts.getFactorMaps().size());
            for (VchTplAcctFactorMap item : vchTempAccts.getFactorMaps()) {
                factorMap.put(item.getFactor(), item);
            }
            row = 0;
            Set asstFactorNums = factorList.values().stream().map(o -> o.getSrcEntityNumber()).collect(Collectors.toSet());
            Map nameMap = FahEntityMetaHelper.batchGetFactorNameMap(asstFactorNums);
            for (Map.Entry entry : factorList.entrySet()) {
                String factorKey = ((FactorInfo)entry.getValue()).getSrcEntityNumber();
                model.setValue(Key_FFactorKey, (Object)((FactorInfo)entry.getValue()).getSrcEntityNumber(), row);
                model.setValue(Key_FFactorName, nameMap.get(((FactorInfo)entry.getValue()).getSrcEntityNumber()), row);
                if (factorMap.containsKey(factorKey)) {
                    VchTplAcctFactorMap vchmapping = (VchTplAcctFactorMap)factorMap.get(factorKey);
                    if (vchmapping.isField() || StringUtils.isNotBlank((CharSequence)vchmapping.getSourceFieldKey())) {
                        model.setValue(Key_FFactorSource, (Object)vchmapping.getSourceFieldKey(), row);
                    }
                    model.setValue(Key_FieldMapping, (Object)vchmapping.getMapping(), row);
                    model.setValue(ENTITY_EXP, (Object)vchmapping.getExpvalentity(), row);
                    if (StringUtils.isEmpty((CharSequence)vchmapping.getExpdescentity())) {
                        String expDesc = BuildTree.tranExpression((String)vchmapping.getExpvalentity(), (MainEntityType)this.getMainEntityType());
                        model.setValue(ENTITY_EXP_DESC, (Object)expDesc, row);
                    } else {
                        model.setValue(ENTITY_EXP_DESC, (Object)vchmapping.getExpdescentity(), row);
                    }
                } else if (destSet.contains(((FactorInfo)entry.getValue()).getSrcEntityNumber())) {
                    String fieldMapDataStr = this.getPageCache().get(FieldMapData_MAP);
                    Map fieldMapData = (Map)SerializationUtils.fromJsonString((String)fieldMapDataStr, HashMap.class);
                    model.setValue(Key_FieldMapping, fieldMapData.get(((FactorInfo)entry.getValue()).getSrcEntityNumber()), row);
                }
                ++row;
            }
        } else if ("conditionexp".equalsIgnoreCase(sourceType)) {
            VchTplAcccounts vchTplAcccounts = vchTempAccts.getVchTplAcccounts();
            if (vchTplAcccounts != null) {
                this.getModel().setValue(EXPCON_DESC, (Object)vchTempAccts.getAcctName());
                FormShowParameter showParameter = this.getFormShowParameter();
                showParameter.setFormId(Key_Accountset);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                String vchTplAcccountsStr = SerializationUtils.toJsonString((Object)vchTplAcccounts);
                showParameter.setCustomParam("vchacctset", (Object)vchTplAcccountsStr);
                this.getPageCache().put(CacheKey_acctJson, vchTplAcccountsStr);
                showParameter.setCustomParam(NON_FIELDS, (Object)this.getPageCache().get(NON_FIELDS));
                showParameter.getCustomParams().put("treenodes", this.getView().getFormShowParameter().getCustomParam("treenodes"));
                showParameter.setCustomParam("accttableid", this.getView().getFormShowParameter().getCustomParam("accttableid"));
                showParameter.setCustomParam(CacheKey_OrgID, this.getView().getFormShowParameter().getCustomParam(CacheKey_OrgID));
                showParameter.getCustomParams().put(HANDINPUT, this.getPageCache().get(HANDINPUT));
                showParameter.getCustomParams().put("accttablelist", this.getView().getFormShowParameter().getCustomParam("accttablelist"));
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, EXPCON_DESC);
                showParameter.setCloseCallBack(closeCallBack);
            }
        } else if ("commonmapping".equalsIgnoreCase(sourceType) && vchTempAccts.getFlexMappingId() != 0L) {
            long commonmappingid = vchTempAccts.getFlexMappingId();
            model.setValue(Flex_CommonMapping, (Object)commonmappingid);
            if (0L != commonmappingid) {
                this.setMainCommonEntryRowData(vchTempAccts);
            }
        }
    }

    private void setMainCommonEntryRowData(VchTplAccts vchTempAccts) {
        boolean exists = QueryServiceHelper.exists((String)"fah_valmap_typenew", (Object)vchTempAccts.getFlexMappingId());
        if (!exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u539f\u6570\u636e\u6620\u5c04\u5173\u7cfb\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u3002", (String)"VchAcctEdit_8", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject fieldMapping = BusinessDataServiceHelper.loadSingle((Object)vchTempAccts.getFlexMappingId(), (String)"fah_valmap_typenew");
        Map<Long, FlexFieldCfg> inputFlexProp = FlexMappingCommonUtil.getInputFlexProp(fieldMapping.getLong("struc.id"));
        List dataCol = vchTempAccts.getFlexMappingItem().getDataCol();
        if (!dataCol.isEmpty()) {
            Map<Long, VchSingleFlexMapping> infoData = dataCol.stream().collect(Collectors.toMap(k -> k.getMappingType(), v -> v));
            this.getModel().deleteEntryData(Flex_Mapping_Entry);
            for (Map.Entry<Long, FlexFieldCfg> data : inputFlexProp.entrySet()) {
                FlexFieldCfg value = data.getValue();
                VchSingleFlexMapping vchSingleFlexMapping = infoData.get(value.getId());
                int factorRow = this.getModel().createNewEntryRow(Flex_Mapping_Entry);
                this.getModel().setValue(Flex_MappingType, value.getId(), factorRow);
                this.getModel().setValue(Flex_MappingName, (Object)value.getName(), factorRow);
                if (vchSingleFlexMapping == null) {
                    this.logger.info("--DAP--errorsetMainCommonEntryRowData:---id:" + value.getId());
                    continue;
                }
                this.getModel().setValue(Flex_MappingIsmustInput, (Object)vchSingleFlexMapping.isIsmustInput(), factorRow);
                this.getModel().setValue(Flex_MappingSourcefield, (Object)vchSingleFlexMapping.getSourceField(), factorRow);
                this.getModel().setValue(Flex_MappingExp, (Object)vchSingleFlexMapping.getMappingexp(), factorRow);
                if (StringUtils.isEmpty((CharSequence)vchSingleFlexMapping.getMappingexpstr())) {
                    String expDesc = BuildTree.tranExpression((String)vchSingleFlexMapping.getMappingexp(), (MainEntityType)this.getMainEntityType());
                    this.getModel().setValue(Flex_MappingExpstr, (Object)expDesc, factorRow);
                    continue;
                }
                this.getModel().setValue(Flex_MappingExpstr, (Object)vchSingleFlexMapping.getMappingexpstr(), factorRow);
            }
            this.searchFlexComboItem();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private VchTplAccts getVchTempAccts() {
        DynamicObject accountmap;
        VchTplAccts vchTempAccts = new VchTplAccts();
        String sourcetype = (String)this.getModel().getValue("sourcetype");
        vchTempAccts.setSourcetype(sourcetype);
        boolean isHandInput = Boolean.parseBoolean(this.getPageCache().get(HANDINPUT));
        if ("fix".equalsIgnoreCase(sourcetype)) {
            if (!isHandInput) {
                DynamicObject account = (DynamicObject)this.getModel().getValue(ACCOUNT);
                if (account == null) return vchTempAccts;
                vchTempAccts.setConstid(account.getLong("id"));
                vchTempAccts.setAcctName(account.getString("number") + " " + account.getString("name"));
                return vchTempAccts;
            }
            String accoutNumber = this.getModel().getValue(ACCOUNTNUMBER) + "";
            if (StringUtils.isEmpty((CharSequence)accoutNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u79d1\u76ee\u7f16\u7801\u3002", (String)"VchAcctEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return null;
            }
            QFilter filter = new QFilter("number", "=", (Object)accoutNumber);
            Long orgId = (Long)this.getModel().getValue("org_id");
            DynamicObjectCollection dynCollection = SysBasePropDataDaoImpl.queryBaseData((String)"bd_accountview", (Long)orgId, (String)"id,name,number,isleaf", (QFilter[])filter.toArray());
            DynamicObject dyn = null;
            if (dynCollection != null && dynCollection.size() > 0) {
                dyn = (DynamicObject)dynCollection.get(0);
            }
            if (dyn == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u4e0d\u5b58\u5728\u6b64\u79d1\u76ee\u7f16\u7801\u3002", (String)"VchAcctEdit_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return null;
            }
            if (!"true".equals(dyn.getString("isleaf"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u7f16\u7801\u4e3a\u975e\u660e\u7ec6\u79d1\u76ee\u7f16\u7801\u3002", (String)"VchAcctEdit_4", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return null;
            }
            vchTempAccts.setHandinput("1");
            vchTempAccts.setAcctName(dyn.getString("number") + " " + dyn.getString("name"));
            vchTempAccts.setSourcetype(sourcetype);
            vchTempAccts.setAcctNumber(dyn.getString("number"));
            return vchTempAccts;
        }
        if ("mapping".equalsIgnoreCase(sourcetype)) {
            accountmap = (DynamicObject)this.getModel().getValue("accountmap");
            if (accountmap == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u5f71\u54cd\u56e0\u7d20\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"VchAcctEdit_5", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return null;
            }
        } else {
            if ("exp".equalsIgnoreCase(sourcetype)) {
                vchTempAccts.setExp((String)this.getModel().getValue(EXP));
                vchTempAccts.setAcctName((String)this.getModel().getValue(EXP_DESC));
                return vchTempAccts;
            }
            if ("conditionexp".equalsIgnoreCase(sourcetype)) {
                String expval;
                vchTempAccts.setAcctName((String)this.getModel().getValue(EXPCON_DESC));
                String name = (String)this.getView().getFormShowParameter().getCustomParam(CacheKey_acctsJson);
                VchTplAccts vchTempAcctsOld = new VchTplAccts();
                if (StringUtils.isNotBlank((CharSequence)name)) {
                    vchTempAcctsOld = (VchTplAccts)SerializationUtils.fromJsonString((String)name, VchTplAccts.class);
                }
                if (!StringUtils.isEmpty((CharSequence)(expval = (String)this.getModel().getValue(EXP)))) {
                    VchReturnData returnData = (VchReturnData)SerializationUtils.fromJsonString((String)expval, VchReturnData.class);
                    if (returnData != null) {
                        vchTempAccts.setVchTplAcccounts((VchTplAcccounts)SerializationUtils.fromJsonString((String)returnData.getDataStr(), VchTplAcccounts.class));
                    }
                } else if (StringUtils.isNotBlank((CharSequence)name)) {
                    vchTempAccts.setVchTplAcccounts(vchTempAcctsOld.getVchTplAcccounts());
                }
                if (!isHandInput) return vchTempAccts;
                vchTempAccts.setHandinput("1");
                return vchTempAccts;
            }
            if (!"commonmapping".equalsIgnoreCase(sourcetype)) return vchTempAccts;
            DynamicObject accountmap2 = (DynamicObject)this.getModel().getValue(Flex_CommonMapping);
            if (accountmap2 == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u901a\u7528\u6620\u5c04\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"VchAcctEdit_7", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return null;
            }
            vchTempAccts.setFlexMappingId(accountmap2.getLong("id"));
            vchTempAccts.setAcctName(accountmap2.getString("name"));
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(Flex_Mapping_Entry);
            Iterator iterator = entryEntity.iterator();
            while (iterator.hasNext()) {
                DynamicObject data = (DynamicObject)iterator.next();
                VchSingleFlexMapping singleData = new VchSingleFlexMapping();
                singleData.setIsmustInput(data.getBoolean(Flex_MappingIsmustInput));
                singleData.setMappingexp(data.getString(Flex_MappingExp));
                singleData.setMappingexpstr(data.getString(Flex_MappingExpstr));
                singleData.setMappingName(data.getString(Flex_MappingName));
                singleData.setMappingType(Long.valueOf(data.getLong(Flex_MappingType)));
                singleData.setParentIds(Long.valueOf(accountmap2.getLong("id")));
                singleData.setSourceField(data.getString(Flex_MappingSourcefield));
                vchTempAccts.getFlexMappingItem().addDataCol(singleData);
            }
            return vchTempAccts;
        }
        vchTempAccts.setMappingid(accountmap.getLong("id"));
        vchTempAccts.setAcctName(accountmap.getString("name"));
        int rowCount = this.getModel().getEntryRowCount(Key_FactorEntity);
        int row = 0;
        while (row < rowCount) {
            String factorKey = (String)this.getModel().getValue(Key_FFactorKey, row);
            String factorSource = (String)this.getModel().getValue(Key_FFactorSource, row);
            DynamicObject fieldMapping = (DynamicObject)this.getModel().getValue(Key_FieldMapping, row);
            if (StringUtils.isNotBlank((CharSequence)factorKey)) {
                VchTplAcctFactorMap factorMap = new VchTplAcctFactorMap();
                factorMap.setFactor(factorKey);
                if (StringUtils.isNotBlank((CharSequence)factorSource)) {
                    factorMap.setSourceFieldKey(factorSource);
                    factorMap.setField(true);
                } else {
                    String entityexpval = (String)this.getModel().getValue(ENTITY_EXP, row);
                    String entityexpdecs = (String)this.getModel().getValue(ENTITY_EXP_DESC, row);
                    factorMap.setExpvalentity(entityexpval);
                    factorMap.setExpdescentity(entityexpdecs);
                }
                if (fieldMapping != null) {
                    factorMap.setMapping(Long.valueOf(fieldMapping.getLong("id")));
                }
                vchTempAccts.getFactorMaps().add(factorMap);
            }
            ++row;
        }
        return vchTempAccts;
    }

    private void loadMappingData() {
        DynamicObject[] mappings = BusinessDataServiceHelper.load((String)"ai_basedatamapping", (String)"mappingplugin,factorvalue,destbasedata.number", null);
        HashSet<String> destSet = new HashSet<String>(mappings.length);
        HashMap mappingMap = new HashMap(mappings.length);
        HashMap<String, Long> fileMapData = new HashMap<String, Long>(mappings.length);
        for (DynamicObject d : mappings) {
            HashSet<String> srcSet;
            String destBaseData = d.getString("destbasedata.number");
            destSet.add(destBaseData);
            if (destBaseData == null) continue;
            if (mappingMap.get(destBaseData) != null) {
                srcSet = (HashSet<String>)mappingMap.get(destBaseData);
            } else {
                srcSet = new HashSet<String>(mappings.length);
                mappingMap.put(destBaseData, srcSet);
            }
            srcSet.add(d.getString("factorvalue"));
            fileMapData.put(destBaseData, d.getLong("id"));
        }
        this.getPageCache().put(DEST_SET, SerializationUtils.toJsonString(destSet));
        this.getPageCache().put(MAPPING_MAP, SerializationUtils.toJsonString(mappingMap));
        this.getPageCache().put(FieldMapData_MAP, SerializationUtils.toJsonString(fileMapData));
        this.getView().setVisible(Boolean.FALSE, new String[]{Key_FieldMapping});
        if (!DapBuildVoucherCommonUtil.getAiSystemParamToOpenMappingType((String)"dap").booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"commonmapping"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap_factor1"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty prop = e.getProperty();
        ChangeData[] change = e.getChangeSet();
        IDataModel model = this.getModel();
        if (prop.getName().equals("sourcetype")) {
            String type = change[0].getNewValue().toString();
            Object booktypeObj = this.getView().getFormShowParameter().getCustomParam("booktypeid");
            Object accttableidObj = this.getView().getFormShowParameter().getCustomParam("accttableid");
            String booktypestr = booktypeObj == null ? "0" : booktypeObj.toString();
            String accttableidtr = accttableidObj == null ? "0" : accttableidObj.toString();
            boolean flag = Long.parseLong(booktypestr) == 0L && Long.parseLong(accttableidtr) == 0L;
            this.acctTypeChange(type, flag);
        } else if (prop.getName().equals("accountmap")) {
            if (change[0].getOldValue() != change[0].getNewValue()) {
                this.getPageCache().put("needRefresh", "true");
            }
            this.refreshAcctFactorEntry();
        } else if (ENTITY_EXP_DESC.equals(prop.getName())) {
            if (StringUtils.isNotBlank((Object)change[0].getNewValue())) {
                int index = model.getEntryCurrentRowIndex(Key_FactorEntity);
                model.setValue(Key_FFactorSource, null, index);
            } else {
                int index = model.getEntryCurrentRowIndex(Key_FactorEntity);
                model.setValue(ENTITY_EXP, null, index);
                model.setValue(ENTITY_EXP_DESC, null, index);
            }
        } else if (Key_FFactorSource.equals(prop.getName()) || Key_FieldMapping.equals(prop.getName())) {
            if (change[0].getNewValue() != null) {
                int index = model.getEntryCurrentRowIndex(Key_FactorEntity);
                model.setValue(ENTITY_EXP, null, index);
                model.setValue(ENTITY_EXP_DESC, null, index);
            }
        } else if (Flex_CommonMapping.equals(prop.getName())) {
            DynamicObject newValue = (DynamicObject)change[0].getNewValue();
            if (newValue == null) {
                this.getModel().deleteEntryData(Flex_Mapping_Entry);
            } else {
                this.getModel().deleteEntryData(Flex_Mapping_Entry);
                Map<Long, FlexFieldCfg> inputFlexProp = FlexMappingCommonUtil.getInputFlexProp(newValue.getLong("struc.id"));
                for (Map.Entry<Long, FlexFieldCfg> data : inputFlexProp.entrySet()) {
                    FlexFieldCfg value = data.getValue();
                    int factorRow = this.getModel().createNewEntryRow(Flex_Mapping_Entry);
                    this.getModel().setValue(Flex_MappingType, value.getId(), factorRow);
                    this.getModel().setValue(Flex_MappingName, (Object)value.getName(), factorRow);
                }
                this.searchFlexComboItem();
            }
        } else if (Flex_MappingSourcefield.equals(prop.getName())) {
            if (change[0].getNewValue() != null) {
                int index = model.getEntryCurrentRowIndex(Flex_Mapping_Entry);
                model.setValue(Flex_MappingExpstr, null, index);
                model.setValue(Flex_MappingExp, null, index);
            }
        } else if (Flex_MappingExpstr.equals(prop.getName())) {
            if (StringUtils.isNotBlank((Object)change[0].getNewValue())) {
                int index = model.getEntryCurrentRowIndex(Flex_Mapping_Entry);
                model.setValue(Flex_MappingSourcefield, null, index);
            } else {
                int index = model.getEntryCurrentRowIndex(Flex_Mapping_Entry);
                model.setValue(Flex_MappingExpstr, null, index);
                model.setValue(Flex_MappingExp, null, index);
            }
        }
    }

    private void acctTypeChange(String type, boolean flag) {
        switch (type) {
            case "fix": {
                this.getView().setVisible(Boolean.valueOf(!flag), new String[]{ACCOUNT});
                this.getView().setVisible(Boolean.valueOf(flag), new String[]{ACCOUNTNUMBER});
                this.getView().setVisible(Boolean.FALSE, new String[]{Flex_CommonMapping, "advconap_factor1", "accountmap", "advconap_factor", EXP_DESC, EXPCON_DESC});
                this.getModel().setValue("accountmap", null);
                this.getModel().setValue(EXP_DESC, null);
                this.getModel().setValue(EXPCON_DESC, null);
                this.getModel().setValue(Flex_CommonMapping, null);
                this.getPageCache().remove(CacheKey_acctJson);
                break;
            }
            case "mapping": {
                this.getView().setVisible(Boolean.valueOf(!flag), new String[]{"accountmap"});
                this.getModel().getValue("org");
                BasedataEdit edit = (BasedataEdit)this.getControl("accountmap");
                QFilter filter = edit.getQFilter();
                QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
                List ids = QueryServiceHelper.queryPrimaryKeys((String)"ai_accountmaptype", (QFilter[])new QFilter[]{filter, enableFilter}, null, (int)2);
                if (ids.size() == 1) {
                    this.getModel().setValue("accountmap", ids.get(0));
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"advconap_factor"});
                this.getView().setVisible(Boolean.FALSE, new String[]{Flex_CommonMapping, "advconap_factor1", ACCOUNT, EXP_DESC, EXPCON_DESC, ACCOUNTNUMBER});
                this.getModel().setValue(ACCOUNT, null);
                this.getModel().setValue(ACCOUNTNUMBER, null);
                this.getModel().setValue(EXP_DESC, null);
                this.getModel().setValue(EXPCON_DESC, null);
                this.getModel().setValue(Flex_CommonMapping, null);
                this.getPageCache().remove(CacheKey_acctJson);
                break;
            }
            case "exp": {
                this.getView().setVisible(Boolean.FALSE, new String[]{ACCOUNT, Flex_CommonMapping, "advconap_factor1", "accountmap", "advconap_factor", EXPCON_DESC, ACCOUNTNUMBER});
                this.getView().setVisible(Boolean.TRUE, new String[]{EXP_DESC});
                this.getModel().setValue(ACCOUNT, null);
                this.getModel().setValue(ACCOUNTNUMBER, null);
                this.getModel().setValue(EXP_DESC, null);
                this.getModel().setValue("accountmap", null);
                this.getModel().setValue(EXP, null);
                this.getModel().setValue(EXPCON_DESC, null);
                this.getModel().setValue(Flex_CommonMapping, null);
                this.getPageCache().remove(CacheKey_acctJson);
                break;
            }
            case "conditionexp": {
                this.getView().setVisible(Boolean.FALSE, new String[]{ACCOUNT, Flex_CommonMapping, "advconap_factor1", "accountmap", "advconap_factor", EXP_DESC, ACCOUNTNUMBER});
                this.getView().setVisible(Boolean.TRUE, new String[]{EXPCON_DESC});
                this.getModel().setValue(ACCOUNT, null);
                this.getModel().setValue(EXP_DESC, null);
                this.getModel().setValue("accountmap", null);
                this.getModel().setValue(EXPCON_DESC, null);
                this.getModel().setValue(EXP, null);
                this.getModel().setValue(Flex_CommonMapping, null);
                this.getPageCache().remove(CacheKey_acctJson);
                break;
            }
            case "commonmapping": {
                this.getView().setVisible(Boolean.valueOf(!flag), new String[]{Flex_CommonMapping});
                this.getModel().getValue("org");
                BasedataEdit edit1 = (BasedataEdit)this.getControl(Flex_CommonMapping);
                QFilter filter1 = edit1.getQFilter();
                QFilter enableFilter1 = new QFilter("enable", "=", (Object)"1");
                List ids1 = QueryServiceHelper.queryPrimaryKeys((String)"ai_accountmaptype", (QFilter[])new QFilter[]{filter1, enableFilter1}, null, (int)2);
                if (ids1.size() == 1) {
                    this.getModel().setValue(Flex_CommonMapping, ids1.get(0));
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{"advconap_factor1"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"accountmap", ACCOUNT, EXP_DESC, EXPCON_DESC, "advconap_factor", ACCOUNTNUMBER});
                this.getModel().setValue(ACCOUNT, null);
                this.getModel().setValue(ACCOUNTNUMBER, null);
                this.getModel().setValue(EXP_DESC, null);
                this.getModel().setValue(EXPCON_DESC, null);
                this.getModel().setValue("accountmap", null);
                this.getPageCache().remove(CacheKey_acctJson);
            }
        }
    }

    private void changeAccountFiler(Long accttableid, Long orgid) {
        QFilter qFilter = new QFilter("accounttable", "=", (Object)accttableid);
        qFilter = qFilter.and(new QFilter("isleaf", "=", (Object)Boolean.TRUE));
        BasedataEdit acct = (BasedataEdit)this.getControl(ACCOUNT);
        acct.setQFilter(qFilter);
    }

    private void refreshAcctFactorEntry() {
        Object factorKey;
        Map<String, String> entities = this.getAcctFactorFromAcctMapping();
        Set<String> entityKeys = entities.keySet();
        IDataModel model = this.getModel();
        boolean needRefresh = false;
        int count = model.getEntryRowCount(Key_FactorEntity);
        ArrayList<Integer> toDeletetRows = new ArrayList<Integer>();
        this.getView().setVisible(Boolean.FALSE, new String[]{Key_FieldMapping});
        for (int i = 0; i < count; ++i) {
            DynamicObject factor = model.getEntryRowEntity(Key_FactorEntity, i);
            factorKey = factor.getString(Key_FFactorKey);
            if (entityKeys.contains(factorKey)) continue;
            toDeletetRows.add(i);
        }
        if (toDeletetRows.size() > 0) {
            int[] deleteIdx = new int[toDeletetRows.size()];
            int i = 0;
            factorKey = toDeletetRows.iterator();
            while (factorKey.hasNext()) {
                int e = (Integer)factorKey.next();
                deleteIdx[i++] = e;
            }
            model.deleteEntryRows(Key_FactorEntity, deleteIdx);
            needRefresh = true;
        }
        Set<String> factorEntities = this.getFactorEntryEntityIds();
        entityKeys.removeAll(factorEntities);
        String destSetStr = this.getPageCache().get(DEST_SET);
        Set destSet = (Set)SerializationUtils.fromJsonString((String)destSetStr, HashSet.class);
        for (String string : factorEntities) {
            if (!destSet.contains(string)) continue;
            this.getView().setVisible(Boolean.TRUE, new String[]{Key_FieldMapping});
        }
        for (Map.Entry entry : entities.entrySet()) {
            int factorRow = this.getModel().createNewEntryRow(Key_FactorEntity);
            this.getModel().setValue(Key_FFactorKey, entry.getKey(), factorRow);
            this.getModel().setValue(Key_FFactorName, entry.getValue(), factorRow);
            if (destSet.contains(entry.getKey())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{Key_FieldMapping});
                String fieldMapDataStr = this.getPageCache().get(FieldMapData_MAP);
                Map fieldMapData = (Map)SerializationUtils.fromJsonString((String)fieldMapDataStr, HashMap.class);
                this.getModel().setValue(Key_FieldMapping, fieldMapData.get(entry.getKey()), factorRow);
            }
            needRefresh = true;
        }
        if (needRefresh) {
            this.fillSourceFields();
        }
    }

    private Map<String, String> getAcctFactorFromAcctMapping() {
        DynamicObjectCollection fieldMapEntry;
        HashMap<String, String> factorMap = new HashMap<String, String>();
        DynamicObject acctMapping = (DynamicObject)this.getModel().getValue("accountmap");
        if (acctMapping != null && (fieldMapEntry = acctMapping.getDynamicObjectCollection("fieldmapentry")) != null) {
            for (DynamicObject mapEntry : fieldMapEntry) {
                factorMap.put(mapEntry.getString("entityid"), mapEntry.getString("fieldname"));
                this.sourceTypeMap.put(mapEntry.getString("entityid"), mapEntry.getString("datatype"));
            }
        }
        return factorMap;
    }

    private Set<String> getFactorEntryEntityIds() {
        int rowCount = this.getModel().getEntryRowCount(Key_FactorEntity);
        HashSet<String> entityIds = new HashSet<String>(rowCount);
        for (int row = 0; row < rowCount; ++row) {
            String factorKey = (String)this.getModel().getValue(Key_FFactorKey, row);
            if (!StringUtils.isNotEmpty((CharSequence)factorKey)) continue;
            entityIds.add(factorKey);
        }
        return entityIds;
    }

    private void fillSourceFields() {
        Set<String> entityIds = this.getFactorEntryEntityIds();
        HashSet temp = new HashSet();
        Map mappingMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(MAPPING_MAP), HashMap.class);
        for (String string : entityIds) {
            Object ids = mappingMap.get(string);
            if (ids == null) continue;
            temp.addAll((Collection)mappingMap.get(string));
        }
        entityIds.addAll(temp);
        HashSet<String> assEntityIDs = new HashSet<String>();
        if (this.sourceTypeMap.size() == 0) {
            this.getAcctFactorFromAcctMapping();
        }
        for (String e : entityIds) {
            String sourceType = this.sourceTypeMap.get(e);
            if (!StringUtils.isNotEmpty((CharSequence)sourceType) || !"1".equals(sourceType)) continue;
            assEntityIDs.add(e);
        }
        if (assEntityIDs.size() > 0) {
            entityIds.add("bos_assistantdata_detail");
        }
        String string = this.getPageCache().get("needRefresh");
        this.getPageCache().remove("needRefresh");
        if (StringUtils.isNotBlank((CharSequence)string)) {
            this.searchComboItem(entityIds, Key_FFactorSource, true);
        } else {
            this.searchComboItem(entityIds, Key_FFactorSource, false);
        }
    }

    private void searchComboItem(Set<String> entityIds, String key, boolean isAutoSetValue) {
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam("sourcebill");
        if (StringUtils.isBlank((CharSequence)sourceBill)) {
            return;
        }
        boolean isevent = Boolean.parseBoolean(this.getView().getFormShowParameter().getCustomParam("isevent") + "");
        MainEntityType srcMainEntityType = this.getMainEntityType();
        List items = DapUtil.buildPropComboItems(entityIds, (MainEntityType)srcMainEntityType, (boolean)true, (boolean)true, (boolean)true);
        ComboEdit fieldEditor = (ComboEdit)this.getView().getControl(key);
        fieldEditor.setComboItems(items);
        int setDefValSize = 2;
        if (items.size() == setDefValSize && isAutoSetValue) {
            fieldEditor.selectedStore((ComboItem)items.get(setDefValSize - 1));
            this.getModel().setValue(key, (Object)((ComboItem)items.get(setDefValSize - 1)).getValue());
        }
    }

    private void searchFlexComboItem() {
        Object Mapping = this.getModel().getValue(Flex_CommonMapping);
        if (Mapping != null) {
            DynamicObjectCollection query;
            Map<Long, FlexFieldCfg> flexProp = FlexMappingCommonUtil.getInputFlexProp(((DynamicObject)Mapping).getLong("struc.id"));
            HashSet<String> entityIds = new HashSet<String>(flexProp.size());
            HashSet<String> flexNumber = new HashSet<String>(flexProp.size());
            for (FlexFieldCfg fcg : flexProp.values()) {
                DataValueTypeEnum dataType = fcg.getDataType();
                if (DataValueTypeEnum.BaseProp == dataType) {
                    entityIds.add(fcg.getRefEntity());
                    continue;
                }
                if (DataValueTypeEnum.AssistProp == dataType) {
                    entityIds.add("bos_assistantdata_detail");
                    continue;
                }
                if (DataValueTypeEnum.String == dataType || DataValueTypeEnum.FahValueSet == dataType) continue;
                if (DataValueTypeEnum.Kingdee_AccountTable == dataType) {
                    entityIds.add("bd_accountview");
                    continue;
                }
                if (DataValueTypeEnum.Kingdee_AcctAssistDim != dataType) continue;
                flexNumber.add(fcg.getRefFieldNum());
            }
            if (!flexNumber.isEmpty() && !(query = QueryServiceHelper.query((String)"bd_asstacttype", (String)"valuetype,valuesource,assistanttype", (QFilter[])new QFilter("number", "in", flexNumber).toArray())).isEmpty()) {
                for (DynamicObject dobj : query) {
                    Object valuetype = dobj.get("valuetype");
                    if ("1".equals(valuetype)) {
                        String sourceBillName = dobj.getDynamicObject("valuesource").getPkValue().toString();
                        entityIds.add(sourceBillName);
                        continue;
                    }
                    if (!"2".equals(valuetype)) continue;
                    entityIds.add("bos_assistantdata_detail");
                }
            }
            this.searchComboItem(entityIds, Flex_MappingSourcefield, false);
        }
    }

    private String checkFlexmappingEntry() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(Flex_Mapping_Entry);
        for (DynamicObject entry : entryEntity) {
            Object mappingType = entry.get(Flex_MappingType);
            Object mappingExp = entry.get(Flex_MappingExp);
            Object mappingSourceField = entry.get(Flex_MappingSourcefield);
            if (!StringUtils.isNotBlank((Object)mappingType) || !StringUtils.isBlank((Object)mappingSourceField) || !StringUtils.isBlank((Object)mappingExp)) continue;
            return ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u4e1a\u8d22\u6620\u5c04\u6570\u636e\u6765\u6e90\uff0c\u6620\u5c04\u5173\u7cfb\u7684\u6765\u6e90\u5b57\u6bb5\u6216\u8005\u8868\u8fbe\u5f0f\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"VchAcctEdit_6", (String)"fi-ai-formplugin", (Object[])new Object[0]);
        }
        return null;
    }

    private MainEntityType getMainEntityType() {
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam("sourcebill");
        Object isEvent = this.getView().getFormShowParameter().getCustomParam("isevent");
        boolean isevent = isEvent instanceof String ? Boolean.parseBoolean((String)isEvent) : isEvent instanceof Boolean && (Boolean)isEvent != false;
        MainEntityType mainType = isevent ? AiEventMetaUtil.getEntityType((Object)Long.valueOf(sourceBill)) : EntityMetadataCache.getDataEntityType((String)sourceBill);
        return mainType;
    }
}

