/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.ai.formplugin.FactorInfo;

public class VchAcctFactorList
extends AbstractFormPlugin
implements RowClickEventListener {
    public static final String FormId_VchAcctFactorList = "ai_vchacctfactorlist";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        if ("btnok".equalsIgnoreCase(evt.getItemKey())) {
            this.getView().returnDataToParent(this.getCurrentSelector());
            this.getView().close();
        } else if ("btncancel".equalsIgnoreCase(evt.getItemKey())) {
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject eo) {
        String str = (String)this.getView().getFormShowParameter().getCustomParam("factorlist");
        if (!StringUtils.isBlank((CharSequence)str)) {
            List<FactorInfo> factorList = FactorInfo.fromJsonStringList(str);
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow("entryentity", factorList.size());
            int rowIndex = 0;
            for (FactorInfo factorInfo : factorList) {
                model.setValue("fseq", (Object)(rowIndex + 1), rowIndex);
                model.setValue("fsrcentitynumber", (Object)factorInfo.getSrcEntityNumber(), rowIndex);
                model.setValue("fsrcentityname", (Object)factorInfo.getSrcEntityName(), rowIndex);
                model.setValue("fsrcpropkey", (Object)factorInfo.getSrcPropKey(), rowIndex);
                model.setValue("fsrcpropname", (Object)factorInfo.getSrcPropName(), rowIndex);
                model.setValue("ffactorname", (Object)factorInfo.getFactorName(), rowIndex);
                model.setValue("ftopclass", (Object)factorInfo.getTopClass(), rowIndex);
                model.setValue("fsubsystem", (Object)factorInfo.getSubSystem(), rowIndex);
                ++rowIndex;
            }
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.getView().returnDataToParent(this.getCurrentSelector());
        this.getView().close();
    }

    private Map<String, Object> getCurrentSelector() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        int row = grid.getEntryState().getFocusRow();
        if (row < 0) {
            return null;
        }
        ret.put("fsrcentitynumber", (String)this.getModel().getValue("fsrcentitynumber", row));
        ret.put("fsrcentityname", (String)this.getModel().getValue("fsrcentityname", row));
        ret.put("fsrcpropkey", (String)this.getModel().getValue("fsrcpropkey", row));
        ret.put("fsrcpropname", (String)this.getModel().getValue("fsrcpropname", row));
        ret.put("ffactorname", (String)this.getModel().getValue("ffactorname", row));
        return ret;
    }

    public void entryRowClick(RowClickEvent arg0) {
    }
}

