/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class VchEntryTypeEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String AcctTableKey = "faccttableid";
    private static final String AcctorgKey = "acctorg";
    private static final String AcctKey = "facctid";
    private static final String Key_Entry = "entryentity";
    private static final String Key_AcctFilterDesc = "facctfilterdesc";
    private static final String Key_AcctFilterXml = "facctfilterxml";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_AcctFilterDesc});
        BasedataEdit acctCtl = (BasedataEdit)this.getControl(AcctKey);
        acctCtl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if (c.getKey().equals(Key_AcctFilterDesc)) {
            this.showVchAcctFilterEdit();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getActionId().equals("ai_vchacctfilter") && closedCallBackEvent.getReturnData() != null) {
            Map ret = (Map)closedCallBackEvent.getReturnData();
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(Key_Entry);
            int row = grid.getEntryState().getFocusRow();
            this.getView().getModel().setValue(Key_AcctFilterDesc, ret.get("desc"), row);
            this.getView().getModel().setValue(Key_AcctFilterXml, ret.get("xml"), row);
        }
    }

    private void showVchAcctFilterEdit() {
        int rowIndex = this.getView().getModel().getEntryCurrentRowIndex(Key_Entry);
        Object desc = this.getModel().getValue(Key_AcctFilterDesc, rowIndex);
        String xml = (String)this.getModel().getValue(Key_AcctFilterXml, rowIndex);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ai_vchacctfilter");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("desc", desc);
        showParameter.setCustomParam("acctfilter", (Object)xml);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ai_vchacctfilter");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        Object source = arg0.getSource();
        Control sourceCtl = (Control)source;
        String key = sourceCtl.getKey();
        int row = arg0.getRow();
        if (AcctKey.equals(key)) {
            DynamicObject acctTable = (DynamicObject)this.getModel().getValue(AcctTableKey, row);
            DynamicObject acctorg = (DynamicObject)this.getModel().getValue(AcctorgKey);
            if (acctTable == null) {
                arg0.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79d1\u76ee\u8868\u3002", (String)"VchEntryTypeEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            } else if (acctorg == null) {
                arg0.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u4e3b\u4f53\u3002", (String)"VchEntryTypeEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            } else {
                ListShowParameter param = (ListShowParameter)arg0.getFormShowParameter();
                Long acctTableID = acctTable.getLong("id");
                ArrayList<QFilter> list = new ArrayList<QFilter>();
                list.add(new QFilter("accounttable", "=", (Object)acctTableID));
                list.add(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)acctorg.getLong("id")));
                param.getListFilterParameter().setQFilters(list);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String acctorg = (String)formShowParameter.getCustomParam(AcctorgKey);
        if (null != acctorg && acctorg.trim().length() > 0) {
            this.getModel().setValue(AcctorgKey, (Object)Long.valueOf(acctorg));
        }
    }
}

