/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.VchExpireDate;
import kd.fi.ai.VchFormulaFilterSetRow;
import kd.fi.ai.VchFormulaFilterset;
import kd.fi.ai.VchReturnData;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.cache.CacheBuildTree;
import kd.fi.ai.function.DapFunctionTypes;
import kd.fi.ai.util.AiEventMetaUtil;
import kd.fi.ai.util.BuildTree;
import kd.fi.ai.util.EntityFieldTreeOption;
import kd.fi.ai.util.EntityFieldTreeResult;
import kd.fi.ai.util.EntityFieldUtil;
import kd.fi.ai.util.EntityTreeUtil;

public class VchFormulaFilterSetEdit
extends AbstractFormPlugin {
    static final String FORMID = "ai_formulafilterset";
    private static final String NON_FIELDS = "nonFields";
    private static final String ENTRY_VCHSETENTRY = "vchsetentry";
    private static final String KEY_FIELDEXPDESC = "fieldexpdesc";
    private static final String KEY_FIELDEXP = "fieldexp";
    private static final String KEY_FFILTER = "ffilter";
    private static final String KEY_FFILTERDESCRIPTION = "ffilterdescription";
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_BTNCANCEL = "btncancel";
    public static final String CACHEKEY_FORMULAFILTERSETJSON = "formulaFilterSetJson";
    public static final String ISHEAD = "isHead";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTNOK, KEY_BTNCANCEL, KEY_FIELDEXPDESC, KEY_FFILTERDESCRIPTION});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String str = (String)this.getView().getFormShowParameter().getCustomParam(CACHEKEY_FORMULAFILTERSETJSON);
        if (!StringUtils.isBlank((CharSequence)str)) {
            VchExpireDate expireDate = (VchExpireDate)SerializationUtils.fromJsonString((String)str, VchExpireDate.class);
            this.setVchFormulaFilterset((VchFormulaFilterset)expireDate);
        }
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam("billEntityNumber");
        boolean isevent = (Boolean)this.getView().getFormShowParameter().getCustomParam("isevent");
        if (StringUtils.isNotBlank((CharSequence)sourceBill)) {
            MainEntityType srcMainEntityType = null;
            srcMainEntityType = isevent ? AiEventMetaUtil.getEntityType((Object)Long.valueOf(sourceBill)) : EntityMetadataCache.getDataEntityType((String)sourceBill);
            boolean isHead = (Boolean)this.getView().getFormShowParameter().getCustomParam(ISHEAD);
            this.fillExprFields(srcMainEntityType, KEY_FIELDEXPDESC, isHead, DateTimeProp.class);
            this.fillExprFields(srcMainEntityType, KEY_FFILTERDESCRIPTION, isHead, null);
        }
        CacheBuildTree.setPageCacheByType((FormShowParameter)this.getView().getFormShowParameter(), (IPageCache)this.getPageCache());
    }

    private void fillExprFields(MainEntityType srcMainET, String cacheKey, boolean isHead, Class<?> fieldType) {
        if (srcMainET == null) {
            this.getPageCache().put(cacheKey, "");
        } else {
            EntityFieldTreeOption option = EntityFieldTreeOption.create();
            option.setEntityType((IDataEntityType)srcMainET);
            option.setReadEntryEntity(!isHead);
            option.setExprType(ExpressionType.Formula);
            option.setFieldType(fieldType);
            option.setIncludeID(true);
            EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
            this.getPageCache().put(NON_FIELDS + cacheKey, SerializationUtils.toJsonString((Object)result.getNonFields()));
            TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
            String toJson = SerializationUtils.toJsonString((Object)tree);
            this.getPageCache().put(cacheKey, toJson);
        }
    }

    protected void setVchFormulaFilterset(VchFormulaFilterset vchFormulaFilterSet) {
        int rowCount = this.getModel().getEntryRowCount(ENTRY_VCHSETENTRY);
        if (rowCount < vchFormulaFilterSet.getItems().size()) {
            this.getModel().batchCreateNewEntryRow(ENTRY_VCHSETENTRY, vchFormulaFilterSet.getItems().size() - rowCount);
        }
        for (int i = 0; i < vchFormulaFilterSet.getItems().size(); ++i) {
            VchFormulaFilterSetRow vchFormulaFilterRow = (VchFormulaFilterSetRow)vchFormulaFilterSet.getItems().get(i);
            VchTplExpression fieldExp = vchFormulaFilterRow.getFieldExp();
            this.getModel().setValue(KEY_FIELDEXP, (Object)SerializationUtils.toJsonString((Object)fieldExp), i);
            String fieldExpDesc = BuildTree.multiLangDesc((String)fieldExp.getDescription().toString(), (String)fieldExp.getExprTran(), () -> BuildTree.tranExpression((String)fieldExp.getExpression(), (MainEntityType)this.getEntityType()));
            if (StringUtils.isBlank((CharSequence)fieldExpDesc)) {
                fieldExpDesc = fieldExp.getExprTran();
            }
            this.getModel().setValue(KEY_FIELDEXPDESC, (Object)fieldExpDesc, i);
            VchTplExpression filterObj = vchFormulaFilterRow.getFilterSet();
            this.getModel().setValue(KEY_FFILTER, (Object)SerializationUtils.toJsonString((Object)filterObj), i);
            String dsp = BuildTree.multiLangDesc((String)filterObj.getDescription().toString(), (String)filterObj.getExprTran(), () -> BuildTree.tranVchTplFormula((CRCondition)filterObj, (MainEntityType)this.getEntityType()));
            if (StringUtils.isBlank((CharSequence)dsp)) {
                dsp = filterObj.getExprTran();
            }
            this.getModel().setValue(KEY_FFILTERDESCRIPTION, (Object)dsp, i);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        switch (ctlSource.getKey()) {
            case "fieldexpdesc": {
                this.showFormulaForm();
                break;
            }
            case "ffilterdescription": {
                this.showConditionForm();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "btnok": {
                this.returnData();
                break;
            }
        }
    }

    private void returnData() {
        String cacheValue;
        String entitynumber;
        String currentFormId;
        VchFormulaFilterset vchFormulaFilterset = this.getVchFormulaFilterset();
        VchReturnData returnData = EntityFieldUtil.validateDiffEntry((Object)vchFormulaFilterset, (String)(currentFormId = (String)this.getView().getFormShowParameter().getCustomParam("ai_button_key")), (String)(entitynumber = (String)this.getView().getFormShowParameter().getCustomParam("billEntityNumber")), (String)(cacheValue = EntityFieldUtil.getCacheValueFromFormParameter((IFormView)this.getView())));
        if (returnData.isStatus()) {
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)returnData));
            this.getView().close();
        } else if (!returnData.isStatus() && StringUtils.isNotEmpty((CharSequence)returnData.getMessage())) {
            this.getView().showTipNotification(returnData.getMessage());
        }
    }

    private VchFormulaFilterset getVchFormulaFilterset() {
        VchExpireDate vchFormulaFilterSet = new VchExpireDate();
        int rowCount = this.getModel().getEntryRowCount(ENTRY_VCHSETENTRY);
        for (int row = 0; row < rowCount; ++row) {
            String filter;
            VchFormulaFilterSetRow vchFormulaFilterSetRow = new VchFormulaFilterSetRow();
            String fieldExp = (String)this.getModel().getValue(KEY_FIELDEXP, row);
            if (StringUtils.isNotEmpty((CharSequence)fieldExp)) {
                VchTplExpression fieldExpObj = (VchTplExpression)SerializationUtils.fromJsonString((String)fieldExp, VchTplExpression.class);
                vchFormulaFilterSetRow.setFieldExp(fieldExpObj);
            }
            if (StringUtils.isNotEmpty((CharSequence)(filter = (String)this.getModel().getValue(KEY_FFILTER, row)))) {
                VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)filter, VchTplExpression.class);
                vchFormulaFilterSetRow.setFilterSet(filterObj);
            }
            vchFormulaFilterSet.getItems().add(vchFormulaFilterSetRow);
        }
        return vchFormulaFilterSet;
    }

    private void showConditionForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ai_condition");
        int row = this.getModel().getEntryCurrentRowIndex(ENTRY_VCHSETENTRY);
        String conditionJson = (String)this.getModel().getValue(KEY_FFILTER, row);
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", this.getView().getFormShowParameter().getCustomParam("billEntityNumber"));
        showParameter.getCustomParams().put("treenodes", this.getPageCache().get(KEY_FFILTERDESCRIPTION));
        boolean isEvent = (Boolean)this.getView().getFormShowParameter().getCustomParam("isevent");
        showParameter.getCustomParams().put("isevent", isEvent);
        showParameter.setCustomParam("ai_vchtemplatecachekey", (Object)EntityFieldUtil.getCacheValueFromFormParameter((IFormView)this.getView()));
        showParameter.setCustomParam("ai_button_key", (Object)"ai_expression-fvchtypedesc");
        String funcsXML = this.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = DapFunctionTypes.get((String)(isEvent ? "event" : "type"));
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        boolean isHead = (Boolean)this.getView().getFormShowParameter().getCustomParam(ISHEAD);
        if (isHead) {
            this.getPageCache().put("srcMainEntityType", "dateHead");
        } else {
            this.getPageCache().put("srcMainEntityType", "dateBody");
        }
        CacheBuildTree.setBuildByType((FormShowParameter)showParameter, (IPageCache)this.getPageCache());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_FFILTERDESCRIPTION));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showFormulaForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ai_formula");
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_VCHSETENTRY);
        String expression = (String)this.getModel().getValue(KEY_FIELDEXP, rowIndex);
        boolean isHead = (Boolean)this.getView().getFormShowParameter().getCustomParam(ISHEAD);
        showParameter.getCustomParams().put("formula", expression);
        showParameter.getCustomParams().put("treenodes", this.getPageCache().get(KEY_FIELDEXPDESC));
        boolean isEvent = (Boolean)this.getView().getFormShowParameter().getCustomParam("isevent");
        showParameter.getCustomParams().put("isevent", isEvent);
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam("billEntityNumber");
        showParameter.getCustomParams().put("entitynumber", sourceBill);
        String funcsXML = this.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = DapFunctionTypes.get((String)(isEvent ? "event" : "type"));
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCustomParam("ai_vchtemplatecachekey", (Object)EntityFieldUtil.getCacheValueFromFormParameter((IFormView)this.getView()));
        showParameter.setCustomParam("ai_button_key", (Object)"ai_expression-fieldexpdesc");
        if (isHead) {
            this.getPageCache().put("srcMainEntityType", "dateHead");
        } else {
            this.getPageCache().put("srcMainEntityType", "dateBody");
        }
        CacheBuildTree.setBuild((FormShowParameter)showParameter, (IPageCache)this.getPageCache());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_FIELDEXPDESC));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (KEY_FIELDEXPDESC.equalsIgnoreCase(actionId)) {
            this.receiveExpressionSet(closedCallBackEvent);
        }
        if (KEY_FFILTERDESCRIPTION.equalsIgnoreCase(actionId) && closedCallBackEvent.getReturnData() != null) {
            String returnStr = (String)closedCallBackEvent.getReturnData();
            VchReturnData retData = (VchReturnData)SerializationUtils.fromJsonString((String)returnStr, VchReturnData.class);
            this.receiveFilter(retData.getDataStr());
        }
    }

    private void receiveExpressionSet(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() != null) {
            String str = (String)closedCallBackEvent.getReturnData();
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_VCHSETENTRY);
            if (StringUtils.isBlank((CharSequence)str)) {
                this.getModel().setValue(KEY_FIELDEXP, (Object)"", rowIndex);
                this.getModel().setValue(KEY_FIELDEXPDESC, (Object)"", rowIndex);
            } else {
                VchReturnData retData = (VchReturnData)SerializationUtils.fromJsonString((String)str, VchReturnData.class);
                VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)retData.getDataStr(), VchTplExpression.class);
                this.getModel().setValue(KEY_FIELDEXP, (Object)retData.getDataStr());
                String desp = filterObj.getDescription().toString();
                if (StringUtils.isBlank((CharSequence)desp)) {
                    desp = filterObj.getExprTran();
                }
                this.getModel().setValue(KEY_FIELDEXPDESC, (Object)desp, rowIndex);
            }
        }
    }

    private void receiveFilter(String filterJson) {
        int row = this.getModel().getEntryCurrentRowIndex(ENTRY_VCHSETENTRY);
        if (StringUtils.isBlank((CharSequence)filterJson)) {
            this.getModel().setValue(KEY_FFILTER, (Object)"", row);
            this.getModel().setValue(KEY_FFILTERDESCRIPTION, (Object)"", row);
        } else {
            VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)filterJson, VchTplExpression.class);
            this.getModel().setValue(KEY_FFILTER, (Object)filterJson, row);
            String dsp = filterObj.getDescription().toString();
            if (StringUtils.isBlank((CharSequence)dsp)) {
                dsp = filterObj.getExprTran();
            }
            this.getModel().setValue(KEY_FFILTERDESCRIPTION, (Object)dsp, row);
        }
    }

    private MainEntityType getEntityType() {
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam("billEntityNumber");
        Boolean isEvent = (Boolean)this.getView().getFormShowParameter().getCustomParam("isevent");
        return BuildTree.getMainEntityType((String)sourceBill, (boolean)(isEvent != null ? isEvent : false));
    }
}

