/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.CellStyle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.UrlUtil;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.productsetting.ProductSettingServiceHelper;
import kd.fi.ai.VchFormulaFilterSetRow;
import kd.fi.ai.VchFormulaFilterset;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.accsys.AccSysUtil;
import kd.fi.ai.dap.DapCache;
import kd.fi.ai.dap.DapWriteAndBlackOpSetUtil;
import kd.fi.ai.dap.MutexVchTempleteUtil;
import kd.fi.ai.enums.CheckBoxEnum;
import kd.fi.ai.enums.PermissonType;
import kd.fi.ai.util.AiEventMetaUtil;
import kd.fi.ai.util.BuildTree;
import kd.fi.ai.util.ContextUtil;
import kd.fi.ai.util.DapFileUtil;
import kd.fi.ai.util.VchTempDataRulePermUtil;
import kd.fi.ai.util.VchTemplateMultiLangUtil;
import kd.fi.v2.fah.constant.FormBuilderConstant;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;
import kd.fi.v2.fah.optimizor.FahOptimizeControlPanel;
import kd.fi.v2.fah.utils.OperationLogUtils;
import kd.fi.v2.fah.utils.StringUtils;
import org.apache.commons.io.FilenameUtils;

public class VchTemplateConfigsListPlugin
extends AbstractListPlugin
implements ClickListener,
RowClickEventListener,
TreeNodeClickListener,
TreeNodeQueryListener,
HyperLinkClickListener,
ItemClickListener,
BeforeFilterF7SelectListener,
SearchEnterListener {
    private static final String AUDIT = "audit";
    private static final String assignPermItemID = "80513208000000ac";
    private static final String PERM_ORGS = "permOrgs";
    private static Log log = LogFactory.getLog(VchTemplateConfigsListPlugin.class);
    private static final String KEY_BILLNO = "number";
    private static final String KEY_ORG_FILTER = "orgfilter";
    private static final String KEY_ENABLE_FILTER = "enableFilter";
    private static final String TOOLBARAP = "toolbarap";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_FBILLNO = "fbillno";
    private static final String Key_NewVchtemplateBtn = "newvchtemplatebtn";
    private static final String Key_ChangeVchtemplateBtn = "changevchtemplatebtn";
    private static final String Key_DelVchtemplateBtn = "delvchtemplatebtn";
    private static final String Key_CoptyVchtemplateBtn = "copyvchtemplatebtn";
    private static final String Key_accounttable = "accounttable";
    private static final String TYPE = "ai_vchtemplete";
    public static final String FLAG_AI_EVENTCLASS = "@ai_eventclass";
    public static final String FLAG_AI_EVENTGROUP = "@ai_eventgroup";
    private String BILL_ROOT_ID = "1";
    private String AI_EVENT_ROOT_ID = "2";
    private Map<String, String> voucherTypeMap = new LinkedHashMap<String, String>();
    private TreeView treev;

    public void initialize() {
        super.initialize();
        TreeView fieldTree = (TreeView)this.getView().getControl("billtree");
        fieldTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        fieldTree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        this.treev = fieldTree;
        EntryGrid entryentity = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        entryentity.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{Key_NewVchtemplateBtn});
        this.addClickListeners(new String[]{Key_DelVchtemplateBtn});
        this.addClickListeners(new String[]{Key_CoptyVchtemplateBtn});
        this.addClickListeners(new String[]{Key_ChangeVchtemplateBtn});
        Search search = (Search)this.getView().getControl("searchfield");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
        this.setCommonFilter();
    }

    private boolean checkPermission(String permItem) {
        String appId = AppMetadataCache.getAppInfo((String)"iep").getId();
        Long orgId = null;
        try {
            orgId = this.getPageCache().get(KEY_ORG_FILTER) == null ? 0L : Long.parseLong(this.getPageCache().get(KEY_ORG_FILTER));
        }
        catch (NumberFormatException e) {
            return false;
        }
        return PermissionServiceHelper.checkPermission((Long)ContextUtil.getUserId(), (Long)orgId, (String)appId, (String)"ai_vchtemplate", (String)permItem) == 1;
    }

    private boolean checkNewPermission() {
        String appId = AppMetadataCache.getAppInfo((String)"iep").getId();
        Long orgId = null;
        try {
            orgId = this.getPageCache().get(KEY_ORG_FILTER) == null ? 0L : Long.parseLong(this.getPageCache().get(KEY_ORG_FILTER));
        }
        catch (NumberFormatException e) {
            return true;
        }
        return PermissionServiceHelper.checkPermission((Long)ContextUtil.getUserId(), (Long)orgId, (String)appId, (String)"ai_vchtemplate", (String)"47156aff000000ac") == 1;
    }

    private void setCommonFilter() {
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.setEntityId("ai_vchtemplate");
        filterContainer.setBillFormId("ai_vchtemplate");
        filterContainer.addFilterContainerInitListener(event -> this.filterContainerInit(event));
        filterContainer.addSearchClickListener(event -> this.filterSearchClickEvent(event));
        filterContainer.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    private void filterSearchClickEvent(SearchClickEvent event) {
        Map map = event.getFilterValues();
        List customlist = (List)map.get("customfilter");
        if (customlist != null && customlist.size() > 0) {
            for (int i = 0; i < customlist.size(); ++i) {
                Map map1 = (Map)customlist.get(i);
                List listValue = (List)map1.get("Value");
                List listFieldName = (List)map1.get("FieldName");
                for (int j = 0; j < listFieldName.size(); ++j) {
                    String key;
                    if (listFieldName.get(j).equals("org.id")) {
                        if (listValue.size() <= 0) continue;
                        key = listValue.get(j).toString();
                        this.getPageCache().put(KEY_ORG_FILTER, key);
                        continue;
                    }
                    if (!listFieldName.get(j).equals("enable")) continue;
                    key = listValue.get(j).toString();
                    this.getPageCache().put(KEY_ENABLE_FILTER, key);
                }
            }
            String billno = this.getPageCache().get(KEY_BILLNO);
            this.loadTempInfo(billno);
        }
    }

    private void filterContainerInit(FilterContainerInitEvent event) {
        event.getSchemeFilterColumns().clear();
        List listFilterColumns = event.getCommonFilterColumns();
        listFilterColumns.clear();
        CommonFilterColumn stateCol = new CommonFilterColumn();
        stateCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7", (String)"VchTemplateConfigsListPlugin_0", (String)"fi-ai-formplugin", (Object[])new Object[0])));
        stateCol.setFieldName("org.id");
        stateCol.setEntityField(false);
        List<ComboItem> comboItems = this.getAcctOrgComboItem("ai_vchtemplate", PermissonType.VIEW);
        if (comboItems.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u5206\u914d\u51ed\u8bc1\u6a21\u677f\u7684\u3010\u67e5\u8be2\u3011\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VchTemplateConfigsListPlugin_58", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
        ArrayList<String> accOrgIdList = new ArrayList<String>(comboItems.size());
        for (ComboItem cb : comboItems) {
            accOrgIdList.add(cb.getValue());
        }
        this.getPageCache().put(PERM_ORGS, SerializationUtils.toJsonString(accOrgIdList));
        stateCol.setComboItems(comboItems);
        String reqOrg = Long.toString(RequestContext.get().getOrgId());
        if (!accOrgIdList.contains(reqOrg) && accOrgIdList.size() > 0) {
            reqOrg = (String)accOrgIdList.get(0);
        } else if (accOrgIdList.isEmpty()) {
            reqOrg = "";
        }
        this.getPageCache().put(KEY_ORG_FILTER, reqOrg);
        stateCol.setDefaultValue(reqOrg);
        listFilterColumns.add(stateCol);
        CommonFilterColumn enableCol = new CommonFilterColumn();
        enableCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u4f7f\u7528\u72b6\u6001", (String)"VchTemplateConfigsListPlugin_1", (String)"fi-ai-formplugin", (Object[])new Object[0])));
        enableCol.setFieldName("enable");
        ArrayList<ComboItem> enableList = new ArrayList<ComboItem>(3);
        enableList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"VchTemplateConfigsListPlugin_2", (String)"fi-ai-formplugin", (Object[])new Object[0])), ""));
        enableList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u542f\u7528", (String)"VchTemplateConfigsListPlugin_3", (String)"fi-ai-formplugin", (Object[])new Object[0])), "1"));
        enableList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7981\u7528", (String)"VchTemplateConfigsListPlugin_4", (String)"fi-ai-formplugin", (Object[])new Object[0])), "0"));
        enableCol.setComboItems(enableList);
        enableCol.setDefaultValue("1");
        enableCol.setEntityField(false);
        listFilterColumns.add(enableCol);
        this.getPageCache().put(KEY_ENABLE_FILTER, "1");
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
    }

    public void click(EventObject evt) {
        String ctlKey;
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        switch (ctlKey = ctlSource.getKey()) {
            case "newvchtemplatebtn": {
                this.newTemplate();
                break;
            }
            case "delvchtemplatebtn": {
                this.checkOrgIsSelect();
                this.confirmDeleteOperate();
                break;
            }
            case "copyvchtemplatebtn": {
                this.checkOrgIsSelect();
                this.copyTemplateOperate();
                break;
            }
            case "changevchtemplatebtn": {
                this.checkOrgIsSelect();
                this.changeTemplateOperate();
                break;
            }
        }
    }

    private void changeTemplateOperate() {
        boolean permission = this.checkPermission("4715a0df000000ac");
        if (!permission) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u4fee\u6539\u6743\u9650\u3002", (String)"VchTemplateConfigsListPlugin_40", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        permission = VchTempDataRulePermUtil.checkOptDataRule((String)"4715a0df000000ac", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)this.getSelectedIds())});
        if (!permission) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u9009\u4e2d[\u51ed\u8bc1\u6a21\u677f]\u7684[\u4fee\u6539]\u64cd\u4f5c\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VchTemplateConfigsListPlugin_53", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        EntryGrid eg = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        int[] rows = eg.getEntryState().getSelectedRows();
        if (rows != null && rows.length > 0) {
            Long useOrgID;
            ArrayList<Long> pkValueArr = new ArrayList<Long>(rows.length);
            ArrayList<Long> createOrgArr = new ArrayList<Long>(rows.length);
            for (int i = 0; i < rows.length; ++i) {
                DynamicObject entryterity = this.getView().getModel().getEntryRowEntity(KEY_ENTRYENTITY, rows[i]);
                Long pkValue = Long.parseLong(entryterity.get("fbillid").toString());
                Long createOrg = Long.parseLong(entryterity.get("orgapply.id").toString());
                pkValueArr.add(pkValue);
                createOrgArr.add(createOrg);
            }
            if (pkValueArr.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u4fee\u6539\u3002", (String)"VchTemplateConfigsListPlugin_41", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            String useOrgIDStr = this.getPageCache().get(KEY_ORG_FILTER);
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)useOrgIDStr) && (useOrgID = Long.valueOf(Long.parseLong(useOrgIDStr))).intValue() != ((Long)createOrgArr.get(0)).intValue()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u975e\u672c\u7ec4\u7ec7\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"VchTemplateConfigsListPlugin_46", (String)"fi-ai-formplugin", (Object[])new Object[0]), new Object[0]));
                return;
            }
            Set lockIDs = new HashSet();
            try {
                HashSet set = new HashSet(1);
                set.add(pkValueArr.get(0));
                lockIDs = MutexVchTempleteUtil.requireMutex((String)TYPE, set, (int)60);
                if (lockIDs.isEmpty()) {
                    HashMap map = MutexVchTempleteUtil.getPseron((String)TYPE, (Long)((Long)pkValueArr.get(0)));
                    String name = map.isEmpty() ? "" : (String)map.get("name");
                    this.getPageCache().put("templeteId", ((Long)pkValueArr.get(0)).toString());
                    HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
                    btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"VchTemplateConfigsListPlugin_42", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u67e5\u770b\u5355\u636e", (String)"VchTemplateConfigsListPlugin_43", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6b63\u5728\u7f16\u8f91\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VchTemplateConfigsListPlugin_44", (String)"fi-ai-formplugin", (Object[])new Object[0]), name), null, MessageBoxOptions.YesNo, null, new ConfirmCallBackListener("viewTemplete"), btnNameMaps, SerializationUtils.toJsonString(new HashMap()));
                }
                this.showTemplateEditForm((Long)lockIDs.iterator().next(), null, "EDIT");
            }
            catch (Exception e) {
                try (TXHandle x = TX.requiresNew();){
                    try {
                        MutexVchTempleteUtil.batchRelease((String)TYPE, lockIDs);
                    }
                    catch (Throwable t) {
                        x.markRollback();
                    }
                }
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"VchTemplateConfigsListPlugin_45", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
    }

    private void copyTemplateOperate() {
        boolean permission = this.checkPermission("47156aff000000ac");
        if (!permission) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u65b0\u589e\u6743\u9650\u3002", (String)"VchTemplateConfigsListPlugin_5", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        permission = VchTempDataRulePermUtil.checkOptDataRule((String)"47156aff000000ac", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)this.getSelectedIds())});
        if (!permission) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u9009\u4e2d[\u51ed\u8bc1\u6a21\u677f]\u7684[\u65b0\u589e(\u590d\u5236)]\u64cd\u4f5c\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VchTemplateConfigsListPlugin_55", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        EntryGrid eg = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        int[] rows = eg.getEntryState().getSelectedRows();
        if (rows != null && rows.length > 0) {
            ArrayList<Long> pkValueArr = new ArrayList<Long>(rows.length);
            for (int i = 0; i < rows.length; ++i) {
                DynamicObject entryterity = this.getView().getModel().getEntryRowEntity(KEY_ENTRYENTITY, rows[i]);
                Long pkValue = Long.parseLong(entryterity.get("fbillid").toString());
                pkValueArr.add(pkValue);
            }
            if (pkValueArr.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\u3002", (String)"VchTemplateConfigsListPlugin_6", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showTemplateEditForm((Long)pkValueArr.get(0), null, "COPY");
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"VchTemplateConfigsListPlugin_45", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean confirmDeleteOperate() {
        boolean permission = this.checkPermission("4715e1f1000000ac");
        if (!permission) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5220\u9664\u6743\u9650\u3002", (String)"VchTemplateConfigsListPlugin_8", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return false;
        }
        permission = VchTempDataRulePermUtil.checkOptDataRule((String)"4715e1f1000000ac", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)this.getSelectedIds())});
        if (!permission) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u9009\u4e2d[\u51ed\u8bc1\u6a21\u677f]\u7684[\u5220\u9664]\u64cd\u4f5c\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VchTemplateConfigsListPlugin_54", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return false;
        }
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(KEY_ENTRYENTITY);
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows != null && rows.length > 0) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("callBackId", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u9009\u62e9\u7684\u51ed\u8bc1\u6a21\u677f\uff1f", (String)"VchTemplateConfigsListPlugin_9", (String)"fi-ai-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBackListener);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u51ed\u8bc1\u6a21\u677f\u3002", (String)"VchTemplateConfigsListPlugin_10", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getCallBackId().equals("callBackId")) {
            int result = e.getResult().getValue();
            if (result == MessageBoxResult.Yes.getValue()) {
                this.delTemplate();
            }
        } else if ("viewTemplete".equals(e.getCallBackId())) {
            MessageBoxResult result = e.getResult();
            if (MessageBoxResult.Yes.equals((Object)result) && kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)this.getPageCache().get("templeteId")) && !"0".equals(this.getPageCache().get("templeteId"))) {
                Long templeteId = Long.parseLong(this.getPageCache().get("templeteId"));
                this.getPageCache().remove("templeteId");
                this.showTemplateEditForm(templeteId, null, "VIEW");
            }
        } else if ("refreshMultiLang".equals(e.getCallBackId())) {
            MessageBoxResult result = e.getResult();
            if (MessageBoxResult.Yes.equals((Object)result)) {
                VchTemplateMultiLangUtil.upgradeVchTemplateMultiLang(this.getModel(), this.getView());
                this.initTree();
            } else {
                this.initTree();
            }
        }
    }

    private void delTemplate() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(KEY_ENTRYENTITY);
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows != null && rows.length > 0) {
            ArrayList<Long> pkValueArr = new ArrayList<Long>(rows.length);
            for (int row : rows) {
                DynamicObjectCollection entryterity = this.getView().getModel().getEntryEntity(KEY_ENTRYENTITY);
                Long pkValue = Long.parseLong(((DynamicObject)entryterity.get(row)).get("fbillid").toString());
                pkValueArr.add(pkValue);
            }
            String useOrgIDStr = this.getPageCache().get(KEY_ORG_FILTER);
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)useOrgIDStr) && this.isCreateDelete(pkValueArr, useOrgIDStr)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u6570\u636e\u4e2d\u5b58\u5728\u5f53\u524d\u7ec4\u7ec7\u4e0d\u662f\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"VchTemplateConfigsListPlugin_38", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            if (this.isEnable(pkValueArr)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u542b\u88ab\u7981\u7528\u7684\u6570\u636e\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"VchTemplateConfigsListPlugin_11", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("ignorerefentityids", "ai_buildreport");
            OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"ai_vchtemplate", (Object[])pkValueArr.toArray(), (OperateOption)option);
            if (result.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"VchTemplateConfigsListPlugin_12", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showOperationResult(result);
            }
            String nodeId = this.getPageCache().get(KEY_BILLNO);
            this.loadTempInfo(nodeId);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("ai_vchtemplateedit".equals(closedCallBackEvent.getActionId())) {
            String billno = this.getPageCache().get(KEY_BILLNO);
            if (null != billno && billno.trim().length() > 0) {
                this.loadTempInfo(billno);
            }
        } else if ("import".equals(closedCallBackEvent.getActionId())) {
            this.doImport((Map)closedCallBackEvent.getReturnData());
        }
    }

    private void newTemplate() {
        boolean isdap;
        boolean permission = this.checkNewPermission();
        if (!permission) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u65b0\u589e\u6743\u9650\u3002", (String)"VchTemplateConfigsListPlugin_5", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        String billNo = this.getPageCache().get(KEY_BILLNO);
        if (billNo.indexOf(FLAG_AI_EVENTCLASS) < 0) {
            try {
                if ("1".equals(billNo)) {
                    billNo = "";
                }
                EntityMetadataCache.getDataEntityType((String)billNo);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u5de6\u6811\u9009\u62e9\u5177\u4f53\u7684\u5355\u636e\u8fdb\u884c\u65b0\u589e\u3002", (String)"VchTemplateConfigsListPlugin_13", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if (!(isdap = ((Boolean)this.getModel().getValue("isdap")).booleanValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u201c\u53c2\u4e0e\u751f\u6210\u51ed\u8bc1\u201d\u3002", (String)"VchTemplateConfigsListPlugin_14", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showTemplateEditForm(0L, billNo, "NEW");
    }

    private void showTemplateEditForm(Long pkValue, String billNo, String status) {
        String useOrgIdStr = this.getPageCache().get(KEY_ORG_FILTER);
        if (("EDIT".equals(status) || "NEW".equals(status) || "COPY".equals(status)) && kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)useOrgIdStr)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"VchTemplateConfigsListPlugin_36", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("NEW".equals(status) || "COPY".equals(status)) {
            List createOrgs = BaseDataServiceHelper.getCreateOrgList((String)"ai_vchtemplate");
            if (createOrgs.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6709\u6743\u9650\u521b\u5efa\u51ed\u8bc1\u6a21\u677f\u7684\u7ec4\u7ec7\u5355\u5143\uff0c\u8bf7\u68c0\u67e5\u529f\u80fd\u6743\u9650\u6216\u63a7\u5236\u89c4\u5219\u662f\u5426\u914d\u7f6e\u6b63\u786e\u3002", (String)"VchTemplateConfigsListPlugin_39", (String)"fi-ai-formplugin", (Object[])new Object[0]), new Object[0]));
                return;
            }
            HashSet createOrgSet = new HashSet(createOrgs);
            Long useOrgId = Long.valueOf(useOrgIdStr);
            if (!createOrgSet.contains(useOrgId) && !createOrgs.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u80fd\u521b\u5efa\u51ed\u8bc1\u6a21\u677f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u201c\u57fa\u7840\u6570\u636e\u7ba1\u63a7\u7b56\u7565\u201d\u63a7\u5236\u89c4\u5219\u5904\u6dfb\u52a0\u4e3a\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"VchTemplateConfigsListPlugin_47", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ai_vchtemplateedit");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submaintab_");
        showParameter.setParentPageId(this.getView().getPageId());
        if ("COPY".equals(status)) {
            showParameter.setCustomParam("status", (Object)"COPY");
            showParameter.setCustomParam("copyid", (Object)pkValue.toString());
            pkValue = 0L;
        } else if ("EDIT".equals(status)) {
            showParameter.setCustomParam("status", (Object)"EDIT");
        } else if ("VIEW".equals(status)) {
            showParameter.setCustomParam("status", (Object)"VIEW");
        }
        showParameter.setCustomParam("pkvalue", (Object)pkValue.toString());
        showParameter.setCustomParam(KEY_BILLNO, (Object)billNo);
        showParameter.setCustomParam(PERM_ORGS, (Object)this.getPageCache().get(PERM_ORGS));
        showParameter.setCustomParam(KEY_ORG_FILTER, (Object)this.getPageCache().get(KEY_ORG_FILTER));
        if (pkValue == 0L) {
            String orgId = this.getPageCache().get(KEY_ORG_FILTER);
            boolean isEmpty = StringUtils.isEmpty((String)orgId);
            if (!isEmpty) {
                showParameter.setCustomParam("createorg", (Object)orgId);
            }
            this.getPageCache().put("createOrg", orgId);
        } else {
            DynamicObject tp = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"ai_vchtemplate", (String)"id,org,createorg");
            Long createOrgID = tp.getLong("createorg.id") == 0L ? tp.getLong("org.id") : tp.getLong("createorg.id");
            this.getPageCache().put("createOrg", createOrgID.toString());
        }
        if ("NEW".equals(status)) {
            showParameter.setCustomParam("status", (Object)"NEW");
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ai_vchtemplateedit");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (FahOptimizeControlPanel.getCacheVchTemplateMultiLang()) {
            this.initTree();
        } else {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u5217\u8868\u672a\u505a\u591a\u8bed\u8a00\u5347\u7ea7\uff0c\u53ef\u80fd\u5bfc\u81f4\u90e8\u5206\u5b57\u6bb5\u663e\u793a\u5f02\u5e38\uff0c\u662f\u5426\u8fdb\u884c\u591a\u8bed\u8a00\u5347\u7ea7\uff1f\uff08\u6570\u636e\u5347\u7ea7\u4ec5\u5f71\u54cd\u5217\u8868\u5b57\u6bb5\u663e\u793a\uff09", (String)"VchTemplateConfigsListPlugin_62", (String)"fi-ai-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("refreshMultiLang", (IFormPlugin)this));
        }
    }

    private void initTree() {
        List children;
        TreeNode aiEventRoot;
        HashMap<String, List<String>> basedataInfo = new HashMap<String, List<String>>();
        TreeNode firstRoot = this.initBillTree(basedataInfo);
        this.treev.addNode(firstRoot);
        if (!ProductSettingServiceHelper.hasBlackFeature((String)"iep", (String)"fi_ai") && null != (aiEventRoot = this.initAIEventTree())) {
            this.treev.addNode(aiEventRoot);
            this.getPageCache().put("secondRoot", SerializationUtils.toJsonString((Object)aiEventRoot));
        }
        TreeNode focusNode = null != (children = firstRoot.getChildren()) && !children.isEmpty() ? (TreeNode)children.get(0) : firstRoot;
        this.treev.focusNode(focusNode);
        this.getPageCache().put("baseInfo", SerializationUtils.toJsonString(basedataInfo));
        this.treev.treeNodeClick(focusNode.getParentid(), focusNode.getId());
        this.getPageCache().put("firstRoot", SerializationUtils.toJsonString((Object)firstRoot));
    }

    private TreeNode initAIEventTree() {
        TreeNode node;
        QFilter qfilter = new QFilter("id", ">", (Object)0L).and(new QFilter("status", "=", (Object)"C")).and(new QFilter("appversion", "<>", (Object)"1"));
        DynamicObject[] eventClasses = BusinessDataServiceHelper.load((String)"ai_eventclass", (String)"id,group.id,name", (QFilter[])qfilter.toArray());
        if (eventClasses.length == 0) {
            return null;
        }
        TreeNode aiEventRoot = new TreeNode();
        aiEventRoot.setParentid("");
        aiEventRoot.setId(this.AI_EVENT_ROOT_ID);
        aiEventRoot.setText(ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\uff08\u8001\u6a21\u578b\uff09", (String)"VchTemplateConfigsListPlugin_15", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        aiEventRoot.setIsOpened(true);
        Set groups = Stream.of(eventClasses).map(e -> e.getLong("group.id")).collect(Collectors.toSet());
        DynamicObject[] eventGrps = BusinessDataServiceHelper.load((String)"ai_eventgroup", (String)"id,parent.id,name", (QFilter[])new QFilter("id", "in", groups).toArray(), (String)"longnumber asc");
        HashMap<String, TreeNode> nodeCache = new HashMap<String, TreeNode>(8);
        for (DynamicObject eventGrp : eventGrps) {
            long parentId = eventGrp.getLong("parent.id");
            node = new TreeNode();
            if (parentId == 0L) {
                aiEventRoot.addChild(node);
                node.setParentid(this.AI_EVENT_ROOT_ID);
            } else {
                String parentNodeId = FLAG_AI_EVENTGROUP + parentId;
                TreeNode parentNode = (TreeNode)nodeCache.get(parentNodeId);
                if (null != parentNode) {
                    parentNode.addChild(node);
                    node.setParentid(parentNodeId);
                }
            }
            long id = eventGrp.getLong("id");
            String nodeId = FLAG_AI_EVENTGROUP + id;
            node.setId(nodeId);
            node.setText(eventGrp.getString("name"));
            node.setIsOpened(false);
            nodeCache.put(nodeId, node);
        }
        for (DynamicObject eventClass : eventClasses) {
            long groupId = eventClass.getLong("group.id");
            node = new TreeNode();
            if (groupId == 0L) {
                aiEventRoot.addChild(node);
                node.setParentid(this.AI_EVENT_ROOT_ID);
            } else {
                String parentNodeId = FLAG_AI_EVENTGROUP + groupId;
                ((TreeNode)nodeCache.get(parentNodeId)).addChild(node);
                node.setParentid(parentNodeId);
            }
            node.setId(FLAG_AI_EVENTCLASS + eventClass.getLong("id"));
            node.setText(eventClass.getString("name"));
            node.setIsOpened(false);
        }
        return aiEventRoot;
    }

    private TreeNode initBillTree(Map<String, List<String>> basedataInfo) {
        TreeNode firstRoot = VchTemplateConfigsListPlugin.createTreeNode("", this.BILL_ROOT_ID, ResManager.loadKDString((String)"\u5355\u636e\u5217\u8868", (String)"VchTemplateConfigsListPlugin_16", (String)"fi-ai-formplugin", (Object[])new Object[0]), true);
        this.createBillNodes(basedataInfo, firstRoot);
        this.createEventNodes(basedataInfo, firstRoot);
        return firstRoot;
    }

    private void createEventNodes(Map<String, List<String>> baseDataInfo, TreeNode firstRoot) {
        QFilter qfilter = new QFilter("id", ">", (Object)0L).and(new QFilter("latestversion", "=", (Object)"1")).and(new QFilter("status", "=", (Object)"C")).and(new QFilter("appversion", "=", (Object)"1"));
        DynamicObject[] eventClasses = BusinessDataServiceHelper.load((String)"fah_ext_datamodel", (String)"number,name,group.id,group.name", (QFilter[])qfilter.toArray(), (String)"group,name");
        String cloudFIId = FormBuilderConstant.CLOUD_FI_ID;
        String eventAppId = FormBuilderConstant.BIZ_APP_ID;
        LinkedHashMap<String, TreeNode> eventGroupMap = new LinkedHashMap<String, TreeNode>();
        for (DynamicObject eventClass : eventClasses) {
            String groupId = eventClass.getString("group.id");
            if (null == groupId) continue;
            String groupName = eventClass.getString("group.name");
            TreeNode groupNode = eventGroupMap.computeIfAbsent(groupId, v -> VchTemplateConfigsListPlugin.createTreeNode(eventAppId, groupId, groupName, false));
            String eventId = DataModelDaoImpl.getTableName((String)eventClass.getString(KEY_BILLNO));
            String eventName = eventClass.getString("name");
            TreeNode eventNode = VchTemplateConfigsListPlugin.createTreeNode(groupId, eventId, eventName, false);
            groupNode.addChild(eventNode);
            baseDataInfo.computeIfAbsent(groupId, v -> new ArrayList()).add(eventId);
            baseDataInfo.computeIfAbsent(eventAppId, v -> new ArrayList()).add(eventId);
            baseDataInfo.computeIfAbsent(cloudFIId, v -> new ArrayList()).add(eventId);
        }
        if (!eventGroupMap.isEmpty()) {
            TreeNode eventAppNode = VchTemplateConfigsListPlugin.createTreeNode(this.BILL_ROOT_ID, eventAppId, ResManager.loadKDString((String)"\u4f1a\u8ba1\u4e8b\u4ef6\u5e93", (String)"VchTemplateConfigsListPlugin_48", (String)"fi-ai-formplugin", (Object[])new Object[0]), false);
            eventAppNode.addChildren(new ArrayList(eventGroupMap.values()));
            TreeNode fiNode = firstRoot.getTreeNode(cloudFIId);
            if (null != fiNode) {
                fiNode.addChild(0, eventAppNode);
            }
        }
    }

    private void createBillNodes(Map<String, List<String>> baseDataInfo, TreeNode firstRoot) {
        DynamicObject[] objects;
        HashMap<String, Map> cloudAndAppMap = new HashMap<String, Map>();
        HashMap<String, Map> bizAppAndEntityMap = new HashMap<String, Map>();
        QFilter modeltypeQfilter = new QFilter("modeltype", "=", (Object)"BillFormModel");
        QFilter voucherQfilter = new QFilter("voucher", "=", (Object)CheckBoxEnum.TRUE.getValue());
        QFilter appFilter = new QFilter("bizappid.deploystatus", "=", (Object)"2").and(new QFilter("bizappid.number", "<>", (Object)"edah"));
        for (DynamicObject row : objects = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"id,name,bizappid.id,bizappid.name,bizappid.bizcloud.id", (QFilter[])new QFilter[]{voucherQfilter, modeltypeQfilter, appFilter}, (String)"bizappid.bizcloud.name,bizappid.name,name")) {
            String cloudId = row.getString("bizappid.bizcloud.id");
            String appId = row.getString("bizappid.id");
            if (null == cloudId || null == appId) continue;
            cloudAndAppMap.computeIfAbsent(cloudId, v -> new LinkedHashMap()).putIfAbsent(appId, row.getString("bizappid.name"));
            bizAppAndEntityMap.computeIfAbsent(appId, v -> new LinkedHashMap()).put(row.getString("id"), row.getString("name"));
            baseDataInfo.computeIfAbsent(cloudId, v -> new ArrayList()).add(row.getString("id"));
            baseDataInfo.computeIfAbsent(appId, v -> new ArrayList()).add(row.getString("id"));
        }
        DynamicObjectCollection clouds = BizCloudServiceHelp.getAllBizClouds();
        for (DynamicObject cloud : clouds) {
            String cloudId = cloud.getString("id");
            Map appMap = (Map)cloudAndAppMap.get(cloudId);
            if (null == appMap) continue;
            String cloudName = cloud.getString("name");
            TreeNode cloudNode = VchTemplateConfigsListPlugin.createTreeNode(this.BILL_ROOT_ID, cloudId, cloudName, false);
            firstRoot.addChild(cloudNode);
            for (Map.Entry appEntry : appMap.entrySet()) {
                String appId = (String)appEntry.getKey();
                String appName = (String)appEntry.getValue();
                TreeNode appNode = VchTemplateConfigsListPlugin.createTreeNode(cloudId, appId, appName, false);
                Map entityMap = (Map)bizAppAndEntityMap.get(appId);
                if (null == entityMap) continue;
                cloudNode.addChild(appNode);
                for (Map.Entry entry : entityMap.entrySet()) {
                    TreeNode childNode = VchTemplateConfigsListPlugin.createTreeNode(appId, (String)entry.getKey(), (String)entry.getValue(), false);
                    appNode.addChild(childNode);
                }
            }
        }
    }

    private static TreeNode createTreeNode(String parentId, String id, String name, boolean isOpened) {
        TreeNode node = new TreeNode();
        node.setParentid(parentId);
        node.setId(id);
        node.setText(name);
        node.setIsOpened(isOpened);
        return node;
    }

    public void queryTreeNodeChildren(TreeNodeEvent arg0) {
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        String nodeId = (String)evt.getNodeId();
        this.loadTempInfo(nodeId);
    }

    private void loadTempInfo(String nodeId) {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String baseInfo = this.getPageCache().get("baseInfo");
        pageCache.put(KEY_BILLNO, nodeId);
        if (baseInfo != null) {
            Map basedataInfo = (Map)SerializationUtils.fromJsonString((String)baseInfo, Map.class);
            if (this.BILL_ROOT_ID.equals(nodeId) || basedataInfo.containsKey(nodeId) || this.AI_EVENT_ROOT_ID.equals(nodeId) || nodeId.indexOf(FLAG_AI_EVENTGROUP) == 0) {
                this.initAllEntity(basedataInfo);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"fieldsetpanelap"});
                this.getView().updateView(KEY_ENTRYENTITY);
                return;
            }
        }
        this.initEntity(nodeId);
        this.getView().updateView(KEY_ENTRYENTITY);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"fieldsetpanelap"});
    }

    private String getEntityIepOprt(String number) {
        if (QueryServiceHelper.exists((String)"bos_entityobject", (Object)number)) {
            Operations ops = EntityMetadataCache.getDataEntityOperations((String)number);
            return ops.getAudit();
        }
        return null;
    }

    private void setDefaultValue(String nodeId) {
        IDataModel model = this.getModel();
        model.deleteEntryData(KEY_ENTRYENTITY);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        Toolbar toolbarap = (Toolbar)this.getView().getControl(TOOLBARAP);
        toolbarap.addItemClickListener((ItemClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)KEY_FBILLNO, (CharSequence)evt.getFieldName())) {
            int rowIndex = evt.getRowIndex();
            String fbillid = (String)this.getModel().getValue("fbillid", rowIndex);
            if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)fbillid)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u51ed\u8bc1\u6a21\u677fID\u6709\u8bef\uff0c\u65e0\u6cd5\u6253\u5f00\u51ed\u8bc1\u6a21\u677f\u3002", (String)"VchTemplateConfigsListPlugin_19", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            long vchTempId = Long.parseLong(fbillid);
            this.showTemplateEditForm(vchTempId, null, "VIEW");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("export".equalsIgnoreCase(evt.getItemKey())) {
            this.checkOrgIsSelect();
            this.doExport();
        } else if ("import".equalsIgnoreCase(evt.getItemKey())) {
            this.checkOrgIsSelect();
            this.uploadFileAndImport();
        } else if ("assign".equalsIgnoreCase(evt.getItemKey())) {
            this.assign();
        } else if ("assign_search".equalsIgnoreCase(evt.getItemKey())) {
            this.assign_search();
        } else if ("disable".equalsIgnoreCase(evt.getItemKey())) {
            this.checkOrgIsSelect();
            this.disable();
        } else if ("enable".equalsIgnoreCase(evt.getItemKey())) {
            this.checkOrgIsSelect();
            this.enable();
        }
    }

    private void disable() {
        long selectOrg;
        boolean permission = this.checkPermission("47160c2b000000ac");
        if (!permission) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u7981\u7528\u6743\u9650\u3002", (String)"VchTemplateConfigsListPlugin_20", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        permission = VchTempDataRulePermUtil.checkOptDataRule((String)"47160c2b000000ac", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)this.getSelectedIds())});
        if (!permission) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u9009\u4e2d[\u51ed\u8bc1\u6a21\u677f]\u7684[\u7981\u7528]\u64cd\u4f5c\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VchTemplateConfigsListPlugin_51", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        int[] selectRows = ((EntryGrid)this.getControl(KEY_ENTRYENTITY)).getSelectRows();
        HashSet<Long> createOrg = new HashSet<Long>(2);
        for (int i : selectRows) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(KEY_ENTRYENTITY, i);
            createOrg.add(rowEntity.getLong("orgapply.id"));
        }
        String org_filter = this.getPageCache().get(KEY_ORG_FILTER);
        long l = selectOrg = org_filter != null ? Long.parseLong(org_filter) : 0L;
        if (createOrg.stream().anyMatch(orgId -> !orgId.equals(selectOrg))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u7981\u7528\u975e\u672c\u7ec4\u7ec7\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"VchTemplateConfigsListPlugin_59", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        int[] rows = grid.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"VchTemplateConfigsListPlugin_21", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> pkList = new ArrayList<Long>(rows.length);
        for (int index : rows) {
            String billid = (String)this.getModel().getValue("fbillid", index);
            pkList.add(Long.parseLong(billid));
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"disable", (String)"ai_vchtemplate", (Object[])pkList.toArray(), (OperateOption)OperateOption.create());
        String nodeId = this.getPageCache().get(KEY_BILLNO);
        this.loadTempInfo(nodeId);
        DynamicObjectCollection tps = QueryServiceHelper.query((String)"ai_vchtemplate", (String)"fsourcebill.id,eventclass.id", (QFilter[])new QFilter[]{new QFilter("id", "in", pkList)});
        for (DynamicObject tp : tps) {
            String entity = tp.getString("fsourcebill.id");
            long eventclass = tp.getLong("eventclass.id");
            DapCache.clearDapConfigCacheByEntity((String)entity, (long)eventclass);
        }
        this.clearDapConfigCache();
        if (result.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"VchTemplateConfigsListPlugin_22", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        } else {
            result.getAllErrorOrValidateInfo();
            StringBuilder strb = new StringBuilder();
            for (IOperateInfo info : result.getAllErrorOrValidateInfo()) {
                strb.append(info.getMessage());
            }
            this.getView().showTipNotification(strb.toString());
        }
    }

    private void enable() {
        boolean permission = this.checkPermission("4730fc5d000000ac");
        if (!permission) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u542f\u7528\u6743\u9650\u3002", (String)"VchTemplateConfigsListPlugin_23", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        permission = VchTempDataRulePermUtil.checkOptDataRule((String)"4730fc5d000000ac", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)this.getSelectedIds())});
        if (!permission) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u9009\u4e2d[\u51ed\u8bc1\u6a21\u677f]\u7684[\u542f\u7528]\u64cd\u4f5c\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VchTemplateConfigsListPlugin_52", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        int[] rows = grid.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"VchTemplateConfigsListPlugin_21", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> pkList = new ArrayList<Long>(rows.length);
        for (int index : rows) {
            String billid = (String)this.getModel().getValue("fbillid", index);
            pkList.add(Long.parseLong(billid));
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"enable", (String)"ai_vchtemplate", (Object[])pkList.toArray(), (OperateOption)OperateOption.create());
        String nodeId = this.getPageCache().get(KEY_BILLNO);
        this.loadTempInfo(nodeId);
        DynamicObjectCollection tps = QueryServiceHelper.query((String)"ai_vchtemplate", (String)"fsourcebill.id,eventclass.id", (QFilter[])new QFilter[]{new QFilter("id", "in", pkList)});
        for (DynamicObject tp : tps) {
            String entity = tp.getString("fsourcebill.id");
            long eventclass = tp.getLong("eventclass.id");
            DapCache.clearDapConfigCacheByEntity((String)entity, (long)eventclass);
        }
        this.clearDapConfigCache();
        if (result.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"VchTemplateConfigsListPlugin_24", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        } else {
            result.getAllErrorOrValidateInfo();
            StringBuilder strb = new StringBuilder();
            for (IOperateInfo info : result.getAllErrorOrValidateInfo()) {
                strb.append(info.getMessage());
            }
            this.getView().showTipNotification(strb.toString());
        }
    }

    private void assign() {
        if (!this.checkFunctionPerm(assignPermItemID)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u5206\u914d\u6743\u9650\u3002", (String)"VchTemplateConfigsListPlugin_25", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean permission = VchTempDataRulePermUtil.checkOptDataRule((String)assignPermItemID, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)this.getSelectedIds())});
        if (!permission) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u9009\u4e2d[\u51ed\u8bc1\u6a21\u677f]\u7684[\u5206\u914d]\u64cd\u4f5c\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VchTemplateConfigsListPlugin_50", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        int[] rows = grid.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"VchTemplateConfigsListPlugin_21", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> pkList = new ArrayList<Long>(rows.length);
        ArrayList<String> numbers = new ArrayList<String>(rows.length);
        for (int index : rows) {
            String number;
            String billid = (String)this.getModel().getValue("fbillid", index);
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)billid)) {
                pkList.add(Long.parseLong(billid));
            }
            if (!kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)(number = (String)this.getModel().getValue(KEY_FBILLNO, index)))) continue;
            numbers.add(number);
        }
        if (this.isEnable(pkList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u6570\u636e\u4e2d\u6709\u88ab\u7981\u7528\u6570\u636e\uff0c\u4e0d\u80fd\u5206\u914d\u3002", (String)"VchTemplateConfigsListPlugin_26", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.isHasAssign(pkList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u6570\u636e\u4e2d\u5b58\u5728\u4e0d\u662f\u5206\u914d\u7b56\u7565\u7684\uff0c\u4e0d\u80fd\u6267\u884c\u5206\u914d\u3002", (String)"VchTemplateConfigsListPlugin_37", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        String useOrgIDStr = this.getPageCache().get(KEY_ORG_FILTER);
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)useOrgIDStr)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"VchTemplateConfigsListPlugin_27", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.isCreateAssign(pkList, useOrgIDStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u6570\u636e\u4e2d\u5b58\u5728\u5f53\u524d\u7ec4\u7ec7\u4e0d\u662f\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5206\u914d\u3002", (String)"VchTemplateConfigsListPlugin_56", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter param = new FormShowParameter();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ids", pkList);
        params.put("numbers", numbers);
        params.put("query", Boolean.FALSE);
        params.put("entityNumber", "ai_vchtemplate");
        params.put("useOrgId", Long.valueOf(useOrgIDStr));
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("bd_assign");
        param.setCustomParams(params);
        this.getView().showForm(param);
    }

    private boolean isCreateAssign(List<Long> pkList, String useOrgIDStr) {
        QFilter qf = new QFilter("createorg", "!=", (Object)Long.parseLong(useOrgIDStr));
        QFilter qf0 = new QFilter("id", "in", pkList);
        QFilter qf1 = new QFilter("ctrlstrategy", "=", (Object)"2");
        return QueryServiceHelper.exists((String)"ai_vchtemplate", (QFilter[])new QFilter[]{qf, qf0, qf1});
    }

    private boolean isCreateDelete(List<Long> pkList, String useOrgIDStr) {
        QFilter qf = new QFilter("createorg", "!=", (Object)Long.parseLong(useOrgIDStr));
        QFilter qf0 = new QFilter("id", "in", pkList);
        return QueryServiceHelper.exists((String)"ai_vchtemplate", (QFilter[])new QFilter[]{qf, qf0});
    }

    private boolean isHasAssign(List<Long> pkList) {
        ArrayList<String> isAssign = new ArrayList<String>();
        isAssign.add("1");
        isAssign.add("2");
        QFilter qf = new QFilter("ctrlstrategy", "not in", isAssign);
        QFilter qf0 = new QFilter("id", "in", pkList);
        return QueryServiceHelper.exists((String)"ai_vchtemplate", (QFilter[])new QFilter[]{qf, qf0});
    }

    private void assign_search() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        int[] rows = grid.getSelectRows();
        if (rows == null || rows.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"VchTemplateConfigsListPlugin_21", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> pkList = new ArrayList<Long>(rows.length);
        for (int index : rows) {
            String billid = (String)this.getModel().getValue("fbillid", index);
            pkList.add(Long.parseLong(billid));
        }
        FormShowParameter param = new FormShowParameter();
        HashMap<String, Object> params = new HashMap<String, Object>(6);
        params.put("ids", pkList);
        params.put("entityNumber", "ai_vchtemplate");
        String useOrgIDStr = this.getPageCache().get(KEY_ORG_FILTER);
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)useOrgIDStr)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"VchTemplateConfigsListPlugin_27", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        params.put("useOrgId", Long.valueOf(useOrgIDStr));
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("bd_assign_query");
        param.setCustomParams(params);
        this.getView().showForm(param);
    }

    protected boolean checkFunctionPerm(String permItemID) {
        String org = this.getPageCache().get(KEY_ORG_FILTER);
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)permItemID) || kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)org)) {
            return true;
        }
        long userId = ContextUtil.getUserId();
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)"iep");
        String bizAppId = appInfo.getId();
        int ret = permissionService.checkPermission(userId, "DIM_ORG", Long.parseLong(org), bizAppId, "ai_vchtemplate", permItemID);
        return ret == 1;
    }

    private void uploadFileAndImport() {
        boolean permission = this.checkPermission("4730fc9f000003ae");
        if (!permission) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u5bfc\u5165\u6743\u9650\u3002", (String)"VchTemplateConfigsListPlugin_28", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ai_importtemplate");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("org", this.getPageCache().get(KEY_ORG_FILTER));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "import");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExport() {
        boolean permission = this.checkPermission("4730fc9f000004ae");
        if (!permission) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u5bfc\u51fa\u6743\u9650\u3002", (String)"VchTemplateConfigsListPlugin_29", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        permission = VchTempDataRulePermUtil.checkOptDataRule((String)"4730fc9f000004ae", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)this.getSelectedIds())});
        if (!permission) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5f53\u524d\u9009\u4e2d[\u51ed\u8bc1\u6a21\u677f]\u7684[\u5bfc\u51fa]\u64cd\u4f5c\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"VchTemplateConfigsListPlugin_49", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        long[] ids = this.getSelectedIds();
        if (ids == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u6a21\u677f\u3002", (String)"VchTemplateConfigsListPlugin_30", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        String localPath = DapFileUtil.genLocalPath();
        File file = DapFileUtil.genFileByLocalPath();
        Map result = DapFileUtil.exportTemplate((String)localPath, (long[])ids);
        Object errMessage = result.get("error");
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank(errMessage)) {
            this.getView().showTipNotification((String)errMessage);
            return;
        }
        Object warnMessage = result.get("warning");
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank(warnMessage)) {
            this.getView().showMessage((String)warnMessage);
            return;
        }
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(FilenameUtils.getFullPath((String)((String)result.get("fileName"))) + FilenameUtils.getName((String)((String)result.get("fileName")))));
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(ids[0] + ".zip", in, 5000);
            String tempFileId = UrlUtil.getParam((String)urls, (String)"id");
            HashMap<String, Object> refEntityMap = new HashMap<String, Object>(3);
            refEntityMap.put("entityNum", "ai_vchtemplate");
            refEntityMap.put("appId", EntityMetadataCache.getDataEntityType((String)"ai_vchtemplate").getAppId());
            refEntityMap.put("billPkId", ids[0]);
            CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true)).put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntityMap), 7200);
            this.getView().openUrl(urls);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        DapFileUtil.deleteFile((File)file);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"VchTemplateConfigsListPlugin_31", (String)"fi-ai-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
        OperationLogUtils.addLog((String)"ai_vchtemplateedit", (String)ResManager.loadKDString((String)"\u5bfc\u51fa\u51ed\u8bc1\u6a21\u677f", (String)"VchTemplateConfigsListPlugin_60", (String)"fi-ai-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u51ed\u8bc1\u6a21\u677f", (String)"VchTemplateConfigsListPlugin_61", (String)"fi-ai-formplugin", (Object[])new Object[0]), kd.bos.dataentity.utils.StringUtils.join((Object[])this.getSelectedBillNos(), (String)",")));
    }

    private long[] getSelectedIds() {
        EntryGrid entry = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        int[] rows = entry.getSelectRows();
        if (rows == null || rows.length == 0) {
            return null;
        }
        long[] ids = new long[rows.length];
        int i = 0;
        for (int index : rows) {
            String billid = (String)this.getModel().getValue("fbillid", index);
            ids[i++] = Long.parseLong(billid);
        }
        return ids;
    }

    private String[] getSelectedBillNos() {
        EntryGrid entry = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        int[] rows = entry.getSelectRows();
        if (rows == null || rows.length == 0) {
            return null;
        }
        String[] billNos = new String[rows.length];
        int i = 0;
        for (int index : rows) {
            billNos[i++] = (String)this.getModel().getValue(KEY_FBILLNO, index);
        }
        return billNos;
    }

    private void doImport(Map<String, Object> importData) {
        if (importData == null) {
            return;
        }
        String importFile = (String)importData.get("file");
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)importFile)) {
            return;
        }
        String[] fieldUrls = kd.bos.dataentity.utils.StringUtils.split((String)importFile, (String)";");
        Long orgid = (Long)importData.get("org");
        for (String fileUrl : fieldUrls) {
            Map result = DapFileUtil.uploadRule((String)fileUrl, (Long)orgid);
            String errMessage = (String)result.get("ERROR");
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)errMessage)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25", (String)"VchTemplateConfigsListPlugin_57", (String)"fi-ai-formplugin", (Object[])new Object[0]), errMessage, null);
                continue;
            }
            Object success = result.get("SUCCESS");
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank(success)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u6210\u529f\u3002", (String)"VchTemplateConfigsListPlugin_34", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            }
            this.loadTempInfo(this.getPageCache().get(KEY_BILLNO));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        TreeView fieldTree;
        TreeView.TreeState state;
        List nodes;
        super.propertyChanged(e);
        ChangeData[] changes = e.getChangeSet();
        Object newValue = changes[0].getNewValue();
        if (e.getProperty().getName().equalsIgnoreCase("isdap")) {
            TreeView fieldTree2 = (TreeView)this.getView().getControl("billtree");
            TreeView.TreeState state2 = fieldTree2.getTreeState();
            List nodes2 = state2.getSelectedNodeId();
            if (nodes2 != null && nodes2.size() > 0) {
                boolean isEvent;
                String billEntity = (String)nodes2.get(0);
                boolean bl = isEvent = billEntity.indexOf(FLAG_AI_EVENTCLASS) == 0;
                if (!QueryServiceHelper.exists((String)"bos_entityobject", (Object)billEntity) && !isEvent) {
                    if (newValue.equals(true)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u53f6\u5b50\u8282\u70b9\u4e0d\u80fd\u66f4\u6539\u6b64\u5c5e\u6027\u3002", (String)"VchTemplateConfigsListPlugin_33", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    }
                    this.getModel().beginInit();
                    this.getModel().setValue("isdap", (Object)"false");
                    this.getModel().endInit();
                    return;
                }
                QFilter qFilter = null;
                long eventClassId = 0L;
                if (isEvent) {
                    eventClassId = Long.parseLong(billEntity.substring(FLAG_AI_EVENTCLASS.length()));
                    qFilter = new QFilter("eventclass", "=", (Object)eventClassId);
                } else {
                    qFilter = new QFilter("billentity", "=", (Object)billEntity);
                }
                DynamicObject config = BusinessDataServiceHelper.loadSingle((String)"ai_dapconfig", (String)"id,isdap,billentity", (QFilter[])new QFilter[]{qFilter});
                if (config != null) {
                    config.set("isdap", newValue);
                } else {
                    config = ORM.create().newDynamicObject("ai_dapconfig");
                    if (isEvent) {
                        eventClassId = Long.parseLong(billEntity.substring(FLAG_AI_EVENTCLASS.length()));
                        config.set("eventclass", (Object)eventClassId);
                        config.set("billentity", (Object)"ai_eventclass");
                    } else {
                        config.set("billentity", (Object)billEntity);
                    }
                    config.set("isdap", newValue);
                    config.set("oper", (Object)this.getEntityIepOprt(billEntity));
                }
                boolean isDap = (Boolean)newValue;
                SaveServiceHelper.save((IDataEntityType)config.getDataEntityType(), (Object[])new Object[]{config});
                DapWriteAndBlackOpSetUtil.registerDapWriteAndBlackOpService((Boolean)isDap, (String)billEntity);
                this.clearDapConfigCache();
                DapCache.clearDapConfigCacheByEntity((String)billEntity, (long)eventClassId);
            }
        } else if (e.getProperty().getName().equalsIgnoreCase("isselecttemp")) {
            TreeView fieldTree3 = (TreeView)this.getView().getControl("billtree");
            TreeView.TreeState state3 = fieldTree3.getTreeState();
            List nodes3 = state3.getSelectedNodeId();
            if (nodes3 != null && nodes3.size() > 0) {
                boolean isEvent;
                String billEntity = (String)nodes3.get(0);
                boolean bl = isEvent = billEntity.indexOf(FLAG_AI_EVENTCLASS) == 0;
                if (!QueryServiceHelper.exists((String)"bos_entityobject", (Object)billEntity) && !isEvent) {
                    if (newValue.equals(true)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u53f6\u5b50\u8282\u70b9\u4e0d\u80fd\u66f4\u6539\u6b64\u5c5e\u6027\u3002", (String)"VchTemplateConfigsListPlugin_33", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    }
                    this.getModel().beginInit();
                    this.getModel().setValue("isselecttemp", (Object)"false");
                    this.getModel().endInit();
                    return;
                }
                QFilter qFilter = null;
                long eventClassId = 0L;
                if (isEvent) {
                    eventClassId = Long.parseLong(billEntity.substring(FLAG_AI_EVENTCLASS.length()));
                    qFilter = new QFilter("eventclass", "=", (Object)eventClassId);
                } else {
                    qFilter = new QFilter("billentity", "=", (Object)billEntity);
                }
                DynamicObject config = BusinessDataServiceHelper.loadSingle((String)"ai_dapconfig", (String)"id,isselecttemp,billentity", (QFilter[])new QFilter[]{qFilter});
                if (config != null) {
                    config.set("isselecttemp", newValue);
                } else {
                    config = ORM.create().newDynamicObject("ai_dapconfig");
                    config.set("billentity", (Object)billEntity);
                    config.set("isselecttemp", newValue);
                    config.set("oper", (Object)this.getEntityIepOprt(billEntity));
                }
                boolean isselecttemp = (Boolean)newValue;
                SaveServiceHelper.save((IDataEntityType)config.getDataEntityType(), (Object[])new Object[]{config});
                this.clearDapConfigCache();
                DapCache.clearDapConfigCacheByEntity((String)billEntity, (long)eventClassId);
            }
        } else if (e.getProperty().getName().equalsIgnoreCase("onlygetdata") && (nodes = (state = (fieldTree = (TreeView)this.getView().getControl("billtree")).getTreeState()).getSelectedNodeId()) != null && nodes.size() > 0) {
            boolean isEvent;
            String billEntity = (String)nodes.get(0);
            boolean bl = isEvent = billEntity.indexOf(FLAG_AI_EVENTCLASS) == 0;
            if (!QueryServiceHelper.exists((String)"bos_entityobject", (Object)billEntity) && !isEvent) {
                if (newValue.equals(true)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u53f6\u5b50\u8282\u70b9\u4e0d\u80fd\u66f4\u6539\u6b64\u5c5e\u6027\u3002", (String)"VchTemplateConfigsListPlugin_33", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                }
                this.getModel().beginInit();
                this.getModel().setValue("onlygetdata", (Object)"false");
                this.getModel().endInit();
                return;
            }
            QFilter qFilter = null;
            long eventClassId = 0L;
            if (isEvent) {
                eventClassId = Long.parseLong(billEntity.substring(FLAG_AI_EVENTCLASS.length()));
                qFilter = new QFilter("eventclass", "=", (Object)eventClassId);
            } else {
                qFilter = new QFilter("billentity", "=", (Object)billEntity);
            }
            DynamicObject config = BusinessDataServiceHelper.loadSingle((String)"ai_dapconfig", (String)"id,onlygetdata,billentity", (QFilter[])new QFilter[]{qFilter});
            if (config != null) {
                config.set("onlygetdata", newValue);
            } else {
                config = ORM.create().newDynamicObject("ai_dapconfig");
                config.set("billentity", (Object)billEntity);
                config.set("onlygetdata", newValue);
                config.set("oper", (Object)this.getEntityIepOprt(billEntity));
            }
            SaveServiceHelper.save((IDataEntityType)config.getDataEntityType(), (Object[])new Object[]{config});
            this.clearDapConfigCache();
            DapCache.clearDapConfigCacheByEntity((String)billEntity, (long)eventClassId);
        }
    }

    private void clearDapConfigCache() {
        DapCache.clearDapConfigCache();
    }

    private boolean isEnable(List<? extends Object> list) {
        QFilter ids = new QFilter("id", "in", list);
        QFilter enable = new QFilter("enable", "=", (Object)"0");
        return QueryServiceHelper.exists((String)"ai_vchtemplate", (QFilter[])new QFilter[]{ids, enable});
    }

    private void initAllEntity(Map<String, List<String>> basedataInfo) {
        String billno = this.getPageCache().get(KEY_BILLNO);
        this.setDefaultValue(billno);
        ArrayList entity = new ArrayList();
        Set<Object> eventIds = new HashSet();
        Boolean isEvent = Boolean.FALSE;
        if (this.AI_EVENT_ROOT_ID.equals(billno)) {
            DynamicObjectCollection eventClasses = QueryServiceHelper.query((String)"ai_eventclass", (String)"id", (QFilter[])new QFilter("id", ">", (Object)0L).toArray());
            eventIds = eventClasses.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
            isEvent = Boolean.TRUE;
        } else if (billno.indexOf(FLAG_AI_EVENTGROUP) == 0) {
            isEvent = Boolean.TRUE;
            long eventGroupId = Long.parseLong(billno.substring(FLAG_AI_EVENTGROUP.length()));
            DynamicObject grp = QueryServiceHelper.queryOne((String)"ai_eventgroup", (String)"longnumber", (QFilter[])new QFilter("id", "=", (Object)eventGroupId).toArray());
            DynamicObjectCollection leafEventGroups = QueryServiceHelper.query((String)"ai_eventgroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("longnumber", "like", (Object)(grp.getString("longnumber") + "%")), new QFilter("isleaf", "=", (Object)true)});
            Set s = leafEventGroups.stream().map(v -> v.get("id")).collect(Collectors.toSet());
            DynamicObjectCollection eventClasses = QueryServiceHelper.query((String)"ai_eventclass", (String)"id", (QFilter[])new QFilter("group", "in", s).toArray());
            eventIds = eventClasses.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
        } else if (this.BILL_ROOT_ID.equals(billno)) {
            basedataInfo.forEach((k, v) -> entity.addAll(v));
        } else {
            entity.addAll(basedataInfo.get(billno));
        }
        ArrayList<QFilter> vchTemplateFilters = new ArrayList<QFilter>();
        if (isEvent.booleanValue()) {
            vchTemplateFilters.add(new QFilter("eventclass", "in", eventIds));
        } else {
            vchTemplateFilters.add(new QFilter("fsourcebill", "in", entity));
        }
        this.buildEntryData(vchTemplateFilters, isEvent);
    }

    private void initEntity(String nodeId) {
        this.setDefaultValue(nodeId);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        boolean isEvent = nodeId.indexOf(FLAG_AI_EVENTCLASS) == 0;
        QFilter qFilter = null;
        qFilter = isEvent ? new QFilter("eventclass", "=", (Object)Long.valueOf(nodeId.substring(FLAG_AI_EVENTCLASS.length()))) : new QFilter("billentity", "=", (Object)nodeId);
        DynamicObject config = QueryServiceHelper.queryOne((String)"ai_dapconfig", (String)"isdap,isselecttemp,onlygetdata", (QFilter[])new QFilter[]{qFilter});
        if (!isEvent) {
            boolean isDap = config != null ? config.getBoolean("isdap") : false;
            DapWriteAndBlackOpSetUtil.registerDapWriteAndBlackOpService((Boolean)isDap, (String)nodeId);
        }
        model.setValue("isdap", (Object)(config != null && config.getBoolean("isdap") ? 1 : 0));
        model.setValue("isselecttemp", (Object)(config != null && config.getBoolean("isselecttemp") ? 1 : 0));
        model.setValue("onlygetdata", (Object)(config != null && config.getBoolean("onlygetdata") ? 1 : 0));
        LinkedList<QFilter> vchTemplateFilters = new LinkedList<QFilter>();
        if (isEvent) {
            long eventClassId = Long.parseLong(nodeId.substring(FLAG_AI_EVENTCLASS.length()));
            vchTemplateFilters.add(new QFilter("eventclass", "=", (Object)eventClassId));
        } else {
            vchTemplateFilters.add(new QFilter("fsourcebill", "=", (Object)nodeId));
        }
        this.buildEntryData(vchTemplateFilters, isEvent);
    }

    private void buildEntryData(List<QFilter> vchTemplateFilters, boolean isEvent) {
        String orgfilter = this.getPageCache().get(KEY_ORG_FILTER);
        this.addVchtemplateFilter(this.getPerOrgList(orgfilter), vchTemplateFilters);
        DynamicObject[] collection = this.getVchTplDyo(vchTemplateFilters, orgfilter);
        if (collection.length == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, collection.length);
        int rowIndex = 0;
        StringBuilder sb = new StringBuilder();
        ArrayList<CellStyle> enableCellStyles = new ArrayList<CellStyle>(collection.length);
        this.getModel().beginInit();
        for (DynamicObject vchTemplateObj : collection) {
            this.genVchTemplateInfo(vchTemplateObj, isEvent, sb, rowIndex);
            CellStyle cellStyle = this.buildEnableCellStyle(rowIndex, vchTemplateObj.getString("enable"));
            if (cellStyle != null) {
                enableCellStyles.add(cellStyle);
            }
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)sb)) {
                this.getView().showTipNotification(sb.toString());
            }
            ++rowIndex;
        }
        this.getModel().endInit();
        this.setEntryGridCellStyle(enableCellStyles);
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent var1) {
        String field = var1.getFieldName();
        if (field.startsWith("org.")) {
            List pkSet = AccSysUtil.getAcctOrgPkList((String)"ai_vchtemplate", (boolean)true, (PermissonType)PermissonType.VIEW);
            var1.getQfilters().add(new QFilter("id", "in", (Object)pkSet));
        }
    }

    private List<ComboItem> getAcctOrgComboItem(String entityId, PermissonType permType) {
        List comboItems = AccSysUtil.getAcctOrgComboItem((String)"ai_vchtemplate", (boolean)true, (PermissonType)PermissonType.VIEW);
        return comboItems;
    }

    private QFilter getBaseDateFilter(String entityID, List<? extends Object> orgids) {
        Object baseDataIdsFilter = null;
        Object object = orgids.get(0);
        if (orgids.size() > 1) {
            HashSet ids = new HashSet(orgids.size());
            for (Object object2 : orgids) {
                QFilter filter = BaseDataServiceHelper.getBaseDataIdInFilter((String)entityID, (Long)Long.parseLong(object2 + ""));
                ids.addAll((Collection)filter.getValue());
            }
            return new QFilter("id", "in", ids);
        }
        return BaseDataServiceHelper.getBaseDataFilter((String)entityID, (Long)Long.parseLong(object + ""));
    }

    private int genVchTemplateInfo(DynamicObject vchTemplateObj, boolean isEvent, StringBuilder sb, int rowIndex) {
        try {
            String srcEntityNumber;
            MainEntityType vchTemplateType;
            String bizappname;
            if (isEvent) {
                bizappname = ((DynamicObject)vchTemplateObj.get("eventclass")).getString("group.name");
                vchTemplateType = AiEventMetaUtil.getEntityType((Object)((DynamicObject)vchTemplateObj.get("eventclass")).get("id"));
                srcEntityNumber = String.valueOf(((DynamicObject)vchTemplateObj.get("eventclass")).get("id"));
            } else {
                bizappname = vchTemplateObj.getDynamicObject("fsourcebill").getString("bizappid.name");
                srcEntityNumber = vchTemplateObj.getDynamicObject("fsourcebill").getString("id");
                vchTemplateType = EntityMetadataCache.getDataEntityType((String)srcEntityNumber);
            }
            IDataModel model = this.getModel();
            Object acctTableId = 0L;
            DynamicObject acctTableObj = (DynamicObject)vchTemplateObj.get("faccttableid");
            if (acctTableObj != null) {
                acctTableId = acctTableObj.getPkValue();
            }
            model.setValue(KEY_FBILLNO, vchTemplateObj.get(KEY_BILLNO), rowIndex);
            model.setValue("fbillid", vchTemplateObj.get("id"), rowIndex);
            model.setValue("fdescription", vchTemplateObj.get("name"), rowIndex);
            model.setValue("orgapply", (Object)(vchTemplateObj.getLong("createorg_id") == 0L ? vchTemplateObj.getLong("org_id") : vchTemplateObj.getLong("createorg_id")), rowIndex);
            try {
                DynamicObject dynamicObject;
                DynamicObjectCollection dynamicObjectCollection = vchTemplateObj.getDynamicObjectCollection("booktype");
                DynamicObject dynamicObject2 = dynamicObject = dynamicObjectCollection != null && !dynamicObjectCollection.isEmpty() ? ((DynamicObject)dynamicObjectCollection.get(0)).getDynamicObject("fbasedataid") : null;
                if (dynamicObject != null) {
                    model.setValue("booktype", (Object)vchTemplateObj.getDynamicObjectCollection("booktype"), rowIndex);
                } else {
                    model.setValue("booktype", null, rowIndex);
                }
            }
            catch (ORMDesignException e) {
                this.appendError(isEvent, vchTemplateObj, sb);
            }
            model.setValue("appname", (Object)bizappname, rowIndex);
            model.setValue("billtype", (Object)vchTemplateObj.getDynamicObject("fsourcebill").getString("name"), rowIndex);
            model.setValue("vchcreator", (Object)vchTemplateObj.getLong("creator_id"), rowIndex);
            model.setValue("vchmodifier", (Object)vchTemplateObj.getLong("modifier_id"), rowIndex);
            model.setValue(Key_accounttable, acctTableId, rowIndex);
            String facctorgid = vchTemplateObj.getString("facctorgid");
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)facctorgid)) {
                String[] acctorgIds = facctorgid.split("\\.");
                facctorgid = acctorgIds[acctorgIds.length - 1];
            }
            model.setValue("bizorg", (Object)BuildTree.tranExpression((String)facctorgid, (MainEntityType)vchTemplateType), rowIndex);
            model.setValue("vchdate", (Object)this.getDateDesc(vchTemplateObj.getString("fvoucherdatedesc"), srcEntityNumber, isEvent), rowIndex);
            model.setValue("vouchertype", (Object)this.getVoucherTypeName(vchTemplateObj.getString("fvchtypedesc")), rowIndex);
            model.setValue("bizdate", (Object)this.getDateDesc(vchTemplateObj.getString("fbizdatedesc"), srcEntityNumber, isEvent), rowIndex);
            model.setValue("enable", (Object)vchTemplateObj.getString("enable"), rowIndex);
            model.setValue("ctrlstrategy", (Object)vchTemplateObj.getString("ctrlstrategy"), rowIndex);
        }
        catch (Exception exc) {
            this.appendError(isEvent, vchTemplateObj, sb);
        }
        return rowIndex;
    }

    private String getDateDesc(String dateDesc, String srcEntityNumber, boolean isEvent) {
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)dateDesc) && dateDesc.contains("[") && dateDesc.contains("{")) {
            List listMap = (List)SerializationUtils.fromJsonString((String)dateDesc, List.class);
            LinkedList<VchFormulaFilterSetRow> setRows = new LinkedList<VchFormulaFilterSetRow>();
            for (Map map : listMap) {
                VchFormulaFilterSetRow setRow = new VchFormulaFilterSetRow();
                VchTplExpression fieldExp = new VchTplExpression();
                fieldExp.setExpression((String)map.get("Expression"));
                fieldExp.setDescription(new LocaleString((String)map.get("Description")));
                fieldExp.setExprTran((String)map.get("ExprTran"));
                setRow.setFieldExp(fieldExp);
                setRows.add(setRow);
            }
            if (!setRows.isEmpty()) {
                VchFormulaFilterset vchFormula = new VchFormulaFilterset();
                vchFormula.setItems(setRows);
                dateDesc = vchFormula.getDescriptionString(srcEntityNumber, isEvent);
            }
        }
        return dateDesc;
    }

    private String getVoucherTypeName(String fvchtypedesc) {
        if (this.voucherTypeMap.isEmpty()) {
            Map vchTypes = BusinessDataServiceHelper.loadFromCache((String)"gl_vouchertype", (String)"name", null);
            for (Map.Entry entry : vchTypes.entrySet()) {
                this.voucherTypeMap.put(String.valueOf(entry.getKey()), ((DynamicObject)entry.getValue()).getString("name"));
            }
        }
        if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)fvchtypedesc)) {
            String[] split = fvchtypedesc.split("/");
            StringBuilder sb = new StringBuilder();
            for (String vchTypeId : split) {
                if (null != this.voucherTypeMap.get(vchTypeId)) {
                    sb.append(this.voucherTypeMap.get(vchTypeId)).append("/");
                    continue;
                }
                sb.append(vchTypeId).append("/");
            }
            if (sb.length() > 0) {
                fvchtypedesc = sb.delete(sb.length() - 1, sb.length()).toString();
            }
        }
        return fvchtypedesc;
    }

    private void appendError(boolean isEvent, DynamicObject vchTemplateObj, StringBuilder sb) {
        if (isEvent) {
            sb.append(vchTemplateObj.getLong("eventclass_id"));
        } else {
            String nodeId = vchTemplateObj.getDynamicObject("fsourcebill").getString("id");
            sb.append(nodeId);
        }
        sb.append(ResManager.loadKDString((String)"\u5355\u636e\u89e3\u6790\u5931\u8d25\u3002", (String)"VchTemplateConfigsListPlugin_35", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        sb.append("\n\t");
    }

    private void addVchtemplateFilter(List<Long> orgList, List<QFilter> vchTemplateFilters) {
        try {
            if (orgList.size() <= 100) {
                vchTemplateFilters.add(this.getBaseDateFilter("ai_vchtemplate", orgList));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String eanbleFilter = this.getPageCache().get(KEY_ENABLE_FILTER);
        if (!StringUtils.isEmpty((String)eanbleFilter)) {
            if (eanbleFilter.equals("0")) {
                vchTemplateFilters.add(new QFilter("enable", "=", (Object)"0"));
            } else {
                vchTemplateFilters.add(new QFilter("enable", "=", (Object)eanbleFilter));
            }
        }
        String appId = AppMetadataCache.getAppInfo((String)"iep").getId();
        QFilter dataRuleFilter = PermissionServiceHelper.getDataPermission((long)ContextUtil.getUserId(), (String)appId, (String)"ai_vchtemplate");
        vchTemplateFilters.add(dataRuleFilter);
    }

    private DynamicObject[] getVchTplDyo(List<QFilter> vchTemplateFilters, String orgfilter) {
        String selectFields = "id,number,name,faccttableid,creator,createorg,booktype,org,enable,fsourcebill,eventclass,modifier,facctorgid,fvoucherdatedesc,fvchtypedesc,fbizdatedesc,ctrlstrategy";
        DynamicObject[] collection = BusinessDataServiceHelper.load((String)"ai_vchtemplate", (String)selectFields, (QFilter[])vchTemplateFilters.toArray(new QFilter[0]), null);
        if (null == collection || collection.length == 0 || this.isHashPer(orgfilter)) {
            return new DynamicObject[0];
        }
        return collection;
    }

    private List<Long> getPerOrgList(String orgfilter) {
        List<Long> orgList = new ArrayList<Long>(4);
        if (!StringUtils.isEmpty((String)orgfilter)) {
            if (orgfilter != null && !orgfilter.isEmpty()) {
                orgList = Collections.singletonList(Long.valueOf(orgfilter));
            }
        } else {
            String permOrgStr = this.getPageCache().get(PERM_ORGS);
            List permOrgList = SerializationUtils.fromJsonStringToList((String)permOrgStr, String.class);
            if (null != permOrgList && !permOrgList.isEmpty()) {
                orgList = permOrgList.stream().mapToLong(s -> Long.parseLong(s.toString())).boxed().collect(Collectors.toList());
            }
        }
        return orgList;
    }

    private boolean isHashPer(String orgfilter) {
        String permOrgStr = this.getPageCache().get(PERM_ORGS);
        List permOrgList = SerializationUtils.fromJsonStringToList((String)permOrgStr, String.class);
        return StringUtils.isEmpty((String)orgfilter) && permOrgList.isEmpty();
    }

    private void setEntryGridCellStyle(List<CellStyle> cellStyles) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
        entryGrid.setCellStyle(cellStyles);
    }

    private CellStyle buildEnableCellStyle(int rowIndex, String enable) {
        if (rowIndex == -1) {
            return null;
        }
        String foreColor = "#26B175";
        if ("0".equals(enable)) {
            foreColor = "#FD6C6A";
        }
        CellStyle cellstyle = new CellStyle();
        cellstyle.setRow(rowIndex);
        cellstyle.setFieldKey("enable");
        cellstyle.setForeColor(foreColor);
        return cellstyle;
    }

    private void checkOrgIsSelect() {
        String org_filter = this.getPageCache().get(KEY_ORG_FILTER);
        if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)org_filter)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"VchTemplateConfigsListPlugin_36", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
    }

    public void search(SearchEnterEvent arg0) {
        Search search = (Search)arg0.getSource();
        String firstRootStr = this.getPageCache().get("firstRoot");
        String secondRootStr = this.getPageCache().get("secondRoot");
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"searchfield", (CharSequence)search.getKey())) {
            TreeView tree = (TreeView)this.getView().getControl("billtree");
            String searchText = arg0.getText();
            String pageCahe = this.getPageCache().get("fi.ai.VchTemplateConfigsListPlugin" + searchText);
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)pageCahe)) {
                List list = SerializationUtils.fromJsonStringToList((String)pageCahe, TreeNode.class);
                if (!list.isEmpty()) {
                    tree.focusNode((TreeNode)list.get(0));
                    this.loadTempInfo(((TreeNode)list.get(0)).getId());
                    list.remove(0);
                    this.getPageCache().put("fi.ai.VchTemplateConfigsListPlugin" + searchText, SerializationUtils.toJsonString((Object)list));
                } else {
                    this.getList(firstRootStr, secondRootStr, searchText, tree);
                }
            } else {
                this.getList(firstRootStr, secondRootStr, searchText, tree);
            }
        }
    }

    private void getList(String firstRootStr, String secondRootStr, String searchText, TreeView tree) {
        TreeNode firstRoot = (TreeNode)SerializationUtils.fromJsonString((String)firstRootStr, TreeNode.class);
        List<Object> list2 = new ArrayList(8);
        if (!ProductSettingServiceHelper.hasBlackFeature((String)"iep", (String)"fi_ai") && kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)secondRootStr)) {
            TreeNode secondRoot = (TreeNode)SerializationUtils.fromJsonString((String)secondRootStr, TreeNode.class);
            TreeNode searchTreesecondRoot = BuildTree.searchTree((String)searchText, (TreeNode)secondRoot);
            list2 = this.getTreeNodes(searchTreesecondRoot, new ArrayList<TreeNode>());
        }
        TreeNode searchTreefirstRoot = BuildTree.searchTree((String)searchText, (TreeNode)firstRoot);
        ArrayList<Object> listAll = new ArrayList<Object>();
        List<TreeNode> list1 = this.getTreeNodes(searchTreefirstRoot, new ArrayList<TreeNode>());
        if (!list1.isEmpty()) {
            tree.focusNode(list1.get(0));
            this.loadTempInfo(list1.get(0).getId());
            list1.remove(0);
            listAll.addAll(list1);
            if (!list2.isEmpty()) {
                listAll.addAll(list2);
            }
        } else if (list1.isEmpty() && !list2.isEmpty()) {
            tree.focusNode((TreeNode)list2.get(0));
            this.loadTempInfo(((TreeNode)list2.get(0)).getId());
            list2.remove(0);
            listAll.addAll(list2);
        }
        if (!listAll.isEmpty()) {
            this.getPageCache().put("fi.ai.VchTemplateConfigsListPlugin" + searchText, SerializationUtils.toJsonString(listAll));
        }
    }

    private List<TreeNode> getTreeNodes(TreeNode searchTreeRoot, List<TreeNode> list) {
        if (!searchTreeRoot.getChildren().isEmpty()) {
            for (TreeNode node : searchTreeRoot.getChildren()) {
                if (node.getChildren() != null) {
                    this.getTreeNodes(node, list);
                    continue;
                }
                list.add(node);
            }
        }
        return list;
    }
}

