/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.util.StringUtils;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.VchReturnData;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.VchTplRate;
import kd.fi.ai.cache.CacheBuildTree;
import kd.fi.ai.function.DapFunctionTypes;
import kd.fi.ai.util.AiEventMetaUtil;
import kd.fi.ai.util.BuildTree;
import kd.fi.ai.util.EntityFieldTreeOption;
import kd.fi.ai.util.EntityFieldTreeResult;
import kd.fi.ai.util.EntityFieldUtil;
import kd.fi.ai.util.EntityTreeUtil;

public class VchTemplateRateEdit
extends AbstractFormPlugin {
    private static final String FixPanel = "fixpanel";
    private static final String ExpPanel = "fieldpanel";
    private static final String Key_btnOK = "btnok";
    private static final String Key_btnCancel = "btncancel";
    private static final String FIELD_FIX = "fix";
    private static final String FIELD_EXP = "field";
    private static final String Cache_SourceFieldCombo = "sourceComboList";
    private static final String Cache_SourceFieldComboMap = "sourceComboMap";
    private static final String RATE_EXP = "expression";
    private static final String RATE_EXP_DESC = "expressiondesc";
    private static final String RATE = "rate";
    private static final String NON_FIELDS = "nonFields";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel, RATE_EXP_DESC});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.fillFields(this.getMainEntityType(), RATE_EXP_DESC, ExpressionType.Formula, true, DecimalProp.class);
        this.initCombo();
        String data = (String)this.getView().getFormShowParameter().getCustomParam("data");
        if (StringUtils.isNotEmpty((String)data)) {
            VchTplRate vchTplRateDate = (VchTplRate)SerializationUtils.fromJsonString((String)data, VchTplRate.class);
            String srcType = vchTplRateDate.getSourcetype();
            if (srcType == null) {
                srcType = FIELD_FIX;
                vchTplRateDate.setSourcetype(srcType);
            }
            this.acctTypeChange(vchTplRateDate.getSourcetype());
            this.getModel().setValue("sourcetype", (Object)vchTplRateDate.getSourcetype());
            if (StringUtils.isNotEmpty((String)vchTplRateDate.getFix())) {
                this.getModel().setValue(RATE, (Object)vchTplRateDate.getFix());
            } else if (vchTplRateDate.getExp() != null) {
                this.getModel().setValue(RATE_EXP, (Object)vchTplRateDate.getExp());
                if (StringUtils.isEmpty((String)vchTplRateDate.getName())) {
                    String expDesc = BuildTree.tranExpression((String)vchTplRateDate.getExp(), (MainEntityType)this.getMainEntityType());
                    this.getModel().setValue(RATE_EXP_DESC, (Object)expDesc);
                } else {
                    this.getModel().setValue(RATE_EXP_DESC, (Object)vchTplRateDate.getName());
                }
            }
        } else {
            String rate = (String)this.getView().getFormShowParameter().getCustomParam(RATE);
            if (StringUtils.isNotEmpty((String)rate)) {
                if ("1".equals(rate) || "@autoCal".equals(rate)) {
                    this.getModel().setValue("sourcetype", (Object)FIELD_FIX);
                    this.getModel().setValue(RATE, (Object)rate);
                    this.getView().setVisible(Boolean.FALSE, new String[]{ExpPanel, RATE_EXP_DESC});
                    ((ComboEdit)this.getView().getControl(RATE)).setMustInput(true);
                } else {
                    this.getModel().setValue("sourcetype", (Object)FIELD_EXP);
                    this.getModel().setValue(RATE_EXP_DESC, (Object)rate);
                    this.getView().setVisible(Boolean.FALSE, new String[]{FixPanel, RATE});
                    ((TextEdit)this.getView().getControl(RATE_EXP_DESC)).setMustInput(true);
                }
            } else {
                this.acctTypeChange(FIELD_FIX);
            }
        }
        CacheBuildTree.setPageCache((FormShowParameter)this.getView().getFormShowParameter(), (IPageCache)this.getPageCache());
    }

    private void fillFields(MainEntityType srcMainET, String key, ExpressionType type, boolean readChildEntity, Class<?> cls) {
        if (srcMainET == null) {
            this.getPageCache().put(key, "");
        } else {
            EntityFieldTreeOption option = EntityFieldTreeOption.create();
            option.setEntityType((IDataEntityType)srcMainET);
            option.setReadEntryEntity(readChildEntity);
            option.setExprType(type);
            option.setFieldType(cls);
            EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
            TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
            String toJson = SerializationUtils.toJsonString((Object)tree);
            this.getPageCache().put(key, toJson);
            String nonFdStr = this.getPageCache().get(NON_FIELDS);
            if (nonFdStr != null) {
                Set nonSet = (Set)SerializationUtils.fromJsonString((String)nonFdStr, Set.class);
                nonSet.addAll(result.getNonFields());
                this.getPageCache().put(NON_FIELDS, SerializationUtils.toJsonString((Object)nonSet));
            } else {
                this.getPageCache().put(NON_FIELDS, SerializationUtils.toJsonString((Object)result.getNonFields()));
            }
        }
    }

    public void click(EventObject evt) {
        Control ctlSource = (Control)evt.getSource();
        if (Key_btnOK.equalsIgnoreCase(ctlSource.getKey())) {
            String cacheValue;
            String entitynumber;
            String currentFormId;
            VchTplRate rate = this.getVchTempRateTable();
            VchReturnData returnData = EntityFieldUtil.validateDiffEntry((Object)rate, (String)(currentFormId = (String)this.getView().getFormShowParameter().getCustomParam("ai_button_key")), (String)(entitynumber = (String)this.getView().getFormShowParameter().getCustomParam("sourcebill")), (String)(cacheValue = EntityFieldUtil.getCacheValueFromFormParameter((IFormView)this.getView())));
            if (returnData.isStatus()) {
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)returnData));
                this.getView().close();
            } else if (!returnData.isStatus() && StringUtils.isNotEmpty((String)returnData.getMessage())) {
                this.getView().showTipNotification(returnData.getMessage());
            }
        } else if (Key_btnCancel.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        } else if (RATE_EXP_DESC.equalsIgnoreCase(ctlSource.getKey())) {
            this.showFormulaForm((String)this.getView().getFormShowParameter().getCustomParam("sourcebill"), RATE_EXP, RATE_EXP_DESC, this.getPageCache().get(RATE_EXP_DESC));
        }
    }

    private void showFormulaForm(String entityKey, String expressionFldKey, String sourceCtrlKey, String fieldNodes) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ai_formula");
        String expression = (String)this.getModel().getValue(expressionFldKey);
        String descFldValue = (String)this.getModel().getValue(sourceCtrlKey);
        VchTplExpression exprObj = new VchTplExpression();
        exprObj.setExprType(ExpressionType.Formula);
        exprObj.setExpression(expression);
        LocaleString description = new LocaleString();
        description.put(Lang.defaultLang().toString(), (Object)descFldValue);
        exprObj.setDescription(description);
        String formulaJson = SerializationUtils.toJsonString((Object)exprObj);
        showParameter.getCustomParams().put("formula", formulaJson);
        showParameter.getCustomParams().put("entitynumber", entityKey);
        boolean isevent = (Boolean)this.getView().getFormShowParameter().getCustomParam("isevent");
        String funcsXML = this.getPageCache().get("functiontypes");
        if (StringUtils.isEmpty((String)funcsXML)) {
            FunctionTypes functionTypes = DapFunctionTypes.get((String)(isevent ? "event" : "type"));
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCustomParam("ai_vchtemplatecachekey", (Object)EntityFieldUtil.getCacheValueFromFormParameter((IFormView)this.getView()));
        showParameter.setCustomParam("ai_button_key", (Object)"ai_vchtemplate_rate-fratedesc");
        this.getPageCache().put("srcMainEntityType", "VchTemplateRateEdit");
        CacheBuildTree.setBuild((FormShowParameter)showParameter, (IPageCache)this.getPageCache());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private VchTplRate getVchTempRateTable() {
        VchTplRate tplRate = new VchTplRate();
        String sourcetype = (String)this.getModel().getValue("sourcetype");
        tplRate.setSourcetype(sourcetype);
        if (FIELD_FIX.equalsIgnoreCase(sourcetype)) {
            String fix = (String)this.getModel().getValue(RATE);
            if (fix != null) {
                tplRate.setFix(fix);
                tplRate.setName(fix.equals("1") ? "1" : ResManager.loadKDString((String)"\u8d26\u7c3f\u9ed8\u8ba4\u6c47\u7387", (String)"VchTemplateRateEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            }
        } else if (FIELD_EXP.equalsIgnoreCase(sourcetype)) {
            String sourcefield = (String)this.getModel().getValue(RATE_EXP);
            String name = (String)this.getModel().getValue(RATE_EXP_DESC);
            tplRate.setExp(sourcefield);
            tplRate.setName(name);
        }
        return tplRate;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty prop = e.getProperty();
        ChangeData[] change = e.getChangeSet();
        if (prop.getName().equals("sourcetype")) {
            String type = change[0].getNewValue().toString();
            this.acctTypeChange(type);
        }
    }

    private void acctTypeChange(String type) {
        switch (type) {
            case "fix": {
                this.getView().setVisible(Boolean.TRUE, new String[]{RATE, FixPanel});
                this.getView().setVisible(Boolean.FALSE, new String[]{RATE_EXP_DESC, RATE_EXP, ExpPanel});
                this.getModel().setValue(RATE_EXP, null);
                this.getModel().setValue(RATE_EXP_DESC, null);
                ((ComboEdit)this.getView().getControl(RATE)).setMustInput(true);
                ((TextEdit)this.getView().getControl(RATE_EXP)).setMustInput(false);
                break;
            }
            case "field": {
                this.getView().setVisible(Boolean.FALSE, new String[]{RATE, FixPanel});
                this.getView().setVisible(Boolean.TRUE, new String[]{RATE_EXP_DESC, ExpPanel});
                this.getModel().setValue(RATE, null);
                ((ComboEdit)this.getView().getControl(RATE)).setMustInput(false);
                ((TextEdit)this.getView().getControl(RATE_EXP_DESC)).setMustInput(true);
            }
        }
    }

    private void initCombo() {
        MainEntityType srcMainET = this.getMainEntityType();
        if (srcMainET == null) {
            return;
        }
        String currLCId = Lang.get().toString();
        List<ComboItem> items = new ArrayList();
        String fields = this.getPageCache().get(Cache_SourceFieldCombo);
        if (StringUtils.isNotEmpty((String)fields)) {
            items = (List)SerializationUtils.deSerializeFromBase64((String)fields);
        } else {
            items = new ArrayList();
            ComboItem item1 = new ComboItem();
            item1.setValue("1");
            item1.setCaption(new LocaleString(currLCId, "1"));
            items.add(item1);
            ComboItem autoCalItem = new ComboItem();
            autoCalItem.setValue("@autoCal");
            autoCalItem.setCaption(new LocaleString(currLCId, ResManager.loadKDString((String)"\u8d26\u7c3f\u9ed8\u8ba4\u6c47\u7387", (String)"VchTemplateRateEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0])));
            items.add(autoCalItem);
            ComboEdit fieldEditor = (ComboEdit)this.getView().getControl(RATE);
            fieldEditor.setComboItems(items);
            HashMap<String, String> comboMap = new HashMap<String, String>(items.size());
            for (ComboItem combo : items) {
                comboMap.put(combo.getValue(), combo.getCaption().getLocaleValue());
            }
            this.getPageCache().put(Cache_SourceFieldComboMap, SerializationUtils.serializeToBase64(comboMap));
            this.getPageCache().put(Cache_SourceFieldCombo, SerializationUtils.serializeToBase64(items));
        }
        ComboEdit comboEditor = (ComboEdit)this.getView().getControl(RATE);
        comboEditor.setComboItems(items);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (RATE_EXP_DESC.equalsIgnoreCase(actionId)) {
            this.receiveExpression(closedCallBackEvent);
        }
    }

    private void receiveExpression(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() != null) {
            String returnStr = (String)closedCallBackEvent.getReturnData();
            if (StringUtils.isBlank((String)returnStr)) {
                this.getModel().setValue(RATE_EXP, (Object)"");
                this.getModel().setValue(RATE_EXP_DESC, (Object)"");
            } else {
                VchReturnData retData = (VchReturnData)SerializationUtils.fromJsonString((String)returnStr, VchReturnData.class);
                VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)retData.getDataStr(), VchTplExpression.class);
                this.getModel().setValue(RATE_EXP, (Object)filterObj.getExpression());
                String desp = filterObj.getDescription().toString();
                if (StringUtils.isEmpty((String)desp)) {
                    desp = filterObj.getExprTran();
                }
                this.getModel().setValue(RATE_EXP_DESC, (Object)desp);
            }
        }
    }

    private MainEntityType getMainEntityType() {
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam("sourcebill");
        boolean isevent = (Boolean)this.getView().getFormShowParameter().getCustomParam("isevent");
        MainEntityType mainType = isevent ? AiEventMetaUtil.getEntityType((Object)Long.valueOf(sourceBill)) : EntityMetadataCache.getDataEntityType((String)sourceBill);
        return mainType;
    }
}

