/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.entity.businessfield.AssistantField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.ai.formplugin.DSField;
import kd.fi.ai.formplugin.FactorInfo;
import kd.fi.ai.formplugin.importhandler.AsstDimMapTypeImportHandler;
import kd.fi.ai.util.DsfieldAsstactTypeMappingHelper;
import kd.fi.ai.util.GLUtil;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.utils.FahEntityMetaHelper;

public class asstDimMapTypeEdit
extends AbstractBasePlugIn {
    private static final String ASSTACTTYPE = "asstacttype";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ASSTFIELD_ASST = "asstfield_asst";
    private static final String ASSTFIELD = "asstfield";
    private static final String DS_FIELDS = "DSFields";
    private static String Key_FactorF7 = "factorname";
    private static String Key_FactorValue = "factorvalue";
    private static String Key_FactorValue_BaseData = "factorvalue_basedata";
    private static String Key_FactorValue_AsstData = "factorvalue_asstdata";
    private static final String ASSTFACTOR = "asstfactor";
    private static final String BASEFACTOR = "basefactor";
    private static final String Key_AutoMap_Number = "automap_number";
    private static final String SELECTENTRY = "entryentity";

    public void initialize() {
        super.initialize();
        OperationStatus stat = this.getView().getFormShowParameter().getStatus();
        if (!OperationStatus.VIEW.equals((Object)stat)) {
            this.addClickListeners(new String[]{Key_FactorF7});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if (c.getKey().equals(Key_FactorF7)) {
            this.showFactorList();
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        new AsstDimMapTypeImportHandler().beforeImporChecktData(e);
    }

    public void afterImportData(ImportDataEventArgs e) {
        new AsstDimMapTypeImportHandler().setSourceDataToModel(this.getModel(), this.getView());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void numberAutoMapping() {
        String DSStr = this.getPageCache().get(DS_FIELDS);
        List dsfields = new ArrayList(5);
        if (DSStr != null) {
            dsfields = SerializationUtils.fromJsonStringToList((String)DSStr, DSField.class);
        }
        IFormView view = this.getView();
        int size = dsfields.size();
        if (size != 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u76ee\u524d\u652f\u6301\u81ea\u52a8\u6620\u5c04\u5355\u4e2a\u5f71\u54cd\u56e0\u7d20\u3002", (String)"asstDimMapTypeEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject asstacttype = (DynamicObject)this.getModel().getValue(ASSTACTTYPE);
        if (null == asstacttype) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"asstDimMapTypeEdit_5", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        String valueType = asstacttype.getString("valuetype");
        if ("3".equals(valueType)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6b64\u6838\u7b97\u7ef4\u5ea6\u7c7b\u578b\u4e0d\u652f\u6301\u81ea\u52a8\u6620\u5c04\u3002", (String)"asstDimMapTypeEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        DSField dsField = (DSField)dsfields.get(0);
        String fieldKey = dsField.getFieldKey();
        List<QFilter> dsFilters = null;
        List<QFilter> aTFilters = null;
        String asstactTypeKey = null;
        if ("1".equals(valueType)) {
            asstactTypeKey = ASSTFIELD;
        } else if ("2".equals(valueType)) {
            asstactTypeKey = ASSTFIELD_ASST;
        }
        IDataModel model = this.getModel();
        Long orgId = (Long)model.getValue("useorg_id");
        DsfieldAsstactTypeMappingHelper helper = new DsfieldAsstactTypeMappingHelper("number", dsField, dsFilters, asstacttype, aTFilters, orgId);
        model.beginInit();
        try (DataSet ds = helper.mappingFinish();){
            if (ds != null) {
                model.deleteEntryData("entryentity");
                int count = ds.copy().count("asstact", false);
                if (count == 0) {
                    return;
                }
                int[] indexs = this.getModel().batchCreateNewEntryRow("entryentity", count);
                int i = 0;
                for (Row row : ds) {
                    int index = indexs[i++];
                    Object asstactTypeId = row.get("asstact");
                    Object dsId = row.get("ds");
                    model.setValue(asstactTypeKey, asstactTypeId, index);
                    model.setValue(fieldKey, dsId, index);
                }
            }
        }
        finally {
            model.endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit asstype = (BasedataEdit)this.getView().getControl(ASSTACTTYPE);
        asstype.addBeforeF7SelectListener(select -> {
            Long useOrgId = (Long)this.getModel().getValue("useorg_id");
            ListShowParameter showParam = (ListShowParameter)select.getFormShowParameter();
            List filters = showParam.getListFilterParameter().getQFilters();
            filters.add(new QFilter("id", "in", (Object)GLUtil.getAssistPKByOrg((Long)useOrgId)));
            filters.add(new QFilter("enable", "=", (Object)"1"));
            showParam.setCustomParam("isCustom", (Object)true);
        });
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object ret = e.getReturnData();
        if (e.getActionId().equals("ai_accountfactorlistf7") && ret != null) {
            List factorItems = (List)ret;
            this.genFactor(factorItems);
        }
    }

    private void showFactorList() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ai_accountfactorlistf7");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObjectCollection fieldmapentry = this.getModel().getEntryEntity("fieldmapentry");
        if (fieldmapentry.size() != 0) {
            HashMap<String, FactorInfo> factorInfoMap = new HashMap<String, FactorInfo>();
            FactorInfo info = null;
            for (DynamicObject dyn : fieldmapentry) {
                info = new FactorInfo();
                info.setBDType(Integer.parseInt(dyn.getString("datatype")));
                info.setSrcEntityNumber(dyn.getString("entityid"));
                info.setSrcPropKey(dyn.getString("entityid"));
                String fieldname = 0 == info.getBDType() ? FahEntityMetaHelper.getEntityName((Object)info.getSrcEntityNumber()) : (1 == info.getBDType() ? FahEntityMetaHelper.getEntityName((Object)ObjectConverterFactory.getLong((Object)info.getSrcEntityNumber())) : dyn.getString("fieldname"));
                info.setSrcEntityName(fieldname);
                info.setFactorName(fieldname);
                factorInfoMap.put(dyn.getString("entityid"), info);
            }
            showParameter.setCustomParam("info", (Object)GLUtil.toSerializedString(factorInfoMap));
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "ai_accountfactorlistf7");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        if (this.getPageCache().get("inited") == null) {
            MainEntityType entitytype = e.getOriginalEntityType();
            BaseShowParameter baseparam = (BaseShowParameter)this.getView().getFormShowParameter();
            Object pk = baseparam.getPkId();
            if (pk != null) {
                DynamicObject editdata = BusinessDataServiceHelper.loadSingle((Object)pk, (String)entitytype.getName());
                DynamicObjectCollection mapdatas = editdata.getDynamicObjectCollection("fieldmapentry");
                ArrayList<DSField> list = new ArrayList<DSField>();
                for (DynamicObject map : mapdatas) {
                    DSField sd = new DSField();
                    sd.setDataType(map.getString("datatype"));
                    sd.setEntityId(map.getString("entityid"));
                    sd.setFieldKey(map.getString("fieldkey"));
                    if (sd.getFieldKey().startsWith(BASEFACTOR)) {
                        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)sd.getEntityId());
                        sd.setFieldName(dataEntityType.getDisplayName());
                    } else if (sd.getFieldKey().startsWith(ASSTFACTOR)) {
                        String name = FahEntityMetaHelper.getEntityName((Object)ObjectConverterFactory.getLong((Object)sd.getEntityId()));
                        sd.setFieldName(new LocaleString(name));
                    } else {
                        sd.setFieldName(new LocaleString(map.getString("fieldname")));
                    }
                    list.add(sd);
                }
                this.reBuildModelAndGrid(list, entitytype, editdata.getDynamicObject(ASSTACTTYPE), true);
                e.setNewEntityType(entitytype);
            }
            this.getPageCache().put("inited", "true");
        } else {
            DynamicObject asstacttype = (DynamicObject)this.getModel().getValue(ASSTACTTYPE);
            DynamicObjectCollection mapdatas = this.getModel().getEntryEntity("fieldmapentry");
            ArrayList<DSField> list = new ArrayList<DSField>();
            for (DynamicObject map : mapdatas) {
                DSField sd = new DSField();
                sd.setDataType(map.getString("datatype"));
                sd.setEntityId(map.getString("entityid"));
                sd.setFieldKey(map.getString("fieldkey"));
                if (sd.getFieldKey().startsWith(BASEFACTOR)) {
                    MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)sd.getEntityId());
                    sd.setFieldName(dataEntityType.getDisplayName());
                } else if (sd.getFieldKey().startsWith(ASSTFACTOR)) {
                    String name = FahEntityMetaHelper.getEntityName((Object)ObjectConverterFactory.getLong((Object)sd.getEntityId()));
                    sd.setFieldName(new LocaleString(name));
                } else {
                    sd.setFieldName(new LocaleString(map.getString("fieldname")));
                }
                if (!StringUtils.isNotBlank((CharSequence)map.getString("entityid"))) continue;
                list.add(sd);
            }
            MainEntityType entitytype = e.getOriginalEntityType();
            this.reBuildModelAndGrid(list, entitytype, asstacttype, true);
            e.setNewEntityType(entitytype);
        }
    }

    public void afterBindData(EventObject e) {
        String factorValue;
        super.afterBindData(e);
        OperationStatus stat = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW.equals((Object)stat)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_save"});
        }
        if (StringUtils.isNotEmpty((CharSequence)(factorValue = (String)this.getModel().getValue(Key_FactorValue)))) {
            String[] factorValues = factorValue.split(",");
            Object[] factorNames = FahEntityMetaHelper.batchGetFactorName((String[])factorValues);
            String nameStr = StringUtils.join((Object[])factorNames, (String)",");
            this.getModel().setValue(Key_FactorF7, (Object)nameStr);
        }
    }

    private void reBuildModelAndGrid(List<DSField> list, MainEntityType mainEntityType, DynamicObject asstacttype, boolean rebuildGrid) {
        this.setFactorColumnMeta(list, mainEntityType);
        this.drawGrid(list, mainEntityType, asstacttype, rebuildGrid);
        this.getPageCache().put(DS_FIELDS, SerializationUtils.toJsonString(list));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (ASSTACTTYPE.equals(key)) {
            String DSStr = this.getPageCache().get(DS_FIELDS);
            List dsfields = null;
            if (DSStr != null) {
                dsfields = SerializationUtils.fromJsonStringToList((String)DSStr, DSField.class);
            }
            this.getModel().deleteEntryData("entryentity");
            this.drawGrid(dsfields, this.getModel().getDataEntityType(), (DynamicObject)this.getModel().getValue(ASSTACTTYPE), true);
            this.getModel().createNewEntryRow("entryentity");
        }
    }

    private void genFactor(List<Map<String, String>> factorItems) {
        IDataModel model = this.getModel();
        if (factorItems.size() > 10) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u76ee\u524d\u652f\u6301\u6700\u591a10\u4e2a\u5f71\u54cd\u56e0\u7d20\u3002", (String)"asstDimMapTypeEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        String entityNumber = "";
        String entityName = "";
        String fbdtype = "0";
        String baseDataEntity = "";
        String asstDataEntity = "";
        ArrayList<DSField> fields = new ArrayList<DSField>(factorItems.size());
        int i = 0;
        int j = 0;
        for (Map<String, String> map : factorItems) {
            entityNumber = entityNumber + map.get("fsrcentitynumber") + ",";
            entityName = entityName + map.get("fsrcentityname") + ",";
            fbdtype = map.get("fbdtype");
            if ("0".equals(fbdtype)) {
                baseDataEntity = baseDataEntity + map.get("fsrcentitynumber") + ",";
            } else if ("1".equals(fbdtype)) {
                asstDataEntity = asstDataEntity + map.get("fsrcentitynumber") + ",";
            }
            DSField field = new DSField();
            field.setDataType(fbdtype);
            field.setEntityId(map.get("fsrcentitynumber"));
            if ("0".equals(fbdtype)) {
                field.setFieldKey(BASEFACTOR + i);
                ++i;
            } else if ("1".equals(fbdtype)) {
                field.setFieldKey(ASSTFACTOR + j);
                ++j;
            }
            field.setFieldName(new LocaleString(map.get("fsrcentityname")));
            fields.add(field);
        }
        if (factorItems.size() > 0) {
            entityNumber = entityNumber.substring(0, entityNumber.length() - 1);
            entityName = entityName.substring(0, entityName.length() - 1);
        }
        if (baseDataEntity.endsWith(",")) {
            baseDataEntity = baseDataEntity.substring(0, baseDataEntity.length() - 1);
        }
        if (asstDataEntity.endsWith(",")) {
            asstDataEntity = asstDataEntity.substring(0, asstDataEntity.length() - 1);
        }
        model.setValue(Key_FactorF7, (Object)entityName);
        model.setValue(Key_FactorValue, (Object)entityNumber);
        model.setValue(Key_FactorValue_BaseData, (Object)baseDataEntity);
        model.setValue(Key_FactorValue_AsstData, (Object)asstDataEntity);
        this.saveFactorDataToModel(fields);
        DynamicObject asstacttype = (DynamicObject)this.getModel().getValue(ASSTACTTYPE);
        this.reBuildModelAndGrid(fields, model.getDataEntityType(), asstacttype, true);
        this.getModel().createNewEntryRow("entryentity");
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "automap_number": {
                this.numberAutoMapping();
                break;
            }
        }
    }

    private void saveFactorDataToModel(List<DSField> refList) {
        IDataModel model = this.getModel();
        model.deleteEntryData("fieldmapentry");
        model.deleteEntryData("entryentity");
        for (DSField field : refList) {
            int rowIndex = model.createNewEntryRow("fieldmapentry");
            model.setValue("datatype", (Object)field.getDataType(), rowIndex);
            model.setValue("entityid", (Object)field.getEntityId(), rowIndex);
            model.setValue("fieldname", (Object)field.getFieldName(), rowIndex);
            model.setValue("fieldkey", (Object)field.getFieldKey(), rowIndex);
        }
    }

    private void setFactorColumnMeta(List<DSField> refList, MainEntityType mainEntityType) {
        EntryProp entry = (EntryProp)mainEntityType.getProperty("entryentity");
        for (DSField field : refList) {
            BasedataProp prop;
            if ("0".equals(field.getDataType())) {
                prop = (BasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty(field.getFieldKey());
                if ("bos_adminorg_structure".equalsIgnoreCase(field.getEntityId())) {
                    prop.setBaseEntityId("bos_org");
                    prop.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)field.getEntityId())) continue;
                try {
                    prop.setBaseEntityId(field.getEntityId());
                    prop.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)field.getEntityId()));
                }
                catch (Exception e) {
                    this.getView().showTipNotification(e.getMessage());
                }
                continue;
            }
            if (!"1".equals(field.getDataType())) continue;
            prop = (AssistantProp)entry.getDynamicCollectionItemPropertyType().getProperty(field.getFieldKey());
            prop.setAsstParentId(field.getEntityId());
            prop.setAsstTypeId(field.getEntityId());
        }
    }

    private void drawGrid(List<DSField> refList, MainEntityType mainEntityType, DynamicObject asstacttype, boolean rebuildGrid) {
        Map<String, Object> assCol;
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>();
        cols.add(this.createSeqColumn());
        if (refList != null) {
            for (DSField ref : refList) {
                Map<String, Object> col = this.createBaseDataColumn(ref);
                cols.add(col);
            }
        }
        if ((assCol = this.createAssTypeColumn(mainEntityType, asstacttype)) != null) {
            cols.add(assCol);
        }
        if (rebuildGrid) {
            HashMap<String, Object> meta = new HashMap<String, Object>();
            meta.put("rk", "rk");
            meta.put("seq", "fseq");
            meta.put("columns", cols);
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.preInvokeControlMethod("entryentity", "createGridColumns", new Object[]{meta});
        }
    }

    private Map<String, Object> createAssTypeColumn(MainEntityType mainEntityType, DynamicObject asstacttype) {
        if (asstacttype == null) {
            return null;
        }
        EntryFieldAp f7Field = new EntryFieldAp();
        f7Field.setName(new LocaleString(asstacttype.getString("name")));
        f7Field.setFieldTextAlign("center");
        f7Field.setTextAlign("center");
        f7Field.setAlignSelf("center");
        f7Field.setWidth(new LocaleString("350"));
        f7Field.setLock("");
        f7Field.setQuickAddNew(false);
        EntryProp entry = (EntryProp)mainEntityType.getProperty("entryentity");
        String valuetype = asstacttype.getString("valuetype");
        String displayProp = "number,name";
        if ("1".equals(valuetype)) {
            String entityNumber = this.getAsstactTypeEntityNumber(asstacttype);
            if (entityNumber != null) {
                BasedataField basedata = new BasedataField();
                basedata.setBaseEntityId(entityNumber);
                basedata.setKey(ASSTFIELD);
                basedata.setDisplayProp(displayProp);
                f7Field.setKey(ASSTFIELD);
                f7Field.setField((Field)basedata);
                BasedataProp prop = (BasedataProp)entry.getDynamicCollectionItemPropertyType().getProperty(ASSTFIELD);
                prop.setBaseEntityId(entityNumber);
                prop.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber));
                return (Map)f7Field.createColumns().get(0);
            }
        } else {
            if ("2".equals(valuetype)) {
                DynamicObject source = asstacttype.getDynamicObject("assistanttype");
                if (source != null) {
                    AssistantField asstData = new AssistantField();
                    asstData.setAsstTypeId(source.getString("id"));
                    asstData.setAsstParentId(source.getString("id"));
                    asstData.setKey(ASSTFIELD_ASST);
                    asstData.setDisplayProp(displayProp);
                    f7Field.setKey(ASSTFIELD_ASST);
                    f7Field.setField((Field)asstData);
                    AssistantProp prop = (AssistantProp)entry.getDynamicCollectionItemPropertyType().getProperty(ASSTFIELD_ASST);
                    prop.setAsstParentId(source.getString("id"));
                    prop.setAsstTypeId(source.getString("id"));
                    return (Map)f7Field.createColumns().get(0);
                }
                this.getView().showMessage(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\u7ed1\u5b9a\u7684\u8f85\u52a9\u503c\u6765\u6e90\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6838\u7b97\u7ef4\u5ea6\u57fa\u7840\u8d44\u6599\u914d\u7f6e\u3002", (String)"asstDimMapTypeEdit_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return null;
            }
            if ("3".equals(valuetype)) {
                TextField txtData = new TextField();
                txtData.setKey("asstfield_text");
                f7Field.setKey("asstfield_text");
                txtData.setMaxLength(200);
                txtData.setMinLength(0);
                f7Field.setField((Field)txtData);
                return (Map)f7Field.createColumns().get(0);
            }
        }
        return null;
    }

    private String getAsstactTypeEntityNumber(DynamicObject asstacttype) {
        String entityNumber = null;
        Object valueSource = asstacttype.get("valuesource");
        if (valueSource instanceof DynamicObject) {
            DynamicObject typeSource = asstacttype.getDynamicObject("valuesource");
            if (typeSource != null) {
                entityNumber = typeSource.getString("number");
            }
        } else if (valueSource instanceof String && StringUtils.isNotEmpty((CharSequence)((String)valueSource))) {
            entityNumber = (String)valueSource;
        }
        return entityNumber;
    }

    private Map<String, Object> createBaseDataColumn(DSField ds) {
        EntryFieldAp f7Field = new EntryFieldAp();
        f7Field.setKey(ds.getFieldKey());
        f7Field.setName(ds.getFieldName());
        f7Field.setFieldTextAlign("center");
        f7Field.setTextAlign("center");
        f7Field.setAlignSelf("center");
        f7Field.setWidth(new LocaleString("350"));
        f7Field.setLock("");
        f7Field.setQuickAddNew(false);
        String displayProp = "number,name";
        if ("0".equals(ds.getDataType())) {
            BasedataField basedata = new BasedataField();
            if ("bos_adminorg_structure".equalsIgnoreCase(ds.getEntityId())) {
                basedata.setBaseEntityId("bos_org");
            } else {
                basedata.setBaseEntityId(ds.getEntityId());
            }
            basedata.setKey(ds.getFieldKey());
            basedata.setDisplayProp(displayProp);
            f7Field.setField((Field)basedata);
        } else {
            AssistantField asstData = new AssistantField();
            asstData.setAsstTypeId(ds.getEntityId());
            asstData.setAsstParentId(ds.getEntityId());
            asstData.setKey(ds.getFieldKey());
            asstData.setDisplayProp(displayProp);
            f7Field.setField((Field)asstData);
        }
        Map map = (Map)f7Field.createColumns().get(0);
        if ("bos_adminorg_structure".equalsIgnoreCase(ds.getEntityId())) {
            map.put("type", "org");
        }
        return map;
    }

    private Map<String, Object> createSeqColumn() {
        HashMap<String, Object> col = new HashMap<String, Object>();
        col.put("dataIndex", "seq");
        col.put("width", 60);
        col.put("header", new LocaleString(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"asstDimMapTypeEdit_4", (String)"fi-ai-formplugin", (Object[])new Object[0])));
        col.put("type", "numberfield");
        col.put("isColPageFixed", Boolean.TRUE);
        return col;
    }
}

