/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin.importhandler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.ai.constant.AsstDimConstant;

public class AsstDimMapTypeImportHandler {
    public static final String ENTITY_BOSORG = "bos_org";

    public void beforeImporChecktData(BeforeImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        Object inputOrg = sourceData.get("createorg");
        if (null == inputOrg) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AsstDimMapTypeImportHandler_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Map orgMap = (Map)inputOrg;
        String orgNumber = (String)orgMap.get("number");
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_BOSORG, (String)"id", (QFilter[])new QFilter("number", "=", (Object)orgNumber).toArray());
        if (org == null) {
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%s\u201d\u7684\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AsstDimMapTypeImportHandler_1", (String)"fi-ai-formplugin", (Object[])new Object[0]), orgNumber));
            e.setCancel(true);
            return;
        }
        JSONArray fieldArray = (JSONArray)sourceData.get("fieldmapentry");
        if (fieldArray != null && !fieldArray.isEmpty() && fieldArray.stream().map(s -> ((JSONObject)s).getString("entityid")).distinct().count() != (long)fieldArray.size()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\u7684\u5b9e\u4f53\u7c7b\u578b\u201centityid\u201d\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AsstDimMapTypeImportHandler_3", (String)"fi-ai-formplugin", (Object[])new Object[0]), new Object[0]));
        }
    }

    public void setSourceDataToModel(IDataModel model, IFormView view) {
        Map numberIdMap;
        DynamicObject asstacttype = (DynamicObject)model.getValue("asstacttype");
        if (asstacttype == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6.\u7f16\u7801\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AsstDimMapTypeImportHandler_4", (String)"fi-ai-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        String valuetype = asstacttype.getString("valuetype");
        DynamicObjectCollection entryEntities = (DynamicObjectCollection)model.getValue("entryentity");
        DynamicObjectCollection importsCollection = (DynamicObjectCollection)model.getValue("factorimport");
        if (CollectionUtils.isEmpty((Collection)importsCollection)) {
            return;
        }
        ArrayList<String> destList = new ArrayList<String>();
        Long orgId = (Long)model.getValue("org_id");
        HashMap<String, String> fieldEntryNameMap = new HashMap<String, String>();
        HashMap<String, List<String>> fieldEntryValueMap = new HashMap<String, List<String>>();
        HashMap<String, String> fieldAssisNumberMap = new HashMap<String, String>();
        HashMap<String, String> fieldBaseDataNumberMap = new HashMap<String, String>();
        HashMap<String, Set<String>> subAssisNumberMap = new HashMap<String, Set<String>>();
        HashMap<String, List<String>> subBaseDataNumberMap = new HashMap<String, List<String>>();
        HashMap<String, Map> numberIdMapByType = new HashMap<String, Map>();
        HashMap<String, Map> numberNameMapByType = new HashMap<String, Map>();
        String factorNumber = null;
        String factorValue = null;
        entryEntities.clear();
        for (DynamicObject entryEntity : importsCollection) {
            destList.add(entryEntity.getString("asstvalue"));
            entryEntities.addNew();
            for (int i = 0; i < 10; ++i) {
                factorNumber = entryEntity.getString("factornumber" + i);
                factorValue = entryEntity.getString("factorvalue" + i);
                if (StringUtils.isEmpty((CharSequence)factorNumber)) continue;
                if (factorNumber.startsWith("[2]")) {
                    fieldEntryNameMap.put("asstfactor" + i, factorNumber.substring(3));
                    fieldEntryValueMap.computeIfAbsent("asstfactor" + i, key -> new ArrayList(10)).add(factorValue);
                    continue;
                }
                fieldEntryNameMap.put("basefactor" + i, factorNumber);
                fieldEntryValueMap.computeIfAbsent("basefactor" + i, key -> new ArrayList(10)).add(factorValue);
            }
        }
        if (CollectionUtils.isEmpty(destList)) {
            return;
        }
        this.fillAssisBaseDataMap(fieldEntryNameMap, fieldAssisNumberMap, fieldBaseDataNumberMap);
        String destNumber = null;
        if ("2".equals(valuetype)) {
            destNumber = String.valueOf(asstacttype.getDynamicObject("assistanttype").get("number"));
            fieldAssisNumberMap.put("asstfield", destNumber);
            subAssisNumberMap.put("asstfield", new HashSet(destList));
        } else if ("1".equals(valuetype)) {
            destNumber = AsstDimConstant.getAsstactTypeEntityNumber((DynamicObject)asstacttype);
            fieldBaseDataNumberMap.put("asstfield", destNumber);
            subBaseDataNumberMap.put("asstfield", destList);
        }
        if (!fieldAssisNumberMap.isEmpty()) {
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
            QFilter qFilter = this.getFactorBaseDataFilter("bos_assistantdatagroup", orgId);
            if (qFilter != null) {
                filterList.add(qFilter);
            }
            filterList.add(new QFilter("number", "in", fieldAssisNumberMap.values()));
            Map assistantMap = BusinessDataServiceHelper.loadFromCache((String)"bos_assistantdatagroup", (String)"id,number,name", (QFilter[])filterList.toArray(new QFilter[0]));
            for (Map.Entry entry : assistantMap.entrySet()) {
                Map numberIdMap2 = numberIdMapByType.computeIfAbsent("bos_assistantdatagroup", k -> new HashMap());
                numberIdMap2.put(((DynamicObject)entry.getValue()).getString("number"), ((DynamicObject)entry.getValue()).getString("id"));
                Map numberNameMap = numberNameMapByType.computeIfAbsent("bos_assistantdatagroup", k -> new HashMap());
                numberNameMap.put(((DynamicObject)entry.getValue()).getString("number"), ((DynamicObject)entry.getValue()).getString("name"));
            }
        }
        this.fillSubAssisBaseDataMap(fieldEntryNameMap, fieldEntryValueMap, subAssisNumberMap, subBaseDataNumberMap);
        if (!subAssisNumberMap.isEmpty()) {
            for (Map.Entry entry : subAssisNumberMap.entrySet()) {
                String id = (String)((Map)numberIdMapByType.get("bos_assistantdatagroup")).get(String.valueOf(fieldAssisNumberMap.get(entry.getKey())));
                Map<Object, DynamicObject> subAssistantMap = this.getAssistData(id, orgId, (Set)entry.getValue());
                for (Map.Entry<Object, DynamicObject> ety : subAssistantMap.entrySet()) {
                    numberIdMap = numberIdMapByType.computeIfAbsent(id, k -> new HashMap());
                    numberIdMap.put(ety.getValue().getString("number"), ety.getValue().getString("id"));
                    Map numberNameMap = numberNameMapByType.computeIfAbsent(id, k -> new HashMap());
                    numberNameMap.put(ety.getValue().getString("number"), ety.getValue().getString("name"));
                }
            }
        }
        if (!subBaseDataNumberMap.isEmpty()) {
            String entityName = "";
            for (Map.Entry ety : subBaseDataNumberMap.entrySet()) {
                entityName = (String)fieldBaseDataNumberMap.get(ety.getKey());
                Map<Object, DynamicObject> subBaseDataMap = this.getBaseData(entityName, orgId, (List)ety.getValue());
                for (Map.Entry<Object, DynamicObject> subBaseEty : subBaseDataMap.entrySet()) {
                    numberIdMap = numberIdMapByType.computeIfAbsent(entityName, k -> new HashMap());
                    numberIdMap.put(subBaseEty.getValue().getString("number"), subBaseEty.getValue().getString("id"));
                    String baseDataName = subBaseEty.getValue().getDataEntityType().getDisplayName().getLocaleValue();
                    Map numberNameMap = numberNameMapByType.computeIfAbsent(entityName, k -> new HashMap());
                    numberNameMap.put(subBaseEty.getValue().getString("number"), baseDataName);
                }
            }
        }
        StringBuffer factoryValue = new StringBuffer();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer factorvalue_basedata = new StringBuffer();
        StringBuffer factorvalue_asstdata = new StringBuffer();
        HashSet<String> hashSet = new HashSet<String>(5);
        String curValue = "";
        String curName = "";
        for (Map.Entry ety : fieldEntryNameMap.entrySet()) {
            curValue = (String)ety.getValue();
            if (((String)ety.getKey()).startsWith("asstfactor") && factorvalue_asstdata.indexOf((String)((Map)numberIdMapByType.get("bos_assistantdatagroup")).get(curValue)) == -1) {
                factorvalue_asstdata.append((String)((Map)numberIdMapByType.get("bos_assistantdatagroup")).get(curValue)).append(",");
                factoryValue.append((String)((Map)numberIdMapByType.get("bos_assistantdatagroup")).get(curValue)).append(",");
                continue;
            }
            if (!((String)ety.getKey()).startsWith("basefactor") || factorvalue_basedata.indexOf(curValue) != -1) continue;
            factorvalue_basedata.append(curValue).append(",");
            factoryValue.append(curValue).append(",");
        }
        model.setValue("factorvalue_asstdata", (Object)this.convertToString(factorvalue_asstdata));
        model.setValue("factorvalue_basedata", (Object)this.convertToString(factorvalue_basedata));
        model.setValue("factorvalue", (Object)this.convertToString(factoryValue));
        DynamicObjectCollection fieldMapEntries = (DynamicObjectCollection)model.getValue("fieldmapentry");
        DynamicObjectType fieldMapType = fieldMapEntries.getDynamicObjectType();
        fieldMapEntries.clear();
        String entryId = "";
        String entryValueKey = "";
        fieldEntryValueMap.put("asstfield", destList);
        fieldEntryNameMap.put("asstfield", destNumber);
        for (Map.Entry ety : fieldEntryValueMap.entrySet()) {
            int dataType = -1;
            entryValueKey = (String)ety.getKey();
            if (((String)ety.getKey()).startsWith("asstfactor")) {
                dataType = 1;
                entryId = (String)((Map)numberIdMapByType.get("bos_assistantdatagroup")).get(fieldEntryNameMap.get(ety.getKey()));
                curName = (String)((Map)numberNameMapByType.get("bos_assistantdatagroup")).get(fieldEntryNameMap.get(ety.getKey()));
                if (StringUtils.isEmpty((CharSequence)curName)) {
                    DynamicObject dyAssist = BusinessDataServiceHelper.newDynamicObject((String)"bos_assistantdatagroup");
                    curName = dyAssist.getDataEntityType().getDisplayName().getLocaleValue();
                }
            } else if (((String)ety.getKey()).startsWith("basefactor")) {
                dataType = 0;
                entryId = (String)fieldEntryNameMap.get(ety.getKey());
                curName = "";
                if (StringUtils.isEmpty((CharSequence)curName)) {
                    DynamicObject dySubBase = BusinessDataServiceHelper.newDynamicObject((String)entryId);
                    curName = dySubBase.getDataEntityType().getDisplayName().getLocaleValue();
                }
            }
            for (int i = 0; i < ((List)ety.getValue()).size(); ++i) {
                DynamicObject dyData = new DynamicObject();
                Map dataMap = new HashMap(16);
                if (dataType == 0 || "asstfield".equals(entryValueKey) && "1".equals(valuetype)) {
                    dyData = BusinessDataServiceHelper.newDynamicObject((String)((String)fieldEntryNameMap.get(ety.getKey())));
                    dataMap = (Map)numberIdMapByType.get(fieldEntryNameMap.get(ety.getKey()));
                } else if (dataType == 1 || "asstfield".equals(entryValueKey) && "2".equals(valuetype)) {
                    dyData = BusinessDataServiceHelper.newDynamicObject((String)"bos_assistantdatagroup");
                    String asstGroupId = (String)((Map)numberIdMapByType.get("bos_assistantdatagroup")).get(fieldEntryNameMap.get(ety.getKey()));
                    dataMap = (Map)numberIdMapByType.get(asstGroupId);
                }
                String subNumber = (String)((List)ety.getValue()).get(i);
                if (dataMap != null && !dataMap.isEmpty()) {
                    dyData.set("id", dataMap.get(subNumber));
                    dyData.set("number", (Object)subNumber);
                    if ("asstfield".equals(entryValueKey) && "2".equals(valuetype)) {
                        ((DynamicObject)entryEntities.get(i)).set("asstfield_asst", (Object)dyData);
                    } else {
                        ((DynamicObject)entryEntities.get(i)).set(entryValueKey, (Object)dyData);
                    }
                }
                if (!"3".equals(valuetype)) continue;
                ((DynamicObject)entryEntities.get(i)).set("asstfield_text", (Object)subNumber);
            }
            if (!hashSet.add(curName) || "asstfield".equals(entryValueKey)) continue;
            stringBuffer.append(curName).append(",");
            DynamicObject dyFieldMap = new DynamicObject(fieldMapType);
            dyFieldMap.set("datatype", (Object)dataType);
            dyFieldMap.set("fieldkey", ety.getKey());
            dyFieldMap.set("entityid", (Object)entryId);
            dyFieldMap.set("fieldname", (Object)curName);
            fieldMapEntries.add((Object)dyFieldMap);
        }
        model.setValue("factorname", (Object)this.convertToString(stringBuffer));
    }

    public Map<Object, DynamicObject> getAssistData(String id, Long orgId, Set<String> numbers) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        QFilter orgFilter = this.getFactorBaseDataFilter("bos_assistantdata_detail", orgId);
        if (orgFilter != null) {
            filterList.add(orgFilter);
        }
        QFilter groupFilter = new QFilter("group", "=", (Object)Long.valueOf(id));
        filterList.add(groupFilter);
        filterList.add(new QFilter("number", "in", numbers));
        Map subAssistantMap = BusinessDataServiceHelper.loadFromCache((String)"bos_assistantdata_detail", (String)"id,number,name", (QFilter[])filterList.toArray(new QFilter[0]));
        if (subAssistantMap == null || subAssistantMap.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6e90\u6570\u636e\u53d6\u503c\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u8f85\u52a9\u8d44\u6599\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AsstDimMapTypeImportHandler_5", (String)"fi-ai-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", numbers)));
        }
        if (numbers.size() > subAssistantMap.size()) {
            ArrayList<String> subAssistDataList = new ArrayList<String>(subAssistantMap.size());
            for (Map.Entry subAssistEty : subAssistantMap.entrySet()) {
                subAssistDataList.add(((DynamicObject)subAssistEty.getValue()).getString("number"));
            }
            Map tempMap = subAssistDataList.parallelStream().collect(Collectors.toMap(Function.identity(), Function.identity(), (oldData, newData) -> newData));
            List distinctList = numbers.parallelStream().filter(str -> !tempMap.containsKey(str)).collect(Collectors.toList());
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6e90\u6570\u636e\u53d6\u503c\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u8f85\u52a9\u8d44\u6599\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AsstDimMapTypeImportHandler_5", (String)"fi-ai-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", distinctList)));
        }
        return subAssistantMap;
    }

    public Map<Object, DynamicObject> getBaseData(String entityName, Long orgId, List<String> numbers) {
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        QFilter orgFilter = this.getFactorBaseDataFilter(entityName, orgId);
        if (orgFilter != null) {
            filterList.add(orgFilter);
        }
        QFilter numberFilter = new QFilter("number", "in", numbers);
        filterList.add(numberFilter);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        if (entityType.getAllFields().get("enable") != null) {
            filterList.add(new QFilter("enable", "=", (Object)"1"));
        }
        Map subBaseDataMap = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)"id,number,name", (QFilter[])filterList.toArray(new QFilter[0]));
        ArrayList<String> newList = new ArrayList<String>(new HashSet<String>(numbers));
        if (subBaseDataMap == null || subBaseDataMap.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u57fa\u7840\u8d44\u6599\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AsstDimMapTypeImportHandler_6", (String)"fi-ai-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", newList)));
        }
        if (newList.size() > subBaseDataMap.size()) {
            ArrayList<String> subBaseDataList = new ArrayList<String>(subBaseDataMap.size());
            for (Map.Entry subBaseEty : subBaseDataMap.entrySet()) {
                subBaseDataList.add(((DynamicObject)subBaseEty.getValue()).getString("number"));
            }
            Map tempMap = subBaseDataList.parallelStream().collect(Collectors.toMap(Function.identity(), Function.identity(), (oldData, newData) -> newData));
            List distinctList = newList.parallelStream().filter(str -> !tempMap.containsKey(str)).collect(Collectors.toList());
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u57fa\u7840\u8d44\u6599\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AsstDimMapTypeImportHandler_6", (String)"fi-ai-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", distinctList)));
        }
        return subBaseDataMap;
    }

    private String convertToString(StringBuffer sbInfo) {
        if (sbInfo == null || sbInfo.length() == 0) {
            return "";
        }
        if (sbInfo.length() > 0) {
            sbInfo = sbInfo.deleteCharAt(sbInfo.length() - 1);
        }
        return sbInfo.toString();
    }

    private void fillSubAssisBaseDataMap(Map<String, String> fieldEntryNameMap, Map<String, List<String>> fieldEntryValueMap, Map<String, Set<String>> subAssisNumberMap, Map<String, List<String>> subBaseDataNumberMap) {
        for (Map.Entry<String, List<String>> ety : fieldEntryValueMap.entrySet()) {
            List numberVals = ety.getValue().stream().filter(p -> StringUtils.isNotBlank((CharSequence)p)).collect(Collectors.toList());
            if (numberVals == null || numberVals.isEmpty()) continue;
            if (ety.getKey().startsWith("asstfactor")) {
                Set subAssisNumberSet = subAssisNumberMap.computeIfAbsent(ety.getKey(), k -> new HashSet());
                subAssisNumberSet.addAll(numberVals);
                continue;
            }
            subBaseDataNumberMap.put(ety.getKey(), numberVals);
        }
    }

    private void fillAssisBaseDataMap(Map<String, String> fieldEntryNameMap, Map<String, String> fieldAssisNumberMap, Map<String, String> fieldBaseDataNumberMap) {
        for (Map.Entry<String, String> ety : fieldEntryNameMap.entrySet()) {
            if (ety.getKey().startsWith("asstfactor")) {
                fieldAssisNumberMap.put(ety.getKey(), ety.getValue());
                continue;
            }
            fieldBaseDataNumberMap.put(ety.getKey(), ety.getValue());
        }
    }

    private QFilter getFactorBaseDataFilter(String entityKey, Long orgId) {
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityKey, (Long)orgId);
        return orgFilter;
    }
}

