/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.accsys.AccSysUtil;
import kd.fi.bd.consts.AccountType;

public class AccountMapTypeService {
    public static final String FORM_KEY = "ai_accountmaptype";

    public Set<Long> getAccountId(Collection<Long> orgIds) {
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        DynamicObject[] dynamicObjectsArr = BusinessDataServiceHelper.load((String)FORM_KEY, (String)"id", (QFilter[])new QFilter[]{orgFilter});
        int len = dynamicObjectsArr.length;
        HashSet<Long> accountmaptypeIdSet = new HashSet<Long>(len);
        if (dynamicObjectsArr == null || dynamicObjectsArr.length == 0) {
            return accountmaptypeIdSet;
        }
        for (int i = 0; i < len; ++i) {
            accountmaptypeIdSet.add(dynamicObjectsArr[i].getLong("id"));
        }
        return accountmaptypeIdSet;
    }

    public Set<Long> getAccountIdsByAllParentOrgId(Long orgId, Long bookTypeId, boolean includeParentSelf) {
        HashSet<Long> parentOrgIdSet = new HashSet<Long>();
        HashSet<Long> orgIdSet = new HashSet<Long>();
        orgIdSet.add(orgId);
        Long iOrgViewId = AccSysUtil.getMainViewByOrgAndBT((Long)orgId, (Long)bookTypeId);
        List parentOrgIdSetEach = AccSysUtil.getParentOrgId((Long)iOrgViewId, orgIdSet, (boolean)true);
        parentOrgIdSet.addAll(parentOrgIdSetEach);
        return this.getAccountId(parentOrgIdSet);
    }

    public List<String> getAccountType() {
        List<String> types = Arrays.asList(AccountType.BUDGET_ACCOUNT);
        return types;
    }

    public List<Long> getAccountTypeIds(Long accountTableId) {
        QFilter[] filters = new QFilter[]{new QFilter("accounttableid", "=", (Object)accountTableId), new QFilter("accounttype", "not in", this.getAccountType())};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bd_accounttype", (String)"id", (QFilter[])filters);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DynamicObject dynamic : collection) {
            ids.add(dynamic.getLong("id"));
        }
        return ids;
    }
}

