/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BasedataEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.BizAsstacttype;
import kd.fi.ai.BizVouSubEntry;

public class BizVoucherService {
    private static final String FENTRYID = "fentryid";
    private static final String FFLEXFIELD = "fflexfield";
    private static final String AI_ASSTACTTYPE = "ai_asstacttype";
    private Set<String> flexSet = new HashSet<String>();
    private Map<String, List<String>> valueKeyMap = new HashMap<String, List<String>>();

    public List<BizAsstacttype> getBizAsstacttypeList(Set<String> fieldSet) {
        ArrayList<BizAsstacttype> list = new ArrayList<BizAsstacttype>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)BizVoucherService.class.getName(), (String)AI_ASSTACTTYPE, (String)"datatype,valuesource,assistanttype,displayproperty,flexfiled,number,name", (QFilter[])new QFilter("flexfiled", "in", fieldSet).toArray(), (String)"flexfiled");){
            Iterator iterator = ds.iterator();
            BizAsstacttype bizAsstact = null;
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                bizAsstact = new BizAsstacttype();
                bizAsstact.setAssistanttype(row.getLong("assistanttype"));
                bizAsstact.setDatatype(row.getString("datatype"));
                bizAsstact.setDisplayproperty(row.getString("displayproperty"));
                bizAsstact.setFlexfiled(row.getString("flexfiled"));
                bizAsstact.setHeadName(row.getString("name"));
                bizAsstact.setNumber(row.getString("number"));
                bizAsstact.setValuesource(row.getString("valuesource"));
                list.add(bizAsstact);
            }
        }
        return list;
    }

    public Map<Long, List<BizVouSubEntry>> getBizVouSubEntry(List<Object> entryIds) {
        String sql = "select fentryid,fdetailid,fseq,fflexfield,fvalue from t_ai_bizvouchersubentry where ";
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(sql, new Object[0]).appendIn(FENTRYID, entryIds);
        HashMap<Long, List<BizVouSubEntry>> bizSubEntryMap = new HashMap<Long, List<BizVouSubEntry>>();
        BizVouSubEntry bizVouSubEntry = null;
        try (DataSet dataSet = DB.queryDataSet((String)BizVoucherService.class.getName(), (DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sqlBuilder);){
            Iterator it = dataSet.iterator();
            while (it.hasNext()) {
                bizVouSubEntry = new BizVouSubEntry();
                Row row = (Row)it.next();
                this.setBizVoucherEntry(bizVouSubEntry, row);
                String flex = row.getString(FFLEXFIELD);
                this.flexSet.add(flex);
                this.valueKeyMap.computeIfAbsent(flex, key -> new ArrayList()).add(row.getString("fvalue"));
                bizSubEntryMap.computeIfAbsent(row.getLong(FENTRYID), key -> new ArrayList()).add(bizVouSubEntry);
            }
        }
        return bizSubEntryMap;
    }

    public Set<String> getFlexSet() {
        return this.flexSet;
    }

    public Map<String, List<String>> getValueKeyMap() {
        return this.valueKeyMap;
    }

    public List<BizVouSubEntry> getBizVouSubEntry(Object entryId) {
        String sql = "select fentryid,fdetailid,fseq,fflexfield,fvalue from t_ai_bizvouchersubentry where fentryid = ?";
        ArrayList<BizVouSubEntry> bizSubEntrys = new ArrayList<BizVouSubEntry>();
        BizVouSubEntry bizVouSubEntry = null;
        Object[] obj = new Object[]{entryId};
        try (DataSet dataSet = DB.queryDataSet((String)BizVoucherService.class.getName(), (DBRoute)DBRoute.of((String)"ai"), (String)sql, (Object[])obj);){
            Iterator it = dataSet.iterator();
            while (it.hasNext()) {
                bizVouSubEntry = new BizVouSubEntry();
                Row row = (Row)it.next();
                this.setBizVoucherEntry(bizVouSubEntry, row);
                bizSubEntrys.add(bizVouSubEntry);
            }
        }
        return bizSubEntrys;
    }

    public void setFieldValue(Map<String, String> fieldMap, List<BizAsstacttype> asstacttypeList, Map<String, String> nameMap, Map<String, String> valueMap) {
        block8: for (BizAsstacttype asstact : asstacttypeList) {
            String flexfiled = asstact.getFlexfiled();
            nameMap.put(flexfiled, asstact.getHeadName());
            String datatype = asstact.getDatatype();
            String property = asstact.getDisplayproperty();
            String value = fieldMap.get(flexfiled);
            switch (datatype) {
                case "1": {
                    DynamicObject dynamicObject;
                    if (!StringUtils.isNotBlank((CharSequence)value) || (dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(value), (String)asstact.getValuesource())) == null) continue block8;
                    valueMap.put(flexfiled, this.setNameByDisplay(dynamicObject, property));
                    break;
                }
                case "2": {
                    DynamicObject dynamicObject;
                    if (!StringUtils.isNotBlank((CharSequence)value) || (dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(value), (String)"bos_assistantdata_detail")) == null) continue block8;
                    valueMap.put(flexfiled, this.setNameByDisplay(dynamicObject, property));
                    break;
                }
                default: {
                    valueMap.put(flexfiled, fieldMap.get(flexfiled));
                }
            }
        }
    }

    public String setNameByDisplay(DynamicObject dynamic, String property) {
        String display = "";
        BasedataEntityType bnt = (BasedataEntityType)dynamic.getDynamicObjectType();
        String numberProperty = bnt.getNumberProperty();
        String nameProperty = bnt.getNameProperty();
        switch (property) {
            case "1": {
                if (StringUtils.isEmpty((CharSequence)numberProperty)) {
                    display = String.valueOf(dynamic.getPkValue());
                    break;
                }
                display = dynamic.getString(numberProperty);
                break;
            }
            case "3": {
                if (StringUtils.isNotEmpty((CharSequence)numberProperty) && StringUtils.isEmpty((CharSequence)nameProperty)) {
                    display = dynamic.getString(numberProperty) + ":" + dynamic.getString(nameProperty);
                    break;
                }
                if (StringUtils.isNotEmpty((CharSequence)numberProperty)) {
                    display = dynamic.getString(numberProperty);
                    break;
                }
                if (StringUtils.isNotEmpty((CharSequence)nameProperty)) {
                    display = dynamic.getString(nameProperty);
                    break;
                }
                display = String.valueOf(dynamic.getPkValue());
                break;
            }
            default: {
                display = StringUtils.isEmpty((CharSequence)nameProperty) ? String.valueOf(dynamic.getPkValue()) : dynamic.getString(nameProperty);
            }
        }
        return display;
    }

    private void setBizVoucherEntry(BizVouSubEntry bizVouSubEntry, Row row) {
        bizVouSubEntry.setDetailid(row.getLong("fdetailid"));
        bizVouSubEntry.setEntryId(row.getLong(FENTRYID));
        bizVouSubEntry.setSeq(row.getInteger("fseq").intValue());
        bizVouSubEntry.setFlexField(row.getString(FFLEXFIELD));
        bizVouSubEntry.setValue(row.getString("fvalue"));
    }
}

