/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.formplugin.vchfieldchange;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.enums.CheckBoxEnum;
import kd.fi.ai.formplugin.vchfieldchange.VchChangeSelectEdit;

public class VchChangeFieldEdit
extends AbstractBillPlugIn {
    private static final String VOUCHER_FIELD_NAME = "voucherfieldname";
    private static final String VOUCHER_FIELD = "voucherfield";
    private static final String ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"addfield"});
        this.addItemClickListeners(new String[]{"fieldtoolbarap"});
        MulBasedataEdit applyBill = (MulBasedataEdit)this.getControl("applybill");
        applyBill.addBeforeF7SelectListener(evt -> {
            ListShowParameter listParam = (ListShowParameter)evt.getFormShowParameter();
            DynamicObjectCollection applyApps = (DynamicObjectCollection)this.getModel().getValue("applyapp");
            HashSet<String> appIds = new HashSet<String>();
            if (applyApps != null && !applyApps.isEmpty()) {
                for (DynamicObject applyApp : applyApps) {
                    appIds.add(applyApp.getString("fbasedataid_id"));
                }
                listParam.getListFilterParameter().getQFilters().add(new QFilter("bizappid", "in", appIds));
            }
            Set<Object> bills = this.getDapBillInfo(Boolean.FALSE);
            listParam.getListFilterParameter().getQFilters().add(new QFilter("id", "in", bills));
            listParam.getListFilterParameter().getQFilters().add(new QFilter("modeltype", "=", (Object)"BillFormModel"));
        });
        MulBasedataEdit applyApp = (MulBasedataEdit)this.getControl("applyapp");
        applyApp.addBeforeF7SelectListener(evt -> {
            Set<Object> appIds = this.getDapBillInfo(Boolean.TRUE);
            ListShowParameter listParam = (ListShowParameter)evt.getFormShowParameter();
            listParam.getListFilterParameter().getQFilters().add(new QFilter("id", "in", appIds));
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRYENTITY);
        if (null != entity && !entity.isEmpty()) {
            Map<String, String> fieldMap = VchChangeSelectEdit.getFieldMap();
            HashMap<String, String> newFieldMap = new HashMap<String, String>(fieldMap.size());
            for (Map.Entry<String, String> entry : fieldMap.entrySet()) {
                newFieldMap.put(entry.getValue(), entry.getKey());
            }
            for (int i = 0; i < entity.size(); ++i) {
                DynamicObject row = (DynamicObject)entity.get(i);
                String voucherField = row.getString(VOUCHER_FIELD);
                String fieldName = (String)newFieldMap.get(voucherField);
                if (!StringUtils.isNotBlank((CharSequence)fieldName)) continue;
                this.getModel().setValue(VOUCHER_FIELD_NAME, (Object)fieldName, i);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("addfield".equals(key)) {
            this.showSelectField();
        }
    }

    private void showSelectField() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("ai_vchselectfield");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "vchSelectField"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("selectField", SerializationUtils.toJsonString(this.getSelectFeild()));
        param.setCustomParams(map);
        this.getView().showForm(param);
    }

    private Set<String> getSelectFeild() {
        IDataModel model = this.getModel();
        int row = model.getEntryRowCount(ENTRYENTITY);
        HashSet<String> field = new HashSet<String>(row);
        for (int i = 0; i < row; ++i) {
            field.add(model.getValue(VOUCHER_FIELD, i) + "");
        }
        return field;
    }

    public void closedCallBack(ClosedCallBackEvent closed) {
        super.closedCallBack(closed);
        String actionId = closed.getActionId();
        if ("vchSelectField".equals(actionId) && closed.getReturnData() != null) {
            this.dealFieldMap((Map)SerializationUtils.fromJsonString((String)(closed.getReturnData() + ""), Map.class));
        }
    }

    private void dealFieldMap(Map<String, String> fieldmap) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField(VOUCHER_FIELD_NAME, new Object[0]);
        vs.addField(VOUCHER_FIELD, new Object[0]);
        fieldmap.forEach((k, v) -> vs.addRow(new Object[]{k, v}));
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow(ENTRYENTITY, vs);
        model.endInit();
        this.getView().updateView(ENTRYENTITY);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        IDataModel model = this.getModel();
        if ("applyapp".equals(name)) {
            model.setValue("applybill", null);
        }
    }

    private Set<Object> getDapBillInfo(Boolean isAppId) {
        QFilter modeltypeQfilter = new QFilter("modeltype", "=", (Object)"BillFormModel");
        QFilter voucherQfilter = new QFilter("voucher", "=", (Object)CheckBoxEnum.TRUE.getValue());
        QFilter appFilter = new QFilter("bizappid.deploystatus", "=", (Object)"2");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bos_entityobject", (String)"id,bizappid.id", (QFilter[])new QFilter[]{voucherQfilter, modeltypeQfilter, appFilter}, (String)"bizappid.number");
        HashSet<Object> objs = new HashSet<Object>();
        if (isAppId.booleanValue()) {
            for (DynamicObject dyo : query) {
                objs.add(dyo.get("bizappid.id"));
            }
        } else {
            for (DynamicObject dyo : query) {
                objs.add(dyo.get("id"));
            }
        }
        return objs;
    }
}

