/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.ai.cache.CacheHelper;
import kd.fi.ai.util.ContextUtil;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExportUtil {
    private Format currencyFormat;

    public void openUrl(String url, IFormView formView) {
        ((IClientViewProxy)formView.getService(IClientViewProxy.class)).addAction("openUrl", (Object)url);
    }

    public static List<String> getDetailList(boolean billassist, boolean bizdc) {
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add("entryentity.billorg");
        fieldList.add("entryentity.billentity");
        fieldList.add("entryentity.billno");
        if (billassist) {
            fieldList.add("entryentity.billassist");
        }
        fieldList.add("entryentity.billamount");
        if (bizdc) {
            fieldList.add("entryentity.bizdc");
        }
        fieldList.add("acctnum");
        fieldList.add("vchno");
        fieldList.add("dc");
        fieldList.add("bizamt");
        fieldList.add("glamt");
        fieldList.add("diff");
        return fieldList;
    }

    public String exportDetail(List<Map<String, String>> dataRows, List<String> fieldList, DynamicObject currency, boolean noBillassist, boolean showBizDc) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("sheet1");
        this.initFormat(currency);
        this.setDetailTable(wb, sheet, dataRows, fieldList, noBillassist, showBizDc);
        try {
            return this.writeFile(wb, ResManager.loadKDString((String)"\u5bf9\u8d26\u660e\u7ec6\u8868", (String)"ExportUtil_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
        catch (IOException e) {
            throw new KDBizException(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    private void initFormat(DynamicObject currency) {
        int amt = 2;
        String sign = "";
        if (currency != null) {
            amt = currency.getInt("amtprecision");
            sign = currency.getString("sign");
        }
        FormatObject fobj = InteServiceHelper.getUserFormat((Long)ContextUtil.getUserId());
        fobj.getCurrencyFormat().setCurrencySymbols(sign);
        fobj.getCurrencyFormat().setMinimumFractionDigits(amt);
        this.currencyFormat = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(fobj);
    }

    private static String[] getNames2() {
        return new String[]{ResManager.loadKDString((String)"\u4e1a\u52a1\u7cfb\u7edf", (String)"ExportUtil_1", (String)"fi-ai-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u603b\u8d26", (String)"ExportUtil_2", (String)"fi-ai-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5dee\u5f02", (String)"ExportUtil_3", (String)"fi-ai-formplugin", (Object[])new Object[0])};
    }

    public void setDetailTable(HSSFWorkbook wb, HSSFSheet sheet, List<Map<String, String>> dataRows, List<String> fieldList, boolean noBillassist, boolean showBizDc) {
        HSSFCell cell;
        int i;
        int head = 3;
        int amountIndex = 3;
        if (!noBillassist) {
            ++head;
            ++amountIndex;
        }
        if (showBizDc) {
            ++head;
        }
        HSSFCellStyle style = this.getHeadColumnStyle(wb);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFRow row = sheet.createRow(0);
        HSSFRow row1 = sheet.createRow(1);
        HSSFCell cell0 = row.createCell(0);
        cell0.setCellValue((RichTextString)new HSSFRichTextString(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"ExportUtil_4", (String)"fi-ai-formplugin", (Object[])new Object[0])));
        CellRangeAddress cellRange0 = new CellRangeAddress(0, 0, 0, (int)((short)head));
        sheet.addMergedRegion(cellRange0);
        cell0.setCellStyle(style);
        HSSFCell cell1 = row.createCell(head + 1);
        cell1.setCellValue((RichTextString)new HSSFRichTextString(ResManager.loadKDString((String)"\u51ed\u8bc1", (String)"ExportUtil_5", (String)"fi-ai-formplugin", (Object[])new Object[0])));
        CellRangeAddress cellRange1 = new CellRangeAddress(0, 0, head + 1, head + 3);
        sheet.addMergedRegion(cellRange1);
        cell1.setCellStyle(style);
        List<String> namesList = this.getFirstPartColumns(noBillassist, showBizDc);
        String[] names2 = ExportUtil.getNames2();
        ArrayList<String> typeList = new ArrayList<String>(1 + names2.length);
        for (i = 0; i < namesList.size(); ++i) {
            if (amountIndex == i) {
                typeList.add("AmountProp");
            } else {
                typeList.add("FieldProp");
            }
            cell = row1.createCell(i);
            cell.setCellValue((RichTextString)new HSSFRichTextString(namesList.get(i)));
            cell.setCellStyle(style);
        }
        for (i = 0; i < names2.length; ++i) {
            typeList.add("AmountProp");
            cell = row.createCell(i + namesList.size());
            cell.setCellValue((RichTextString)new HSSFRichTextString(names2[i]));
            CellRangeAddress cellRange = new CellRangeAddress(0, 1, i + namesList.size(), i + namesList.size());
            sheet.addMergedRegion(cellRange);
            cell.setCellStyle(style);
        }
        for (int h = 0; h < dataRows.size(); ++h) {
            HSSFRow createRow = sheet.createRow(h + 2);
            Map<String, String> dyn = dataRows.get(h);
            int mergeRow = 0;
            if (dyn.get("mergeRow") != null && !"".equals(dyn.get("mergeRow"))) {
                mergeRow = Integer.parseInt(dyn.get("mergeRow"));
            }
            for (int i2 = 0; i2 < fieldList.size(); ++i2) {
                if (mergeRow == 0 && i2 > fieldList.size() - 7) continue;
                String number = fieldList.get(i2);
                String type = (String)typeList.get(i2);
                String value = "";
                if (type.equals("FieldProp")) {
                    value = dyn.get(number);
                } else if (type.equals("AmountProp")) {
                    value = dyn.get(number);
                    value = StringUtils.isBlank((CharSequence)value) || value.equals("0E-10") || Double.parseDouble(value) == 0.0 ? "" : this.currencyFormat.format(new BigDecimal(value));
                }
                HSSFCell cell2 = createRow.createCell(i2);
                cell2.setCellValue(value);
                if (mergeRow > 1 && i2 > fieldList.size() - 7) {
                    CellRangeAddress cellRange = new CellRangeAddress(h + 2, h + mergeRow + 1, i2, i2);
                    sheet.addMergedRegion(cellRange);
                }
                cell2.setCellStyle(style);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeFile(HSSFWorkbook wb, String formName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheHelper.getTempFileCache().saveAsUrl(this.getTempFilename(formName), (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    protected String getTempFilename(String formName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddhhmmssSSS");
        String currDateTime = dateFormat.format(new Date());
        String userName = RequestContext.get().getUserName();
        return formName + "-" + currDateTime + "-" + userName + ".xls";
    }

    public HSSFCellStyle getCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle numberStyle = wb.createCellStyle();
        numberStyle.setBorderLeft(BorderStyle.THIN);
        numberStyle.setBorderTop(BorderStyle.THIN);
        numberStyle.setBorderRight(BorderStyle.THIN);
        numberStyle.setBorderBottom(BorderStyle.THIN);
        numberStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        numberStyle.setHidden(false);
        return numberStyle;
    }

    public HSSFCellStyle getHeadColumnStyle(HSSFWorkbook wb) {
        HSSFCellStyle headColumnStyle = wb.createCellStyle();
        if (headColumnStyle == null) {
            headColumnStyle = this.createHssfCellStyle(wb);
        }
        return headColumnStyle;
    }

    public HSSFCellStyle createHssfCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle headColumnStyle = wb.createCellStyle();
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderTop(BorderStyle.THIN);
        headColumnStyle.setBorderLeft(BorderStyle.THIN);
        headColumnStyle.setBorderRight(BorderStyle.THIN);
        headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headColumnStyle.setAlignment(HorizontalAlignment.CENTER);
        headColumnStyle.setHidden(false);
        return headColumnStyle;
    }

    private static String[] getNames() {
        return new String[]{ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7", (String)"ExportUtil_12", (String)"fi-ai-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61", (String)"ExportUtil_13", (String)"fi-ai-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"ExportUtil_14", (String)"fi-ai-formplugin", (Object[])new Object[0]), "billassist", ResManager.loadKDString((String)"\u91d1\u989d", (String)"ExportUtil_15", (String)"fi-ai-formplugin", (Object[])new Object[0]), "bizdc", ResManager.loadKDString((String)"\u79d1\u76ee", (String)"ExportUtil_16", (String)"fi-ai-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7", (String)"ExportUtil_17", (String)"fi-ai-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u501f\u8d37\u65b9\u5411", (String)"ExportUtil_18", (String)"fi-ai-formplugin", (Object[])new Object[0])};
    }

    public List<String> getFirstPartColumns(boolean noBillassist, boolean showBizDc) {
        ArrayList<String> retCol = new ArrayList<String>();
        HashSet<String> handleShowFields = new HashSet<String>(){
            {
                this.add("billassist");
                this.add("bizdc");
            }
        };
        String[] names = ExportUtil.getNames();
        for (int i = 0; i < names.length; ++i) {
            String columnName = names[i];
            if (handleShowFields.contains(columnName)) {
                if (!noBillassist && "billassist".equals(columnName)) {
                    retCol.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ef4\u5ea6", (String)"ExportUtil_19", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                }
                if (!showBizDc || !"bizdc".equals(columnName)) continue;
                retCol.add(ResManager.loadKDString((String)"\u501f\u8d37\u65b9\u5411", (String)"ExportUtil_18", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                continue;
            }
            retCol.add(columnName);
        }
        return retCol;
    }
}

