/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.VchExpireDate;
import kd.fi.ai.VchFormulaFilterSetRow;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.VchTplVoucherType;
import kd.fi.ai.VchTplVoucherTypes;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.utils.StringUtils;

public class VchTemplateMultiLangUtil {
    private static Log logger = LogFactory.getLog(VchTemplateMultiLangUtil.class);

    public static boolean upgradeVchTemplateMultiLang(IDataModel model, IFormView view) {
        logger.info("start upgradeVchTemplateMultiLang...");
        String querySql = "select fid,fxml,facctorgid, fvoucherdatedesc, fvchtypedesc, fbizdatedesc from t_ai_vchtemplate ";
        LinkedList<Object[]> params = new LinkedList<Object[]>();
        try (DataSet queryDataSet = DB.queryDataSet((String)VchTemplateMultiLangUtil.class.getName(), (DBRoute)FAHCommonConstant.AI, (String)querySql);){
            for (Row row : queryDataSet) {
                String fxml = row.getString("fxml");
                if (StringUtils.isEmpty((String)fxml)) continue;
                Object[] param = new Object[5];
                VCHTemplate vchTemplate = VCHTemplate.deserializeFromString((String)fxml, null);
                param[0] = vchTemplate.getAcctOrgSet();
                VchTplVoucherTypes vchTypesSet = vchTemplate.getVchTypesSet();
                if (null != vchTypesSet) {
                    StringBuilder sb = new StringBuilder();
                    List items = vchTypesSet.getItems();
                    for (VchTplVoucherType item : items) {
                        sb.append(item.getVchGrpId()).append("/");
                    }
                    if (sb.length() > 0 && sb.length() < 500) {
                        sb.delete(sb.length() - 1, sb.length());
                        param[2] = sb.toString();
                    } else {
                        param[2] = row.getString("fvchtypedesc");
                    }
                } else {
                    param[2] = row.getString("fvchtypedesc");
                }
                VchExpireDate bizDateSet = vchTemplate.getBizDateSet2();
                if (null != bizDateSet) {
                    String dateStr;
                    List items = bizDateSet.getItems();
                    LinkedList list = new LinkedList();
                    for (Object item : items) {
                        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                        VchTplExpression fieldExp = item.getFieldExp();
                        map.put("ExprTran", fieldExp.getExprTran());
                        map.put("Expression", fieldExp.getExpression());
                        map.put("Description", fieldExp.getDescription().toString());
                        list.add(map);
                    }
                    param[3] = !list.isEmpty() ? ((dateStr = SerializationUtils.toJsonString(list)).length() < 500 ? dateStr : row.getString("fbizdatedesc")) : row.getString("fbizdatedesc");
                } else {
                    param[3] = row.getString("fbizdatedesc");
                }
                VchExpireDate vchDateSet = vchTemplate.getVchDateSet2();
                if (null != vchDateSet) {
                    String dateStr;
                    Object item;
                    List items = vchDateSet.getItems();
                    LinkedList list = new LinkedList();
                    item = items.iterator();
                    while (item.hasNext()) {
                        VchFormulaFilterSetRow item2 = (VchFormulaFilterSetRow)item.next();
                        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                        VchTplExpression fieldExp = item2.getFieldExp();
                        map.put("ExprTran", fieldExp.getExprTran());
                        map.put("Expression", fieldExp.getExpression());
                        map.put("Description", fieldExp.getDescription().toString());
                        list.add(map);
                    }
                    param[1] = !list.isEmpty() ? ((dateStr = SerializationUtils.toJsonString(list)).length() < 500 ? dateStr : row.getString("fvoucherdatedesc")) : row.getString("fvoucherdatedesc");
                } else {
                    param[1] = row.getString("fvoucherdatedesc");
                }
                param[4] = row.get("fid");
                params.add(param);
            }
        }
        if (params.isEmpty()) {
            return false;
        }
        String sql = "update t_ai_vchtemplate set facctorgid = ?, fvoucherdatedesc = ?, fvchtypedesc = ?, fbizdatedesc = ? where fid = ?";
        DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)sql, params);
        String sysParamSql = "update t_ai_sysparam set fvalue = 'true' where fkey = 'ai.dap.vchtemplate.multilang'";
        DB.execute((DBRoute)FAHCommonConstant.AI, (String)sysParamSql);
        SysParamConfig.removeCache((String)"ai.dap.vchtemplate.multilang");
        logger.info("end upgradeVchTemplateMultiLang...");
        return true;
    }
}

