/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.fi.ai.v2.fah.dto.FahVoucherCompleteDto;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ai.util.DapBuildVoucherCommonUtil;

public class VchtemplateDetailListPlugin
extends AbstractFormPlugin {
    private static final String cacheCompleteKey = "completebillkey";
    private static final String BillTypeKey = "billtypekey";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button check = (Button)this.getControl("btnok");
        check.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object opresult = this.getView().getFormShowParameter().getCustomParam("opresult");
        Object sourceId = this.getView().getFormShowParameter().getCustomParam("sourceId");
        Object entityname = this.getView().getFormShowParameter().getCustomParam("entityname");
        if (opresult != null && sourceId != null && entityname != null) {
            OperationResult opResult = (OperationResult)DataEntitySerializer.deSerializerFromString((String)((String)opresult), (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
            Set srcIds = (Set)SerializationUtils.fromJsonString((String)((String)sourceId), Set.class);
            String billType = (String)entityname;
            this.getPageCache().put(BillTypeKey, billType);
            this.buildOperateResult(opResult, billType, srcIds);
        }
    }

    private void buildOperateResult(OperationResult opResult, String billType, Set<Long> srcIds) {
        srcIds.removeAll(opResult.getSuccessPkIds());
        FahVoucherCompleteDto vchComplete = new FahVoucherCompleteDto(srcIds, billType);
        vchComplete.check();
        Map missBillMap = vchComplete.getMissBillMap();
        this.getPageCache().put(cacheCompleteKey, SerializationUtils.toJsonString(vchComplete.getCompleteIds().stream().distinct().collect(Collectors.toList())));
        int maxSize = 0;
        for (List billIds : missBillMap.values()) {
            maxSize += billIds.size();
        }
        int[] entryseq = this.getModel().batchCreateNewEntryRow("entryentity", maxSize);
        int i = 0;
        for (Map.Entry entries : missBillMap.entrySet()) {
            String entityKey = (String)entries.getKey();
            String metaName = this.getMetaName(entityKey);
            List ids = (List)entries.getValue();
            String billNoFormBill = DapBuildVoucherCommonUtil.getBillNoFormBill((String)entityKey);
            if (ids.isEmpty()) continue;
            Map<Long, String> longStringMap = this.queryBillNumber(entityKey, ids, billNoFormBill);
            for (Long id : ids) {
                this.getModel().setValue("billtype", (Object)metaName, entryseq[i]);
                this.getModel().setValue("billno", (Object)longStringMap.get(id), entryseq[i]);
                ++i;
            }
        }
    }

    private String getMetaName(String entityKey) {
        return EntityMetadataCache.getDataEntityType((String)entityKey).getDisplayName().getLocaleValue();
    }

    private Map<Long, String> queryBillNumber(String entityKey, List<Long> ids, String billNoFormBill) {
        HashMap<Long, String> result = new HashMap<Long, String>();
        DynamicObjectCollection dataCol = QueryServiceHelper.query((String)entityKey, (String)(billNoFormBill + ",id"), (QFilter[])new QFilter("id", "in", ids).toArray());
        if (dataCol != null && !dataCol.isEmpty()) {
            for (DynamicObject data : dataCol) {
                result.put(data.getLong("id"), data.getString(billNoFormBill));
            }
        }
        return result;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("btnok")) {
            String cpk = this.getPageCache().get(cacheCompleteKey);
            String billType = this.getPageCache().get(BillTypeKey);
            if (StringUtils.isNotBlank((CharSequence)cpk)) {
                List cids = (List)SerializationUtils.fromJsonString((String)cpk, List.class);
                OperationResult deletevoucher = OperationServiceHelper.executeOperate((String)"deletevoucher", (String)billType, (Object[])cids.toArray(), (OperateOption)OperateOption.create());
                DataEntitySerializerOption option = new DataEntitySerializerOption();
                option.setIncludeComplexProperty(true);
                String op_result = DataEntitySerializer.serializerToString((Object)deletevoucher, (DataEntitySerializerOption)option);
                HashMap<String, Object> returnData = new HashMap<String, Object>(2);
                returnData.put("operationresultdata", op_result);
                returnData.put("pageid", this.getView().getFormShowParameter().getCustomParam("pageid"));
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(returnData));
                this.getView().close();
            }
        }
    }
}

