/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.admin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.ai.util.DateUtil;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.formplugin.admin.util.ClassHelper;
import kd.fi.v2.fah.utils.StringUtils;

public class FahAdminToolEdit
extends AbstractFormPlugin {
    private static final String defaultRegion = "redis.serversForCache";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"removebdcache", "querycache", "querycachekey", "removecachekey", "setcache", "settl", "querysysprops", "btn_updata", "btn_rundto"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        switch (((Control)evt.getSource()).getKey()) {
            case "removebdcache": {
                this.removeBaseDataCache();
                break;
            }
            case "removecachekey": {
                this.removeCacheKey();
                break;
            }
            case "querycache": {
                this.queryCache();
                break;
            }
            case "querycachekey": {
                this.queryCacheKey();
                break;
            }
            case "setcache": {
                this.setCacheNew();
                break;
            }
            case "settl": {
                this.setTtl();
                break;
            }
            case "querysysprops": {
                this.querySysProps();
                break;
            }
            case "btn_updata": {
                this.updateRegBillData();
            }
            case "btn_rundto": {
                this.runDTOs();
            }
        }
    }

    private void setCacheNew() {
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>(8);
        String regionValue = (String)this.getModel().getValue("regions");
        String keyType = this.getCacheKeyType();
        String cacheKey = (String)this.getModel().getValue("cachekey");
        String hashKey = (String)this.getModel().getValue("hashekey");
        Integer expireSecond = (Integer)this.getModel().getValue("expiresecond");
        String fullKey = this.getCacheKeyAddPrefixAndSuffix(cacheKey);
        resultMap.put("fullKey", fullKey);
        boolean err = this.checkCachePageParams(regionValue, keyType, cacheKey, hashKey, true, expireSecond, false, resultMap);
        String cacheValue = (String)this.getModel().getValue("newcachevalue");
        resultMap.put("cacheValue", cacheValue);
        if (null == cacheValue) {
            resultMap.put("cacheValueErr", "cacheValue is null");
            err = true;
        }
        if (!err) {
            String selectRegion = defaultRegion.equals(regionValue) ? null : regionValue;
            DistributeSessionlessCache distributeSessionlessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(selectRegion);
            String result = this.setRedisValue(distributeSessionlessCache, fullKey, keyType, hashKey, cacheValue, expireSecond);
            resultMap.put("setCache", "expireSecond:" + expireSecond + " s, " + result);
        }
        this.setCacheValueOnPage(resultMap);
    }

    private String setRedisValue(DistributeSessionlessCache cache, String cacheKey, String keyType, String hashKey, String cacheValue, Integer expireSecond) {
        try {
            switch (keyType) {
                case "hash": {
                    if (StringUtils.isEmpty((String)hashKey)) break;
                    if (this.notNeedSetTtl(expireSecond)) {
                        cache.put(cacheKey, hashKey, (Object)cacheValue);
                        break;
                    }
                    cache.put(cacheKey, hashKey, cacheValue, expireSecond.intValue());
                    break;
                }
                case "list": {
                    if (this.notNeedSetTtl(expireSecond)) {
                        cache.addList(cacheKey, new String[]{cacheValue});
                        break;
                    }
                    cache.addList(cacheKey, new String[]{cacheValue}, expireSecond.intValue());
                    break;
                }
                case "set": {
                    if (this.notNeedSetTtl(expireSecond)) {
                        cache.addToSet(cacheKey, new String[]{cacheValue});
                        break;
                    }
                    cache.addToSet(cacheKey, new String[]{cacheValue}, expireSecond.intValue());
                    break;
                }
                default: {
                    if (this.notNeedSetTtl(expireSecond)) {
                        cache.put(cacheKey, (Object)cacheValue);
                        break;
                    }
                    cache.put(cacheKey, (Object)cacheValue, expireSecond.intValue());
                }
            }
            return "ok";
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private void setTtl() {
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>(8);
        String regionValue = (String)this.getModel().getValue("regions");
        String keyType = this.getCacheKeyType();
        String cacheKey = (String)this.getModel().getValue("cachekey");
        String hashKey = (String)this.getModel().getValue("hashekey");
        Integer expireSecond = (Integer)this.getModel().getValue("expiresecond");
        String fullKey = this.getCacheKeyAddPrefixAndSuffix(cacheKey);
        resultMap.put("fullKey", fullKey);
        boolean err = this.checkCachePageParams(regionValue, keyType, cacheKey, hashKey, false, expireSecond, true, resultMap);
        if (!err) {
            String selectRegion = defaultRegion.equals(regionValue) ? null : regionValue;
            DistributeSessionlessCache distributeSessionlessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(selectRegion);
            distributeSessionlessCache.expireAfter(fullKey, expireSecond.intValue());
            resultMap.put("setTtl", expireSecond + " s, ok");
        }
        this.setCacheValueOnPage(resultMap);
    }

    private void setCacheValueOnPage(Map<String, Object> resultMap) {
        String result = JSON.toJSONString(resultMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
        this.getModel().setValue("cachevalue", (Object)result);
        this.getView().updateView();
    }

    private void removeCacheKey() {
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>(8);
        String regionValue = (String)this.getModel().getValue("regions");
        String keyType = this.getCacheKeyType();
        String cacheKey = (String)this.getModel().getValue("cachekey");
        String hashKey = (String)this.getModel().getValue("hashekey");
        String fullKey = this.getCacheKeyAddPrefixAndSuffix(cacheKey);
        resultMap.put("fullKey", fullKey);
        Integer expireSecond = (Integer)this.getModel().getValue("expiresecond");
        boolean err = this.checkCachePageParams(regionValue, keyType, cacheKey, hashKey, true, expireSecond, false, resultMap);
        if (!err) {
            String selectRegion = defaultRegion.equals(regionValue) ? null : regionValue;
            DistributeSessionlessCache distributeSessionlessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(selectRegion);
            Object valueBefore = this.getRedisValue(distributeSessionlessCache, fullKey, keyType, hashKey, false);
            String resultKeyBefore = String.format("[region:%1$s][%2$s][beforeRemove]", selectRegion, fullKey);
            resultMap.put(resultKeyBefore, valueBefore);
            if ("hash".equals(keyType)) {
                distributeSessionlessCache.remove(fullKey, hashKey);
            } else {
                distributeSessionlessCache.remove(fullKey);
            }
            Object valueAfter = this.getRedisValue(distributeSessionlessCache, fullKey, keyType, hashKey, false);
            String resultKeyAfter = String.format("[region:%1$s][%2$s][afterRemove]", selectRegion, fullKey);
            resultMap.put(resultKeyAfter, valueAfter);
        }
        this.setCacheValueOnPage(resultMap);
    }

    private boolean checkCachePageParams(String regionValue, String keyType, String cacheKey, String hashKey, boolean checkHashKey, Integer expireSecond, boolean checkExpireSecond, Map<String, Object> resultMap) {
        resultMap.put("regionValue", regionValue);
        resultMap.put("cacheKey", cacheKey);
        resultMap.put("keyType", keyType);
        resultMap.put("hashKey", hashKey);
        resultMap.put("expireSecond", expireSecond);
        boolean err = false;
        if (StringUtils.isEmpty((String)regionValue)) {
            err = true;
            resultMap.put("regionErr", "please select region");
        }
        if (StringUtils.isEmpty((String)keyType)) {
            err = true;
            resultMap.put("keyTypeErr", "please select keyType");
        }
        if (StringUtils.isEmpty((String)cacheKey)) {
            err = true;
            resultMap.put("cacheKeyErr", "please input cacheKey");
        }
        if (checkHashKey && "hash".equals(keyType) && StringUtils.isEmpty((String)hashKey)) {
            err = true;
            resultMap.put("hashKeyErr", "please input hashKey");
        }
        if (checkExpireSecond && null == expireSecond) {
            resultMap.put("expireSecondErr", "please input expireSecond");
            err = true;
        }
        return err;
    }

    private void queryCache() {
        this.queryCache(false);
    }

    private void queryCacheKey() {
        this.queryCache(true);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Set<String> regions = this.getRedisServerRegions();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(8);
        for (String region : regions) {
            ComboItem comboItem = new ComboItem();
            if (StringUtils.isEmpty((String)region)) {
                comboItem.setCaption(new LocaleString(defaultRegion));
                comboItem.setValue(defaultRegion);
            } else {
                comboItem.setCaption(new LocaleString(region));
                comboItem.setValue(region);
            }
            items.add(comboItem);
        }
        ((ComboEdit)this.getControl("regions")).setComboItems(items);
    }

    private void querySysProps() {
        String sysprop = (String)this.getModel().getValue("sysprop");
        Properties properties = System.getProperties();
        Map<String, String> envProps = System.getenv();
        HashMap<String, Map<Object, Object>> resultMap = new HashMap<String, Map<Object, Object>>(2);
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>(properties.size());
        if (StringUtils.isEmpty((String)sysprop)) {
            for (String propertyKey : properties.stringPropertyNames()) {
                propertiesMap.put(propertyKey, properties.get(propertyKey));
            }
            resultMap.put("properties", propertiesMap);
            resultMap.put("envProps", envProps);
        } else {
            for (String propertyKey : properties.stringPropertyNames()) {
                if (!propertyKey.contains(sysprop)) continue;
                propertiesMap.put(propertyKey, properties.get(propertyKey));
            }
            HashMap<String, String> envPropsMap = new HashMap<String, String>(envProps.size());
            for (Map.Entry<String, String> envProp : envProps.entrySet()) {
                String propertyKey = envProp.getKey();
                if (!propertyKey.contains(sysprop)) continue;
                envPropsMap.put(propertyKey, envProp.getValue());
            }
            resultMap.put("properties", propertiesMap);
            resultMap.put("envProps", envPropsMap);
        }
        String result = JSON.toJSONString(resultMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
        this.getModel().setValue("propsvalue", (Object)result);
    }

    private void queryCache(boolean onlyKeys) {
        String cacheKey = (String)this.getModel().getValue("cachekey");
        if (StringUtils.isEmpty((String)cacheKey)) {
            return;
        }
        String hashKey = (String)this.getModel().getValue("hashekey");
        LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>(8);
        String fullKey = this.getCacheKeyAddPrefixAndSuffix(cacheKey);
        String keyType = this.getCacheKeyType();
        Set<String> regions = this.getRedisServerRegions();
        String regionValue = (String)this.getModel().getValue("regions");
        Set<Object> selectRegions = StringUtils.isEmpty((String)regionValue) ? regions : (defaultRegion.equals(regionValue) ? Collections.singleton(null) : Collections.singleton(regionValue));
        resultMap.put("onlyKeys:", onlyKeys);
        resultMap.put("regions:", regions);
        resultMap.put("selectRegions:", selectRegions);
        resultMap.put("hashekey:", hashKey);
        resultMap.put("acctId:", CacheKeyUtil.getAcctId());
        for (String region : selectRegions) {
            DistributeSessionlessCache distributeSessionlessCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(region);
            Object value = this.getRedisValue(distributeSessionlessCache, fullKey, keyType, hashKey, onlyKeys);
            String resultKey = String.format("[region:%1$s][%2$s]", region, fullKey);
            resultMap.put(resultKey, value);
        }
        this.setCacheValueOnPage(resultMap);
    }

    private String getCacheKeyType() {
        String keyType;
        String cacheTypePrefix = (String)this.getModel().getValue("cachetypeprefix");
        if (StringUtils.isEmpty((String)cacheTypePrefix)) {
            return "";
        }
        switch (cacheTypePrefix) {
            case "pageCache": 
            case "baseDataCache": 
            case "appCache": 
            case "hash": {
                keyType = "hash";
                break;
            }
            case "string": {
                keyType = "string";
                break;
            }
            case "num": {
                keyType = "num";
                break;
            }
            case "list": {
                keyType = "list";
                break;
            }
            case "set": {
                keyType = "set";
                break;
            }
            default: {
                keyType = "";
            }
        }
        return keyType;
    }

    private String getCacheKeyAddPrefixAndSuffix(String cacheKey) {
        String keySuffix;
        String keyPrefix;
        String cacheTypePrefix = (String)this.getModel().getValue("cachetypeprefix");
        if (StringUtils.isEmpty((String)cacheTypePrefix)) {
            return cacheKey;
        }
        switch (cacheTypePrefix) {
            case "pageCache": {
                keyPrefix = CacheKeyUtil.getAcctId() + ".pagecache.";
                keySuffix = "";
                break;
            }
            case "baseDataCache": {
                keyPrefix = RequestContext.get().getAccountId() + ".";
                keySuffix = "";
                break;
            }
            case "appCache": {
                keyPrefix = CacheKeyUtil.getAcctId() + ".";
                keySuffix = "_appcache_";
                break;
            }
            default: {
                keyPrefix = "";
                keySuffix = "";
            }
        }
        return keyPrefix + cacheKey + keySuffix;
    }

    private Set<String> getRedisServerRegions() {
        HashSet<String> regions = new HashSet<String>(8);
        Properties properties = System.getProperties();
        Set<String> propertyKeys = properties.stringPropertyNames();
        for (String propertyKey : propertyKeys) {
            if (propertyKey.startsWith("redis.serversForCache.")) {
                String region = propertyKey.replace("redis.serversForCache.", "");
                regions.add(region);
            }
            if (!propertyKey.equals(defaultRegion)) continue;
            regions.add(null);
        }
        return regions;
    }

    private Object getRedisValue(DistributeSessionlessCache cache, String cacheKey, String keyType, String hashKey, boolean onlyKeys) {
        try {
            switch (keyType) {
                case "hash": {
                    if (StringUtils.isEmpty((String)hashKey)) {
                        return onlyKeys ? cache.getKeys(cacheKey) : cache.getAll(cacheKey);
                    }
                    return onlyKeys ? this.matchHashKey(cache.getKeys(cacheKey), hashKey) : cache.get(cacheKey, hashKey);
                }
                case "string": {
                    return onlyKeys ? cache.getKeysWithPrefix(cacheKey) : cache.get(cacheKey);
                }
                case "list": {
                    return onlyKeys ? cache.getKeysWithPrefix(cacheKey) : cache.getList(cacheKey);
                }
                case "set": {
                    return onlyKeys ? cache.getKeysWithPrefix(cacheKey) : cache.getSetValues(cacheKey);
                }
            }
            if (onlyKeys) {
                return cache.getKeysWithPrefix(cacheKey);
            }
            String value = null;
            ArrayList<Function<String, Object>> funcList = new ArrayList<Function<String, Object>>(4);
            funcList.add(arg_0 -> ((DistributeSessionlessCache)cache).getAll(arg_0));
            funcList.add(arg_0 -> ((DistributeSessionlessCache)cache).get(arg_0));
            funcList.add(arg_0 -> ((DistributeSessionlessCache)cache).getList(arg_0));
            funcList.add(arg_0 -> ((DistributeSessionlessCache)cache).getSetValues(arg_0));
            for (Function function : funcList) {
                try {
                    value = (String)function.apply(cacheKey);
                    break;
                }
                catch (Exception e4) {
                    value = e4.getMessage();
                }
            }
            return value;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private List<String> matchHashKey(List<String> keys, String hashKey) {
        if (CollectionUtils.isEmpty(keys)) {
            return null;
        }
        ArrayList<String> matchKeys = new ArrayList<String>(keys.size());
        for (String key : keys) {
            if (!key.toLowerCase().contains(hashKey.toLowerCase())) continue;
            matchKeys.add(key);
        }
        return matchKeys;
    }

    private void removeBaseDataCache() {
        String baseDataType = (String)this.getModel().getValue("basedatatype_id");
        if (StringUtils.isEmpty((String)baseDataType)) {
            return;
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)baseDataType);
        BusinessDataServiceHelper.removeCache((DynamicObjectType)dataEntityType);
        this.getModel().setValue("reuslt1", (Object)(DateUtil.getLongFormat().format(new Date()) + " exc ok."));
    }

    private boolean notNeedSetTtl(Integer expireSecond) {
        return null == expireSecond || expireSecond <= 0;
    }

    private void updateRegBillData() {
        String upFieldSql = "update t_fah_regbill set fsrcbillstatusfield = 'billstatus' where fsrcbillstatusfield = '' or fsrcbillstatusfield = ' ' or fsrcbillstatusfield is null";
        try (TXHandle h = TX.requiresNew();){
            try {
                DB.execute((DBRoute)FAHCommonConstant.AI, (String)upFieldSql);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
        long maxId = (Long)DB.query((DBRoute)DBRoute.of((String)"ai"), (String)"select max(fentryid) as entryid from t_fah_regbill_en", resultSet -> {
            if (resultSet.next()) {
                return resultSet.getLong("entryid");
            }
            return 3997052735425653760L;
        });
        ++maxId;
        String qrySql = "select fid,fsrcbillstatus,fsrcbilldatefield from t_fah_regbill where fid not in (select fid from t_fah_regbill_en)";
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        try (DataSet rows = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"ai"), (String)qrySql);){
            for (Row row : rows) {
                Object[] param = new Object[4];
                String status = row.getString("fsrcbillstatus");
                param[0] = row.getLong("fid");
                param[1] = maxId++;
                param[2] = status.substring(1, status.length() - 1);
                param[3] = row.getString("fsrcbilldatefield");
                params.add(param);
            }
        }
        if (!params.isEmpty()) {
            String updateSql = "INSERT INTO t_fah_regbill_en (fid,fentryid,fseq,fsrcbillstatusval,fsrcbilldatefieldnum,fevtstatusfieldnum,fdescription) VALUES (?,?,1,?,?,' ',' ');";
            TXHandle h = TX.requiresNew();
            Object object = null;
            try {
                try {
                    DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)updateSql, params);
                }
                catch (Exception e) {
                    h.markRollback();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (h != null) {
                    if (object != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
    }

    private void runDTOs() {
        String packageName = (String)this.getModel().getValue("packagepath");
        Set<Class<?>> clzFromPkg = null;
        try {
            clzFromPkg = ClassHelper.getClzFromPkg(packageName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashSet<Class> clzSet = new HashSet<Class>();
        if (null != clzFromPkg && !clzFromPkg.isEmpty()) {
            for (Class clazz : clzFromPkg) {
                if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) continue;
                clzSet.add(clazz);
            }
        }
        for (Class clazz : clzSet) {
            try {
                Object obj = clazz.newInstance();
                ClassHelper.tryAccessMethods(obj);
                Constructor constructor = clazz.getConstructor(Integer.TYPE);
                constructor.newInstance(1);
                Object result = obj.toString();
                result = obj.equals(clazz.newInstance());
                result = obj.hashCode();
            }
            catch (Exception exception) {}
        }
        this.getView().showSuccessNotification("success! class number: " + clzSet.size());
    }
}

