/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.devtools.util;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.sequence.SequenceReader;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.cache.common.SimpleDataDistributeCacheService;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.formplugin.devtools.pojo.FahEventDto;
import kd.fi.v2.fah.formplugin.devtools.pojo.FahEventLineDto;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;

public class PerformanceUtil {
    private static final SimpleDataDistributeCacheService cache = SimpleDataDistributeCacheService.getInstance();
    private static final LZ4Factory factory = LZ4Factory.fastestInstance();
    static ObjectMapper objectMapper = new ObjectMapper();

    public static String testDBvsRedis(Integer taskNo, Integer headSize, Integer lineSize) throws Exception {
        String result;
        String headSql = "INSERT INTO t_fah_event_header (fid, fnumber, forgid, fsrc_systype, fsrc_sysid, fsrc_billtype, fsrc_billno, fsrc_billid, fsourceentry, fsourceentryid, fevtclassid, fevttypeid, fbizdate, fbookeddate, fruleid, fruleversion, fdispatchid, fdispatchversion, fevtlinecnt, fcreatestage, fcreatestatus, fneedacct, fbizdatastatus, fispreview, frelateid, freversestatus, fcreatetime, fmodifytime, fcreatorid, fmodifierid, frequestid, fpartitiongrpcode) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        String lineSql = "INSERT INTO t_fah_event_line (fid, fentryid, fseq, flinetypeid, fsourceentry, fsrcbillentryid, fsrclineruleid, famount, fcurrencyid, fbizlinestatus, fdimgrpvalid) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        List<FahEventDto> data1 = PerformanceUtil.getEventDtos(headSize, lineSize);
        long startTime = new Date().getTime();
        PairTuple<byte[], Integer> pair = PerformanceUtil.compressData(data1);
        String cacheStr = Base64.getEncoder().encodeToString((byte[])pair.getKey());
        long endTime = new Date().getTime();
        double serializeTime = (double)(endTime - startTime) / 1000.0;
        startTime = new Date().getTime();
        cache.put("testDBvsRedis" + taskNo, (Object)cacheStr);
        endTime = new Date().getTime();
        double redisPutTime = (double)(endTime - startTime) / 1000.0;
        startTime = new Date().getTime();
        String cachedData = (String)cache.get("testDBvsRedis" + taskNo);
        endTime = new Date().getTime();
        double redisGetTime = (double)(endTime - startTime) / 1000.0;
        startTime = new Date().getTime();
        PerformanceUtil.decompressData(cachedData, (Integer)pair.getValue());
        endTime = new Date().getTime();
        double deserialTime = (double)(endTime - startTime) / 1000.0;
        try (TXHandle tx = TX.requiresNew();){
            try {
                PairTuple<List<Object[]>, List<Object[]>> params = PerformanceUtil.generateInsertParams(data1);
                DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)headSql, (List)((List)params.getKey()));
                DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)lineSql, (List)((List)params.getValue()));
                SqlBuilder querySql = new SqlBuilder();
                List headPKS = data1.stream().map(o -> o.getFid()).collect(Collectors.toList());
                querySql.appendIn("select * from t_fah_event_header t1 join t_fah_event_line t2 on t1.fid = t2.fid where t1.fid ", headPKS);
                querySql.append(" order by t1.fid, t2.fseq", new Object[0]);
                startTime = new Date().getTime();
                DataSet dataSet = DB.queryDataSet((String)"testDBvsRedis", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)querySql);
                PerformanceUtil.generateData(dataSet, headSize, lineSize);
                dataSet.close();
                endTime = new Date().getTime();
                double dbTime = (double)(endTime - startTime) / 1000.0;
                SqlBuilder deleteSql1 = new SqlBuilder();
                deleteSql1.appendIn("delete from t_fah_event_header where fid ", headPKS);
                SqlBuilder deleteSql2 = new SqlBuilder();
                deleteSql2.appendIn("delete from t_fah_event_line where fid ", headPKS);
                DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)deleteSql1);
                DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)deleteSql2);
                double wholeTime = serializeTime + redisPutTime + redisGetTime + deserialTime;
                result = "taskNo:" + taskNo + " redis: seailize time:" + serializeTime + " put time:" + redisPutTime + " get time\uff1a:" + redisGetTime + " deserialize time:" + deserialTime + " full time:" + wholeTime + "\r\nDB query time\uff1a" + dbTime + "s\r\ntime ratio:" + wholeTime / dbTime * 100.0;
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
        return result;
    }

    private static PairTuple<byte[], Integer> compressData(List<FahEventDto> list) throws Exception {
        String jsonString = JSON.toJSONString(list);
        byte[] data = jsonString.getBytes("UTF-8");
        int decompressedLength = data.length;
        LZ4Compressor compressor = factory.fastCompressor();
        int maxCompressedLength = compressor.maxCompressedLength(decompressedLength);
        byte[] compressed = new byte[maxCompressedLength];
        int compressedLength = compressor.compress(data, 0, decompressedLength, compressed, 0, maxCompressedLength);
        return new PairTuple((Object)compressed, (Object)decompressedLength);
    }

    private static List<FahEventDto> decompressData(String cacheStr, Integer decompressedLength) throws Exception {
        byte[] compressed = Base64.getDecoder().decode(cacheStr);
        LZ4FastDecompressor decompressor = factory.fastDecompressor();
        byte[] restored = new byte[decompressedLength.intValue()];
        int compressedLength2 = decompressor.decompress(compressed, 0, restored, 0, decompressedLength.intValue());
        return (List)JSON.parseObject((String)new String(restored, "UTF-8"), List.class);
    }

    public static List<FahEventDto> getEventDtos(int size, int lineSize) {
        SequenceReader sReader = new SequenceReader(FAHCommonConstant.AI);
        Long[] ids = (Long[])sReader.getSequences((Object[])new Long[size], "t_fah_event", size);
        Long[] entryids = (Long[])sReader.getSequences((Object[])new Long[size * lineSize], "t_fah_event_line", size * lineSize);
        ArrayList<FahEventDto> list = new ArrayList<FahEventDto>(size);
        for (int i = 0; i < size; ++i) {
            FahEventDto dto = FahEventDto.getInitData();
            dto.setFid(ids[i]);
            dto.setFnumber(ObjectConverterFactory.getString((Object)ids[i]));
            ArrayList<FahEventLineDto> lines = new ArrayList<FahEventLineDto>(lineSize);
            for (int j = 0; j < lineSize; ++j) {
                FahEventLineDto lineDto = FahEventLineDto.getInitData();
                lineDto.setFid(ids[i]);
                lineDto.setFentryid(entryids[i * lineSize + j]);
                lineDto.setFseq(j + 1);
                lines.add(lineDto);
            }
            dto.setLines(lines);
            list.add(dto);
        }
        return list;
    }

    public static PairTuple<List<Object[]>, List<Object[]>> generateInsertParams(List<FahEventDto> data) {
        ArrayList<Object[]> headParams = new ArrayList<Object[]>(data.size());
        ArrayList<Object[]> lineParams = new ArrayList<Object[]>(data.get(0).getLines().size());
        for (FahEventDto head : data) {
            Object[] headParam = new Object[]{head.getFid(), head.getFnumber(), head.getForgid(), head.getFsrc_systype(), head.getFsrc_sysid(), head.getFsrc_billtype(), head.getFsrc_billno(), head.getFsrc_billid(), head.getFsourceentry(), head.getFsourceentryid(), head.getFevtclassid(), head.getFevttypeid(), head.getFbizdate(), head.getFbookeddate(), head.getFruleid(), head.getFruleversion(), head.getFdispatchid(), head.getFdispatchversion(), head.getFevtlinecnt(), head.getFcreatestage(), head.getFcreatestatus(), head.getFneedacct(), head.getFbizdatastatus(), head.getFispreview(), head.getFrelateid(), head.getFreversestatus(), head.getFcreatetime(), head.getFmodifytime(), head.getFcreatorid(), head.getFmodifierid(), head.getFrequestid(), head.getFpartitiongrpcode()};
            headParams.add(headParam);
            for (FahEventLineDto line : head.getLines()) {
                Object[] lineParam = new Object[]{line.getFid(), line.getFentryid(), line.getFseq(), line.getFlinetypeid(), line.getFsourceentry(), line.getFsrcbillentryid(), line.getFsrclineruleid(), line.getFamount(), line.getFcurrencyid(), line.getFbizlinestatus(), line.getFdimgrpvalid()};
                lineParams.add(lineParam);
            }
        }
        return new PairTuple(headParams, lineParams);
    }

    private static List<FahEventDto> generateData(DataSet dataSet, Integer headSize, Integer lineSize) {
        ArrayList<FahEventDto> result = new ArrayList<FahEventDto>(headSize);
        long fid = 0L;
        FahEventDto dto = new FahEventDto(lineSize);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            if (fid != row.getLong("fid")) {
                if (fid != 0L) {
                    result.add(dto);
                }
                dto = new FahEventDto(lineSize);
                fid = row.getLong("fid");
                dto.setFid(fid);
                dto.setFnumber(row.getString("fnumber"));
                dto.setForgid(row.getLong("forgid"));
                dto.setFsrc_systype(row.getLong("fsrc_systype"));
                dto.setFsrc_sysid(row.getLong("fsrc_sysid"));
                dto.setFsrc_billtype(row.getString("fsrc_billtype"));
                dto.setFsrc_billno(row.getString("fsrc_billno"));
                dto.setFsrc_billid(row.getLong("fsrc_billid"));
                dto.setFsourceentry(row.getString("fsourceentry"));
                dto.setFsourceentryid(row.getLong("fsourceentryid"));
                dto.setFevtclassid(row.getLong("fevtclassid"));
                dto.setFevttypeid(row.getLong("fevttypeid"));
                dto.setFbizdate(row.getDate("fbizdate"));
                dto.setFbookeddate(row.getDate("fbookeddate"));
                dto.setFruleid(row.getLong("fruleid"));
                dto.setFruleversion(row.getInteger("fruleversion"));
                dto.setFdispatchid(row.getLong("fdispatchid"));
                dto.setFdispatchversion(row.getInteger("fdispatchversion"));
                dto.setFevtlinecnt(row.getInteger("fevtlinecnt"));
                dto.setFcreatestage(row.getString("fcreatestage"));
                dto.setFcreatestatus(row.getString("fcreatestatus"));
                dto.setFneedacct(row.getString("fneedacct"));
                dto.setFbizdatastatus(row.getString("fbizdatastatus"));
                dto.setFispreview(row.getString("fispreview"));
                dto.setFrelateid(row.getLong("frelateid"));
                dto.setFreversestatus(row.getString("freversestatus"));
                dto.setFcreatetime(row.getDate("fcreatetime"));
                dto.setFmodifytime(row.getDate("fmodifytime"));
                dto.setFcreatorid(row.getLong("fcreatorid"));
                dto.setFmodifierid(row.getLong("fmodifierid"));
                dto.setFrequestid(row.getLong("frequestid"));
                dto.setFpartitiongrpcode(row.getInteger("fpartitiongrpcode"));
            }
            FahEventLineDto line = new FahEventLineDto();
            line.setFid(row.getLong("fid"));
            line.setFentryid(row.getLong("fentryid"));
            line.setFseq(row.getInteger("fseq"));
            line.setFlinetypeid(row.getLong("flinetypeid"));
            line.setFsourceentry(row.getString("fsourceentry"));
            line.setFsrcbillentryid(row.getLong("fsrcbillentryid"));
            line.setFsrclineruleid(row.getLong("fsrclineruleid"));
            line.setFamount(row.getBigDecimal("famount"));
            line.setFcurrencyid(row.getLong("fcurrencyid"));
            line.setFbizlinestatus(row.getString("fbizlinestatus"));
            line.setFdimgrpvalid(row.getLong("fdimgrpvalid"));
            dto.addLine(line);
        }
        return result;
    }

    public static String testFastVSJackson(Integer taskNo, List<FahEventDto> data, boolean isFastJson) throws JsonProcessingException {
        long startTime = new Date().getTime();
        String jsonString = isFastJson ? JSON.toJSONString(data) : objectMapper.writeValueAsString(data);
        long endTime = new Date().getTime();
        double serializeTime = (double)(endTime - startTime) / 1000.0;
        startTime = new Date().getTime();
        List list = isFastJson ? (List)JSON.parseObject((String)jsonString, List.class) : (List)objectMapper.readValue(jsonString, List.class);
        endTime = new Date().getTime();
        double parseTime = (double)(endTime - startTime) / 1000.0;
        double wholeTime = serializeTime + parseTime;
        return "taskNo:" + taskNo + " redis: seailize time:" + serializeTime + " parse time:" + parseTime + " wholeTime:" + wholeTime;
    }
}

