/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.VchTplExpression;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.constant.enums.ExtractModeEnum;
import kd.fi.v2.fah.constant.enums.ExtractTypeEnum;
import kd.fi.v2.fah.constant.enums.PresetSysFieldEnum;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.dao.config.xla.FahAcctRuleDaoImpl;
import kd.fi.v2.fah.dao.event.FahEventRuleDao;
import kd.fi.v2.fah.models.event.acctrule.AcctInfo;
import kd.fi.v2.fah.models.event.acctrule.AcctPurposeCollection;
import kd.fi.v2.fah.models.event.acctrule.AcctRuleCfg;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSet;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSetData;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSetEntry;
import kd.fi.v2.fah.models.event.eventrule.EvtReferenceFieldDto;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.util.EventUtil;
import kd.fi.v2.fah.utils.DataModelUtils;
import kd.fi.v2.fah.utils.DynFieldValueSetUtil;
import kd.fi.v2.fah.utils.EventRuleUtils;
import kd.fi.v2.fah.utils.ExtractFieldUtils;
import kd.fi.v2.fah.utils.FahAcctRuleUtils;
import kd.fi.v2.fah.utils.FahMappingUtils;
import kd.fi.v2.fah.utils.LicenseUtil;
import kd.fi.v2.fah.utils.StringUtils;

public class FahAcctRuleEdit
extends AbstractFormPlugin
implements TreeNodeClickListener,
BeforeF7SelectListener {
    private static final String LEFT_TREE = "treeviewap";
    private static final String BTNEDIT = "btn_edit";
    private static final String BTNDELETE = "btn_delete";
    private static final String BTNADD = "btn_add";
    private static final String GROUP_SELECTID = "GROUP_SELECTID";
    private static final String GROUP_MAXSEQ = "GROUP_MAXSEQ";

    private void initLeftTree(boolean isAddNew) {
        TreeView tree = (TreeView)this.getView().getControl(LEFT_TREE);
        tree.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u6838\u7b97\u76ee\u7684", (String)"FahAcctRuleEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        root.setId("root");
        tree.addNode(root);
        tree.focusNode(root);
        tree.expand("root");
        this.switchShow(false);
        this.getPageCache().put(GROUP_SELECTID, "root");
        this.getPageCache().put(GROUP_MAXSEQ, "1");
        if (!isAddNew) {
            List<Long> ids = this.getSelectedIds();
            AcctRuleCfg acctRuleCfg = this.getAcctRuleCfg();
            TreeNode focusNode = null;
            int maxSeq = 0;
            for (AcctPurposeCollection acctGroup : (BaseMutableArrayMapStorage)acctRuleCfg.getCollections()) {
                TreeNode node = new TreeNode();
                String nodeId = String.valueOf(acctGroup.getAcctPurposeId());
                ids.add(Long.valueOf(nodeId));
                node.setId(String.valueOf(acctGroup.getAcctPurposeId()));
                node.setText(acctGroup.getName());
                node.setParentid("root");
                if (focusNode == null) {
                    focusNode = node;
                }
                tree.addNode(node);
                maxSeq = acctGroup.getSeq();
            }
            tree.focusNode(focusNode);
            if (focusNode != null) {
                this.getPageCache().put(GROUP_SELECTID, focusNode.getId());
            }
            this.getPageCache().put(GROUP_MAXSEQ, String.valueOf(maxSeq + 1));
            this.cacheSelectedIds(ids);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{BTNDELETE});
        if (this.isAddNew()) {
            this.initAcctRuleCfg(this.isAddNew());
            this.initLeftTree(this.isAddNew());
            SequenceReader sReader = new SequenceReader(new DBRoute("ai"));
            Long[] id = (Long[])sReader.getSequences((Object[])new Long[1], "fah_acctrule", 1);
            this.getModel().setValue("id", (Object)id[0]);
            AcctRuleCfg acctRuleCfg = this.getAcctRuleCfg();
            acctRuleCfg.setId(id[0]);
            acctRuleCfg.setEnable("1");
            this.cacheAcctRuleCfg(acctRuleCfg);
            this.getModel().setDataChanged(false);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!this.isAddNew()) {
            AcctRuleCfg acctRuleCfg;
            this.initAcctRuleCfg(this.isAddNew());
            this.initLeftTree(this.isAddNew());
            DynamicObject eventRule = (DynamicObject)this.getModel().getValue("eventrule");
            this.updateData(eventRule, true);
            this.switchShow(true);
            if (EventUtil.acctRuleIsQuote((Long)((Long)this.getModel().getValue("id")))) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"name", "number"});
            }
            if ((acctRuleCfg = this.getAcctRuleCfg()) != null) {
                this.getModel().setValue("name", (Object)acctRuleCfg.getName());
            }
            this.getModel().setDataChanged(false);
        }
        EntryGrid entry = (EntryGrid)this.getView().getControl("entryentity");
        entry.setColumnProperty("linetype", "isFixed", (Object)true);
        entry.setColumnProperty("amount_original", "isFixed", (Object)true);
        entry.setColumnProperty("currency", "isFixed", (Object)true);
        if (!OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_save"});
        }
    }

    private void initAcctRuleCfg(boolean isAddNew) {
        AcctRuleCfg acctRuleCfg;
        if (isAddNew) {
            acctRuleCfg = new AcctRuleCfg();
            acctRuleCfg.setDynamicExtractFieldCfgs(new BaseMutableArrayMapStorage());
        } else {
            acctRuleCfg = FahAcctRuleDaoImpl.loadFromDBById((Long)this.getAcctRuleId());
        }
        this.cacheAcctRuleCfg(acctRuleCfg);
    }

    private Long getAcctRuleId() {
        return (Long)this.getModel().getValue("id");
    }

    private boolean isAddNew() {
        return OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNDELETE, BTNADD});
        TreeView tree = (TreeView)this.getView().getControl(LEFT_TREE);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"acctorg", "acctbook", "acctdate", "acctperiod", "vouchertype", "fcreator", "bizdate", "attachment", "referenceinformation"});
        this.addClickListeners(new String[]{"amount_base", "account", "assgrp", "summary", "cashflowitem", "otherfield"});
        BasedataEdit groupmergerule = (BasedataEdit)this.getControl("groupmergerule");
        groupmergerule.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String btnName = ((Control)evt.getSource()).getKey();
        DynamicObject sourcebillObj = (DynamicObject)this.getModel().getValue("sourcebill");
        if (sourcebillObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e8b\u4ef6\u89c4\u5219\u3002", (String)"FahAcctRuleEdit_10", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        String sourceBill = sourcebillObj.getString("number");
        String publicNumber = ((DynamicObject)this.getModel().getValue("eventrule")).getString("sourceentry");
        String entryNumber = (String)((HashMap)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("EntryNumberMap"))).get(this.getModel().getEntryCurrentRowIndex("entryentity"));
        IDataModel dataModel = this.getModel();
        switch (btnName) {
            case "btn_add": {
                this.showAcctPurposeForm();
                break;
            }
            case "vouchertype": {
                EventRuleUtils.showDynamicExtractFieldForm((IFormView)this.getView(), (Long)this.getAcctRuleId(), (IFormPlugin)this, (String)"fah_acctrule", (String)"vouchertype", (String)sourceBill, (String)publicNumber, (DynamicExtractFieldValueSetData)this.getDynamicExtractFieldCfg("vouchertypeid", (String)this.getModel().getValue("vouchertype")), (boolean)true);
                break;
            }
            case "fcreator": {
                EventRuleUtils.showDynamicExtractFieldForm((IFormView)this.getView(), (Long)this.getAcctRuleId(), (IFormPlugin)this, (String)"fah_acctrule", (String)"fcreator", (String)sourceBill, (String)publicNumber, (DynamicExtractFieldValueSetData)this.getDynamicExtractFieldCfg("fcreatorid", (String)this.getModel().getValue("fcreator")), (boolean)true);
                break;
            }
            case "attachment": {
                EventRuleUtils.showDynamicExtractFieldForm((IFormView)this.getView(), (Long)this.getAcctRuleId(), (IFormPlugin)this, (String)"fah_acctrule", (String)"attachment", (String)sourceBill, (String)publicNumber, (DynamicExtractFieldValueSetData)this.getDynamicExtractFieldCfg("attachmentid", (String)this.getModel().getValue("attachment")), (boolean)true);
                break;
            }
            case "amount_base": {
                this.showAmountBase(sourceBill, entryNumber, dataModel);
                break;
            }
            case "account": {
                Long eventRuleId = (Long)this.getModel().getValue("eventrule_id");
                Long lineTypeId = (Long)this.getModel().getValue("linetype_id");
                if (FahEventRuleDao.checkEvtLineWithRelation((Long)eventRuleId, (Long)lineTypeId)) {
                    this.getView().getFormShowParameter().setCustomParam("function_ext", (Object)SerializationUtils.serializeToBase64(Collections.singletonList(ExtractModeEnum.RELATION)));
                }
                Map<String, Object> param = this.createReferenceFieldParam(eventRuleId, lineTypeId);
                this.getView().getFormShowParameter().setCustomParam("dyn_param", (Object)SerializationUtils.serializeToBase64(param));
                EventRuleUtils.showDynamicExtractFieldForm((IFormView)this.getView(), (Long)this.getAcctRuleId(), (IFormPlugin)this, (String)"fah_acctrule", (String)"account", (String)sourceBill, (String)entryNumber, (DynamicExtractFieldValueSetData)this.getDynamicExtractFieldCfg("accountid", (String)this.getModel().getValue("account")));
                break;
            }
            case "assgrp": {
                this.showAssgrp(sourceBill, entryNumber);
                break;
            }
            case "summary": {
                EventRuleUtils.showDynamicExtractFieldForm((IFormView)this.getView(), (Long)this.getAcctRuleId(), (IFormPlugin)this, (String)"fah_acctrule", (String)"summary", (String)sourceBill, (String)entryNumber, (DynamicExtractFieldValueSetData)this.getDynamicExtractFieldCfg("summaryid", (String)this.getModel().getValue("summary")), (boolean)true);
                break;
            }
            case "referenceinformation": {
                EventRuleUtils.showDynamicExtractFieldForm((IFormView)this.getView(), (Long)this.getAcctRuleId(), (IFormPlugin)this, (String)"fah_acctrule", (String)"referenceinformation", (String)sourceBill, (String)entryNumber, (DynamicExtractFieldValueSetData)this.getDynamicExtractFieldCfg("referenceinformationid", (String)this.getModel().getValue("referenceinformation")), (boolean)true);
                break;
            }
            case "cashflowitem": {
                this.showCashFlowItem(sourceBill, entryNumber, dataModel);
                break;
            }
            case "otherfield": {
                this.showOtherField(sourceBill, entryNumber, dataModel);
            }
        }
    }

    private Map<String, Object> createReferenceFieldParam(Long eventRuleId, Long lineTypeId) {
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put("EVT_RULE_ID", eventRuleId);
        param.put("EVT_RULE_LINE_ID", lineTypeId);
        DynamicObject lineType = (DynamicObject)this.getModel().getValue("linetype");
        if (null != lineType) {
            param.put("EVT_RULE_LINE_NAME", lineType.getString("name"));
        }
        return param;
    }

    private void showOtherField(String sourceBill, String entryNumber, IDataModel dataModel) {
        FormShowParameter parameter = this.createFormShowParameter("fah_otherfieldset", "fah_otherfieldset", sourceBill, entryNumber);
        BaseMutableArrayMapStorage valueSetDatas = this.getAcctRuleCfg().getDynamicExtractFieldCfgs();
        HashMap<String, Object> otherFieldvalueSetMap = new HashMap<String, Object>(5);
        otherFieldvalueSetMap.put("quantity", valueSetDatas.get((Object)((Long)dataModel.getValue("quantityid"))));
        otherFieldvalueSetMap.put("measurement", valueSetDatas.get((Object)((Long)dataModel.getValue("measurementid"))));
        otherFieldvalueSetMap.put("unitprice", valueSetDatas.get((Object)((Long)dataModel.getValue("unitpriceid"))));
        otherFieldvalueSetMap.put("biznumber", valueSetDatas.get((Object)((Long)dataModel.getValue("biznumberid"))));
        otherFieldvalueSetMap.put("expiredate", valueSetDatas.get((Object)((Long)dataModel.getValue("expiredateid"))));
        parameter.setCustomParam("otherFieldvalueSetMap", (Object)SerializationUtils.serializeToBase64(otherFieldvalueSetMap));
        parameter.setCustomParam("billType", (Object)sourceBill);
        this.getView().showForm(parameter);
    }

    private void showAmountBase(String sourceBill, String entryNumber, IDataModel dataModel) {
        FormShowParameter parameter = this.createFormShowParameter("fah_amountset", "fah_amountset", sourceBill, entryNumber);
        BaseMutableArrayMapStorage amountValueSetDatas = this.getAcctRuleCfg().getDynamicExtractFieldCfgs();
        HashMap<String, Object> amountValueSetMap = new HashMap<String, Object>(3);
        amountValueSetMap.put("currency", amountValueSetDatas.get((Object)((Long)dataModel.getValue("currencyid"))));
        amountValueSetMap.put("exchangerate", amountValueSetDatas.get((Object)((Long)dataModel.getValue("exchangerateid"))));
        amountValueSetMap.put("amount", amountValueSetDatas.get((Object)((Long)dataModel.getValue("amount_baseid"))));
        parameter.setCustomParam("amountValueSetDatas", (Object)SerializationUtils.serializeToBase64(amountValueSetMap));
        parameter.setCustomParam("billType", (Object)sourceBill);
        parameter.setCustomParam("isEventBill", (Object)DataModelUtils.isEventBill((String)sourceBill));
        Object amountField = this.getModel().getValue("entry_amount");
        if (!StringUtils.isEmpty((Object)amountField)) {
            parameter.setCustomParam("amountField", amountField);
        }
        this.getView().showForm(parameter);
    }

    private void showCashFlowItem(String sourceBill, String entryNumber, IDataModel dataModel) {
        FormShowParameter parameter = this.createFormShowParameter("fah_cashflowitem_set", "cashflowitem", sourceBill, entryNumber);
        BaseMutableArrayMapStorage cashFlowSetData = this.getAcctRuleCfg().getDynamicExtractFieldCfgs();
        HashMap<String, Object> cashFlowMap = new HashMap<String, Object>(3);
        cashFlowMap.put("cashflowitem", cashFlowSetData.get((Object)((Long)dataModel.getValue("cashflowitemid"))));
        cashFlowMap.put("cashflowsupitem", cashFlowSetData.get((Object)((Long)dataModel.getValue("cashflowsupitemid"))));
        cashFlowMap.put("cashflowitemassgrp", cashFlowSetData.get((Object)((Long)dataModel.getValue("cashflowitemassgrpid"))));
        parameter.setCustomParam("cashFlowValueSetDatas", (Object)SerializationUtils.serializeToBase64(cashFlowMap));
        parameter.setCustomParam("billType", (Object)sourceBill);
        Long eventRuleId = (Long)this.getModel().getValue("eventrule_id");
        Long lineTypeId = (Long)this.getModel().getValue("linetype_id");
        Map<String, Object> param = this.createReferenceFieldParam(eventRuleId, lineTypeId);
        parameter.setCustomParam("dyn_param", (Object)SerializationUtils.serializeToBase64(param));
        this.getView().showForm(parameter);
    }

    private void showAssgrp(String sourceBill, String entryNumber) {
        FormShowParameter parameter = this.createFormShowParameter("fah_asstact_set", "assgrp", sourceBill, entryNumber);
        parameter.setCustomParam("sourcePageField", (Object)"assgrp");
        List assgrpComboItems = ExtractFieldUtils.getEntityFieldFromSourcePageAndField((String)"fah_acctrule", (String)"assgrp", (String)sourceBill, (String)entryNumber);
        parameter.setCustomParam("source_bill_field_vals", (Object)SerializationUtils.serializeToBase64((Object)assgrpComboItems));
        DynamicExtractFieldValueSetData assgrpid = this.getDynamicExtractFieldCfg("assgrpid", null);
        if (assgrpid != null) {
            parameter.setCustomParam("SOURCE_MODEL", (Object)SerializationUtils.serializeToBase64((Object)assgrpid));
        }
        Long eventRuleId = (Long)this.getModel().getValue("eventrule_id");
        Long lineTypeId = (Long)this.getModel().getValue("linetype_id");
        Map<String, Object> param = this.createReferenceFieldParam(eventRuleId, lineTypeId);
        parameter.setCustomParam("dyn_param", (Object)SerializationUtils.serializeToBase64(param));
        parameter.setCustomParam("billType", (Object)sourceBill);
        this.getView().showForm(parameter);
    }

    private FormShowParameter createFormShowParameter(String formId, String actionId, String sourceBill, String entryNumber) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        parameter.setCustomParam("sourcePage", (Object)"fah_acctrule");
        parameter.setCustomParam("sourcePageId", (Object)this.getAcctRuleId());
        parameter.setCustomParam("sourceBill", (Object)sourceBill);
        parameter.setCustomParam("entryNumber", (Object)entryNumber);
        return parameter;
    }

    private DynamicExtractFieldValueSetData getDynamicExtractFieldCfg(String fieldId, String showName) {
        Object value = this.getModel().getValue(fieldId);
        if (value != null && Long.parseLong(value.toString()) != 0L) {
            DynamicExtractFieldValueSetData model = (DynamicExtractFieldValueSetData)this.getAcctRuleCfg().getDynamicExtractFieldCfgs().get((Object)ObjectConverterFactory.getLong((Object)value));
            ((DynamicExtractFieldValueSet)model.getFieldValueSetList().get(0)).setShowName(showName);
            return model;
        }
        return null;
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        if (BTNDELETE.equals(((Control)evt.getSource()).getKey())) {
            if ("root".equals(this.getPageCache().get(GROUP_SELECTID))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u6839\u8282\u70b9\u3002", (String)"FahAcctRuleEdit_11", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("deleteNode", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u6838\u7b97\u76ee\u7684\u540e\u5c06\u540c\u6b65\u5220\u9664\u6838\u7b97\u89c4\u5219\u914d\u7f6e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FahAcctRuleEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            evt.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        TreeView tree = (TreeView)this.getView().getControl(LEFT_TREE);
        if ("deleteNode".equals(evt.getCallBackId()) && evt.getResult().equals((Object)MessageBoxResult.Yes)) {
            AcctRuleCfg acctRuleCfg = this.getAcctRuleCfg();
            String nodeId = this.getPageCache().get(GROUP_SELECTID);
            acctRuleCfg.removeEx((Object)Long.parseLong(nodeId));
            this.cacheAcctRuleCfg(acctRuleCfg);
            tree.deleteNode(nodeId);
            List<Long> selectIds = this.getSelectedIds();
            int index = selectIds.indexOf(Long.parseLong(nodeId));
            selectIds.remove(Long.parseLong(nodeId));
            this.cacheSelectedIds(selectIds);
            TreeNode node = new TreeNode();
            if (selectIds.size() > 0) {
                index = index == 0 ? index : index - 1;
                String focusNodeId = String.valueOf(selectIds.get(index));
                node.setId(focusNodeId);
                tree.focusNode(node);
                this.getPageCache().put(GROUP_SELECTID, focusNodeId);
            } else {
                node.setId("root");
                tree.focusNode(node);
                this.getPageCache().put(GROUP_SELECTID, "root");
                this.switchShow(false);
            }
            this.updateData((DynamicObject)this.getModel().getValue("eventrule"), false);
        } else if ("eventRule".equals(evt.getCallBackId())) {
            if (evt.getResult().equals((Object)MessageBoxResult.Yes)) {
                AcctRuleCfg acctRuleCfg = new AcctRuleCfg();
                acctRuleCfg.setDynamicExtractFieldCfgs(new BaseMutableArrayMapStorage());
                this.cacheAcctRuleCfg(acctRuleCfg);
                this.updateData((DynamicObject)this.getModel().getValue("eventrule"), true);
                tree.deleteAllNodes();
                TreeNode root = new TreeNode();
                root.setText(ResManager.loadKDString((String)"\u6838\u7b97\u76ee\u7684", (String)"FahAcctRuleEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                root.setId("root");
                tree.addNode(root);
                tree.focusNode(root);
                tree.expand("root");
                this.getPageCache().put(GROUP_SELECTID, "root");
                this.switchShow(false);
                this.cacheSelectedIds(new LinkedList<Long>());
            } else {
                this.getPageCache().put("isUpdateValue", "false");
                this.getModel().setValue("eventrule", SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("eventRuleOldValue")));
            }
        } else if ("eventRuleIsNull".equals(evt.getCallBackId())) {
            if (evt.getResult().equals((Object)MessageBoxResult.Yes)) {
                AcctRuleCfg acctRuleCfg = new AcctRuleCfg();
                acctRuleCfg.setDynamicExtractFieldCfgs(new BaseMutableArrayMapStorage());
                this.cacheAcctRuleCfg(acctRuleCfg);
                this.updateData((DynamicObject)this.getModel().getValue("eventrule"), true);
                tree.deleteAllNodes();
                TreeNode root = new TreeNode();
                root.setText(ResManager.loadKDString((String)"\u6838\u7b97\u76ee\u7684", (String)"FahAcctRuleEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                root.setId("root");
                tree.addNode(root);
                tree.focusNode(root);
                tree.expand("root");
                this.getPageCache().put(GROUP_SELECTID, "root");
                this.switchShow(false);
                this.cacheSelectedIds(new LinkedList<Long>());
            } else {
                this.getPageCache().put("isUpdateValue", "false");
                this.getModel().setValue("eventrule", SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("eventRuleOldValue")));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String key = e.getProperty().getName();
        AcctRuleCfg acctRuleCfg = this.getAcctRuleCfg();
        BaseMutableArrayMapStorage valueSetData = acctRuleCfg.getDynamicExtractFieldCfgs();
        IDataModel dataModel = this.getModel();
        switch (key) {
            case "eventrule": {
                if (newValue == oldValue) break;
                this.getPageCache().put("eventRuleOldValue", SerializationUtils.serializeToBase64((Object)oldValue));
                if (newValue != null) {
                    if (oldValue != null && StringUtils.isEmpty((String)this.getPageCache().get("isUpdateValue"))) {
                        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("eventRule", (IFormPlugin)this);
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u4e8b\u4ef6\u89c4\u5219\uff0c\u5c06\u6e05\u9664\u6838\u7b97\u76ee\u7684\u53ca\u6838\u7b97\u89c4\u5219\u914d\u7f6e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FahAcctRuleEdit_3", (String)"fi-ai-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                    } else if (StringUtils.isEmpty((String)this.getPageCache().get("isUpdateValue"))) {
                        this.updateData((DynamicObject)newValue, true);
                    }
                } else {
                    ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("eventRuleIsNull", (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u6e05\u7a7a\u4e8b\u4ef6\u89c4\u5219\uff0c\u5c06\u6e05\u9664\u6838\u7b97\u76ee\u7684\u53ca\u6838\u7b97\u89c4\u5219\u914d\u7f6e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"FahAcctRuleEdit_4", (String)"fi-ai-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                    this.getPageCache().remove("isUpdateValue");
                }
                this.getPageCache().remove("isUpdateValue");
                break;
            }
            case "vouchertype": 
            case "fcreator": 
            case "attachment": 
            case "account": 
            case "referenceinformation": 
            case "summary": {
                if (newValue != null && !StringUtils.isEmpty((Object)newValue)) break;
                valueSetData.removeEx((Object)Long.valueOf(String.valueOf(dataModel.getValue(key + "id"))));
                dataModel.setValue(key + "id", null);
                break;
            }
            case "accountid": {
                DynamicExtractFieldValueSetData accountData;
                if (null != newValue && 0L != (Long)newValue && null != (accountData = (DynamicExtractFieldValueSetData)this.getAcctRuleCfg().getDynamicExtractFieldCfgs().get((Object)((Long)newValue))) && !accountData.getFieldValueSetList().isEmpty() && ExtractTypeEnum.RELATION == ((DynamicExtractFieldValueSet)accountData.getFieldValueSetList().get(0)).getGetValueType()) {
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"assgrp"});
                    this.getModel().setValue("assgrp", (Object)ExtractTypeEnum.RELATION.getDesc().loadKDString(), rowIndex);
                    this.getModel().setValue("assgrpid", null, rowIndex);
                    return;
                }
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"assgrp"});
                Long assGrpId = (Long)this.getModel().getValue("assgrpid", rowIndex);
                if (null != assGrpId && 0L != assGrpId) break;
                this.getModel().setValue("assgrp", null, rowIndex);
                break;
            }
            case "assgrp": {
                if (newValue != null && !StringUtils.isEmpty((Object)newValue)) break;
                valueSetData.removeEx((Object)((Long)dataModel.getValue(key + "id")));
                dataModel.setValue(key + "id", null, rowIndex);
                dataModel.setValue("assgrp", (Object)ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e", (String)"FahAcctRuleEdit_02", (String)"fi-ai-formplugin", (Object[])new Object[0]), rowIndex);
                break;
            }
            case "amount_base": {
                if (newValue != null && !StringUtils.isEmpty((Object)newValue)) break;
                valueSetData.removeEx((Object)((Long)dataModel.getValue("amount_baseid")));
                valueSetData.removeEx((Object)((Long)dataModel.getValue("exchangerateid")));
                valueSetData.removeEx((Object)((Long)dataModel.getValue("currencyid")));
                dataModel.setValue("amount_baseid", null);
                dataModel.setValue("exchangerateid", null);
                dataModel.setValue("currencyid", null);
                break;
            }
            case "cashflowitem": {
                if (newValue != null && !StringUtils.isEmpty((Object)newValue)) break;
                valueSetData.removeEx((Object)((Long)dataModel.getValue("cashflowitemid")));
                valueSetData.removeEx((Object)((Long)dataModel.getValue("cashflowsupitemid")));
                valueSetData.removeEx((Object)((Long)dataModel.getValue("cashflowitemassgrpid")));
                dataModel.setValue("cashflowitemid", null);
                dataModel.setValue("cashflowsupitemid", null);
                dataModel.setValue("cashflowitemassgrpid", null);
                dataModel.setValue("cashflowitem", (Object)ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e", (String)"FahAcctRuleEdit_02", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                break;
            }
            case "otherfield": {
                if (newValue != null && !StringUtils.isEmpty((Object)newValue)) break;
                valueSetData.removeEx((Object)((Long)dataModel.getValue("quantityid")));
                valueSetData.removeEx((Object)((Long)dataModel.getValue("measurementid")));
                valueSetData.removeEx((Object)((Long)dataModel.getValue("unitpriceid")));
                valueSetData.removeEx((Object)((Long)dataModel.getValue("biznumberid")));
                valueSetData.removeEx((Object)((Long)dataModel.getValue("expiredateid")));
                dataModel.setValue("quantityid", null);
                dataModel.setValue("measurementid", null);
                dataModel.setValue("unitpriceid", null);
                dataModel.setValue("biznumberid", null);
                dataModel.setValue("expiredateid", null);
                dataModel.setValue("otherfield", (Object)ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e", (String)"FahAcctRuleEdit_02", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            }
        }
        this.cacheAcctRuleCfg(acctRuleCfg);
    }

    private void clearData() {
        IDataModel dataModel = this.getModel();
        dataModel.setValue("vouchertypeid", (Object)0L);
        dataModel.setValue("fcreatorid", (Object)0L);
        dataModel.setValue("attachmentid", (Object)0L);
        dataModel.setValue("vouchertype", null);
        dataModel.setValue("fcreator", null);
        dataModel.setValue("attachment", null);
        dataModel.setValue("referenceinformation", null);
        dataModel.setValue("groupmergerule", null);
        this.getModel().deleteEntryData("entryentity");
    }

    private void updateData(DynamicObject eventRule, boolean isUpdateHead) {
        IDataModel dataModel = this.getModel();
        AcctRuleCfg acctRuleCfg = this.getAcctRuleCfg();
        MainEntityType mainEntityType = null;
        if (isUpdateHead) {
            if (eventRule != null) {
                String billType = eventRule.getString("group.id");
                mainEntityType = EntityMetadataCache.getDataEntityType((String)billType);
                dataModel.setValue("eventclass", (Object)eventRule.getLong("eventclass.id"));
                dataModel.setValue("eventtype", (Object)eventRule.getLong("eventtype.id"));
                dataModel.setValue("sourcebill", (Object)billType);
                String bizorg = eventRule.getString("bizorg");
                String bizdate = eventRule.getString("bizdate");
                String bookeddate = eventRule.getString("bookeddate");
                dataModel.setValue("bizorg", (Object)FahAcctRuleUtils.getFieldLongName((String)bizorg, (MainEntityType)mainEntityType));
                dataModel.setValue("bizdata", (Object)FahAcctRuleUtils.getFieldLongName((String)bizdate, (MainEntityType)mainEntityType));
                dataModel.setValue("bookeddate", (Object)FahAcctRuleUtils.getFieldLongName((String)bookeddate, (MainEntityType)mainEntityType));
            } else {
                dataModel.setValue("eventclass", null);
                dataModel.setValue("eventtype", null);
                dataModel.setValue("sourcebill", null);
                dataModel.setValue("bizorg", null);
                dataModel.setValue("bizdata", null);
                dataModel.setValue("bookeddate", null);
            }
        }
        this.getPageCache().put("eventRuleOldValue", SerializationUtils.serializeToBase64((Object)eventRule));
        this.clearData();
        int i = 0;
        HashMap<Integer, String> EntryNumberMap = new HashMap<Integer, String>(4);
        if (eventRule != null) {
            mainEntityType = EntityMetadataCache.getDataEntityType((String)eventRule.getString("group.id"));
            for (DynamicObject row : eventRule.getDynamicObjectCollection("evtrule_line")) {
                DynamicExtractFieldValueSetData currency;
                if (!row.getBoolean("entry_enable")) continue;
                this.getModel().createNewEntryRow("entryentity");
                dataModel.setValue("linetype", (Object)row.getLong("entry_linetype.id"), i);
                DynamicExtractFieldValueSetData amount = ExtractFieldUtils.loadDynamicExtractFieldValueSetData((Long)row.getLong("entry_amountid"));
                if (amount != null) {
                    String amountField = ((DynamicExtractFieldValueSet)amount.getFieldValueSetList().get(0)).getTextValue();
                    dataModel.setValue("entry_amount", (Object)amountField, i);
                    dataModel.setValue("amount_original", (Object)FahAcctRuleUtils.getFieldLongName((String)amountField, (MainEntityType)mainEntityType), i);
                    String[] entrys = amountField.split("\\.");
                    IDataEntityProperty prop = mainEntityType.findProperty(entrys[0]);
                    if (prop == null || prop.getParent() instanceof MainEntityType) {
                        EntryNumberMap.put(i, mainEntityType.getName());
                    } else {
                        IDataEntityType parentProp = prop.getParent();
                        if (parentProp != null) {
                            EntryNumberMap.put(i, parentProp.getName());
                        } else {
                            EntryNumberMap.put(i, mainEntityType.getName());
                        }
                    }
                }
                if ((currency = ExtractFieldUtils.loadDynamicExtractFieldValueSetData((Long)row.getLong("entry_currencyid"))) != null) {
                    String currencyField = ((DynamicExtractFieldValueSet)currency.getFieldValueSetList().get(0)).getTextValue();
                    dataModel.setValue("currency", (Object)FahAcctRuleUtils.getFieldLongName((String)currencyField, (MainEntityType)mainEntityType), i);
                }
                dataModel.setValue("eventlineruleid", (Object)row.getLong("id"), i);
                dataModel.setValue("assgrp", (Object)ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e", (String)"FahAcctRuleEdit_02", (String)"fi-ai-formplugin", (Object[])new Object[0]), i);
                dataModel.setValue("cashflowitem", (Object)ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e", (String)"FahAcctRuleEdit_02", (String)"fi-ai-formplugin", (Object[])new Object[0]), i);
                dataModel.setValue("otherfield", (Object)ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e", (String)"FahAcctRuleEdit_02", (String)"fi-ai-formplugin", (Object[])new Object[0]), i);
                ++i;
            }
        }
        this.getPageCache().put("EntryNumberMap", SerializationUtils.serializeToBase64(EntryNumberMap));
        String nodeId = this.getPageCache().get(GROUP_SELECTID);
        if (!StringUtils.isEmpty((String)nodeId) && !"root".equals(nodeId)) {
            BaseMutableArrayMapStorage dynamicExtractFieldCfgs = acctRuleCfg.getDynamicExtractFieldCfgs();
            dataModel.setValue("acctdate", (Object)ResManager.loadKDString((String)"\u4e8b\u4ef6.\u8bb0\u8d26\u65e5\u671f", (String)"FahAcctRuleEdit_03", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            dataModel.setValue("acctperiod", (Object)ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u6240\u5c5e\u671f\u95f4", (String)"FahAcctRuleEdit_04", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            dataModel.setValue("bizdate", (Object)ResManager.loadKDString((String)"\u4e8b\u4ef6.\u4e1a\u52a1\u65e5\u671f", (String)"FahAcctRuleEdit_05", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            dataModel.setValue("acctorg", (Object)ResManager.loadKDString((String)"\u4e8b\u4ef6.\u4e1a\u52a1\u5355\u5143\u7684\u59d4\u6258\u8bb0\u8d26\u7ec4\u7ec7", (String)"FahAcctRuleEdit_07", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            dataModel.setValue("acctbook", (Object)ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u5728\u6838\u7b97\u76ee\u7684\u4e0b\u7ef4\u62a4\u7684\u8d26\u7c3f", (String)"FahAcctRuleEdit_08", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            if (acctRuleCfg.get((Object)Long.parseLong(nodeId)) != null && ((AcctPurposeCollection)acctRuleCfg.get((Object)Long.parseLong(nodeId))).getValues() != null) {
                for (AcctInfo acctInfo : (AcctInfo[])((AcctPurposeCollection)acctRuleCfg.get((Object)Long.parseLong(nodeId))).getValues()) {
                    String expressionValue;
                    List summaryValueSetList;
                    if (acctInfo.getSeq() == 0) {
                        String expressionValue2;
                        List referenceInformationValueSetList;
                        DynamicExtractFieldValueSet accRuleCreatorVal;
                        List accRuleCreatorValSet;
                        DynamicObject vouchertype;
                        Long id;
                        Long voucherType = acctInfo.getVoucherType();
                        Long creator = acctInfo.getCreator();
                        Long attachment = acctInfo.getAttachment();
                        Long groupmergerule = acctInfo.getGroupmergerule();
                        Long referenceInformation = acctInfo.getReferenceInformation();
                        dataModel.setValue("vouchertypeid", (Object)voucherType);
                        dataModel.setValue("fcreatorid", (Object)creator);
                        dataModel.setValue("attachmentid", (Object)attachment);
                        dataModel.setValue("groupmergerule", (Object)groupmergerule);
                        dataModel.setValue("referenceinformationid", (Object)referenceInformation);
                        if (dynamicExtractFieldCfgs == null) continue;
                        DynamicExtractFieldValueSetData valueSetData = (DynamicExtractFieldValueSetData)dynamicExtractFieldCfgs.get((Object)voucherType);
                        if (valueSetData != null && (id = ((DynamicExtractFieldValueSet)valueSetData.getFieldValueSetList().get(0)).getRefPropValue()) != null && id != 0L && (vouchertype = QueryServiceHelper.queryOne((String)"gl_vouchertype", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)})) != null) {
                            dataModel.setValue("vouchertype", vouchertype.get("name"));
                        }
                        DynamicExtractFieldValueSetData accRuleCreator = (DynamicExtractFieldValueSetData)dynamicExtractFieldCfgs.get((Object)creator);
                        String reWriteCreator = null;
                        if (accRuleCreator != null && (accRuleCreatorValSet = accRuleCreator.getFieldValueSetList()) != null && !accRuleCreatorValSet.isEmpty() && (accRuleCreatorVal = (DynamicExtractFieldValueSet)accRuleCreatorValSet.get(0)) != null) {
                            switch (accRuleCreatorVal.getGetValueType()) {
                                case SOURCE_FIELD: {
                                    reWriteCreator = FahAcctRuleUtils.getFieldLongName((String)accRuleCreatorVal.getTextValue(), (MainEntityType)mainEntityType);
                                    break;
                                }
                                case PRESET_SYS_FIELD: {
                                    reWriteCreator = Optional.ofNullable(PresetSysFieldEnum.parseByCode((String)accRuleCreatorVal.getTextValue())).map(PresetSysFieldEnum::getDesc).orElse(null);
                                    break;
                                }
                            }
                        }
                        dataModel.setValue("fcreator", reWriteCreator);
                        dataModel.setValue("attachment", dynamicExtractFieldCfgs.get((Object)attachment) != null ? FahAcctRuleUtils.getFieldLongName((String)((DynamicExtractFieldValueSet)((DynamicExtractFieldValueSetData)dynamicExtractFieldCfgs.get((Object)attachment)).getFieldValueSetList().get(0)).getTextValue(), (MainEntityType)mainEntityType) : null);
                        DynamicExtractFieldValueSetData referenceInformationData = (DynamicExtractFieldValueSetData)dynamicExtractFieldCfgs.get((Object)referenceInformation);
                        if (referenceInformationData == null || null == (referenceInformationValueSetList = referenceInformationData.getFieldValueSetList()) || referenceInformationValueSetList.isEmpty() || !StringUtils.isNotEmpty((String)(expressionValue2 = ((DynamicExtractFieldValueSet)referenceInformationValueSetList.get(0)).getExpressionValue()))) continue;
                        VchTplExpression expression = (VchTplExpression)SerializationUtils.fromJsonString((String)expressionValue2, VchTplExpression.class);
                        dataModel.setValue("referenceinformation", (Object)expression.getExprTran());
                        continue;
                    }
                    String acctDirection = acctInfo.getAcctDirection();
                    Long amount = acctInfo.getAmount();
                    Long currency = acctInfo.getCurrency();
                    Long exchangerate = acctInfo.getExchangeRate();
                    Long account = acctInfo.getAccount();
                    Long assGrp = acctInfo.getAssGrp();
                    Long summary = acctInfo.getSummary();
                    Long cashFlowItem = acctInfo.getCashFlowItem();
                    Long cashFlowsupItem = acctInfo.getCashFlowsupItem();
                    Long cashFlowItemassgrp = acctInfo.getCashFlowItemAssgrp();
                    Long quantity = acctInfo.getQuantity();
                    Long measurement = acctInfo.getMeasurement();
                    Long unitprice = acctInfo.getUnitprice();
                    Long biznumber = acctInfo.getBiznumber();
                    Long expiredate = acctInfo.getExpiredate();
                    int index = acctInfo.getSeq() - 1;
                    int currentEntryCount = this.getModel().getEntryRowCount("entryentity");
                    if (currentEntryCount <= index) {
                        this.getModel().batchCreateNewEntryRow("entryentity", index - currentEntryCount + 1);
                    }
                    dataModel.setValue("amount_baseid", (Object)amount, index);
                    dataModel.setValue("currencyid", (Object)currency, index);
                    dataModel.setValue("exchangerateid", (Object)exchangerate, index);
                    dataModel.setValue("accountid", (Object)account, index);
                    dataModel.setValue("assgrpid", (Object)assGrp, index);
                    dataModel.setValue("summaryid", (Object)summary, index);
                    dataModel.setValue("cashflowitemid", (Object)cashFlowItem, index);
                    dataModel.setValue("cashflowsupitemid", (Object)cashFlowsupItem, index);
                    dataModel.setValue("cashflowitemassgrpid", (Object)cashFlowItemassgrp, index);
                    dataModel.setValue("quantityid", (Object)quantity, index);
                    dataModel.setValue("measurementid", (Object)measurement, index);
                    dataModel.setValue("unitpriceid", (Object)unitprice, index);
                    dataModel.setValue("biznumberid", (Object)biznumber, index);
                    dataModel.setValue("expiredateid", (Object)expiredate, index);
                    dataModel.setValue("acctDirection", (Object)acctDirection, index);
                    dataModel.setValue("isneedmerge", (Object)acctInfo.getIsneedmerge(), index);
                    dataModel.setValue("amountreverse", (Object)acctInfo.getAmountreverse(), index);
                    if (dynamicExtractFieldCfgs == null) continue;
                    if (dynamicExtractFieldCfgs.get((Object)amount) != null) {
                        dataModel.setValue("amount_base", (Object)FahAcctRuleUtils.getFieldLongName((String)((DynamicExtractFieldValueSet)((DynamicExtractFieldValueSetData)dynamicExtractFieldCfgs.get((Object)amount)).getFieldValueSetList().get(0)).getTextValue(), (MainEntityType)mainEntityType), index);
                    }
                    boolean accountIsRelation = false;
                    if (dynamicExtractFieldCfgs.get((Object)account) != null) {
                        long referenceFieldId;
                        EvtReferenceFieldDto referenceFieldDto;
                        String textValue;
                        DynamicExtractFieldValueSet valueset = (DynamicExtractFieldValueSet)((DynamicExtractFieldValueSetData)dynamicExtractFieldCfgs.get((Object)account)).getFieldValueSetList().get(0);
                        if (ExtractTypeEnum.SOURCE_FIELD == valueset.getGetValueType()) {
                            dataModel.setValue("account", (Object)FahAcctRuleUtils.getFieldLongName((String)valueset.getTextValue(), (MainEntityType)mainEntityType), index);
                        } else if (ExtractTypeEnum.MAPPING == valueset.getGetValueType()) {
                            Long mapId = ((DynamicExtractFieldValueSetEntry)valueset.getFieldValueSetEntry().get(0)).getMappingId();
                            if (mapId != null) {
                                DynamicObject map = QueryServiceHelper.queryOne((String)"fah_valmap_typenew", (String)"group.name group", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)mapId)});
                                if (map == null) continue;
                                dataModel.setValue("account", (Object)map.getString("group"), index);
                            }
                        } else if (ExtractTypeEnum.RELATION == valueset.getGetValueType()) {
                            accountIsRelation = true;
                            dataModel.setValue("account", (Object)ExtractTypeEnum.RELATION.getDesc().loadKDString(), index);
                        } else if (ExtractTypeEnum.REFERENCE_FIELD == valueset.getGetValueType() && StringUtils.isNotEmpty((String)(textValue = valueset.getTextValue())) && null != (referenceFieldDto = FahEventRuleDao.queryReferenceFieldById((Long)(referenceFieldId = Long.parseLong(textValue))))) {
                            String captionPrefix = "";
                            if (referenceFieldDto.getEvtLineId() == 0L) {
                                captionPrefix = ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"FahDynFieldValSetDetailEdit_5", (String)"fi-ai-formplugin", (Object[])new Object[0]);
                            } else {
                                DynamicObject lineType = (DynamicObject)this.getModel().getValue("linetype", index);
                                if (null != lineType) {
                                    captionPrefix = lineType.getString("name");
                                }
                            }
                            dataModel.setValue("account", (Object)(captionPrefix + "." + referenceFieldDto.getFieldName()), index);
                        }
                    }
                    dataModel.setValue("assgrp", (Object)(dynamicExtractFieldCfgs.get((Object)assGrp) != null ? ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"FahAcctRuleEdit_01", (String)"fi-ai-formplugin", (Object[])new Object[0]) : (accountIsRelation ? ExtractTypeEnum.RELATION.getDesc().loadKDString() : ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e", (String)"FahAcctRuleEdit_02", (String)"fi-ai-formplugin", (Object[])new Object[0]))), index);
                    dataModel.setValue("cashflowitem", (Object)(dynamicExtractFieldCfgs.get((Object)cashFlowItem) != null || dynamicExtractFieldCfgs.get((Object)cashFlowsupItem) != null || dynamicExtractFieldCfgs.get((Object)cashFlowItemassgrp) != null ? ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"FahAcctRuleEdit_01", (String)"fi-ai-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e", (String)"FahAcctRuleEdit_02", (String)"fi-ai-formplugin", (Object[])new Object[0])), index);
                    dataModel.setValue("otherfield", (Object)(dynamicExtractFieldCfgs.get((Object)quantity) != null || dynamicExtractFieldCfgs.get((Object)measurement) != null || dynamicExtractFieldCfgs.get((Object)unitprice) != null || dynamicExtractFieldCfgs.get((Object)biznumber) != null || dynamicExtractFieldCfgs.get((Object)expiredate) != null ? ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"FahAcctRuleEdit_01", (String)"fi-ai-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e", (String)"FahAcctRuleEdit_02", (String)"fi-ai-formplugin", (Object[])new Object[0])), index);
                    DynamicExtractFieldValueSetData summaryData = (DynamicExtractFieldValueSetData)dynamicExtractFieldCfgs.get((Object)summary);
                    if (summaryData == null || null == (summaryValueSetList = summaryData.getFieldValueSetList()) || summaryValueSetList.isEmpty() || !StringUtils.isNotEmpty((String)(expressionValue = ((DynamicExtractFieldValueSet)summaryValueSetList.get(0)).getExpressionValue()))) continue;
                    VchTplExpression expression = (VchTplExpression)SerializationUtils.fromJsonString((String)expressionValue, VchTplExpression.class);
                    dataModel.setValue("summary", (Object)expression.getExprTran(), index);
                }
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        String nodeId = (String)evt.getNodeId();
        boolean isRoot = StringUtils.isEmpty((String)nodeId) || nodeId.equals("root");
        this.getView().setEnable(Boolean.valueOf(!isRoot), new String[]{BTNDELETE});
        this.switchShow(!isRoot);
        String lastNodeId = this.getPageCache().get(GROUP_SELECTID);
        if (StringUtils.isNotEmpty((String)lastNodeId) && !"root".equals(lastNodeId) && !lastNodeId.equals(nodeId)) {
            this.saveDataToModel(lastNodeId);
        }
        this.getPageCache().put(GROUP_SELECTID, nodeId);
        Object eventRule = this.getModel().getValue("eventrule");
        if (eventRule != null) {
            this.updateData((DynamicObject)eventRule, false);
        }
    }

    private void saveHeadToModel() {
        AcctRuleCfg acctRuleCfg = this.getAcctRuleCfg();
        IDataModel model = this.getModel();
        acctRuleCfg.setId((Long)this.getModel().getValue("id"));
        acctRuleCfg.setName(((ILocaleString)this.getModel().getValue("name")).getLocaleValue());
        acctRuleCfg.setNumber((String)model.getValue("number"));
        acctRuleCfg.setEventRuleId((Long)model.getValue("eventrule_id"));
        this.cacheAcctRuleCfg(acctRuleCfg);
    }

    private void saveDataToModel(String selectedGroup) {
        Long groupId;
        String nodeId = this.getPageCache().get(GROUP_SELECTID);
        if (StringUtils.isEmpty((String)nodeId) || "root".equals(nodeId)) {
            return;
        }
        AcctRuleCfg acctRuleCfg = this.getAcctRuleCfg();
        AcctPurposeCollection acctPurposeCollection = (AcctPurposeCollection)acctRuleCfg.get((Object)(groupId = Long.valueOf(Long.parseLong(selectedGroup))));
        if (acctPurposeCollection == null) {
            return;
        }
        AcctInfo acctInfo = (AcctInfo)acctPurposeCollection.get(0);
        if (acctInfo == null) {
            acctInfo = new AcctInfo();
        }
        IDataModel model = this.getModel();
        acctInfo.setSeq(Integer.valueOf(0));
        acctInfo.setAcctGroupId(groupId);
        acctInfo.setAcctOrg((Long)model.getValue("acctorgid"));
        acctInfo.setAcctBook((Long)model.getValue("acctbookid"));
        acctInfo.setVoucherType((Long)model.getValue("vouchertypeid"));
        acctInfo.setCreator((Long)model.getValue("fcreatorid"));
        acctInfo.setAttachment((Long)model.getValue("attachmentid"));
        acctInfo.setReferenceInformation((Long)model.getValue("referenceinformationid"));
        acctInfo.setGroupmergerule((Long)model.getValue("groupmergerule_id"));
        acctPurposeCollection.add((Object)acctInfo);
        int i = 0;
        for (DynamicObject entry : model.getEntryEntity("entryentity")) {
            int index = i + 1;
            AcctInfo acctLine = (AcctInfo)acctPurposeCollection.get(index);
            if (acctLine == null) {
                acctLine = new AcctInfo();
            }
            acctLine.setSeq(Integer.valueOf(index));
            acctLine.setEventLineRuleId(Long.valueOf(entry.getLong("eventlineruleid")));
            acctLine.setAcctDirection(entry.getString("acctdirection"));
            acctLine.setIsneedmerge(entry.getBoolean("isneedmerge"));
            acctLine.setAmountreverse(entry.getBoolean("amountreverse"));
            acctLine.setAmount(Long.valueOf(entry.getLong("amount_baseid")));
            acctLine.setCurrency(Long.valueOf(entry.getLong("currencyid")));
            acctLine.setExchangeRate(Long.valueOf(entry.getLong("exchangerateid")));
            acctLine.setAccount(Long.valueOf(entry.getLong("accountid")));
            acctLine.setAssGrp(Long.valueOf(entry.getLong("assgrpid")));
            acctLine.setSummary(Long.valueOf(entry.getLong("summaryid")));
            acctLine.setCashFlowItem(Long.valueOf(entry.getLong("cashflowitemid")));
            acctLine.setCashFlowItemAssgrp(Long.valueOf(entry.getLong("cashflowitemassgrpid")));
            acctLine.setCashFlowsupItem(Long.valueOf(entry.getLong("cashflowsupitemid")));
            acctLine.setQuantity(Long.valueOf(entry.getLong("quantityid")));
            acctLine.setMeasurement(Long.valueOf(entry.getLong("measurementid")));
            acctLine.setUnitprice(Long.valueOf(entry.getLong("unitpriceid")));
            acctLine.setBiznumber(Long.valueOf(entry.getLong("biznumberid")));
            acctLine.setExpiredate(Long.valueOf(entry.getLong("expiredateid")));
            acctPurposeCollection.add((Object)acctLine);
            ++i;
        }
        this.cacheAcctRuleCfg(acctRuleCfg);
    }

    private AcctRuleCfg getAcctRuleCfg() {
        AcctRuleCfg acctRuleCfg;
        if (!StringUtils.isEmpty((String)this.getPageCache().get("AcctRuleCfg"))) {
            acctRuleCfg = (AcctRuleCfg)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("AcctRuleCfg"));
        } else {
            acctRuleCfg = new AcctRuleCfg();
            this.cacheAcctRuleCfg(acctRuleCfg);
        }
        return acctRuleCfg;
    }

    private void cacheAcctRuleCfg(AcctRuleCfg acctRuleCfg) {
        this.getPageCache().put("AcctRuleCfg", SerializationUtils.serializeToBase64((Object)acctRuleCfg));
    }

    private void showAcctPurposeForm() {
        ListShowParameter para = new ListShowParameter();
        para.setHasRight(true);
        para.setLookUp(true);
        para.setShowTitle(false);
        para.setBillFormId("fah_evt_accountpurpose");
        para.setFormId("bos_listf7");
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        para.getOpenStyle().setInlineStyleCss(css);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setMultiSelect(true);
        ListFilterParameter filterParam = new ListFilterParameter();
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        if (!this.getSelectedIds().isEmpty()) {
            filter.and(new QFilter("id", "not in", (Object)this.getSelectedIds().toArray()));
        }
        filterParam.setFilter(filter);
        para.setListFilterParameter(filterParam);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "accountPurposeSelected"));
        this.getView().showForm((FormShowParameter)para);
    }

    private DynamicExtractFieldValueSetData getReturnData(String returnData) {
        if (StringUtils.isEmpty((String)returnData)) {
            return null;
        }
        return (DynamicExtractFieldValueSetData)SerializationUtils.deSerializeFromBase64((String)returnData);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        Long branchId = 0L;
        DynamicExtractFieldValueSetData data = null;
        String dynFldDesc = null;
        if (returnData instanceof Map && (data = this.getReturnData((String)((Map)returnData).get("dynFldVal"))) != null) {
            branchId = data.getBranchId();
            dynFldDesc = (String)((Map)returnData).get("dynFldDesc");
        }
        IDataModel model = this.getModel();
        AcctRuleCfg acctRuleCfg = this.getAcctRuleCfg();
        String number = evt.getActionId();
        BaseMutableArrayMapStorage valueSetDatas = acctRuleCfg.getDynamicExtractFieldCfgs();
        switch (number) {
            case "accountPurposeSelected": {
                if (returnData == null) break;
                this.updateDataAndTree(acctRuleCfg, (ListSelectedRowCollection)returnData);
                break;
            }
            case "vouchertype": {
                Long oldId = (Long)model.getValue("vouchertypeid");
                if (data == null) {
                    model.setValue("vouchertype", null);
                    this.cacheDynamicExtractFieldCfg((BaseMutableArrayMapStorage<Long, DynamicExtractFieldValueSetData>)valueSetDatas, oldId, null);
                    return;
                }
                Long id = ((DynamicExtractFieldValueSet)data.getFieldValueSetList().get(0)).getRefPropValue();
                if (id != null) {
                    DynamicObject vouchertype = QueryServiceHelper.queryOne((String)"gl_vouchertype", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
                    model.setValue("vouchertype", vouchertype.get("name"));
                }
                this.cacheDynamicExtractFieldCfg((BaseMutableArrayMapStorage<Long, DynamicExtractFieldValueSetData>)valueSetDatas, oldId, data);
                model.setValue("vouchertypeid", (Object)branchId);
                break;
            }
            case "fcreator": 
            case "attachment": {
                this.updateCloseBack((BaseMutableArrayMapStorage<Long, DynamicExtractFieldValueSetData>)valueSetDatas, data, dynFldDesc, number);
                break;
            }
            case "fah_amountset": {
                Object[] returnDatas = (Object[])SerializationUtils.deSerializeFromBase64((String)String.valueOf(returnData));
                HashMap valueSetId = (HashMap)returnDatas[0];
                valueSetDatas.removeEx((Object)((Long)model.getValue("currencyid")));
                valueSetDatas.removeEx((Object)((Long)model.getValue("exchangerateid")));
                valueSetDatas.removeEx((Object)((Long)model.getValue("amount_baseid")));
                valueSetDatas.addAll((Collection)returnDatas[1]);
                model.setValue("currencyid", valueSetId.get("currency"));
                model.setValue("exchangerateid", valueSetId.get("exchangerate"));
                Long amountid = (Long)valueSetId.get("amount");
                model.setValue("amount_baseid", (Object)amountid);
                if (amountid == null) break;
                model.setValue("amount_base", returnDatas[2]);
                break;
            }
            case "account": {
                Long accountOldId = (Long)model.getValue("accountid");
                if (data == null) {
                    model.setValue("account", null);
                    this.cacheDynamicExtractFieldCfg((BaseMutableArrayMapStorage<Long, DynamicExtractFieldValueSetData>)valueSetDatas, accountOldId, null);
                    return;
                }
                DynamicExtractFieldValueSet valueset = (DynamicExtractFieldValueSet)data.getFieldValueSetList().get(0);
                if (ExtractTypeEnum.SOURCE_FIELD == valueset.getGetValueType()) {
                    model.setValue("account", (Object)dynFldDesc);
                } else if (ExtractTypeEnum.MAPPING == valueset.getGetValueType()) {
                    Long mapId = ((DynamicExtractFieldValueSetEntry)valueset.getFieldValueSetEntry().get(0)).getMappingId();
                    if (mapId != null) {
                        DynamicObject map = QueryServiceHelper.queryOne((String)"fah_valmap_typenew", (String)"group.name group", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)mapId)});
                        model.setValue("account", (Object)map.getString("group"));
                    }
                } else if (ExtractTypeEnum.RELATION == valueset.getGetValueType() || ExtractTypeEnum.REFERENCE_FIELD == valueset.getGetValueType()) {
                    model.setValue("account", (Object)dynFldDesc);
                }
                this.cacheDynamicExtractFieldCfg((BaseMutableArrayMapStorage<Long, DynamicExtractFieldValueSetData>)valueSetDatas, accountOldId, data);
                this.cacheAcctRuleCfg(acctRuleCfg);
                model.setValue("accountid", (Object)branchId);
                break;
            }
            case "assgrp": {
                model.setValue("assgrp", (Object)dynFldDesc);
                this.cacheDynamicExtractFieldCfg((BaseMutableArrayMapStorage<Long, DynamicExtractFieldValueSetData>)valueSetDatas, (Long)model.getValue("assgrpid"), data);
                model.setValue("assgrpid", (Object)branchId);
                break;
            }
            case "cashflowitem": {
                valueSetDatas.removeEx((Object)((Long)model.getValue("cashflowitemid")));
                valueSetDatas.removeEx((Object)((Long)model.getValue("cashflowsupitemid")));
                valueSetDatas.removeEx((Object)((Long)model.getValue("cashflowitemassgrpid")));
                Object[] returnDatas = (Object[])SerializationUtils.deSerializeFromBase64((String)String.valueOf(returnData));
                HashMap cashFlowMap = (HashMap)returnDatas[0];
                if (null != cashFlowMap) {
                    for (Map.Entry entry : cashFlowMap.entrySet()) {
                        if (StringUtils.isNotEmpty((String)((String)entry.getValue()))) {
                            DynamicExtractFieldValueSetData valueSetData = (DynamicExtractFieldValueSetData)SerializationUtils.deSerializeFromBase64((String)((String)entry.getValue()));
                            model.setValue((String)entry.getKey() + "id", (Object)valueSetData.getBranchId());
                            valueSetDatas.add((Object)valueSetData);
                            continue;
                        }
                        model.setValue((String)entry.getKey() + "id", null);
                    }
                }
                model.setValue("cashflowitem", returnDatas[1]);
                break;
            }
            case "fah_otherfieldset": {
                Object[] returnDatas = (Object[])SerializationUtils.deSerializeFromBase64((String)String.valueOf(returnData));
                HashMap otherfieldValueSetId = (HashMap)returnDatas[0];
                valueSetDatas.removeEx((Object)((Long)model.getValue("quantityid")));
                valueSetDatas.removeEx((Object)((Long)model.getValue("measurementid")));
                valueSetDatas.removeEx((Object)((Long)model.getValue("unitpriceid")));
                valueSetDatas.removeEx((Object)((Long)model.getValue("biznumberid")));
                valueSetDatas.removeEx((Object)((Long)model.getValue("expiredateid")));
                valueSetDatas.addAll((Collection)returnDatas[1]);
                model.setValue("quantityid", otherfieldValueSetId.get("quantity"));
                model.setValue("measurementid", otherfieldValueSetId.get("measurement"));
                model.setValue("unitpriceid", otherfieldValueSetId.get("unitprice"));
                model.setValue("biznumberid", otherfieldValueSetId.get("biznumber"));
                model.setValue("expiredateid", otherfieldValueSetId.get("expiredate"));
                model.setValue("otherfield", (Object)ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e", (String)"FahAcctRuleEdit_01", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                break;
            }
            case "summary#": {
                PairTuple dataTuple = DynFieldValueSetUtil.convertToDataOfExpression((Object)returnData, (Long)this.getAcctRuleId(), (String)"fah_acctrule", (String)"summary");
                if (null == dataTuple) break;
                data = (DynamicExtractFieldValueSetData)dataTuple.getKey();
                model.setValue("summary", dataTuple.getValue());
                model.setValue("summaryid", (Object)data.getBranchId());
                valueSetDatas.removeEx((Object)((Long)model.getValue("summaryid")));
                valueSetDatas.add((Object)data);
                break;
            }
            case "referenceinformation#": {
                PairTuple dataTuple = DynFieldValueSetUtil.convertToDataOfExpression((Object)returnData, (Long)this.getAcctRuleId(), (String)"fah_acctrule", (String)"referenceinformation");
                if (null == dataTuple) break;
                data = (DynamicExtractFieldValueSetData)dataTuple.getKey();
                model.setValue("referenceinformation", dataTuple.getValue());
                model.setValue("referenceinformationid", (Object)data.getBranchId());
                valueSetDatas.removeEx((Object)((Long)model.getValue("referenceinformationid")));
                valueSetDatas.add((Object)data);
                break;
            }
            case "fcreator#": {
                PairTuple dataTuple = DynFieldValueSetUtil.convertToDataOfBillField((Object)returnData, (Long)this.getAcctRuleId(), (String)"fah_acctrule", (String)"fcreator");
                if (null == dataTuple) break;
                data = (DynamicExtractFieldValueSetData)dataTuple.getKey();
                model.setValue("fcreator", dataTuple.getValue());
                model.setValue("fcreatorid", (Object)data.getBranchId());
                valueSetDatas.removeEx((Object)((Long)model.getValue("fcreatorid")));
                valueSetDatas.add((Object)data);
                break;
            }
            case "attachment#": {
                PairTuple dataTuple = DynFieldValueSetUtil.convertToDataOfBillField((Object)returnData, (Long)this.getAcctRuleId(), (String)"fah_acctrule", (String)"attachment");
                if (null == dataTuple) break;
                data = (DynamicExtractFieldValueSetData)dataTuple.getKey();
                model.setValue("attachment", dataTuple.getValue());
                model.setValue("attachmentid", (Object)data.getBranchId());
                valueSetDatas.removeEx((Object)((Long)model.getValue("attachmentid")));
                valueSetDatas.add((Object)data);
                break;
            }
            case "vouchertype#": {
                PairTuple dataTuple = DynFieldValueSetUtil.convertToDataOfConstant((Object)returnData, (Long)this.getAcctRuleId(), (String)"fah_acctrule", (String)"vouchertype");
                if (null == dataTuple) break;
                data = (DynamicExtractFieldValueSetData)dataTuple.getKey();
                model.setValue("vouchertype", dataTuple.getValue());
                model.setValue("vouchertypeid", (Object)data.getBranchId());
                valueSetDatas.removeEx((Object)((Long)model.getValue("vouchertypeid")));
                valueSetDatas.add((Object)data);
                Long id = ((DynamicExtractFieldValueSet)data.getFieldValueSetList().get(0)).getRefPropValue();
                if (id == null) break;
                DynamicObject vouchertype = QueryServiceHelper.queryOne((String)"gl_vouchertype", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
                model.setValue("vouchertype", vouchertype.get("name"));
            }
        }
        this.cacheAcctRuleCfg(acctRuleCfg);
    }

    private void updateCloseBack(BaseMutableArrayMapStorage<Long, DynamicExtractFieldValueSetData> valueSetDatas, DynamicExtractFieldValueSetData data, String dynFldDesc, String number) {
        IDataModel model = this.getModel();
        Long oldId = (Long)model.getValue(number + "id");
        if (data == null) {
            model.setValue(number, null);
            this.cacheDynamicExtractFieldCfg(valueSetDatas, oldId, null);
            return;
        }
        model.setValue(number, (Object)dynFldDesc);
        this.cacheDynamicExtractFieldCfg(valueSetDatas, oldId, data);
        model.setValue(number + "id", (Object)data.getBranchId());
    }

    private void updateDataAndTree(AcctRuleCfg acctRuleCfg, ListSelectedRowCollection returnData) {
        TreeView tree = (TreeView)this.getView().getControl(LEFT_TREE);
        if (returnData.isEmpty()) {
            return;
        }
        List<Long> ids = this.getSelectedIds();
        for (ListSelectedRow listSelectedRow : returnData) {
            Long id = (Long)listSelectedRow.getPrimaryKeyValue();
            if (acctRuleCfg.get((Object)id) != null) continue;
            ids.add(id);
            TreeNode node = new TreeNode();
            node.setText(listSelectedRow.getName());
            node.setId(String.valueOf(id));
            node.setParentid("root");
            tree.addNode(node);
            AcctPurposeCollection acctPurposeCollection = new AcctPurposeCollection();
            SequenceReader sReader = new SequenceReader(new DBRoute("ai"));
            Long[] groupId = (Long[])sReader.getSequences((Object[])new Long[1], "fah_evt_acctgroup", 1);
            acctPurposeCollection.setAcctPurposeId(id);
            acctPurposeCollection.setId(groupId[0]);
            int maxSeq = Integer.parseInt(this.getPageCache().get(GROUP_MAXSEQ));
            acctPurposeCollection.setSeq(maxSeq);
            acctPurposeCollection.setName(listSelectedRow.getName());
            this.getPageCache().put(GROUP_MAXSEQ, String.valueOf(maxSeq + 1));
            acctRuleCfg.add((Object)acctPurposeCollection);
        }
        this.getView().setEnable(Boolean.valueOf(true), new String[]{BTNDELETE});
        this.cacheSelectedIds(ids);
    }

    private void switchShow(boolean isShowData) {
        this.getView().setVisible(Boolean.valueOf(isShowData), new String[]{"publicinfo_flex", "lineinfo_flex"});
        this.getView().setVisible(Boolean.valueOf(!isShowData), new String[]{"acctpurposeflex"});
    }

    private void cacheDynamicExtractFieldCfg(BaseMutableArrayMapStorage<Long, DynamicExtractFieldValueSetData> valueSetDatas, Long id, DynamicExtractFieldValueSetData data) {
        valueSetDatas.removeEx((Object)id);
        if (data != null) {
            valueSetDatas.add((Object)data);
        }
    }

    private List<Long> getSelectedIds() {
        List<Long> selectedIds;
        if (!StringUtils.isEmpty((String)this.getPageCache().get("acctPurposeSelectId"))) {
            selectedIds = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("acctPurposeSelectId"));
        } else {
            selectedIds = new LinkedList<Long>();
            this.cacheSelectedIds(selectedIds);
        }
        return selectedIds;
    }

    private void cacheSelectedIds(List<Long> selectedIds) {
        this.getPageCache().put("acctPurposeSelectId", SerializationUtils.serializeToBase64(selectedIds));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("savenew".equals(args.getOperateKey())) {
            FahAcctRuleDaoImpl.save((AcctRuleCfg)this.getAcctRuleCfg());
            this.getModel().setDataChanged(false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if ("savenew".equals(((FormOperate)args.getSource()).getOperateKey())) {
            LicenseUtil.checkFahLicenseWithTips((IFormView)this.getView());
            this.saveDataToModel(this.getPageCache().get(GROUP_SELECTID));
            this.saveHeadToModel();
            if (QueryServiceHelper.exists((String)"fah_acctrule", (QFilter[])new QFilter[]{new QFilter("eventrule", "=", this.getModel().getValue("eventrule_id")).and(new QFilter("id", "!=", this.getModel().getValue("id")))})) {
                String name = ((DynamicObject)this.getModel().getValue("eventrule")).getString("name");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c\u4e8b\u4ef6\u89c4\u5219\u201d\uff1a\u201c%1$s\u201d\u5df2\u5b58\u5728\u6838\u7b97\u89c4\u5219\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FahAcctRuleEdit_09", (String)"fi-ai-formplugin", (Object[])new Object[0]), name));
                args.setCancel(true);
                return;
            }
            if (FahMappingUtils.isNumberRepeat((String)"fah_acctrule", (String)((String)this.getModel().getValue("number")), (Object)this.getModel().getValue("id"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"FahAccountPurposeEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            AcctRuleCfg acctRuleCfg = this.getAcctRuleCfg();
            if (acctRuleCfg.getValues() == null || ((AcctPurposeCollection[])acctRuleCfg.getValues()).length == 0 || ((AcctPurposeCollection[])acctRuleCfg.getValues()).length == 1 && acctRuleCfg.get(0) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u6dfb\u52a0\u4e00\u4e2a\u6838\u7b97\u76ee\u7684\u3002", (String)"FahAccountPurposeEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            StringBuilder msg = new StringBuilder();
            for (AcctPurposeCollection acctGroup : (AcctPurposeCollection[])acctRuleCfg.getValues()) {
                String name = acctGroup.getName();
                AcctInfo acctInfo = (AcctInfo)acctGroup.get(0);
                StringBuilder errorName = new StringBuilder();
                if (acctInfo == null || acctInfo.getVoucherType() == null || acctInfo.getVoucherType() == 0L) {
                    errorName.append(",").append(ResManager.loadKDString((String)"\u51ed\u8bc1\u7c7b\u578b", (String)"FahAccountPurposeEdit_4", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                }
                if (acctInfo == null || acctInfo.getCreator() == null || acctInfo.getCreator() == 0L) {
                    errorName.append(",").append(ResManager.loadKDString((String)"\u5236\u5355\u4eba", (String)"FahAccountPurposeEdit_5", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                }
                if (!StringUtils.isEmpty((Object)errorName)) {
                    msg.append(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u76ee\u7684\u201c%1$s\u201d\u4e0b\u516c\u5171\u4fe1\u606f\u201c%2$s\u201d\u672a\u586b\u5199\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FahAccountPurposeEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]), name, errorName.substring(1))).append("\n");
                }
                if (acctGroup.getValues() == null) {
                    msg.append(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u76ee\u7684\u201c%1$s\u201d\u4e0b\u884c\u4fe1\u606f\u6240\u6709\u5fc5\u5f55\u5b57\u6bb5\u672a\u586b\u5199\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FahAccountPurposeEdit_7", (String)"fi-ai-formplugin", (Object[])new Object[0]), name)).append("\n");
                    continue;
                }
                for (AcctInfo acctLine : (AcctInfo[])acctGroup.getValues()) {
                    int seq = acctLine.getSeq();
                    if (seq == 0) continue;
                    StringBuilder lineMsg = new StringBuilder();
                    if (StringUtils.isEmpty((String)acctLine.getAcctDirection())) {
                        lineMsg.append(",").append(ResManager.loadKDString((String)"\u501f\u8d37\u65b9\u5411", (String)"FahAccountPurposeEdit_8", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    }
                    if (acctLine.getAmount() == null || acctLine.getAmount() == 0L) {
                        lineMsg.append(",").append(ResManager.loadKDString((String)"\u672c\u4f4d\u5e01\u91d1\u989d", (String)"FahAccountPurposeEdit_9", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    }
                    if (acctLine.getAccount() == null || acctLine.getAccount() == 0L) {
                        lineMsg.append(",").append(ResManager.loadKDString((String)"\u79d1\u76ee", (String)"FahAccountPurposeEdit_10", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    }
                    if (acctLine.getSummary() == null || acctLine.getSummary() == 0L) {
                        lineMsg.append(",").append(ResManager.loadKDString((String)"\u6458\u8981", (String)"FahAccountPurposeEdit_13", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    }
                    if (StringUtils.isEmpty((Object)lineMsg)) continue;
                    msg.append(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u76ee\u7684\u201c%1$s\u201d\u4e0b\u884c\u4fe1\u606f\u7b2c\u201c%2$s\u201d\u884c\u5fc5\u5f55\u5b57\u6bb5\u201c%3$s\u201d\u672a\u586b\u5199\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FahAccountPurposeEdit_3", (String)"fi-ai-formplugin", (Object[])new Object[0]), name, seq, lineMsg.substring(1))).append("\n");
                }
            }
            if (!StringUtils.isEmpty((Object)msg)) {
                this.getView().showErrorNotification(msg.toString());
                args.setCancel(true);
                return;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("groupmergerule".equals(key)) {
            String nodeId = this.getPageCache().get(GROUP_SELECTID);
            ListShowParameter par = (ListShowParameter)evt.getFormShowParameter();
            par.setFormId("bos_listf7");
            evt.getCustomQFilters().add(new QFilter("group.id", "=", (Object)Long.parseLong(nodeId)));
        }
    }
}

