/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.fi.ai.util.EntityTreeUtil;
import kd.fi.v2.fah.utils.FahEntityMetaHelper;
import kd.fi.v2.fah.utils.StringUtils;
import kd.fi.v2.fah.utils.TreeBuildUtils;

public class FahBillFieldTree
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener,
TreeNodeQueryListener {
    private static final String LEFT_TREE = "treeviewap";
    private static Log logger = LogFactory.getLog(FahBillFieldTree.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.addRootNode();
    }

    private void addRootNode() {
        Map paramMap;
        String param = (String)this.getView().getFormShowParameter().getCustomParam("param");
        TreeView tv = (TreeView)this.getView().getControl(LEFT_TREE);
        if (!StringUtils.isEmpty((String)param) && !(paramMap = (Map)JSON.parseObject((String)param, Map.class)).isEmpty()) {
            MainEntityType srcMainET = EntityMetadataCache.getDataEntityType((String)((String)paramMap.get("entityType")));
            TreeNode rootNode = new TreeNode();
            rootNode.setId(srcMainET.getName());
            rootNode.setText(srcMainET.getDisplayName().getLocaleValue());
            rootNode.setChildren(new ArrayList());
            rootNode.setDisabled(true);
            rootNode.setColor("#000000");
            tv.addNode(rootNode);
            this.getPageCache().put("rootNode", srcMainET.getName());
        }
    }

    private String getCacheKey() {
        return CacheKeyUtil.getAcctId() + ":" + this.getView().getPageId();
    }

    private TreeNode getSearchNodes(String searchName) {
        Map paramMap;
        String param = (String)this.getView().getFormShowParameter().getCustomParam("param");
        if (!StringUtils.isEmpty((String)param) && !(paramMap = (Map)JSON.parseObject((String)param, Map.class)).isEmpty()) {
            paramMap.put("SearchText", searchName);
            return EntityTreeUtil.getEntityFieldNodes((Map)paramMap);
        }
        return new TreeNode();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DistributeSessionlessCache treeNodesCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("fi");
        treeNodesCache.remove(this.getCacheKey());
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        TreeView treeView = (TreeView)this.getView().getControl(LEFT_TREE);
        String hisSearchText = this.getPageCache().get("searchText");
        if (!StringUtils.isEmpty((String)searchText)) {
            if (!StringUtils.isEquals((String)hisSearchText, (String)searchText)) {
                treeView.deleteAllNodes();
                treeView.addNode(this.getSearchNodes(searchText));
            }
        } else if (!StringUtils.isEmpty((String)hisSearchText)) {
            treeView.deleteAllNodes();
            this.addRootNode();
        }
        this.getPageCache().put("searchText", searchText);
    }

    public void registerListener(EventObject e) {
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        TreeView treeView = (TreeView)this.getView().getControl(LEFT_TREE);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        if (StringUtils.isEmpty((String)this.getPageCache().get("searchText"))) {
            treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        }
        this.addClickListeners(new String[]{"btnok"});
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Map paramMap;
        super.treeNodeClick(evt);
        TreeView treeView = (TreeView)this.getView().getControl(LEFT_TREE);
        String nodeId = treeView.getTreeState().getFocusNodeId();
        String[] LongNumber = nodeId.split("\\.");
        this.getModel().setValue("fexpression", (Object)LongNumber[LongNumber.length - 1]);
        String param = (String)this.getView().getFormShowParameter().getCustomParam("param");
        if (!StringUtils.isEmpty((String)param) && !(paramMap = (Map)JSON.parseObject((String)param, Map.class)).isEmpty()) {
            StringBuilder longName = new StringBuilder();
            MainEntityType srcMainET = EntityMetadataCache.getDataEntityType((String)((String)paramMap.get("entityType")));
            IDataEntityProperty prop = srcMainET.findProperty(LongNumber[0]);
            if (prop != null && prop.getParent() instanceof EntryType) {
                longName.append(prop.getParent().getDisplayName().getLocaleValue()).append(".");
            }
            FahEntityMetaHelper.findField((EntityType)srcMainET, (String)nodeId, v -> longName.append(v.getDisplayName().getLocaleValue()).append("."));
            longName.deleteCharAt(longName.lastIndexOf("."));
            this.getModel().setValue("ftranexpr", (Object)longName);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        TreeView treeView = (TreeView)this.getView().getControl(LEFT_TREE);
        Map node = treeView.getTreeState().getFocusNode();
        String rootNodeId = this.getPageCache().get("rootNode");
        if (StringUtils.isEmpty((Object)this.getModel().getValue("fexpression")) || node == null || StringUtils.isEmpty(node.get("parentid")) || StringUtils.isEquals((String)((String)node.get("parentid")), (String)rootNodeId)) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5177\u4f53\u5b57\u6bb5\u3002", (String)"FahBillFieldTree_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if ("btnok".equals(((Control)evt.getSource()).getKey())) {
            TreeView treeView = (TreeView)this.getView().getControl(LEFT_TREE);
            String nodeId = treeView.getTreeState().getFocusNodeId();
            String[] returnData = new String[]{nodeId, (String)this.getModel().getValue("ftranexpr")};
            this.getView().returnDataToParent((Object)returnData);
            this.getView().close();
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        Map paramMap;
        String param = (String)this.getView().getFormShowParameter().getCustomParam("param");
        TreeView treeView = (TreeView)this.getView().getControl(LEFT_TREE);
        if (!StringUtils.isEmpty((String)param) && !(paramMap = (Map)JSON.parseObject((String)param, Map.class)).isEmpty()) {
            MainEntityType srcMainET = EntityMetadataCache.getDataEntityType((String)((String)paramMap.get("entityType")));
            List nodes = null;
            Class<?> fieldClassType = null;
            String dataType = null;
            try {
                dataType = (String)paramMap.get("dataType");
                if (!kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)dataType)) {
                    fieldClassType = Class.forName(dataType);
                }
            }
            catch (ClassNotFoundException e) {
                logger.error("Class<{}> not find, err: {}", (Object)dataType, (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            boolean needFilterOrg = false;
            if (!StringUtils.isEmpty(paramMap.get("needOrg"))) {
                needFilterOrg = "true".equalsIgnoreCase((String)paramMap.get("needOrg"));
            }
            String entryNumber = paramMap.get("entryNumber") != null ? (String)paramMap.get("entryNumber") : null;
            String basePropType = paramMap.get("basePropType") != null ? (String)paramMap.get("basePropType") : null;
            int maxLevel = paramMap.get("maxLevel") == null ? 4 : (Integer)paramMap.get("maxLevel");
            HashSet filterField = null;
            if (paramMap.get("filterField") != null) {
                filterField = new HashSet((Collection)paramMap.get("filterField"));
            }
            String nodeId = (String)evt.getNodeId();
            if (StringUtils.isEmpty((Object)evt.getParentNodeId())) {
                nodes = TreeBuildUtils.getTreeNodesByParent((String)nodeId, (EntityType)srcMainET, (String)"", (int)0, (int)maxLevel, filterField, fieldClassType, (String)basePropType, (boolean)true, (String)entryNumber, (boolean)needFilterOrg);
            } else if (nodeId.contains(".")) {
                IDataEntityProperty prop = FahEntityMetaHelper.findFieldByFullPath((EntityType)srcMainET, (String)nodeId);
                if (prop instanceof BasedataProp) {
                    srcMainET = EntityMetadataCache.getDataEntityType((String)((BasedataProp)prop).getBaseEntityId());
                    nodes = TreeBuildUtils.getTreeNodesByParent((String)nodeId, (EntityType)srcMainET, (String)nodeId, (int)nodeId.split("\\.").length, (int)maxLevel, filterField, fieldClassType, (String)basePropType, (boolean)false, (String)entryNumber, (boolean)needFilterOrg);
                }
            } else if ("headField".equals(nodeId)) {
                nodes = TreeBuildUtils.getTreeNodesByParent((String)nodeId, (EntityType)srcMainET, (String)"", (int)0, (int)maxLevel, filterField, fieldClassType, (String)basePropType, (boolean)false, (String)entryNumber, (boolean)needFilterOrg);
            } else if (srcMainET.findProperty(nodeId) instanceof EntryProp) {
                nodes = TreeBuildUtils.getTreeNodesByParent((String)nodeId, (EntityType)((EntityType)srcMainET.getAllEntities().get(nodeId)), (String)"", (int)0, (int)maxLevel, filterField, fieldClassType, (String)basePropType, (boolean)false, (String)entryNumber, (boolean)needFilterOrg);
            } else {
                IDataEntityProperty prop = srcMainET.findProperty(nodeId);
                if (prop instanceof BasedataProp) {
                    MainEntityType type = EntityMetadataCache.getDataEntityType((String)((BasedataProp)prop).getBaseEntityId());
                    nodes = TreeBuildUtils.getTreeNodesByParent((String)nodeId, (EntityType)type, (String)nodeId, (int)1, (int)maxLevel, filterField, fieldClassType, (String)basePropType, (boolean)false, (String)entryNumber, (boolean)needFilterOrg);
                }
            }
            treeView.addNodes(nodes);
        }
    }
}

