/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.constant.enums.ExtractModeEnum;
import kd.fi.v2.fah.constant.enums.ExtractTypeEnum;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.dao.event.FahEventRuleCfgDAO;
import kd.fi.v2.fah.utils.EventRuleUtils;
import kd.fi.v2.fah.utils.StringUtils;

public class FahDynamicExtractFieldConfig
extends AbstractFormPlugin {
    private static final String FIELD_DATATYPE_MAP = "FIELD_DATATYPE_MAP";
    private static final String COMBO_ITEMS = "COMBO_ITEMS";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain", "tb_cust", "tb_arg"});
        this.addClickListeners(new String[]{"arg_constant", "arg_expression"});
    }

    public void afterCreateNewData(EventObject e) {
        String[] split;
        Set functionSet;
        super.afterCreateNewData(e);
        String enablefunction = (String)this.getModel().getValue("enablefunction");
        Boolean flag = Boolean.FALSE;
        if (StringUtils.isNotEmpty((String)enablefunction) && !(functionSet = Arrays.stream(split = enablefunction.split("\\|")).collect(Collectors.toSet())).contains(ObjectConverterFactory.getString((Object)ExtractModeEnum.CUST_RULE.getCode()))) {
            flag = Boolean.TRUE;
        }
        this.getView().setVisible(flag, new String[]{"custpanel"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"baseprop", "assistprop"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initFunctionEntry();
        if (this.isEdit()) {
            String enablefunction;
            this.getView().setEnable(Boolean.FALSE, new String[]{"sourcepageid", "sourcefield"});
            this.getModel().setValue("sourcepageid", this.getModel().getValue("sourcepage"));
            DynamicObjectCollection argentry = this.getModel().getEntryEntity("argentry");
            if (!argentry.isEmpty()) {
                for (int i = 0; i < argentry.size(); ++i) {
                    ComboEdit comboEdit = (ComboEdit)this.getView().getFlexControl("arg_field", i);
                    List items = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(COMBO_ITEMS));
                    comboEdit.setComboItems(items);
                }
            }
            if (!StringUtils.isEmpty((String)(enablefunction = (String)this.getModel().getValue("enablefunction")))) {
                String[] split;
                for (String indexStr : split = enablefunction.split("\\|")) {
                    this.getModel().setValue("func_enable", (Object)true, ObjectConverterFactory.getInteger((Object)indexStr).intValue());
                }
            }
            this.getModel().setValue("name", (Object)this.findNameByNumber((String)this.getModel().getValue("sourcefield")));
        }
    }

    private boolean isEdit() {
        return this.getModelID() != null && this.getModelID() != 0L;
    }

    private Long getModelID() {
        return (Long)this.getModel().getValue("id");
    }

    private void initFunctionEntry() {
        this.getModel().batchCreateNewEntryRow("funcentry", ExtractModeEnum.values().length);
        for (ExtractModeEnum extractModeEnum : ExtractModeEnum.values()) {
            this.getModel().setValue("func_desc", (Object)extractModeEnum.getName().loadKDString(), extractModeEnum.getCode());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "arg_add": {
                if (StringUtils.isEmpty((Object)this.getModel().getValue("sourcepage"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6240\u5c5e\u9875\u9762\u3002", (String)"FahDynamicExtractFieldConfig_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                int index = this.getModel().createNewEntryRow("argentry");
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"arg_field", "arg_constant", "arg_expression", "arg_datatype"});
                break;
            }
            case "arg_delete": {
                EntryGrid argentry = (EntryGrid)this.getView().getControl("argentry");
                this.getModel().deleteEntryRows("argentry", argentry.getSelectRows());
                break;
            }
            case "cust_add": {
                int index2 = this.getModel().createNewEntryRow("custentry");
                this.getView().setEnable(Boolean.FALSE, index2, new String[]{"cust_number", "cust_name", "cust_desc"});
                break;
            }
            case "cust_delete": {
                EntryGrid custentry = (EntryGrid)this.getView().getControl("custentry");
                this.getModel().deleteEntryRows("custentry", custentry.getSelectRows());
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        switch (key = ctlSource.getKey()) {
            case "arg_constant": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("fah_constant_value");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "arg_constant"));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                int index = this.getModel().getEntryCurrentRowIndex("argentry");
                String argConstant = (String)this.getModel().getValue("arg_constant", index);
                if (StringUtils.isNotEmpty((String)argConstant)) {
                    showParameter.setCustomParam("value", (Object)argConstant);
                }
                this.getView().showForm(showParameter);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("arg_constant".equals(e.getActionId())) {
            int index = this.getModel().getEntryCurrentRowIndex("argentry");
            if (e.getReturnData() != null) {
                this.getModel().setValue("arg_constant", e.getReturnData(), index);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (propertyName) {
            case "arg_source": {
                if (ObjectConverterFactory.getString((Object)ExtractTypeEnum.SOURCE_FIELD.getCode()).equals(newValue)) {
                    this.fillCheckBoxList(rowIndex);
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"arg_field"});
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"arg_constant", "arg_expression"});
                    this.getModel().setValue("arg_constant", null, rowIndex);
                    this.getModel().setValue("arg_expression", null, rowIndex);
                    break;
                }
                if (ObjectConverterFactory.getString((Object)ExtractTypeEnum.CONSTANT_VALUE.getCode()).equals(newValue)) {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"arg_constant"});
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"arg_field", "arg_expression"});
                    this.getModel().setValue("arg_field", null, rowIndex);
                    this.getModel().setValue("arg_expression", null, rowIndex);
                    break;
                }
                if (!ObjectConverterFactory.getString((Object)ExtractTypeEnum.EXPRESSION.getCode()).equals(newValue)) break;
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"arg_expression"});
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"arg_field", "arg_constant"});
                this.getModel().setValue("arg_constant", null, rowIndex);
                this.getModel().setValue("arg_field", null, rowIndex);
                break;
            }
            case "sourcepageid": {
                DynamicObject sourcePageDyn = (DynamicObject)newValue;
                if (sourcePageDyn == null) {
                    this.getModel().setValue("sourcepage", null);
                } else {
                    this.getModel().setValue("sourcepage", (Object)sourcePageDyn.getString("number"));
                }
                List<ComboItem> comboItems = this.initComboList();
                ComboEdit comboEdit = (ComboEdit)this.getView().getControl("sourcefield");
                comboEdit.setComboItems(comboItems);
                break;
            }
            case "arg_field": {
                Map fieldDataTypeMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(FIELD_DATATYPE_MAP));
                this.getModel().setValue("arg_datatype", (Object)((DataValueTypeEnum)fieldDataTypeMap.get(newValue)).getCode(), rowIndex);
                break;
            }
            case "sourcefield": {
                String s = (String)newValue;
                this.getModel().setValue("name", (Object)this.findNameByNumber(s));
                if (s.contains(".")) {
                    s = s.substring(s.lastIndexOf(".") + 1, s.length());
                }
                if (FahEventRuleCfgDAO.isExistsSameDynExtFldCfg((Long)((Long)this.getModel().getValue("id")), (Object)this.getModel().getValue("sourcepage"), (String)s)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u3010\u6765\u6e90\u754c\u9762-\u6765\u6e90\u5b57\u6bb5\u3011\u7684\u914d\u7f6e\uff0c\u4fdd\u5b58\u5c06\u8986\u76d6\u65e7\u8bb0\u5f55\u3002", (String)"FahDynamicExtractFieldConfig_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                }
                this.getModel().setValue("number", (Object)s);
                Map fieldDataTypeMap2 = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(FIELD_DATATYPE_MAP));
                this.getModel().setValue("datatype", (Object)((DataValueTypeEnum)fieldDataTypeMap2.get(newValue)).getCode(), rowIndex);
                break;
            }
            case "func_enable": {
                if (ExtractModeEnum.CUST_RULE != ExtractModeEnum.getEnumByCode((Object)rowIndex)) break;
                this.getView().setVisible((Boolean)newValue, new String[]{"custpanel"});
                if (((Boolean)newValue).booleanValue()) break;
                this.getModel().deleteEntryData("custentry");
                break;
            }
            case "datatype": {
                if (DataValueTypeEnum.BaseProp.getCode() == ObjectConverterFactory.getByte((Object)newValue).byteValue()) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"baseprop"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"assistprop"});
                    break;
                }
                if (DataValueTypeEnum.AssistProp.getCode() != ObjectConverterFactory.getByte((Object)newValue).byteValue()) break;
                this.getView().setVisible(Boolean.FALSE, new String[]{"baseprop"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"assistprop"});
            }
        }
    }

    private String findNameByNumber(String number) {
        List items = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(COMBO_ITEMS));
        for (ComboItem item : items) {
            if (!number.equals(item.getValue())) continue;
            String name = item.getCaption().getLocaleValue();
            if (name.contains(".")) {
                name = name.substring(name.lastIndexOf(".") + 1, name.length());
            }
            return name;
        }
        return null;
    }

    private List<ComboItem> initComboList() {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)((String)this.getModel().getValue("sourcepage")));
        HashMap fieldDataTypeMap = new HashMap(16);
        List items = EventRuleUtils.createComboItems((MainEntityType)mainEntityType, fieldDataTypeMap, null);
        this.getPageCache().put(FIELD_DATATYPE_MAP, SerializationUtils.serializeToBase64(fieldDataTypeMap));
        this.getPageCache().put(COMBO_ITEMS, SerializationUtils.serializeToBase64((Object)items));
        return items;
    }

    private void fillCheckBoxList(int rowIndex) {
        ComboEdit comboEdit = (ComboEdit)this.getView().getFlexControl("arg_field", rowIndex);
        List items = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(COMBO_ITEMS));
        comboEdit.setComboItems(items);
    }
}

