/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.QFBuilder;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.event.DispatchFieldInfo;
import kd.fi.v2.fah.event.DispatchZoneFieldSettingInfo;
import kd.fi.v2.fah.event.DispatchZoneInfo;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.utils.FahSerializeHelper;
import kd.fi.v2.fah.utils.StringUtils;

public class FahEventDispatchFieldSettingEdit
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String[] dbfields = new String[]{"ftxtattr1", "ftxtattr2", "ftxtattr3", "ftxtattr4", "ftxtattr5", "ftxtattr6", "ftxtattr7", "ftxtattr8", "ftxtattr9", "ftxtattr10"};
    private static final String SUBENTRYENTITY = "subentryentity";
    private static final String ENTRYENTITY = "entryentity";
    private static final String DATA_CACHE_KEY = "data_cache_key";
    private static final String LAST_ENTRY_INDEX = "last_entry_index";
    private static final String SOURCE_FIELD_CALL_BACK_ID = "source_field_call_back_id";
    private static final int SUBENTRY_MAX_SIZE = 5;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"btn_save", "btn_cancel", "fieldsourceshow"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.getSourceBill());
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        for (EntityType entityType : mainEntityType.getAllEntities().values()) {
            if (entityType instanceof LinkEntryType || entityType.isDbIgnore()) continue;
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(entityType.getDisplayName().toString()));
            comboItem.setValue(entityType.getName());
            items.add(comboItem);
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("zone");
        comboEdit.setComboItems(items);
        this.getPageCache().put(LAST_ENTRY_INDEX, "0");
        String fieldSetting = (String)this.getView().getFormShowParameter().getCustomParam("fieldSetting");
        if (StringUtils.isNotEmpty((String)fieldSetting)) {
            DispatchZoneFieldSettingInfo settingInfo = (DispatchZoneFieldSettingInfo)FahSerializeHelper.fromJsonString((String)fieldSetting, DispatchZoneFieldSettingInfo.class);
            if (!settingInfo.isEmpty()) {
                this.cacheFieldSettingData(settingInfo);
                this.getModel().deleteEntryData(ENTRYENTITY);
                this.getModel().batchCreateNewEntryRow(ENTRYENTITY, settingInfo.size());
                int index = 0;
                for (DispatchZoneInfo data : settingInfo) {
                    this.getModel().setValue("zone", (Object)data.getZone(), index);
                    this.getModel().setValue("enable", (Object)data.getEnable(), index);
                    ++index;
                }
                this.refreshSubEntry((DispatchZoneInfo)settingInfo.get(0));
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_subadd", "btn_subdelete"});
        }
    }

    private void refreshSubEntry(DispatchZoneInfo info) {
        this.getModel().deleteEntryData(SUBENTRYENTITY);
        if (info != null) {
            if (info.getEnable().booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_subadd", "btn_subdelete"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_subadd", "btn_subdelete"});
            }
            if (info.getFieldSettings() != null && !info.getFieldSettings().isEmpty()) {
                this.getModel().batchCreateNewEntryRow(SUBENTRYENTITY, info.getFieldSettings().size());
                int subindex = 0;
                for (DispatchFieldInfo subSetting : info.getFieldSettings()) {
                    this.getModel().setValue("fieldname", (Object)subSetting.getFieldname(), subindex);
                    this.getModel().setValue("fieldsource", (Object)subSetting.getFieldsource(), subindex);
                    this.getModel().setValue("fieldsourceshow", (Object)subSetting.getFieldSourceShow(this.getSourceBill()), subindex);
                    this.getModel().setValue("dbfield", (Object)subSetting.getDbfield(), subindex);
                    ++subindex;
                }
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_subadd", "btn_subdelete"});
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        Integer lastIndex = this.getLastSelectedEntryIndex();
        Integer index = evt.getRow();
        if (index != -1 && !index.equals(lastIndex)) {
            this.updateCachedData(lastIndex);
            DispatchZoneFieldSettingInfo cacheData = this.getCacheData();
            DispatchZoneInfo newZoneInfo = (DispatchZoneInfo)cacheData.get((Object)ObjectConverterFactory.getString((Object)index));
            this.refreshSubEntry(newZoneInfo);
            this.getPageCache().put(LAST_ENTRY_INDEX, ObjectConverterFactory.getString((Object)index));
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_save": {
                this.updateCachedData(this.getLastSelectedEntryIndex());
                if (!this.validateSavable()) break;
                this.getView().returnDataToParent((Object)this.getPageCache().get(DATA_CACHE_KEY));
                this.getView().close();
                break;
            }
            case "btn_cancel": {
                this.getView().close();
                break;
            }
            case "fieldsourceshow": {
                this.showFieldSourceForm();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyName) {
            case "enable": {
                if (((Boolean)newValue).booleanValue()) {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_subadd", "btn_subdelete"});
                    break;
                }
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_subadd", "btn_subdelete"});
                if (!this.validateExistData(null)) break;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u533a\u57df\u5df2\u914d\u7f6e\u6570\u636e\uff0c\u5982\u679c\u5173\u95ed\u3010\u542f\u7528\u6761\u4ef6\u5b57\u6bb5\u3011\uff0c\u5219\u4f1a\u5220\u9664\u5df2\u914d\u7f6e\u6761\u4ef6\u5b57\u6bb5\u3001\u4ee5\u53ca\u5bf9\u5e94\u6761\u4ef6\u5b57\u6bb5\u914d\u7f6e\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u9700\u8981\u5173\u95ed\u3002", (String)"FahEventDispatchFieldEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("enable", (IFormPlugin)this));
            }
        }
    }

    private boolean validateSavable() {
        StringBuilder sb;
        DispatchZoneFieldSettingInfo cacheData = this.getCacheData();
        LinkedList<String> emptyZoneIndexes = new LinkedList<String>();
        LinkedList<String> emptyFieldIndexes = new LinkedList<String>();
        LinkedList<String> emptySettingIndexes = new LinkedList<String>();
        block0: for (DispatchZoneInfo data : cacheData) {
            if (StringUtils.isEmpty((String)data.getZone())) {
                emptyZoneIndexes.add(data.getIndex());
            }
            if (!data.getEnable().booleanValue()) continue;
            if (data.getFieldSettings() != null && !data.getFieldSettings().isEmpty()) {
                for (DispatchFieldInfo fieldSetting : data.getFieldSettings()) {
                    if (!StringUtils.isEmpty((String)fieldSetting.getFieldsource()) && !StringUtils.isEmpty((String)fieldSetting.getFieldname())) continue;
                    emptyFieldIndexes.add(data.getIndex());
                    continue block0;
                }
                continue;
            }
            emptySettingIndexes.add(data.getIndex());
        }
        StringBuilder message = new StringBuilder();
        if (!emptyZoneIndexes.isEmpty()) {
            sb = new StringBuilder();
            emptyZoneIndexes.stream().forEach(o -> sb.append(ObjectConverterFactory.getInteger((Object)o) + 1).append(" "));
            message.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u672a\u9009\u62e9\u5206\u6d41\u533a\u57df\u3002", (String)"FahEventDispatchFieldSettingEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]), sb.toString())).append("\r\n");
        }
        if (!emptyFieldIndexes.isEmpty()) {
            sb = new StringBuilder();
            emptyFieldIndexes.stream().forEach(o -> sb.append(ObjectConverterFactory.getInteger((Object)o) + 1).append(" "));
            message.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u6d41\u533a\u57df\u5b58\u5728\u5206\u6d41\u6761\u4ef6\u672a\u8bbe\u7f6e\u5b8c\u5168\u3002", (String)"FahEventDispatchFieldSettingEdit_3", (String)"fi-ai-formplugin", (Object[])new Object[0]), sb.toString())).append("\r\n");
        }
        if (!emptySettingIndexes.isEmpty()) {
            sb = new StringBuilder();
            emptySettingIndexes.stream().forEach(o -> sb.append(ObjectConverterFactory.getInteger((Object)o) + 1).append(" "));
            message.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u6d41\u533a\u57df\u542f\u7528\u6761\u4ef6\u5b57\u6bb5\u4f46\u6761\u4ef6\u5b57\u6bb5\u4e3a\u7a7a\u3002", (String)"FahEventDispatchFieldSettingEdit_4", (String)"fi-ai-formplugin", (Object[])new Object[0]), sb.toString())).append("\r\n");
        }
        if (StringUtils.isNotEmpty((String)message.toString())) {
            this.getView().showErrorNotification(message.toString());
            return false;
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "deleteentry": {
                if (!this.validateExistData(null)) break;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u53d6\u503c\u533a\u57df\u5df2\u914d\u7f6e\u6570\u636e\uff0c\u5982\u679c\u5220\u9664\u5c06\u4f1a\u6e05\u9664\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u9700\u8981\u5220\u9664\uff1f", (String)"FahEventDispatchZoneEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("deleteentry", (IFormPlugin)this));
                args.setCancel(true);
                break;
            }
            case "deletesubentry": {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl(SUBENTRYENTITY);
                int[] selectRows = entryGrid.getSelectRows();
                if (!this.validateExistData(selectRows[0])) break;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u6761\u4ef6\u5b57\u6bb5\u5df2\u914d\u7f6e\u6570\u636e\uff0c\u5982\u679c\u5220\u9664\u5b57\u6bb5\uff0c\u5219\u4f1a\u5220\u9664\u5bf9\u5e94\u6761\u4ef6\u5b57\u6bb5\u914d\u7f6e\u7684\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u9700\u8981\u5220\u9664\u3002", (String)"FahEventDispatchFieldEdit_3", (String)"fi-ai-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("deletesubentry", (IFormPlugin)this));
                args.setCancel(true);
                break;
            }
            case "newsubentry": {
                DynamicObjectCollection subentry = this.getModel().getEntryEntity(SUBENTRYENTITY);
                if (subentry.size() < 5) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6761\u4ef6\u5b57\u6bb5\u9650\u5236\u6570\u91cf\u4e3a5\u4e2a\u3002", (String)"FahEventDispatchFieldEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId;
        super.confirmCallBack(evt);
        switch (callBackId = evt.getCallBackId()) {
            case "deleteentry": {
                if (MessageBoxResult.Yes != evt.getResult()) break;
                this.getModel().deleteEntryRow(ENTRYENTITY, this.getLastSelectedEntryIndex().intValue());
                this.rebuildCachedData();
                this.getModel().deleteEntryData(SUBENTRYENTITY);
                this.getPageCache().remove(LAST_ENTRY_INDEX);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_subadd", "btn_subdelete"});
                break;
            }
            case "deletesubentry": {
                if (MessageBoxResult.Yes != evt.getResult()) break;
                int rowIndex = this.getModel().getEntryCurrentRowIndex(SUBENTRYENTITY);
                this.getModel().deleteEntryRow(SUBENTRYENTITY, rowIndex);
                break;
            }
            case "enable": {
                if (MessageBoxResult.Yes == evt.getResult()) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_subadd", "btn_subdelete"});
                    this.getModel().deleteEntryData(SUBENTRYENTITY);
                    break;
                }
                this.getModel().setValue("enable", (Object)Boolean.TRUE);
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_subadd", "btn_subdelete"});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "deleteentry": {
                this.rebuildCachedData();
                this.getModel().deleteEntryData(SUBENTRYENTITY);
                this.getPageCache().remove(LAST_ENTRY_INDEX);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_subadd", "btn_subdelete"});
                break;
            }
            case "newentry": {
                EntryGrid entryGrid2 = (EntryGrid)this.getView().getControl(ENTRYENTITY);
                int index2 = entryGrid2.getSelectRows()[0];
                this.updateCachedData(this.getLastSelectedEntryIndex());
                DispatchZoneFieldSettingInfo cacheData2 = this.getCacheData();
                DispatchZoneInfo newZoneInfo = (DispatchZoneInfo)cacheData2.get((Object)ObjectConverterFactory.getString((Object)index2));
                this.refreshSubEntry(newZoneInfo);
                this.getPageCache().put(LAST_ENTRY_INDEX, ObjectConverterFactory.getString((Object)index2));
            }
        }
    }

    private void rebuildCachedData() {
        Integer index = this.getLastSelectedEntryIndex();
        DispatchZoneFieldSettingInfo cacheData = this.getCacheData();
        ((BaseMutableArrayMapStorage)cacheData.getCollections()).removeEx((Object)ObjectConverterFactory.getString((Object)index));
        DispatchZoneFieldSettingInfo newData = new DispatchZoneFieldSettingInfo();
        for (DispatchZoneInfo info : cacheData) {
            Integer entryKey = ObjectConverterFactory.getInteger((Object)info.getIndex());
            if (entryKey < index) {
                newData.add((Object)info);
                continue;
            }
            if (entryKey <= index) continue;
            info.setIndex(ObjectConverterFactory.getString((Object)(entryKey - 1)));
            newData.add((Object)info);
        }
        this.cacheFieldSettingData(newData);
    }

    private boolean validateExistData(Integer subEntryIndex) {
        String dbfield;
        QFBuilder qb = new QFBuilder();
        String zone = (String)this.getModel().getValue("zone", this.getLastSelectedEntryIndex().intValue());
        if (StringUtils.isEmpty((String)zone)) {
            return false;
        }
        qb.add("valuezone", "=", (Object)zone);
        if (subEntryIndex != null && StringUtils.isNotEmpty((String)(dbfield = (String)this.getModel().getValue("dbfield", subEntryIndex.intValue())))) {
            qb.add(dbfield, "!=", (Object)Character.valueOf(' '));
            qb.add(dbfield, "is not null", null);
        }
        qb.add("dispatchid", "=", (Object)this.getDispatchId());
        return QueryServiceHelper.exists((String)"fah_evt_disp_rule", (QFilter[])qb.toArray());
    }

    private void showFieldSourceForm() {
        if (StringUtils.isEmpty((String)this.getCurrentZone())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u6d41\u533a\u57df\u3002", (String)"FahEventDispatchFieldSettingEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("sourcePage", "fah_disp_field_setting");
        param.put("entityType", this.getSourceBill());
        param.put("sourcePageField", "fieldsource");
        param.put("entryNumber", this.getCurrentZone());
        param.put("maxLevel", 2);
        param.put("needOrg", "true");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fah_billfieldtree");
        showParameter.setCustomParam("param", (Object)JSON.toJSONString(param));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SOURCE_FIELD_CALL_BACK_ID));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        switch (closedCallBackEvent.getActionId()) {
            case "source_field_call_back_id": {
                String[] fieldKey = (String[])closedCallBackEvent.getReturnData();
                if (fieldKey == null || fieldKey.length != 2) break;
                int rowIndex = this.getModel().getEntryCurrentRowIndex(SUBENTRYENTITY);
                this.getModel().setValue("fieldsource", (Object)fieldKey[0], rowIndex);
                this.getModel().setValue("fieldsourceshow", (Object)fieldKey[1], rowIndex);
                if (!StringUtils.isEmpty((String)((String)this.getModel().getValue("fieldname")))) break;
                this.getModel().setValue("fieldname", (Object)fieldKey[1], rowIndex);
            }
        }
    }

    private void updateCachedData(Integer lastIndex) {
        if (lastIndex == null) {
            return;
        }
        DispatchZoneFieldSettingInfo cacheData = this.getCacheData();
        DispatchZoneInfo zoneInfo = new DispatchZoneInfo();
        zoneInfo.setIndex(ObjectConverterFactory.getString((Object)lastIndex));
        zoneInfo.setZone((String)this.getModel().getValue("zone", lastIndex.intValue()));
        zoneInfo.setEnable((Boolean)this.getModel().getValue("enable", lastIndex.intValue()));
        if (zoneInfo.getEnable().booleanValue()) {
            LinkedList<DispatchFieldInfo> list = new LinkedList<DispatchFieldInfo>();
            DynamicObjectCollection subentrys = this.getModel().getEntryEntity(SUBENTRYENTITY);
            if (subentrys != null) {
                List<String> dbfieldList = this.getDBfieldList(subentrys);
                for (DynamicObject subentry : subentrys) {
                    DispatchFieldInfo fieldInfo = new DispatchFieldInfo();
                    fieldInfo.setFieldname(subentry.getString("fieldname"));
                    fieldInfo.setFieldsource(subentry.getString("fieldsource"));
                    String dbfield = subentry.getString("dbfield");
                    if (StringUtils.isEmpty((String)dbfield)) {
                        dbfield = dbfieldList.get(0);
                        dbfieldList.remove(0);
                    }
                    fieldInfo.setDbfield(dbfield);
                    list.add(fieldInfo);
                }
                zoneInfo.setFieldSettings(list);
            }
        }
        cacheData.add((Object)zoneInfo);
        this.cacheFieldSettingData(cacheData);
    }

    private List<String> getDBfieldList(DynamicObjectCollection fields) {
        ArrayList<String> list = new ArrayList<String>(10);
        for (String dbfield : dbfields) {
            list.add(dbfield);
        }
        List collect = fields.stream().filter(o -> StringUtils.isNotEmpty((String)o.getString("dbfield"))).map(o -> o.getString("dbfield")).collect(Collectors.toList());
        list.removeAll(collect);
        return list;
    }

    private void cacheFieldSettingData(DispatchZoneFieldSettingInfo cacheData) {
        this.getPageCache().put(DATA_CACHE_KEY, FahSerializeHelper.toJsonString((Object)cacheData));
    }

    private DispatchZoneFieldSettingInfo getCacheData() {
        String s = this.getPageCache().get(DATA_CACHE_KEY);
        if (StringUtils.isNotEmpty((String)s)) {
            return (DispatchZoneFieldSettingInfo)FahSerializeHelper.fromJsonString((String)s, DispatchZoneFieldSettingInfo.class);
        }
        return new DispatchZoneFieldSettingInfo();
    }

    private Integer getLastSelectedEntryIndex() {
        String cache = this.getPageCache().get(LAST_ENTRY_INDEX);
        if (StringUtils.isNotEmpty((String)cache)) {
            return ObjectConverterFactory.getInteger((Object)cache);
        }
        return null;
    }

    private String getSourceBill() {
        return (String)this.getView().getFormShowParameter().getCustomParam("sourceBill");
    }

    private Long getDispatchId() {
        return ObjectConverterFactory.getLong((Object)this.getView().getFormShowParameter().getCustomParam("pk"));
    }

    private String getCurrentZone() {
        return (String)this.getModel().getValue("zone", this.getLastSelectedEntryIndex().intValue());
    }
}

