/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.report.CellStyle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.ai.enums.PermissonType;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.constant.enums.event.DataChangeTypeEnum;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.dao.config.event.FahDispatchRuleDaoImpl;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;
import kd.fi.v2.fah.dao.event.FahRegBillDao;
import kd.fi.v2.fah.dao.flex.MappingValueDaoImpl;
import kd.fi.v2.fah.element.BaseDataElement;
import kd.fi.v2.fah.element.BooleanElement;
import kd.fi.v2.fah.element.ComboElement;
import kd.fi.v2.fah.element.DateElement;
import kd.fi.v2.fah.element.Element;
import kd.fi.v2.fah.element.EntryElement;
import kd.fi.v2.fah.element.TextElement;
import kd.fi.v2.fah.event.DispatchFieldInfo;
import kd.fi.v2.fah.event.DispatchZoneFieldSettingInfo;
import kd.fi.v2.fah.event.DispatchZoneInfo;
import kd.fi.v2.fah.models.MappingValueTypeOrg;
import kd.fi.v2.fah.models.event.dispatch.EventDispatchRuleData;
import kd.fi.v2.fah.services.DuplicateDispatchChecker;
import kd.fi.v2.fah.util.EventDispatchSchemeUtils;
import kd.fi.v2.fah.util.PermUtils;
import kd.fi.v2.fah.utils.DateValueUtils;
import kd.fi.v2.fah.utils.EventRuleUtils;
import kd.fi.v2.fah.utils.FahSerializeHelper;
import kd.fi.v2.fah.utils.LicenseUtil;
import kd.fi.v2.fah.utils.OperationLogUtils;
import kd.fi.v2.fah.utils.StringUtils;

public class FahEventDispatchSchemePlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener,
TreeNodeClickListener,
SearchEnterListener {
    private static final String EDIT_SERIALNUMS = "EDIT_SERIALNUMS";
    private static final String ADD_SERIALNUMS = "ADD_SERIALNUMS";
    private static final String DELETE_SERIALNUMS = "DELETE_SERIALNUMS";
    private static final String DUP_CHECK_RESULT = "DUP_CHECK_RESULT";
    private static final String ORG_CACHE = "ORG_CACHE";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ORG_ID = "ORG_ID";
    private static final String DYN_FIELD_PREFIX = "dispatch_";
    private static final String ORG_ZONE_MAX_SERIALNUMBER = "orgZoneMaxSerialNumber";
    private static final String UNIQUE_PAGE_ID = "UNIQUE_PAGE_ID";
    private static final String UPDATE_FLAG = "UPDATE_FLAG";
    private static final String SERIALNUMBERSET = "SerialNumberSet";
    private static Log log = LogFactory.getLog(FahEventDispatchSchemePlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain", "treetb"});
        this.addClickListeners(new String[]{"event_scheme_set", "btn_addrow", "fieldsettingview"});
        TreeView tree = (TreeView)this.getView().getControl("treeviewap");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        EntryGrid dupentry = (EntryGrid)this.getControl("dupentry");
        dupentry.addRowClickListener((RowClickEventListener)this);
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        SequenceReader sReader = new SequenceReader(new DBRoute("ai"));
        Long[] id = (Long[])sReader.getSequences((Object[])new Long[1], "fah_evt_dispatch_scheme", 1);
        this.getModel().setValue("id", (Object)id[0]);
        Long orgId = ObjectConverterFactory.getLong((Object)this.getView().getParentView().getPageCache().get("createOrg"));
        this.getModel().setValue("org", (Object)orgId);
        List<MappingValueTypeOrg> orglist = this.initOrgCache();
        this.getPageCache().put(ORG_CACHE, SerializationUtils.serializeToBase64(orglist));
        SplitContainer splitContainer = (SplitContainer)this.getControl("splitcontainerap");
        splitContainer.setCollapse("splitpanelap1", true);
        this.getView().setVisible(Boolean.FALSE, new String[]{"tabap"});
    }

    private void setHelpText() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        FahEventDispatchSchemePlugin.setTips(entryGrid, "effectdate", ResManager.loadKDString((String)"\u5305\u542b\u5f53\u5929\u4e3a\u751f\u6548\u65f6\u95f4", (String)"FahEventDispatchSchemePlugin_18", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        FahEventDispatchSchemePlugin.setTips(entryGrid, "expiredate", ResManager.loadKDString((String)"\u5305\u542b\u5f53\u5929\u4e3a\u751f\u6548\u65f6\u95f4", (String)"FahEventDispatchSchemePlugin_18", (String)"fi-ai-formplugin", (Object[])new Object[0]));
    }

    protected static void setTips(EntryGrid entryGrid, String field, String content) {
        HashMap<String, Object> helperMap = new HashMap<String, Object>();
        helperMap.put("type", "text");
        HashMap<String, String> titleMap = new HashMap<String, String>();
        titleMap.put("zh_CN", "");
        helperMap.put("title", titleMap);
        HashMap<String, String> contentMap = new HashMap<String, String>();
        contentMap.put("zh_CN", content);
        helperMap.put("content", contentMap);
        entryGrid.setColumnProperty(field, "tips", helperMap);
    }

    private void initUserInfo() {
        long creatorId;
        Object creator = this.getModel().getValue("creator");
        if (creator == null) {
            creatorId = UserServiceHelper.getCurrentUserId();
            this.getModel().setValue("creator", (Object)creatorId);
        } else {
            creatorId = ((DynamicObject)creator).getLong("id");
        }
        DynamicObject userInfo = DataModelDaoImpl.queryUserInfo((Object)creatorId);
        if (userInfo == null) {
            return;
        }
        ((Label)this.getControl("personname")).setText(userInfo.getString("name"));
        ((Label)this.getControl("persondpt")).setText(userInfo.getString("entryentity.dpt.name"));
        ((Label)this.getControl("personphone")).setText(userInfo.getString("phone"));
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "bar_org": {
                if (!PermUtils.hasPermission((String)PermissonType.APPLY_ORG.getPermId(), (String)"fah_evt_dispatch_scheme")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u9002\u7528\u7ec4\u7ec7\u6743\u9650\u3002", (String)"FahEventDispatchSchemePlugin_22", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("fah_valmap_type_orgedit");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCustomParam("typeid", (Object)this.getPKId());
                parameter.setCustomParam("createorg", this.getModel().getValue("org_id"));
                parameter.setCustomParam("orgcache", (Object)this.getPageCache().get(ORG_CACHE));
                parameter.setCustomParam("dispatchDupcheck", (Object)this.getPageCache().get(DUP_CHECK_RESULT));
                parameter.setCustomParam("sourcePage", (Object)"fah_evt_dispatch_scheme");
                if (this.isEdit() && "0".equals((String)this.getModel().getValue("checkstatus"))) {
                    parameter.setCustomParam("checkstatus", (Object)"0");
                }
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bar_org"));
                this.getView().showForm(parameter);
                break;
            }
            case "tree_addrow": {
                FormShowParameter parameter2 = new FormShowParameter();
                parameter2.setFormId("fah_valmap_type_orgedit");
                parameter2.getOpenStyle().setShowType(ShowType.Modal);
                parameter2.setCustomParam("typeid", (Object)this.getPKId());
                parameter2.setCustomParam("createorg", this.getModel().getValue("org_id"));
                parameter2.setCustomParam("mode", (Object)"selectCustom");
                parameter2.setCustomParam("orgcache", (Object)this.getPageCache().get(ORG_CACHE));
                parameter2.setCustomParam("permorg", (Object)SerializationUtils.serializeToBase64((Object)PermUtils.getAllPermOrgs((IDataModel)this.getModel(), (String)this.getPageCache().get(ORG_CACHE), (boolean)false, (String)"fah_evt_dispatch_scheme", (Long)this.getPKId())));
                parameter2.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tree_addrow"));
                this.getView().showForm(parameter2);
                break;
            }
            case "tree_deleterow": {
                this.updateTempData(ObjectConverterFactory.getLong((Object)this.getPageCache().get(ORG_ID)), (String)this.getModel().getValue("zone"), true);
                TreeView tree = (TreeView)this.getControl("treeviewap");
                String focusNodeId = tree.getTreeState().getFocusNodeId();
                if ("root".equals(focusNodeId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u6839\u8282\u70b9\u3002", (String)"FahEventDispatchSchemePlugin_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (focusNodeId.equals(ObjectConverterFactory.getString((Object)this.getModel().getValue("org_id")))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u521b\u5efa\u7ec4\u7ec7\u8282\u70b9\u3002", (String)"FahEventDispatchSchemePlugin_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (FahDispatchRuleDaoImpl.isExistData((Long)this.getPKId(), (Long)ObjectConverterFactory.getLong((Object)focusNodeId), null, (String)this.getBatchId())) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u5df2\u7ef4\u62a4\u4e2a\u6027\u5316\u6620\u5c04\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\u3002", (String)"FahEventDispatchSchemePlugin_3", (String)"fi-ai-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("tree_deleterow", (IFormPlugin)this));
                    break;
                }
                this.switchCustomStatus(Boolean.FALSE, focusNodeId);
                tree.deleteNode(focusNodeId);
                break;
            }
            case "bar_custom": {
                if (!PermUtils.hasPermission((String)PermissonType.SHOW_CUSTOM_ORG.getPermId(), (String)"fah_evt_dispatch_scheme")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u663e\u793a\u4e2a\u6027\u5316\u7ec4\u7ec7\u6743\u9650\u3002", (String)"FahEventDispatchSchemePlugin_21", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showLeftTree();
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_custom"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_hidecustom"});
                break;
            }
            case "bar_hidecustom": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_custom"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_hidecustom", "treepanel"});
                break;
            }
            case "bar_close": {
                this.getModel().setDataChanged(false);
                this.getView().close();
                break;
            }
            case "bar_disable": {
                if (!PermUtils.hasPermission((String)PermissonType.DISABLE.getPermId(), (String)"fah_evt_dispatch_scheme")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u7981\u7528\u6743\u9650\u3002", (String)"FahEventGenRuleList_16", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                if ("0".equals(this.getModel().getValue("enable"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7981\u7528\u7684\u89c4\u5219\u4e0d\u80fd\u518d\u6b21\u7981\u7528\u3002", (String)"FahEventRulePlugin_7", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                FahDispatchRuleDaoImpl.switchEnable(Collections.singletonList(this.getPKId()), (String)"0");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"FahEventRulePlugin_8", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("enable", (Object)"0");
                OperationLogUtils.addLog((String)"fah_evt_dispatch_scheme", (String)ResManager.loadKDString((String)"\u7981\u7528", (String)"FahEventRulePlugin_20", (String)"fi-ai-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801%s\u7981\u7528\u6210\u529f\u3002", (String)"FahEventRulePlugin_18", (String)"fi-ai-formplugin", (Object[])new Object[0]), this.getModel().getValue("number")));
                break;
            }
            case "bar_enable": {
                if (!PermUtils.hasPermission((String)PermissonType.ENABLE.getPermId(), (String)"fah_evt_dispatch_scheme")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u542f\u7528\u6743\u9650\u3002", (String)"FahEventGenRuleList_17", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                if ("1".equals(this.getModel().getValue("enable"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u542f\u7528\u7684\u89c4\u5219\u4e0d\u80fd\u518d\u6b21\u542f\u7528\u3002", (String)"FahEventRulePlugin_9", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                FahDispatchRuleDaoImpl.switchEnable(Collections.singletonList(this.getPKId()), (String)"1");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"FahEventRulePlugin_10", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("enable", (Object)"1");
                OperationLogUtils.addLog((String)"fah_evt_dispatch_scheme", (String)ResManager.loadKDString((String)"\u542f\u7528", (String)"FahEventRulePlugin_21", (String)"fi-ai-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801%s\u542f\u7528\u6210\u529f\u3002", (String)"FahEventRulePlugin_19", (String)"fi-ai-formplugin", (Object[])new Object[0]), this.getModel().getValue("number")));
            }
        }
    }

    private void showLeftTree() {
        List orgList;
        String orgCache = this.getPageCache().get(ORG_CACHE);
        if (StringUtils.isNotEmpty((String)orgCache)) {
            orgList = (List)SerializationUtils.deSerializeFromBase64((String)orgCache);
        } else {
            MappingValueDaoImpl dao = new MappingValueDaoImpl();
            orgList = dao.queryOrgRecordsByTypeId(this.getPKId());
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"treepanel"});
        this.buildLeftTree(orgList);
    }

    private Long getPKId() {
        return (Long)this.getModel().getValue("id");
    }

    private Long getMasterId() {
        Long masterId = (Long)this.getModel().getValue("masterid");
        if (masterId == null || masterId == 0L) {
            return (Long)this.getModel().getValue("id");
        }
        return masterId;
    }

    private boolean isEdit() {
        return OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus());
    }

    private void switchCustomStatus(Boolean isCustom, String focusNodeId) {
        String orgCache = this.getPageCache().get(ORG_CACHE);
        List orgList = (List)SerializationUtils.deSerializeFromBase64((String)orgCache);
        for (MappingValueTypeOrg org : orgList) {
            if (((Long)org.getId()).longValue() != ObjectConverterFactory.getLong((Object)focusNodeId).longValue()) continue;
            org.setCustom(isCustom);
        }
        this.getPageCache().put(ORG_CACHE, SerializationUtils.serializeToBase64((Object)orgList));
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Long orgId;
        super.treeNodeClick(evt);
        String orgIdStr = (String)evt.getNodeId();
        String zone = (String)this.getModel().getValue("zone");
        Long exOrgId = this.getOrgId();
        this.updateTempData(exOrgId, zone, true);
        this.getPageCache().put(ORG_ID, orgIdStr);
        if ("root".equals(orgIdStr)) {
            orgId = null;
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_addrow", "btn_deleterow"});
        } else {
            orgId = ObjectConverterFactory.getLong((Object)orgIdStr);
            this.getView().setEnable(Boolean.TRUE, new String[]{"btn_addrow", "btn_deleterow"});
        }
        if (StringUtils.isNotEmpty((String)((String)this.getModel().getValue("zone")))) {
            this.buildEntryEntity(orgId, zone, null);
            this.showDuplicateMessage(orgIdStr, zone);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        FormShowParameter parameter = new FormShowParameter();
        switch (key) {
            case "event_scheme_set": {
                String eventSchemeId = (String)this.getModel().getValue("event_scheme_id", this.getSelectedRow().intValue());
                if (StringUtils.isNotEmpty((String)eventSchemeId)) {
                    parameter = new BillShowParameter();
                    parameter.setFormId("fah_evt_disp_en");
                    ((BillShowParameter)parameter).setPkId((Object)ObjectConverterFactory.getLong((Object)eventSchemeId));
                    parameter.setCustomParam("sourceBill", (Object)this.getSourceBillNo());
                    parameter.setCustomParam("zone", this.getModel().getValue("zone"));
                    parameter.setCustomParam("dispatchId", (Object)this.getPKId());
                    parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "event_scheme_set"));
                } else {
                    parameter = new ListShowParameter();
                    parameter.setFormId("bos_templatetreelistf7");
                    ((ListShowParameter)parameter).setLookUp(true);
                    ((ListShowParameter)parameter).setBillFormId("fah_evt_gen_rule");
                    ((ListShowParameter)parameter).setMultiSelect(true);
                    QFilter qFilter = new QFilter("sourceentry", "=", this.getModel().getValue("zone"));
                    qFilter.and("group", "=", (Object)this.getSourceBillNo());
                    ((ListShowParameter)parameter).getListFilterParameter().setFilter(qFilter);
                    StyleCss css = new StyleCss();
                    css.setWidth("960");
                    css.setHeight("580");
                    parameter.getOpenStyle().setInlineStyleCss(css);
                    parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "event_rule_f7_select"));
                }
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(parameter);
                break;
            }
            case "fieldsettingview": {
                parameter.setFormId("fah_disp_field_setting");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCustomParam("pk", (Object)this.getPKId());
                parameter.setCustomParam("sourceBill", (Object)this.getSourceBillNo());
                parameter.setCustomParam("fieldSetting", this.getModel().getValue("fieldSetting"));
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fieldsettingview"));
                this.getView().showForm(parameter);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        Object returnData = event.getReturnData();
        if (StringUtils.isEmpty((Object)returnData)) {
            return;
        }
        switch (event.getActionId()) {
            case "bar_org": {
                this.getPageCache().put(ORG_CACHE, (String)returnData);
                break;
            }
            case "tree_addrow": {
                List orgList;
                List selectRows = (List)SerializationUtils.deSerializeFromBase64((String)((String)returnData));
                String orgCache = this.getPageCache().get(ORG_CACHE);
                if (!StringUtils.isNotEmpty((String)orgCache) || (orgList = (List)SerializationUtils.deSerializeFromBase64((String)orgCache)) == null || orgList.isEmpty()) break;
                for (MappingValueTypeOrg selectRow : selectRows) {
                    MappingValueTypeOrg org = EventDispatchSchemeUtils.findOrgById((List)orgList, (Long)((Long)selectRow.getId()));
                    if (org == null) continue;
                    org.setCustom(Boolean.TRUE);
                }
                this.buildLeftTree(orgList);
                this.getPageCache().put(ORG_CACHE, SerializationUtils.serializeToBase64((Object)orgList));
                break;
            }
            case "event_scheme_set": {
                Long eventSchemeId = ObjectConverterFactory.getLong((Object)this.getModel().getValue("event_scheme_id", this.getSelectedRow().intValue()));
                this.getModel().setValue("event_scheme_set", (Object)EventDispatchSchemeUtils.getFullName((Long)eventSchemeId), this.getSelectedRow().intValue());
                break;
            }
            case "event_rule_f7_select": {
                HashSet<Long> evtRulePks = new HashSet<Long>(((ListSelectedRowCollection)returnData).size());
                for (ListSelectedRow row : (ListSelectedRowCollection)returnData) {
                    evtRulePks.add((Long)row.getPrimaryKeyValue());
                }
                DynamicObject schemeSet = EventDispatchSchemeUtils.generateSchemeSetData((Long)this.getPKId(), evtRulePks);
                this.getModel().setValue("event_scheme_set", (Object)EventDispatchSchemeUtils.getFullName((Long)((Long)schemeSet.getPkValue())), this.getSelectedRow().intValue());
                this.getModel().setValue("event_scheme_id", (Object)ObjectConverterFactory.getString((Object)schemeSet.getPkValue()), this.getSelectedRow().intValue());
                break;
            }
            case "fieldsettingview": {
                DispatchZoneFieldSettingInfo oldInfo = this.getFieldSettingInfo();
                this.getModel().setValue("fieldsetting", returnData);
                DispatchZoneFieldSettingInfo newInfo = (DispatchZoneFieldSettingInfo)FahSerializeHelper.fromJsonString((String)((String)returnData), DispatchZoneFieldSettingInfo.class);
                this.getModel().setValue("fieldsettingview", (Object)this.generateShowText(newInfo));
                this.dealingOldSetting(oldInfo, newInfo);
                this.rebuildZoneComboList(newInfo);
                this.rebuildEntryEntity(newInfo);
            }
        }
    }

    private void rebuildZoneComboList(DispatchZoneFieldSettingInfo newInfo) {
        HashSet<String> zoneSet = new HashSet<String>(newInfo.size());
        for (DispatchZoneInfo zoneInfo : newInfo) {
            zoneSet.add(zoneInfo.getZone());
        }
        List items = EventDispatchSchemeUtils.getComboItemList((String)this.getSourceBillNo(), zoneSet);
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("zone");
        comboEdit.setComboItems(items);
        this.setValueZoneTips(items.size());
    }

    private void rebuildEntryEntity(DispatchZoneFieldSettingInfo newInfo) {
        String zone = (String)this.getModel().getValue("zone");
        DispatchZoneInfo zoneInfo = EventDispatchSchemeUtils.findZoneInfoByZone((String)zone, (DispatchZoneFieldSettingInfo)newInfo);
        if (zoneInfo == null) {
            zoneInfo = (DispatchZoneInfo)newInfo.get((Object)"0");
            this.getModel().setValue("zone", (Object)zoneInfo.getZone());
        }
        this.cacheEntryElement(this.getElementList(zoneInfo.getFieldSettings()));
        this.entryBuild();
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5206\u6d41\u53d6\u503c\u8bbe\u7f6e\u6539\u53d8\uff0c\u9700\u8981\u91cd\u65b0\u6784\u5efa\u5217\u8868\u3002", (String)"FahEventDispatchSchemePlugin_24", (String)"fi-ai-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, new ConfirmCallBackListener("zoneFieldSettingChange"));
    }

    private LinkedList<Element> getElementList(List<DispatchFieldInfo> fieldSettings) {
        LinkedList<Element> entryElementList = new LinkedList<Element>();
        entryElementList.add((Element)new TextElement("serialnumber", ResManager.loadKDString((String)"\u6d41\u6c34\u53f7", (String)"FahEventDispatchSchemePlugin_5", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY, false));
        entryElementList.add((Element)new BaseDataElement("eorg", ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7", (String)"FahEventDispatchSchemePlugin_6", (String)"fi-ai-formplugin", (Object[])new Object[0]), "bos_org", ENTRYENTITY, false, false));
        if (fieldSettings != null && !fieldSettings.isEmpty()) {
            for (DispatchFieldInfo info : fieldSettings) {
                String fieldNumber = DYN_FIELD_PREFIX + info.getDbfield();
                String fieldName = info.getFieldname();
                boolean isMustInput = false;
                TextElement element = new TextElement(fieldNumber, fieldName, ENTRYENTITY, isMustInput, 50);
                element.setFlexFieldType("2");
                entryElementList.add((Element)element);
            }
        }
        entryElementList.add((Element)new BooleanElement("need_gen_evt", ResManager.loadKDString((String)"\u4ea7\u751f\u4e8b\u4ef6", (String)"FahEventDispatchSchemePlugin_23", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY));
        entryElementList.add((Element)new TextElement("event_scheme_set", ResManager.loadKDString((String)"\u4e8b\u4ef6\u89c4\u5219", (String)"FahEventDispatchSchemePlugin_02", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY, 1));
        entryElementList.add((Element)new DateElement("effectdate", ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f", (String)"FahEventDispatchSchemePlugin_7", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY));
        entryElementList.add((Element)new DateElement("expiredate", ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f", (String)"FahEventDispatchSchemePlugin_8", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY));
        entryElementList.add((Element)new ComboElement("check", ResManager.loadKDString((String)"\u6821\u9a8c\u91cd\u590d", (String)"FahEventDispatchSchemePlugin_9", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY, "fah_evt_dispatch_scheme", "combostatus", false, "A", false));
        entryElementList.add((Element)new BooleanElement("enable_en", ResManager.loadKDString((String)"\u542f\u7528", (String)"FahEventDispatchSchemePlugin_10", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY));
        TextElement eventSchemeSetId = new TextElement("event_scheme_id", "EventSchemeSetId", ENTRYENTITY);
        eventSchemeSetId.setVisible(false);
        entryElementList.add((Element)eventSchemeSetId);
        TextElement entryID = new TextElement("entry_pk", "EventPK", ENTRYENTITY);
        entryID.setVisible(false);
        entryElementList.add((Element)entryID);
        return entryElementList;
    }

    private void dealingOldSetting(DispatchZoneFieldSettingInfo oldInfo, DispatchZoneFieldSettingInfo newInfo) {
        if (oldInfo == null) {
            return;
        }
        HashSet<String> deletedZoneSet = new HashSet<String>(1);
        HashMap<String, Set> deletedDBfieldMap = new HashMap<String, Set>(1);
        for (DispatchZoneInfo oldZoneInfo : oldInfo) {
            DispatchZoneInfo newZoneInfo = EventDispatchSchemeUtils.findZoneInfoByZone((String)oldZoneInfo.getZone(), (DispatchZoneFieldSettingInfo)newInfo);
            if (newZoneInfo == null) {
                deletedZoneSet.add(oldZoneInfo.getZone());
                continue;
            }
            if (oldZoneInfo.getFieldSettings() == null) continue;
            for (DispatchFieldInfo oldFieldSetting : oldZoneInfo.getFieldSettings()) {
                if (this.existDBfield(oldFieldSetting.getDbfield(), newZoneInfo)) continue;
                deletedDBfieldMap.computeIfAbsent(oldZoneInfo.getZone(), o -> new HashSet(1)).add(oldFieldSetting.getDbfield());
            }
        }
        FahDispatchRuleDaoImpl.deleteDataByZoneAndDbFields((Long)this.getPKId(), deletedZoneSet, deletedDBfieldMap, (String)this.getBatchId());
    }

    private boolean existDBfield(String dbfield, DispatchZoneInfo newZoneInfo) {
        boolean flag = false;
        if (newZoneInfo.getFieldSettings() != null && !newZoneInfo.getFieldSettings().isEmpty()) {
            for (DispatchFieldInfo fieldSetting : newZoneInfo.getFieldSettings()) {
                if (!dbfield.equals(fieldSetting.getDbfield())) continue;
                flag = true;
            }
        }
        return flag;
    }

    private String generateShowText(DispatchZoneFieldSettingInfo info) {
        StringBuilder sb = new StringBuilder();
        for (DispatchZoneInfo zoneInfo : info) {
            sb.append(EventDispatchSchemeUtils.findFieldNameByNumber((String)this.getSourceBillNo(), (String)zoneInfo.getZone())).append(";");
        }
        sb.deleteCharAt(sb.lastIndexOf(";"));
        return sb.toString();
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId;
        super.confirmCallBack(evt);
        MessageBoxResult result = evt.getResult();
        switch (callBackId = evt.getCallBackId()) {
            case "zoneFieldSettingChange": 
            case "valueZoneChange": {
                Long orgID = this.getOrgId();
                this.buildEntryEntity(orgID, (String)this.getModel().getValue("zone"), null);
                break;
            }
            case "tree_deleterow": {
                if (result != MessageBoxResult.Yes) break;
                TreeView tree = (TreeView)this.getControl("treeviewap");
                String focusNodeId = tree.getTreeState().getFocusNodeId();
                Long orgId = ObjectConverterFactory.getLong((Object)focusNodeId);
                EventDispatchSchemeUtils.gengerateDeleteData((Long)this.getPKId(), (String)this.getBatchId(), (Long)orgId, null);
                this.switchCustomStatus(Boolean.FALSE, focusNodeId);
                tree.deleteNode(focusNodeId);
                TreeNode treeNode = new TreeNode();
                Object createOrgId = this.getModel().getValue("org_id");
                treeNode.setId(ObjectConverterFactory.getString((Object)createOrgId));
                tree.focusNode(treeNode);
                this.getPageCache().put(ORG_ID, ObjectConverterFactory.getString((Object)createOrgId));
                this.buildEntryEntity(orgId, (String)this.getModel().getValue("zone"), null);
                this.clearChangedSetCache();
            }
        }
    }

    private Integer getSelectedRow() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        if (entryGrid.getSelectRows() != null && entryGrid.getSelectRows().length > 0) {
            return entryGrid.getSelectRows()[0];
        }
        return null;
    }

    private void buildLeftTree(List<MappingValueTypeOrg> orgList) {
        TreeView treev = (TreeView)this.getControl("treeviewap");
        treev.deleteAllNodes();
        TreeNode node = EventDispatchSchemeUtils.getRoot(orgList, (Long)((Long)this.getModel().getValue("org_id")), (String)((DynamicObject)this.getModel().getValue("org")).getString("name"), (IPageCache)this.getPageCache());
        treev.addNode(node);
        treev.updateNode(node);
        String nodeId = ObjectConverterFactory.getString((Object)this.getModel().getValue("org_id"));
        treev.focusNode(node.getTreeNode(nodeId));
    }

    private String getSourceBillNo() {
        DynamicObject sourcebill = (DynamicObject)this.getModel().getValue("group");
        return sourcebill == null ? null : sourcebill.getString("number");
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String searchText = searchEnterEvent.getText();
        TreeView tree = (TreeView)this.getControl("treeviewap");
        if (StringUtils.isEmpty((String)searchText)) {
            return;
        }
        ArrayList treeIdList = new ArrayList(16);
        Map treeNodeMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("treeNodeMap"));
        for (Map.Entry entry : treeNodeMap.entrySet()) {
            if (!((TreeNode)entry.getValue()).getLongNumber().contains(searchText) && !((TreeNode)entry.getValue()).getText().contains(searchText)) continue;
            treeIdList.add(entry.getKey());
        }
        if (treeIdList.isEmpty()) {
            return;
        }
        String selectedGroup = tree.getTreeState().getFocusNodeId();
        if (StringUtils.isNotEmpty((String)selectedGroup) && treeIdList.contains(selectedGroup)) {
            int i = treeIdList.indexOf(selectedGroup);
            if (i == treeIdList.size() - 1) {
                TreeNode treeNode = (TreeNode)treeNodeMap.get(treeIdList.get(0));
                tree.focusNode(treeNode);
                tree.treeNodeClick(treeNode.getParentid(), treeNode.getId());
            } else {
                TreeNode treeNode = (TreeNode)treeNodeMap.get(treeIdList.get(i + 1));
                tree.focusNode(treeNode);
                tree.treeNodeClick(treeNode.getParentid(), treeNode.getId());
            }
        } else {
            TreeNode treeNode = (TreeNode)treeNodeMap.get(treeIdList.get(0));
            tree.focusNode(treeNode);
            tree.treeNodeClick(treeNode.getParentid(), treeNode.getId());
        }
    }

    public void setView(IFormView formView) {
        super.setView(formView);
        this.getView().addCustomControls(new String[]{ENTRYENTITY});
        boolean isInit = StringUtils.isEmpty((String)this.getPageCache().get("isInit"));
        if (isInit && !this.isAddNew()) {
            Long pk = ObjectConverterFactory.getLong((Object)String.valueOf(((BillShowParameter)this.getView().getFormShowParameter()).getPkId()));
            DispatchZoneFieldSettingInfo info = FahDispatchRuleDaoImpl.queryDispatchZoneFieldSettingInfo((Long)pk);
            if (info != null && info.size() > 0) {
                this.cacheEntryElement(this.getElementList(((DispatchZoneInfo)info.get(0)).getFieldSettings()));
            } else {
                this.cacheEntryElement(new LinkedList<Element>());
            }
        }
        this.getPageCache().put("isInit", "true");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initBizOrgComboItems();
        this.initUserInfo();
        this.getPageCache().put(ORG_ZONE_MAX_SERIALNUMBER, SerializationUtils.serializeToBase64(new HashMap()));
        if (!this.isAddNew()) {
            ThreadCache.put((Object)"isInit", (Object)Boolean.TRUE);
            this.entryBuild();
            this.getView().updateView(ENTRYENTITY);
            this.setHelpText();
            MappingValueDaoImpl dao = new MappingValueDaoImpl();
            List orglist = dao.queryOrgRecordsByTypeId(this.getPKId());
            this.getPageCache().put(ORG_CACHE, SerializationUtils.serializeToBase64((Object)orglist));
            DispatchZoneFieldSettingInfo info = this.getFieldSettingInfo();
            if (info != null) {
                this.getModel().setValue("fieldsettingview", (Object)this.generateShowText(info));
                this.rebuildZoneComboList(info);
                String zone = ((DispatchZoneInfo)info.get(0)).getZone();
                this.getModel().setValue("zone", (Object)zone);
                this.getPageCache().put(ORG_ID, ObjectConverterFactory.getString((Object)this.getModel().getValue("org_id")));
                this.buildEntryEntity((Long)this.getModel().getValue("org_id"), zone, null);
                this.checkDuplicate(true);
            }
            this.setFieldStyle((String)this.getModel().getValue("checkstatus"));
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"treepanel", "bar_hidecustom"});
        this.getPageCache().put(ORG_ID, ObjectConverterFactory.getString((Object)this.getModel().getValue("org_id")));
    }

    private DispatchZoneFieldSettingInfo getFieldSettingInfo() {
        String fieldsetting = (String)this.getModel().getValue("fieldsetting");
        if (!StringUtils.isEmpty((String)fieldsetting)) {
            DispatchZoneFieldSettingInfo info = (DispatchZoneFieldSettingInfo)FahSerializeHelper.fromJsonString((String)fieldsetting, DispatchZoneFieldSettingInfo.class);
            return info;
        }
        return null;
    }

    private void buildEntryEntity(Long orgId, String valueZone, Set<Integer> serialNumSet) {
        String updateFlag = this.getView().getPageCache().get(UPDATE_FLAG);
        if (StringUtils.isEmpty((String)updateFlag)) {
            this.getView().getPageCache().put(UPDATE_FLAG, "false");
        }
        this.getModel().deleteEntryData(ENTRYENTITY);
        String fieldsetting = (String)this.getModel().getValue("fieldsetting");
        DispatchZoneFieldSettingInfo info = (DispatchZoneFieldSettingInfo)FahSerializeHelper.fromJsonString((String)fieldsetting, DispatchZoneFieldSettingInfo.class);
        DispatchZoneInfo zoneInfo = EventDispatchSchemeUtils.findZoneInfoByZone((String)valueZone, (DispatchZoneFieldSettingInfo)info);
        DataSet dataSet = FahDispatchRuleDaoImpl.queryDataSet((Long)this.getPKId(), (String)this.getBatchId(), (Long)orgId, (String)valueZone, serialNumSet, (DispatchZoneInfo)zoneInfo);
        DataSet copy = dataSet.copy();
        Map orgMaxSerialNumber = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(ORG_ZONE_MAX_SERIALNUMBER));
        String key = orgId + "$" + valueZone;
        boolean needInitMaxSerialNum = orgId != null && (orgMaxSerialNumber.isEmpty() || orgMaxSerialNumber.get(key) == null);
        int size = 0;
        for (Row row : copy) {
            ++size;
            if (!needInitMaxSerialNum) continue;
            orgMaxSerialNumber.put(key, row.getInteger("serialnumber"));
        }
        if (size == 0 && needInitMaxSerialNum) {
            orgMaxSerialNumber.put(key, 1);
        }
        this.getPageCache().put(ORG_ZONE_MAX_SERIALNUMBER, SerializationUtils.serializeToBase64((Object)orgMaxSerialNumber));
        LinkedHashSet<Integer> serialNumberSet = new LinkedHashSet<Integer>();
        if (size > 0) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, size);
            Iterator iterator = dataSet.iterator();
            int index = 0;
            LinkedList<String> fields = new LinkedList<String>();
            while (iterator.hasNext()) {
                Long dispgrp;
                Row row = (Row)iterator.next();
                int serialNumber = row.getInteger("serialnumber");
                this.getModel().setValue("entry_pk", (Object)row.getLong("id"), index);
                this.getModel().setValue("serialnumber", (Object)serialNumber, index);
                this.getModel().setValue("eorg", (Object)row.getLong("orgid"), index);
                serialNumberSet.add(serialNumber);
                if (zoneInfo != null && zoneInfo.getFieldSettings() != null && !zoneInfo.getFieldSettings().isEmpty()) {
                    for (DispatchFieldInfo cfg : zoneInfo.getFieldSettings()) {
                        this.getModel().setValue(DYN_FIELD_PREFIX + cfg.getDbfield(), (Object)row.getString(cfg.getDbfield()), index);
                        fields.add(DYN_FIELD_PREFIX + cfg.getDbfield());
                    }
                }
                if ((dispgrp = row.getLong("dispgrp")) != null && dispgrp != 0L) {
                    this.getModel().setValue("event_scheme_id", (Object)dispgrp, index);
                    this.getModel().setValue("event_scheme_set", (Object)EventDispatchSchemeUtils.getFullName((Long)dispgrp), index);
                }
                this.getModel().setValue("effectdate", (Object)row.getDate("effectdate"), index);
                this.getModel().setValue("expiredate", (Object)row.getDate("expiredate"), index);
                this.getModel().setValue("check", (Object)row.getString("status"), index);
                this.setCellStyle(this.getView(), index, row.getString("status"));
                this.getModel().setValue("enable_en", (Object)row.getString("enable_en"), index);
                this.getModel().setValue("need_gen_evt", (Object)row.getString("need_gen_evt"), index);
                if (orgId == null) {
                    fields.add("event_scheme_set");
                    fields.add("effectdate");
                    fields.add("expiredate");
                    fields.add("enable_en");
                    fields.add("need_gen_evt");
                    this.getView().setEnable(Boolean.FALSE, index, fields.toArray(new String[0]));
                }
                ++index;
                fields.clear();
            }
        } else {
            this.getModel().createNewEntryRow(ENTRYENTITY);
            this.getModel().setValue("serialnumber", (Object)1);
            Set<Integer> set = this.getChangedSerialNumSet(ADD_SERIALNUMS);
            set.add(1);
            this.cacheChangedSerialNumberInfo(ADD_SERIALNUMS, set);
        }
        this.cacheSerialNumberSet(serialNumberSet);
        copy.close();
        dataSet.close();
        this.getView().getPageCache().remove(UPDATE_FLAG);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String updateFlag;
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if ("zone".equals(propertyName) && newValue != oldValue) {
            Boolean isInit = (Boolean)ThreadCache.get((Object)"isInit");
            if (isInit == null || !isInit.booleanValue()) {
                this.updateTempData(this.getOrgId(), (String)oldValue, true);
                this.getModel().deleteEntryData(ENTRYENTITY);
                DispatchZoneInfo zoneInfo = EventDispatchSchemeUtils.findZoneInfoByZone((String)((String)newValue), (DispatchZoneFieldSettingInfo)this.getFieldSettingInfo());
                this.cacheEntryElement(this.getElementList(zoneInfo == null ? null : zoneInfo.getFieldSettings()));
                this.entryBuild();
                this.setHelpText();
                this.getView().showConfirm(ResManager.loadKDString((String)"\u53d6\u503c\u533a\u57df\u6539\u53d8\uff0c\u9700\u8981\u91cd\u65b0\u6784\u5efa\u5217\u8868\u3002", (String)"FahEventDispatchSchemePlugin_16", (String)"fi-ai-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, new ConfirmCallBackListener("valueZoneChange"));
            }
        } else if ("checkstatus".equals(propertyName)) {
            this.setFieldStyle((String)newValue);
        } else if ("event_scheme_set".equals(propertyName) && StringUtils.isEmpty((Object)newValue)) {
            this.getModel().setValue("event_scheme_id", null, rowIndex);
        } else if (e.getProperty().getParent().getName().equals(ENTRYENTITY) && !"false".equals(updateFlag = this.getView().getPageCache().get(UPDATE_FLAG))) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            int serialnumber = ((DynamicObject)entryEntity.get(rowIndex)).getInt("serialnumber");
            Set<Integer> addSet = this.getChangedSerialNumSet(ADD_SERIALNUMS);
            Set<Integer> editSet = this.getChangedSerialNumSet(EDIT_SERIALNUMS);
            if (addSet == null || !addSet.contains(serialnumber)) {
                editSet.add(serialnumber);
            }
            this.cacheChangedSerialNumberInfo(EDIT_SERIALNUMS, editSet);
        }
    }

    private void setValueZoneTips(int size) {
        Label lblTip = (Label)this.getControl("labelap");
        if (size > 1) {
            lblTip.setText(String.format(ResManager.loadKDString((String)"\u5171\u8bbe\u7f6e%s\u4e2a\u5206\u6d41\u533a\u57df\uff0c\u8bf7\u5207\u6362\u67e5\u770b\u3002", (String)"FahEventDispatchSchemePlugin_17", (String)"fi-ai-formplugin", (Object[])new Object[0]), size));
        } else {
            lblTip.setText("");
        }
    }

    private void cacheChangedSerialNumberInfo(String pageCacheId, Object obj) {
        this.getPageCache().put(pageCacheId, SerializationUtils.serializeToBase64((Object)obj));
    }

    private boolean isAddNew() {
        return OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus());
    }

    private void entryBuild() {
        this.getEntryElement().build(this.getView());
    }

    private EntryElement getEntryElement() {
        String elements = this.getPageCache().get("entryentity_element");
        if (elements == null) {
            LinkedList<Element> elementList = new LinkedList<Element>();
            return this.cacheEntryElement(elementList);
        }
        return (EntryElement)SerializationUtils.deSerializeFromBase64((String)elements);
    }

    private EntryElement cacheEntryElement(LinkedList<Element> elementList) {
        EntryElement entryElement = new EntryElement(ENTRYENTITY);
        entryElement.setItems(elementList);
        entryElement.setSplitPage(true);
        this.getPageCache().put("entryentity_element", SerializationUtils.serializeToBase64((Object)entryElement));
        return entryElement;
    }

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{ENTRYENTITY});
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException var5) {
            throw new KDException((Throwable)var5, new ErrorCode("LoadCustomControlMetasSample", var5.getMessage()), new Object[0]);
        }
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(ENTRYENTITY);
        this.getEntryElement().registerEntryProp(entryType);
        e.setNewEntityType(newMainType);
    }

    public void onGetControl(OnGetControlArgs e) {
        EntryElement entryElement = this.getEntryElement();
        ArrayList<EntryElement> items = new ArrayList<EntryElement>(entryElement.getItems());
        items.add(entryElement);
        Optional<Element> first = items.stream().filter(x -> x.getName().equals(e.getKey())).findFirst();
        if (first.isPresent()) {
            Element element = first.get();
            Control control = element.getControl(this.getView());
            e.setControl(control);
        }
    }

    private void initBizOrgComboItems() {
        String sourcebill = ((DynamicObject)this.getModel().getValue("group")).getString("number");
        if (StringUtils.isEmpty((String)sourcebill)) {
            return;
        }
        String srcOrgField = FahRegBillDao.querySrcOrg((String)sourcebill);
        if (srcOrgField.isEmpty()) {
            return;
        }
        LinkedList<ComboItem> items = new LinkedList<ComboItem>();
        IDataEntityProperty orgPrt = (IDataEntityProperty)EntityMetadataCache.getDataEntityType((String)sourcebill).getAllFields().get(srcOrgField);
        if (orgPrt instanceof OrgProp || this.isOrgBaseProp(orgPrt)) {
            ComboItem comboItem = new ComboItem();
            StringBuilder caption = new StringBuilder();
            EventRuleUtils.generateParentCaption((StringBuilder)caption, (IDataEntityType)orgPrt.getParent());
            String displayName = orgPrt.getDisplayName().toString();
            caption.append(displayName == null ? "" : displayName);
            comboItem.setCaption(new LocaleString(caption.toString()));
            StringBuilder value = new StringBuilder();
            EventRuleUtils.generateParentValue((StringBuilder)value, (IDataEntityType)orgPrt.getParent());
            comboItem.setValue(value + orgPrt.getName());
            items.add(comboItem);
        }
        if (items.isEmpty()) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("orgsrcfield");
        comboEdit.setComboItems(items);
        this.getModel().setValue("orgsrcfield", (Object)((ComboItem)items.get(0)).getValue());
    }

    private boolean isOrgBaseProp(IDataEntityProperty property) {
        return property instanceof BasedataProp && ("bos_org".equalsIgnoreCase(((BasedataProp)property).getBaseEntityId()) || "bos_adminorg".equalsIgnoreCase(((BasedataProp)property).getBaseEntityId()));
    }

    private List<MappingValueTypeOrg> initOrgCache() {
        DynamicObject orgObj = (DynamicObject)this.getModel().getValue("org");
        MappingValueTypeOrg org = new MappingValueTypeOrg(Long.valueOf(orgObj.getLong("id")), orgObj.getString("number"), orgObj.getString("name"), ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"FahEventDispatchSchemePlugin_11", (String)"fi-ai-formplugin", (Object[])new Object[0]), "10", Boolean.TRUE);
        return Collections.singletonList(org);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("save".equals(key)) {
            LicenseUtil.checkFahLicenseWithTips((IFormView)this.getView());
            Long orgId = this.getOrgId();
            this.updateTempData(orgId, (String)this.getModel().getValue("zone"), true);
            if (!this.validateCanSave()) {
                args.setCancel(true);
                this.buildEntryEntity(this.getOrgId(), (String)this.getModel().getValue("zone"), null);
            }
        } else if ("newentry".equals(key)) {
            String zone = (String)this.getModel().getValue("zone");
            if (StringUtils.isEmpty((String)zone)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u53d6\u503c\u533a\u57df\u3002", (String)"FahEventDispatchSchemePlugin_04", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            DispatchZoneInfo zoneInfo = EventDispatchSchemeUtils.findZoneInfoByZone((String)zone, (DispatchZoneFieldSettingInfo)this.getFieldSettingInfo());
            if (!zoneInfo.getEnable().booleanValue() && entryEntity.size() >= 1) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u53d6\u503c\u533a\u57df\u672a\u542f\u7528\u6761\u4ef6\u5b57\u6bb5\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u591a\u884c\u3002", (String)"FahEventDispatchSchemePlugin_07", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            if (entryEntity.size() >= 100) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bcf\u4e2a\u53d6\u503c\u533a\u57df\u6700\u5927\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7100\u884c\u3002", (String)"FahEventDispatchSchemePlugin_06", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            }
        } else if ("deleteentry".equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            String chache = this.getPageCache().get(DELETE_SERIALNUMS);
            Map<Integer, Long> deleteMap = StringUtils.isEmpty((String)chache) ? new HashMap(selectRows.length) : (Map)SerializationUtils.deSerializeFromBase64((String)chache);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
            for (int selectRow : selectRows) {
                deleteMap.put(((DynamicObject)entryEntity.get(selectRow)).getInt("serialnumber"), ((DynamicObject)entryEntity.get(selectRow)).getLong("entry_pk"));
            }
            this.cacheChangedSerialNumberInfo(DELETE_SERIALNUMS, deleteMap);
            List sortIndex = Arrays.stream(selectRows).boxed().collect(Collectors.toList());
            sortIndex.sort(Comparator.reverseOrder());
            Map orgMaxSerialNumber = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(ORG_ZONE_MAX_SERIALNUMBER));
            Long orgId = this.getOrgId();
            String serialNumberKey = orgId + "$" + this.getModel().getValue("zone");
            Set<Integer> serialNumberSet = this.getSerialNumberSet();
            Iterator iterator = sortIndex.iterator();
            while (iterator.hasNext()) {
                int serialnumber;
                int maxserialnumber;
                int rowIndex = (Integer)iterator.next();
                if (orgMaxSerialNumber.get(serialNumberKey) == null || (maxserialnumber = ((Integer)orgMaxSerialNumber.get(serialNumberKey)).intValue()) != (serialnumber = Integer.parseInt(this.getModel().getValue("serialnumber", rowIndex).toString())) || serialNumberSet.contains(serialnumber)) continue;
                orgMaxSerialNumber.put(serialNumberKey, --serialnumber);
            }
            this.getPageCache().put(ORG_ZONE_MAX_SERIALNUMBER, SerializationUtils.serializeToBase64((Object)orgMaxSerialNumber));
        }
    }

    private void cacheSerialNumberSet(Set<Integer> serialNumberSet) {
        this.getPageCache().put(SERIALNUMBERSET, SerializationUtils.serializeToBase64(serialNumberSet));
    }

    protected Set<Integer> getSerialNumberSet() {
        Set<Integer> serialNumberSet;
        if (!StringUtils.isEmpty((String)this.getView().getPageCache().get(SERIALNUMBERSET))) {
            serialNumberSet = (Set)SerializationUtils.deSerializeFromBase64((String)this.getView().getPageCache().get(SERIALNUMBERSET));
        } else {
            serialNumberSet = new LinkedHashSet<Integer>();
            this.cacheSerialNumberSet(serialNumberSet);
        }
        return serialNumberSet;
    }

    private boolean validateCanSave() {
        String number = (String)this.getModel().getValue("number");
        if (!this.isNumberMatch(number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u80fd\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u7ec4\u6210\u3002", (String)"EventRuleSaveValidator_1", (String)"fi-ai-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (FahDispatchRuleDaoImpl.isNumberExist((String)number, (Long)this.getMasterId())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"FahEventDispatchSchemePlugin_05", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return false;
        }
        Map timeIllegal = FahDispatchRuleDaoImpl.queryTimeIllegalTempData((Long)this.getPKId(), (String)this.getBatchId());
        if (!timeIllegal.isEmpty()) {
            Set orgIds = timeIllegal.keySet().stream().map(s -> ObjectConverterFactory.getLong((Object)s.split("\\$")[0])).collect(Collectors.toSet());
            Map nameNumberMap = new MappingValueDaoImpl().queryOrgNameNumberMap(orgIds);
            StringBuilder errorMsg = new StringBuilder();
            StringBuilder errorMsgBody = new StringBuilder();
            for (Map.Entry entry : timeIllegal.entrySet()) {
                String[] split = ((String)entry.getKey()).split("\\$");
                Long orgId = ObjectConverterFactory.getLong((Object)split[0]);
                String orgName = (String)((PairTuple)nameNumberMap.get(orgId)).getValue();
                String zoneName = EventDispatchSchemeUtils.findFieldNameByNumber((String)this.getSourceBillNo(), (String)split[1]);
                StringBuilder seralNumStr = new StringBuilder();
                for (Integer integer : (Set)entry.getValue()) {
                    seralNumStr.append(integer).append('\u3001');
                }
                if (seralNumStr.length() > 0) {
                    seralNumStr.deleteCharAt(seralNumStr.lastIndexOf("\u3001"));
                }
                errorMsgBody.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s\uff0c\u53d6\u503c\u533a\u57df\uff1a%2$s\uff0c\u6d41\u6c34\u53f7\uff1a%3$s\uff1b%4$s", (String)"FahEventDispatchSchemePlugin_19", (String)"fi-ai-formplugin", (Object[])new Object[0]), orgName, zoneName, seralNumStr, "\r\n"));
            }
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ec4\u7ec7\u53ca\u53d6\u503c\u533a\u57df\u5185\u5b58\u5728\u7ed3\u675f\u65e5\u671f\u5c0f\u4e8e\u5f00\u59cb\u65e5\u671f\u7684\u6570\u636e\uff0c\u8bf7\u4fee\u6539\uff1a%1$s%2$s\u3002", (String)"FahEventDispatchSchemePlugin_20", (String)"fi-ai-formplugin", (Object[])new Object[0]), "\r\n", errorMsgBody));
            FormShowParameter parameters = new FormShowParameter();
            parameters.getOpenStyle().setShowType(ShowType.Modal);
            parameters.setFormId("bos_operationresult");
            parameters.setShowTitle(false);
            parameters.setCustomParam("title", (Object)ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"FahValMapEdit_35", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            parameters.setCustomParam("errorMsg", (Object)errorMsg.toString());
            this.getView().showForm(parameters);
            return false;
        }
        String orgCache = this.getPageCache().get(ORG_CACHE);
        List orgList = (List)SerializationUtils.deSerializeFromBase64((String)orgCache);
        DynamicObjectCollection collection = FahDispatchRuleDaoImpl.queryDuplicateRecord((List)orgList, (String)this.getSourceBillNo(), (Long)this.getMasterId());
        if (!collection.isEmpty()) {
            Set orgs = collection.stream().map(o -> o.getString("ownorg.number")).collect(Collectors.toSet());
            Set schemeIds = collection.stream().map(o -> o.getLong("maptype")).collect(Collectors.toSet());
            DynamicObjectCollection schemes = QueryServiceHelper.query((String)"fah_evt_dispatch_scheme", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", schemeIds)});
            Set schemeNums = schemes.stream().map(o -> o.getString("number")).collect(Collectors.toSet());
            String orgStr = String.join((CharSequence)",", orgs);
            String schemeStr = String.join((CharSequence)",", schemeNums);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u5df2\u9002\u7528\u4e8e\u5206\u6d41\u89c4\u5219\u201c%2$s\u201d\u4e2d\uff0c\u4e0d\u80fd\u518d\u8bbe\u4e3a\u9002\u7528\u7ec4\u7ec7\u3002", (String)"FahEventDispatchSchemePlugin_03", (String)"fi-ai-formplugin", (Object[])new Object[0]), orgStr, schemeStr));
            return false;
        }
        return true;
    }

    private boolean isNumberMatch(String number) {
        Pattern pattern = Pattern.compile("[a-zA-Z0-9_]+");
        return pattern.matcher(number).matches();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("save".equals(key)) {
            try (TXHandle tx = TX.requiresNew();){
                try {
                    this.saveOrg(this.getPKId());
                    FahDispatchRuleDaoImpl.insertDisSchemaData((Long)this.getPKId(), (String)this.getBatchId());
                    FahDispatchRuleDaoImpl.clearUnreferredSchemeEntryRec((Long)this.getPKId());
                }
                catch (Exception e) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FahEventDispatchSchemePlugin_08", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    log.error((Throwable)e);
                    tx.markRollback();
                }
            }
            this.checkDuplicate(false);
            Date date = QueryServiceHelper.queryOne((String)"fah_evt_dispatch_scheme", (String)"lastchecktime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getPKId())}).getDate("lastchecktime");
            this.getModel().setValue("lastchecktime", (Object)date);
            this.showDuplicateMessage(this.getPageCache().get(ORG_ID), (String)this.getModel().getValue("zone"));
            Long orgId = this.getOrgId();
            this.buildEntryEntity(orgId, (String)this.getModel().getValue("zone"), null);
            if (orgId != null) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"btn_addrow", "btn_deleterow"});
            }
        } else if ("newentry".equals(key)) {
            Long orgId;
            String serialNumberKey;
            Map orgMaxSerialNumber = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get(ORG_ZONE_MAX_SERIALNUMBER));
            Integer maxserialnumber = (Integer)orgMaxSerialNumber.get(serialNumberKey = (orgId = this.getOrgId()) + "$" + this.getModel().getValue("zone"));
            if (maxserialnumber == null) {
                maxserialnumber = 0;
            }
            maxserialnumber = maxserialnumber + 1;
            orgMaxSerialNumber.put(serialNumberKey, maxserialnumber);
            this.getPageCache().put(ORG_ZONE_MAX_SERIALNUMBER, SerializationUtils.serializeToBase64((Object)orgMaxSerialNumber));
            Set<Integer> set = this.getChangedSerialNumSet(ADD_SERIALNUMS);
            set.add(maxserialnumber);
            this.cacheChangedSerialNumberInfo(ADD_SERIALNUMS, set);
            this.getModel().setValue("serialnumber", (Object)maxserialnumber);
        }
    }

    private Long getOrgId() {
        String orgIdStr = this.getPageCache().get(ORG_ID);
        Long orgId = "root".equals(orgIdStr) ? null : ObjectConverterFactory.getLong((Object)orgIdStr);
        return orgId;
    }

    private void saveOrg(Long pkid) {
        String orgCache = this.getPageCache().get(ORG_CACHE);
        List orgList = (List)SerializationUtils.deSerializeFromBase64((String)orgCache);
        MappingValueDaoImpl dao = new MappingValueDaoImpl();
        dao.saveValMapOrg(orgList, pkid, "fah_evt_dispatch_scheme");
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        if (ENTRYENTITY.equals(e.getEntryProp().getName())) {
            int index = e.getRowDataEntities()[0].getRowIndex();
            this.setCellStyle(this.getView(), index, (String)this.getModel().getValue("check", index));
            TreeView treev = (TreeView)this.getControl("treeviewap");
            if (treev.getTreeState().getFocusNodeId() != null && !"root".equals(treev.getTreeState().getFocusNodeId())) {
                this.getModel().setValue("eorg", (Object)treev.getTreeState().getFocusNodeId(), index);
            } else {
                this.getModel().setValue("eorg", this.getModel().getValue("org"), index);
            }
            this.getModel().setValue("effectdate", (Object)DateValueUtils.getFirstDate(), index);
            this.getModel().setValue("expiredate", (Object)DateValueUtils.getLastDate(), index);
        }
    }

    protected void setCellStyle(IFormView view, int rownum, String status) {
        EntryGrid grid = (EntryGrid)view.getControl(ENTRYENTITY);
        CellStyle item = new CellStyle();
        item.setFieldKey("check");
        item.setRow(rownum);
        item.setForeColor("A".equals(status) ? "red" : "green");
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        cellStyles.add(item);
        grid.setCellStyle(cellStyles);
    }

    private void setFieldStyle(String newValue) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("fc", "0".equals(newValue) ? "green" : "red");
        this.getView().updateControlMetadata("checkstatus", fieldMap);
    }

    private void updateTempData(Long orgId, String zone, boolean clearCache) {
        if (orgId == null || zone == null) {
            return;
        }
        DispatchZoneInfo zoneInfo = EventDispatchSchemeUtils.findZoneInfoByZone((String)zone, (DispatchZoneFieldSettingInfo)this.getFieldSettingInfo());
        if (zoneInfo == null) {
            return;
        }
        List fieldInfos = zoneInfo.getFieldSettings();
        Set<Integer> addSet = this.getChangedSerialNumSet(ADD_SERIALNUMS);
        Set<Integer> editSet = this.getChangedSerialNumSet(EDIT_SERIALNUMS);
        HashMap tempData = new HashMap();
        LinkedList<EventDispatchRuleData> addData = new LinkedList<EventDispatchRuleData>();
        LinkedList<EventDispatchRuleData> editData = new LinkedList<EventDispatchRuleData>();
        LinkedList<EventDispatchRuleData> deleteData = new LinkedList<EventDispatchRuleData>();
        SequenceReader sReader = new SequenceReader(new DBRoute("ai"));
        Long[] id = (Long[])sReader.getSequences((Object[])new Long[addSet.size()], "fah_evt_disp_rule", addSet.size());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        int index = 0;
        for (DynamicObject obj : entryEntity) {
            Integer serialnumber = obj.getInt("serialnumber");
            if (!addSet.contains(serialnumber) && !editSet.contains(serialnumber)) continue;
            EventDispatchRuleData data = new EventDispatchRuleData();
            if (fieldInfos != null) {
                ArrayList<Object> input = new ArrayList<Object>(fieldInfos.size());
                for (DispatchFieldInfo fieldInfo : fieldInfos) {
                    input.add(obj.get(DYN_FIELD_PREFIX + fieldInfo.getDbfield()));
                }
                data.setInParamKey(input);
            }
            data.setDispatchId(this.getPKId());
            data.setSerialNumber(serialnumber.intValue());
            data.setOrgId(orgId);
            data.setValueZone(zone);
            data.setEffectDate(obj.getDate("effectdate"));
            Date expiredate = obj.getDate("expiredate");
            if (expiredate != null) {
                data.setExpireDate(DateValueUtils.appendTime((Date)expiredate, (boolean)true));
            }
            data.setDispGrp(Long.valueOf(obj.getLong("event_scheme_id")));
            data.setBatchId(this.getBatchId());
            data.setEnable(obj.getBoolean("enable_en") ? "1" : "0");
            data.setNeedGenEvt(obj.getBoolean("need_gen_evt") ? "1" : "0");
            data.setStatus("A");
            if (addSet.contains(serialnumber)) {
                data.setId(id[index]);
                ++index;
                data.setChangeType(DataChangeTypeEnum.ADD.getCode());
                addData.add(data);
                continue;
            }
            data.setId(ObjectConverterFactory.getLong((Object)obj.getString("entry_pk")));
            data.setChangeType(DataChangeTypeEnum.UPDATE.getCode());
            editData.add(data);
        }
        String deleteCache = this.getPageCache().get(DELETE_SERIALNUMS);
        if (StringUtils.isNotEmpty((String)deleteCache)) {
            Map deleteMap = (Map)SerializationUtils.deSerializeFromBase64((String)deleteCache);
            for (Map.Entry entry : deleteMap.entrySet()) {
                if (entry.getValue() == null || (Long)entry.getValue() == 0L) continue;
                EventDispatchRuleData data = new EventDispatchRuleData();
                data.setId((Long)entry.getValue());
                data.setInParamKey(new LinkedList());
                data.setDispatchId(this.getPKId());
                data.setSerialNumber(((Integer)entry.getKey()).intValue());
                data.setOrgId(orgId);
                data.setValueZone(zone);
                data.setBatchId(this.getBatchId());
                data.setEnable("0");
                data.setNeedGenEvt("0");
                data.setStatus("A");
                data.setChangeType(DataChangeTypeEnum.DELETE.getCode());
                data.setDispGrp(Long.valueOf(0L));
                deleteData.add(data);
            }
        }
        if (!addData.isEmpty()) {
            tempData.put(DataChangeTypeEnum.ADD, addData);
        }
        if (!editData.isEmpty()) {
            tempData.put(DataChangeTypeEnum.UPDATE, editData);
        }
        if (!deleteData.isEmpty()) {
            tempData.put(DataChangeTypeEnum.DELETE, deleteData);
        }
        if (!tempData.isEmpty()) {
            FahDispatchRuleDaoImpl.insertTempData((List)fieldInfos, tempData);
        }
        if (clearCache) {
            this.clearChangedSetCache();
        }
    }

    private void clearChangedSetCache() {
        this.getPageCache().remove(ADD_SERIALNUMS);
        this.getPageCache().remove(EDIT_SERIALNUMS);
        this.getPageCache().remove(DELETE_SERIALNUMS);
    }

    private String getBatchId() {
        String pageId = this.getPageCache().get(UNIQUE_PAGE_ID);
        if (StringUtils.isEmpty((String)pageId)) {
            String uuid = UUID.randomUUID().toString().replaceAll("-", "");
            pageId = uuid.substring(0, 15);
            this.getPageCache().put(UNIQUE_PAGE_ID, pageId);
        }
        return pageId;
    }

    private Set<Integer> getChangedSerialNumSet(String pageCacheId) {
        String str = this.getPageCache().get(pageCacheId);
        if (StringUtils.isEmpty((String)str)) {
            return new HashSet<Integer>(1);
        }
        return (Set)SerializationUtils.deSerializeFromBase64((String)str);
    }

    private boolean checkDuplicate(boolean isInit) {
        this.getPageCache().remove(DUP_CHECK_RESULT);
        DuplicateDispatchChecker checker = new DuplicateDispatchChecker();
        Map checkResultMap = checker.checkDuplicate(this.getPKId());
        if (isInit) {
            if (!checkResultMap.isEmpty()) {
                this.getPageCache().put(DUP_CHECK_RESULT, SerializationUtils.serializeToBase64((Object)checkResultMap));
                this.showDuplicateMessage(ObjectConverterFactory.getString((Object)this.getModel().getValue("org_id")), (String)this.getModel().getValue("zone"));
            } else {
                SplitContainer splitContainer = (SplitContainer)this.getControl("splitcontainerap");
                splitContainer.setCollapse("splitpanelap1", true);
            }
            return !checkResultMap.isEmpty();
        }
        if (checkResultMap.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabap"});
            FahDispatchRuleDaoImpl.updateEntryCheckStatus((Long)this.getPKId(), (String)"C", null, null, null);
            FahDispatchRuleDaoImpl.updateCheckStatus((Long)this.getPKId(), (String)"0");
            this.getModel().setValue("checkstatus", (Object)"0");
            return false;
        }
        FahDispatchRuleDaoImpl.updateCheckStatus((Long)this.getPKId(), (String)"1");
        this.getModel().setValue("checkstatus", (Object)"1");
        this.getPageCache().put(DUP_CHECK_RESULT, SerializationUtils.serializeToBase64((Object)checkResultMap));
        Set orgSet = PermUtils.getAllPermOrgs((IDataModel)this.getModel(), (String)this.getPageCache().get(ORG_CACHE), (boolean)true, (String)"fah_evt_dispatch_scheme", (Long)this.getPKId());
        if (!orgSet.isEmpty()) {
            FahDispatchRuleDaoImpl.updateEntryCheckStatus((Long)this.getPKId(), (String)"C", (Set)orgSet, null, null);
            Map nameNumberMap = new MappingValueDaoImpl().queryOrgNameNumberMap(orgSet);
            Map valueZoneInfoMap = EventDispatchSchemeUtils.getValueZoneInfoMap((String)this.getSourceBillNo());
            StringBuilder errorMsg = new StringBuilder();
            for (Map.Entry entry : checkResultMap.entrySet()) {
                String[] split = ((String)entry.getKey()).split("\\$");
                Long orgId = ObjectConverterFactory.getLong((Object)split[0]);
                String valueZone = split[1];
                PairTuple orgNumberName = (PairTuple)nameNumberMap.get(orgId);
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s(%2$s)\uff0c\u53d6\u503c\u533a\u57df\uff1a%3$s(%4$s)", (String)"FahEventDispatchSchemePlugin_14", (String)"fi-ai-formplugin", (Object[])new Object[0]), orgNumberName.getValue(), orgNumberName.getKey(), valueZoneInfoMap.get(valueZone), valueZone)).append("\r\n");
                HashSet serialNumbers = new HashSet(16);
                ((List)entry.getValue()).stream().forEach(o -> serialNumbers.addAll(o));
                HashSet<Long> orgs = new HashSet<Long>(1);
                orgs.add(orgId);
                FahDispatchRuleDaoImpl.updateEntryCheckStatus((Long)this.getPKId(), (String)"A", orgs, (String)valueZone, serialNumbers);
            }
            if (!isInit) {
                String errorMsgResult = String.format(ResManager.loadKDString((String)"\u7ef4\u62a4\u7684\u6620\u5c04\u53d6\u503c\u4e2d\u5b58\u5728\u91cd\u590d\u9879\u3002\u5b58\u5728\u91cd\u590d\u9879\u7684\u7ec4\u7ec7\u53ca\u53d6\u503c\u533a\u57df\u6709\uff1a%1$s%2$s\u3002", (String)"FahEventDispatchSchemePlugin_13", (String)"fi-ai-formplugin", (Object[])new Object[0]), "\r\n", errorMsg);
                this.getView().showMessage(errorMsgResult);
            }
        }
        return true;
    }

    private void showDuplicateMessage(String orgIdStr, String zone) {
        String key;
        this.getModel().deleteEntryData("dupentry");
        SplitContainer splitContainer = (SplitContainer)this.getControl("splitcontainerap");
        if ("root".equals(orgIdStr)) {
            splitContainer.setCollapse("splitpanelap1", true);
            return;
        }
        String cache = this.getPageCache().get(DUP_CHECK_RESULT);
        if (StringUtils.isEmpty((String)cache)) {
            splitContainer.setCollapse("splitpanelap1", true);
            return;
        }
        Map checkResultMap = (Map)SerializationUtils.deSerializeFromBase64((String)cache);
        List serialNumsList = (List)checkResultMap.get(key = orgIdStr + "$" + zone);
        if (serialNumsList == null || serialNumsList.isEmpty()) {
            splitContainer.setCollapse("splitpanelap1", true);
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"tabap"});
        splitContainer.setCollapse("splitpanelap1", false);
        this.getModel().batchCreateNewEntryRow("dupentry", serialNumsList.size());
        int index = 0;
        for (Set serialNumbers : serialNumsList) {
            if (serialNumbers.isEmpty()) continue;
            StringBuilder sb = new StringBuilder();
            for (Integer integer : serialNumbers) {
                sb.append(integer).append(',');
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.lastIndexOf(","));
            }
            this.getModel().setValue("serialnums", (Object)sb.toString(), index);
            ++index;
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        Long orgId = this.getOrgId();
        if (orgId == null) {
            return;
        }
        String zone = (String)this.getModel().getValue("zone");
        EntryGrid source = (EntryGrid)evt.getSource();
        if (source.getKey().equals("dupentry")) {
            int row = evt.getRow();
            this.updateTempData(orgId, zone, true);
            if (row == -1) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"btn_addrow"});
                this.buildEntryEntity(orgId, zone, null);
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_addrow"});
                String s = (String)this.getModel().getValue("serialnums");
                String[] serialNums = s.split(",");
                HashSet<Integer> serialNumSet = new HashSet<Integer>(serialNums.length);
                Arrays.stream(serialNums).forEach(o -> serialNumSet.add(ObjectConverterFactory.getInteger((Object)o)));
                this.buildEntryEntity(orgId, zone, serialNumSet);
            }
        }
    }
}

