/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.ai.enums.CheckBoxEnum;
import kd.fi.ai.enums.PermissonType;
import kd.fi.ai.util.BuildTree;
import kd.fi.ai.util.ContextUtil;
import kd.fi.v2.fah.constant.FormBuilderConstant;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.dao.config.event.FahDispatchRuleDaoImpl;
import kd.fi.v2.fah.dao.event.FahRegBillDao;
import kd.fi.v2.fah.util.EventDispatchSchemeUtils;
import kd.fi.v2.fah.util.PermUtils;
import kd.fi.v2.fah.utils.LicenseUtil;
import kd.fi.v2.fah.utils.OperationLogUtils;
import kd.fi.v2.fah.utils.StringUtils;

public class FahEventDispatchSchemeTreeList
extends AbstractTreeListPlugin
implements BeforeFilterF7SelectListener {
    private static final String algoKey = "kd.fi.v2.fah.formplugin.eventcenter.FahEventDispatchSchemeTreeList";
    private static final String KEY_BILLLISTAP = "billlistap";
    private TreeView treev;
    private String BILL_ROOT_ID = "1";
    private static final String KEY_BILLNO = "number";

    public void initialize() {
        TreeView fieldTree;
        super.initialize();
        this.treev = fieldTree = (TreeView)this.getView().getControl("treeview");
        this.deprecatedStandardTips();
        this.setCommonFilter();
    }

    private void deprecatedStandardTips() {
        String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
        String s = SerializationUtils.toJsonString(Collections.singletonList(new TreeNode()));
        this.getPageCache().put(matchNodesCacheKey, s);
        this.getPageCache().remove(oldSearchTextCacheKey);
    }

    private void setCommonFilter() {
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.addFilterContainerInitListener(event -> this.filterContainerInit(event));
        filterContainer.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    private void filterContainerInit(FilterContainerInitEvent event) {
        List commonFilterColumns = event.getCommonFilterColumns();
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            if (!commonFilterColumn.getFieldName().startsWith("group")) continue;
            ((CommonFilterColumn)commonFilterColumn).setComboItems(this.getSourceBillComboList());
            break;
        }
    }

    private List<ComboItem> getSourceBillComboList() {
        DynamicObject[] objects;
        LinkedList<ComboItem> result = new LinkedList<ComboItem>();
        QFilter modeltypeQfilter = new QFilter("modeltype", "=", (Object)"BillFormModel");
        QFilter voucherQfilter = new QFilter("voucher", "=", (Object)CheckBoxEnum.TRUE.getValue());
        QFilter appFilter = new QFilter("bizappid.deploystatus", "=", (Object)"2");
        for (DynamicObject dyn : objects = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"id,name", (QFilter[])new QFilter[]{voucherQfilter, modeltypeQfilter, appFilter}, (String)KEY_BILLNO)) {
            ComboItem item = new ComboItem(new LocaleString(dyn.getString("name")), dyn.getString("id"));
            result.add(item);
        }
        return result;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        HashMap<String, String> errorMap = new HashMap<String, String>();
        switch (evt.getItemKey()) {
            case "tbldisable": {
                if (!PermUtils.hasPermission((String)PermissonType.DISABLE.getPermId(), (String)"fah_evt_dispatch_scheme")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u7981\u7528\u6743\u9650\u3002", (String)"FahEventGenRuleList_16", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                List ids = this.getSelectedRowPKs().stream().map(o -> o.getPrimaryKeyValue()).collect(Collectors.toList());
                if (ids.size() == 0) {
                    return;
                }
                List pKs = FahDispatchRuleDaoImpl.getUpdateablePKs(ids, (String)"1");
                ids.removeAll(pKs);
                if (!pKs.isEmpty()) {
                    FahDispatchRuleDaoImpl.switchEnable((List)pKs, (String)"0");
                }
                if (!ids.isEmpty()) {
                    List numbers = FahDispatchRuleDaoImpl.getModelNumberById(ids);
                    for (String number : numbers) {
                        errorMap.put(number, ResManager.loadKDString((String)"\u5df2\u7981\u7528\u7684\u89c4\u5219\u4e0d\u80fd\u518d\u6b21\u7981\u7528\u3002", (String)"FahEventGenRuleList_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    }
                }
                OperationLogUtils.addLog((String)"fah_evt_dispatch_scheme", (String)ResManager.loadKDString((String)"\u7981\u7528", (String)"FahEventRulePlugin_20", (String)"fi-ai-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801%s\u7981\u7528\u6210\u529f\u3002", (String)"FahEventRulePlugin_18", (String)"fi-ai-formplugin", (Object[])new Object[0]), EventDispatchSchemeUtils.getNumberStrByPk((List)pKs)));
                this.showErrorMessage(pKs.size(), errorMap, ResManager.loadKDString((String)"\u7981\u7528", (String)"FahEventGenRuleList_4", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                this.refreshList(this.getSelectedBillNo());
                break;
            }
            case "tblenable": {
                if (!PermUtils.hasPermission((String)PermissonType.ENABLE.getPermId(), (String)"fah_evt_dispatch_scheme")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u542f\u7528\u6743\u9650\u3002", (String)"FahEventGenRuleList_17", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                List ids = this.getSelectedRowPKs().stream().map(o -> o.getPrimaryKeyValue()).collect(Collectors.toList());
                if (ids.size() == 0) {
                    return;
                }
                List pKs = FahDispatchRuleDaoImpl.getUpdateablePKs(ids, (String)"0");
                ids.removeAll(pKs);
                if (!pKs.isEmpty()) {
                    FahDispatchRuleDaoImpl.switchEnable((List)pKs, (String)"1");
                }
                if (!ids.isEmpty()) {
                    List numbers = FahDispatchRuleDaoImpl.getModelNumberById(ids);
                    for (String number : numbers) {
                        errorMap.put(number, ResManager.loadKDString((String)"\u5df2\u542f\u7528\u7684\u89c4\u5219\u4e0d\u80fd\u518d\u6b21\u542f\u7528\u3002", (String)"FahEventGenRuleList_5", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    }
                }
                OperationLogUtils.addLog((String)"fah_evt_dispatch_scheme", (String)ResManager.loadKDString((String)"\u542f\u7528", (String)"FahEventRulePlugin_21", (String)"fi-ai-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801%s\u542f\u7528\u6210\u529f\u3002", (String)"FahEventRulePlugin_19", (String)"fi-ai-formplugin", (Object[])new Object[0]), EventDispatchSchemeUtils.getNumberStrByPk((List)pKs)));
                this.showErrorMessage(pKs.size(), errorMap, ResManager.loadKDString((String)"\u542f\u7528", (String)"FahEventGenRuleList_6", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                this.refreshList(this.getSelectedBillNo());
                break;
            }
            case "tblrefresh": {
                this.refreshList(this.getSelectedBillNo());
            }
        }
    }

    private void refreshList(String billNo) {
        TreeNode root = this.getRootNode();
        TreeNode treeNode = root.getTreeNode(billNo);
        this.treev.treeNodeClick(treeNode.getParentid(), treeNode.getId());
    }

    private ListSelectedRowCollection getSelectedRowPKs() {
        BillList billList = (BillList)this.getView().getControl(KEY_BILLLISTAP);
        return billList.getSelectedRows();
    }

    private void showErrorMessage(int successSize, Map<String, String> errorMap, String opName) {
        if (errorMap.isEmpty()) {
            String successMsg = String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"FahEventGenRuleList_7", (String)"fi-ai-formplugin", (Object[])new Object[0]), opName);
            this.getView().showSuccessNotification(successMsg);
            return;
        }
        if (successSize == 0 && errorMap.size() == 1) {
            for (String value : errorMap.values()) {
                this.getView().showErrorNotification(value);
            }
            return;
        }
        String titleMsg = ResManager.loadKDString((String)"\u5171\u201c%1$s\u201d\u6761\u6570\u636e\uff0c\u201c%2$s\u201d\u6210\u529f\u201c%3$s\u201d\u6761\uff0c\u5931\u8d25\u201c%4$s\u201d\u6761\u3002", (String)"FahEventGenRuleList_8", (String)"fi-ai-formplugin", (Object[])new Object[0]);
        String title = String.format(titleMsg, successSize + errorMap.size(), opName, successSize, errorMap.size());
        LinkedList<String> list = new LinkedList<String>();
        for (Map.Entry<String, String> entry : errorMap.entrySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append(entry.getKey()).append("\uff1a").append(entry.getValue());
            list.add(sb.toString());
        }
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("title", (Object)title);
        parameters.setCustomParam("errorMsg", list);
        parameters.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showErrorMsg"));
        this.getView().showForm(parameters);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initTree();
        this.getView().setEnable(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
        LicenseUtil.checkFahLicenseWithTips((IFormView)this.getView());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillList billList = (BillList)this.getControl(KEY_BILLLISTAP);
        Set pks = billList.getCurrentListAllRowCollection().stream().map(o -> o.getPrimaryKeyValue()).collect(Collectors.toSet());
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"fah_evt_dispatch_scheme", (String)"id,group.number", (QFilter[])new QFilter[]{new QFilter("id", "in", pks)});
        HashMap<Long, String> sourcemap = new HashMap<Long, String>(collection.size());
        for (DynamicObject obj : collection) {
            sourcemap.put(obj.getLong("id"), obj.getString("group.number"));
        }
        Map map = FahRegBillDao.batchQuerySrcOrg(sourcemap.values());
        int index = 0;
        for (ListSelectedRow row : billList.getCurrentListAllRowCollection()) {
            String sourceBill = (String)sourcemap.get((Long)row.getPrimaryKeyValue());
            billList.setCellFieldValue("orgsrcfield", index, (Object)EventDispatchSchemeUtils.getSourceBillEntryName((String)sourceBill, (String)((String)map.get(sourceBill))));
            ++index;
        }
    }

    private void initTree() {
        this.treev.deleteAllNodes();
        HashMap<String, List<String>> basedataInfo = new HashMap<String, List<String>>();
        TreeNode root = this.initBillTree(basedataInfo);
        this.treev.addNode(root);
        List children = root.getChildren();
        TreeNode focusNode = null != children && !children.isEmpty() ? (TreeNode)children.get(0) : root;
        this.treev.focusNode(focusNode);
        this.getPageCache().put("baseInfo", SerializationUtils.toJsonString(basedataInfo));
        this.treev.treeNodeClick(focusNode.getParentid(), focusNode.getId());
        this.getView().updateView(KEY_BILLLISTAP);
        this.getPageCache().put("Root", SerializationUtils.toJsonString((Object)root));
    }

    private TreeNode initBillTree(Map<String, List<String>> basedataInfo) {
        TreeNode root = FahEventDispatchSchemeTreeList.createTreeNode("", this.BILL_ROOT_ID, ResManager.loadKDString((String)"\u5df2\u6ce8\u518c\u63a5\u5165\u7684\u5355\u636e\u5217\u8868", (String)"FahEventDispatchSchemeTreeList_5", (String)"fi-ai-formplugin", (Object[])new Object[0]), true);
        this.createBillNodes(basedataInfo, root);
        this.createEventNodes(basedataInfo, root);
        return root;
    }

    private static TreeNode createTreeNode(String parentId, String id, String name, boolean isOpened) {
        TreeNode node = new TreeNode();
        node.setParentid(parentId);
        node.setId(id);
        node.setText(name);
        node.setIsOpened(isOpened);
        return node;
    }

    private void createBillNodes(Map<String, List<String>> baseDataInfo, TreeNode root) {
        HashMap cloudAndAppMap = new HashMap();
        HashMap bizAppAndEntityMap = new HashMap();
        FahRegBillDao.getNormalBillTreeNode(cloudAndAppMap, bizAppAndEntityMap, baseDataInfo);
        if (cloudAndAppMap.isEmpty()) {
            return;
        }
        DynamicObjectCollection clouds = BizCloudServiceHelp.getAllBizClouds();
        for (DynamicObject cloud : clouds) {
            String cloudId = cloud.getString("id");
            Map appMap = (Map)cloudAndAppMap.get(cloudId);
            if (null == appMap) continue;
            String cloudName = cloud.getString("name");
            TreeNode cloudNode = FahEventDispatchSchemeTreeList.createTreeNode(this.BILL_ROOT_ID, cloudId, cloudName, false);
            root.addChild(cloudNode);
            for (Map.Entry appEntry : appMap.entrySet()) {
                String appId = (String)appEntry.getKey();
                String appName = (String)appEntry.getValue();
                TreeNode appNode = FahEventDispatchSchemeTreeList.createTreeNode(cloudId, appId, appName, false);
                Map entityMap = (Map)bizAppAndEntityMap.get(appId);
                if (null == entityMap) continue;
                cloudNode.addChild(appNode);
                for (Map.Entry entry : entityMap.entrySet()) {
                    TreeNode childNode = FahEventDispatchSchemeTreeList.createTreeNode(appId, (String)entry.getKey(), (String)entry.getValue(), false);
                    childNode.setLeaf(true);
                    appNode.addChild(childNode);
                }
            }
        }
    }

    private void createEventNodes(Map<String, List<String>> baseDataInfo, TreeNode firstRoot) {
        LinkedHashMap eventGroupMap = new LinkedHashMap();
        FahRegBillDao.getEvtBillTreeNode(eventGroupMap, baseDataInfo);
        if (!eventGroupMap.isEmpty()) {
            TreeNode eventAppNode = FahEventDispatchSchemeTreeList.createTreeNode(FormBuilderConstant.CLOUD_FI_ID, FormBuilderConstant.BIZ_APP_ID, ResManager.loadKDString((String)"\u4f1a\u8ba1\u4e8b\u4ef6\u5e93", (String)"FahEventDispatchSchemeTreeList_3", (String)"fi-ai-formplugin", (Object[])new Object[0]), false);
            eventAppNode.addChildren(new ArrayList(eventGroupMap.values()));
            TreeNode fiNode = firstRoot.getTreeNode(FormBuilderConstant.CLOUD_FI_ID);
            if (null != fiNode) {
                fiNode.addChild(0, eventAppNode);
            } else {
                TreeNode cloudNode = FahEventDispatchSchemeTreeList.createTreeNode(this.BILL_ROOT_ID, FormBuilderConstant.CLOUD_FI_ID, ResManager.loadKDString((String)"\u8d22\u52a1\u4e91", (String)"FahEventDispatchSchemeTreeList_4", (String)"fi-ai-formplugin", (Object[])new Object[0]), false);
                firstRoot.addChild(cloudNode);
                cloudNode.addChild(0, eventAppNode);
            }
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent event) {
        String field = event.getFieldName();
        if (field.startsWith("group")) {
            QFilter modeltypeQfilter = new QFilter("modeltype", "=", (Object)"BillFormModel");
            QFilter voucherQfilter = new QFilter("voucher", "=", (Object)CheckBoxEnum.TRUE.getValue());
            QFilter appFilter = new QFilter("bizappid.deploystatus", "=", (Object)"2");
            event.getQfilters().add(modeltypeQfilter);
            event.getQfilters().add(voucherQfilter);
            event.getQfilters().add(appFilter);
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
        String nodeId = (String)e.getNodeId();
        this.getPageCache().put(KEY_BILLNO, nodeId);
    }

    public void setFilter(SetFilterEvent e) {
        QFilter qFilter;
        HasPermOrgResult permOrgRs;
        super.setFilter(e);
        Iterator iterator = e.getQFilters().iterator();
        Set pks = null;
        int hasChosenCreateOrg = 0;
        while (iterator.hasNext()) {
            QFilter qFilter2 = (QFilter)iterator.next();
            String property = qFilter2.getProperty();
            if ("org.id".equals(property)) {
                this.getPageCache().put("createOrg", ObjectConverterFactory.getString((Object)qFilter2.getValue()));
                ++hasChosenCreateOrg;
                continue;
            }
            if (property.startsWith("group")) {
                iterator.remove();
                continue;
            }
            if (!property.startsWith("usableorg")) continue;
            iterator.remove();
            Object value = qFilter2.getValue();
            LinkedList<Object> ids = new LinkedList<Object>();
            if (value instanceof Long || value instanceof Integer) {
                ids.add(value);
            } else if (value instanceof List) {
                ids.addAll((List)value);
            }
            pks = FahDispatchRuleDaoImpl.querySchemeByUseableOrg(ids);
        }
        if (hasChosenCreateOrg == 0) {
            this.getPageCache().remove("createOrg");
        }
        if (pks != null) {
            e.getQFilters().add(new QFilter("id", "in", pks));
        }
        if (!(permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)"2FMS=8GUFGGN", (String)"fah_evt_dispatch_scheme", (String)PermissonType.VIEW.getPermId())).hasAllOrgPerm()) {
            List idList = permOrgRs.getHasPermOrgs();
            e.getQFilters().add(new QFilter("org.id", "in", (Object)idList));
        }
        Map<String, List<String>> basedataInfo = this.getLeftTreeBaseDataInfo();
        String nodeId = this.getSelectedBillNo();
        if (this.BILL_ROOT_ID.equals(nodeId)) {
            List billNumList = basedataInfo.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            if (!billNumList.isEmpty()) {
                qFilter = new QFilter("group", "in", billNumList);
                e.getQFilters().add(qFilter);
            }
        } else {
            List<String> billNumList = basedataInfo.get(nodeId);
            qFilter = billNumList == null || billNumList.isEmpty() ? new QFilter("group", "=", (Object)nodeId) : new QFilter("group", "in", billNumList);
            e.getQFilters().add(qFilter);
        }
    }

    private String getSelectedBillNo() {
        return this.getPageCache().get(KEY_BILLNO);
    }

    private TreeNode getRootNode() {
        return (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("Root"), TreeNode.class);
    }

    private Map<String, List<String>> getLeftTreeBaseDataInfo() {
        return (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("baseInfo"), Map.class);
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        HasPermOrgResult permOrgRs;
        super.filterColumnSetFilter(args);
        if (null != args.getFieldName() && (args.getFieldName().startsWith("org") || args.getFieldName().startsWith("usableorg")) && !(permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)"2FMS=8GUFGGN", (String)"fah_evt_dispatch_scheme", (String)PermissonType.VIEW.getPermId())).hasAllOrgPerm()) {
            List idList = permOrgRs.getHasPermOrgs();
            QFilter orgFilter = new QFilter("id", "in", (Object)idList);
            args.addCustomQFilter(orgFilter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn orgCol : filterColumnList) {
            if (!orgCol.getFieldName().startsWith("org")) continue;
            CommonFilterColumn orgColumn = (CommonFilterColumn)orgCol;
            if (!StringUtils.isEmpty((String)this.getPageCache().get("createOrg"))) break;
            String defaultOrgId = this.getDefaultOrgId();
            orgColumn.setDefaultValue(defaultOrgId);
            this.getPageCache().put("createOrg", defaultOrgId);
            break;
        }
    }

    private String getDefaultOrgId() {
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)"2FMS=8GUFGGN", (String)"fah_evt_dispatch_scheme", (String)PermissonType.VIEW.getPermId());
        if (!permOrgRs.hasAllOrgPerm()) {
            List idList = permOrgRs.getHasPermOrgs();
            if (!idList.isEmpty()) {
                return ObjectConverterFactory.getString(idList.get(0));
            }
            return "";
        }
        return ObjectConverterFactory.getString((Object)RequestContext.get().getOrgId());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String keyName = ((FormOperate)args.getSource()).getOperateKey();
        if ("new".equals(keyName)) {
            HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)"2FMS=8GUFGGN", (String)"fah_evt_dispatch_scheme", (String)PermissonType.NEW.getPermId());
            if (StringUtils.isEmpty((String)this.getPageCache().get("createOrg"))) {
                if (!permOrgRs.hasAllOrgPerm()) {
                    if (permOrgRs.getHasPermOrgs().isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"FahEventDispatchSchemeTreeList_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    this.getPageCache().put("createOrg", ObjectConverterFactory.getString(permOrgRs.getHasPermOrgs().get(0)));
                } else {
                    this.getPageCache().put("createOrg", ObjectConverterFactory.getString((Object)UserServiceHelper.getUserMainOrgId((long)UserServiceHelper.getCurrentUserId())));
                }
            } else {
                if (this.getPageCache().get("createOrg").contains(",")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u589e\u65f6\u5728\u5e38\u7528\u6761\u4ef6\u4e2d\u4ec5\u652f\u6301\u9009\u62e9\u4e00\u4e2a\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"FahDataValMapList_13", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (!permOrgRs.hasAllOrgPerm() && !permOrgRs.getHasPermOrgs().contains(ObjectConverterFactory.getLong((Object)this.getPageCache().get("createOrg")))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u6ca1\u6709\u65b0\u5efa\u6743\u9650\u3002", (String)"FahDataValMapList_16", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            String selectedBillNo = this.getSelectedBillNo();
            TreeNode rootNode = this.getRootNode();
            if (!rootNode.getTreeNode(selectedBillNo).isLeaf()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u660e\u7ec6\u8282\u70b9\u7684\u5355\u636e\u7c7b\u578b\u65b0\u589e\u4e8b\u4ef6\u5206\u6d41\u89c4\u5219\u3002", (String)"FahEventDispatchSchemeTreeList_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("delete".equals(keyName)) {
            HashMap<String, String> errorMap = new HashMap<String, String>();
            List ids = this.getSelectedRowPKs().stream().map(o -> o.getPrimaryKeyValue()).collect(Collectors.toList());
            List pKs = FahDispatchRuleDaoImpl.getUpdateablePKs(ids, (String)"1");
            if (!pKs.isEmpty()) {
                List numbers = FahDispatchRuleDaoImpl.getModelNumberById((List)pKs);
                for (String number : numbers) {
                    errorMap.put(number, ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u542f\u7528\u72b6\u6001\u4e8b\u4ef6\u5206\u6d41\u89c4\u5219\u3002", (String)"FahEventDispatchSchemeTreeList_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                }
                ids.removeAll(pKs);
                FahDispatchRuleDaoImpl.deleteRuleByIds(ids);
                this.showErrorMessage(ids.size(), errorMap, ResManager.loadKDString((String)"\u5220\u9664", (String)"FahEventGenRuleList_11", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if ("showErrorMsg".equals(evt.getActionId())) {
            this.refreshList(this.getSelectedBillNo());
        }
    }

    public void search(SearchEnterEvent arg) {
        Search search = (Search)arg.getSource();
        String firstRootStr = this.getPageCache().get("Root");
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"searchap", (CharSequence)search.getKey())) {
            TreeView tree = (TreeView)this.getView().getControl("treeview");
            String searchText = arg.getText();
            String pageCahe = this.getPageCache().get("FahEventDispatchSchemeTreeList" + searchText);
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)pageCahe)) {
                List list = SerializationUtils.fromJsonStringToList((String)pageCahe, TreeNode.class);
                if (!list.isEmpty()) {
                    tree.focusNode((TreeNode)list.get(0));
                    this.refreshList(((TreeNode)list.get(0)).getId());
                    list.remove(0);
                    this.getPageCache().put("FahEventDispatchSchemeTreeList" + searchText, SerializationUtils.toJsonString((Object)list));
                } else {
                    this.getList(firstRootStr, searchText, tree);
                }
            } else {
                this.getList(firstRootStr, searchText, tree);
            }
        }
    }

    private void getList(String RootStr, String searchText, TreeView tree) {
        TreeNode firstRoot = (TreeNode)SerializationUtils.fromJsonString((String)RootStr, TreeNode.class);
        TreeNode searchTreefirstRoot = BuildTree.searchTree((String)searchText, (TreeNode)firstRoot);
        List<TreeNode> list = this.getTreeNodes(searchTreefirstRoot, new ArrayList<TreeNode>());
        if (!list.isEmpty()) {
            tree.focusNode(list.get(0));
            this.refreshList(list.get(0).getId());
            list.remove(0);
        }
        if (!list.isEmpty()) {
            this.getPageCache().put("FahEventDispatchSchemeTreeList" + searchText, SerializationUtils.toJsonString(list));
        }
    }

    private List<TreeNode> getTreeNodes(TreeNode searchTreeRoot, List<TreeNode> list) {
        if (!searchTreeRoot.getChildren().isEmpty()) {
            for (TreeNode node : searchTreeRoot.getChildren()) {
                if (node.getChildren() != null) {
                    this.getTreeNodes(node, list);
                    continue;
                }
                list.add(node);
            }
        }
        return list;
    }
}

