/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.v2.fah.models.event.eventrule.EvtRuleRelationFieldMappingDto;
import kd.fi.v2.fah.utils.FahAcctRuleUtils;

public class FahEvtRelationFieldSetEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String Key_btnOK = "btnok";
    private static final String Key_btnCancel = "btncancel";
    private static final String SOURCE_BILL = "sourcebill";
    private static final String SOURCE_ENTRY = "sourceentry";
    private static final String SOURCE_FIELD = "sourcefield";
    private static final String SOURCE_FIELD_VAL = "sourcefieldval";
    private static final String TARGET_BILL = "targetbill";
    private static final String TARGET_ENTRY = "targetentry";
    private static final String TARGET_FIELD = "targetfield";
    private static final String TARGET_FIELD_VAL = "targetfieldval";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel, SOURCE_FIELD, TARGET_FIELD});
        BasedataEdit targetBillType = (BasedataEdit)this.getControl(TARGET_BILL);
        targetBillType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        String sourceBill = (String)this.getView().getFormShowParameter().getCustomParam(SOURCE_BILL);
        String sourceField = (String)this.getView().getFormShowParameter().getCustomParam(SOURCE_FIELD);
        if (StringUtils.isEmpty((CharSequence)sourceBill) || StringUtils.isEmpty((CharSequence)sourceField)) {
            return;
        }
        model.setValue(SOURCE_BILL, (Object)sourceBill);
        this.setSourceComboItems(sourceBill, sourceField, SOURCE_ENTRY);
        String targetBill = (String)this.getView().getFormShowParameter().getCustomParam(TARGET_BILL);
        String targetField = (String)this.getView().getFormShowParameter().getCustomParam(TARGET_FIELD);
        if (StringUtils.isEmpty((CharSequence)targetBill) || StringUtils.isEmpty((CharSequence)targetField)) {
            return;
        }
        model.setValue(TARGET_BILL, (Object)targetBill);
        this.setSourceComboItems(targetBill, targetField, TARGET_ENTRY);
        String data = (String)this.getView().getFormShowParameter().getCustomParam("data");
        if (StringUtils.isNotEmpty((CharSequence)data)) {
            try {
                this.setHistoryData(model, data);
            }
            catch (Exception ex) {
                throw new KDBizException("data echo error.");
            }
        }
    }

    private void setHistoryData(IDataModel model, String data) {
        EvtRuleRelationFieldMappingDto mappingDto = (EvtRuleRelationFieldMappingDto)JSON.parseObject((String)data, EvtRuleRelationFieldMappingDto.class);
        model.setValue(SOURCE_BILL, (Object)mappingDto.getSourceBill());
        model.setValue(SOURCE_ENTRY, (Object)mappingDto.getSourceEntry());
        model.setValue(SOURCE_FIELD, (Object)FahAcctRuleUtils.getFieldLongName((String)mappingDto.getSourceField(), (MainEntityType)EntityMetadataCache.getDataEntityType((String)mappingDto.getSourceBill())));
        model.setValue(SOURCE_FIELD_VAL, (Object)mappingDto.getSourceField());
        model.setValue(TARGET_BILL, (Object)mappingDto.getTargetBill());
        model.setValue(TARGET_ENTRY, (Object)mappingDto.getTargetEntry());
        MainEntityType targetmMainEntityType = EntityMetadataCache.getDataEntityType((String)mappingDto.getTargetBill());
        model.setValue(TARGET_FIELD, (Object)FahAcctRuleUtils.getFieldLongName((String)mappingDto.getTargetField(), (MainEntityType)targetmMainEntityType));
        model.setValue(TARGET_FIELD_VAL, (Object)mappingDto.getTargetField());
    }

    private void setSourceComboItems(String sourceBill, String sourceField, String entryNumber) {
        IDataModel model = this.getModel();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)sourceBill);
        if (null != mainEntityType && null != sourceField) {
            String entityNumber;
            String[] entrys = sourceField.split("\\.");
            IDataEntityProperty prop = mainEntityType.findProperty(entrys[0]);
            LinkedHashMap<String, LocaleString> entryMap = new LinkedHashMap<String, LocaleString>();
            entryMap.put(mainEntityType.getName(), mainEntityType.getDisplayName());
            if (null == prop || null == prop.getParent() || prop.getParent() instanceof MainEntityType) {
                entityNumber = mainEntityType.getName();
            } else {
                IDataEntityType parentProp = prop.getParent();
                IDataEntityType parent = parentProp.getParent();
                if (null != parent) {
                    entryMap.put(parent.getName(), parent.getDisplayName());
                }
                entryMap.put(parentProp.getName(), parentProp.getDisplayName());
                entityNumber = parentProp.getName();
            }
            ComboEdit comboEdit = (ComboEdit)this.getView().getControl(entryNumber);
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(entryMap.size());
            for (Map.Entry entry : entryMap.entrySet()) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(((LocaleString)entry.getValue()).getLocaleValue()));
                comboItem.setValue((String)entry.getKey());
                items.add(comboItem);
            }
            comboEdit.setComboItems(items);
            model.setValue(entryNumber, (Object)entityNumber);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        IDataModel model = this.getModel();
        Control ctlSource = (Control)evt.getSource();
        switch (ctlSource.getKey()) {
            case "sourcefield": {
                String sourceBill = (String)model.getValue("sourcebill_id");
                if (StringUtils.isEmpty((CharSequence)sourceBill)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6765\u6e90\u5355\u636e\u7c7b\u578b\u3002", (String)"FahEvtRelationFieldSetEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                String sourceEntry = (String)model.getValue(SOURCE_ENTRY);
                if (StringUtils.isEmpty((CharSequence)sourceEntry)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6765\u6e90\u5355\u636e\u4f53\u3002", (String)"FahEvtRelationFieldSetEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showBillTreeForm(sourceBill, sourceEntry, SOURCE_FIELD);
                break;
            }
            case "targetfield": {
                String targetBillType = (String)model.getValue("targetbill_id");
                if (StringUtils.isEmpty((CharSequence)targetBillType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5173\u8054\u5355\u636e\u7c7b\u578b\u3002", (String)"FahEvtRelationFieldSetEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                String targetEntry = (String)model.getValue(TARGET_ENTRY);
                if (StringUtils.isEmpty((CharSequence)targetEntry)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5173\u8054\u5355\u636e\u4f53\u3002", (String)"FahEvtRelationFieldSetEdit_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showBillTreeForm(targetBillType, targetEntry, TARGET_FIELD);
                break;
            }
        }
    }

    private void showBillTreeForm(String sourceBill, String entryNumber, String actionId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fah_billfieldtree");
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put("entityType", sourceBill);
        param.put("entryNumber", entryNumber);
        param.put("maxLevel", 0);
        showParameter.setCustomParam("param", (Object)JSON.toJSONString(param));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(showParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        switch (name = e.getProperty().getName()) {
            case "targetbill": {
                ArrayList<ComboItem> items = new ArrayList<ComboItem>();
                if (null != newValue) {
                    String entityNum = ((DynamicObject)newValue).getString("id");
                    MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
                    for (EntityType entityType : mainEntityType.getAllEntities().values()) {
                        if (entityType instanceof LinkEntryType) continue;
                        ComboItem comboItem = new ComboItem();
                        comboItem.setCaption(new LocaleString(entityType.getDisplayName().toString()));
                        comboItem.setValue(entityType.getName());
                        items.add(comboItem);
                    }
                }
                ComboEdit comboEdit = (ComboEdit)this.getView().getControl(TARGET_ENTRY);
                comboEdit.setComboItems(items);
                this.getModel().setValue(TARGET_ENTRY, null);
                break;
            }
            case "sourceentry": {
                this.getModel().setValue(SOURCE_FIELD, null);
                break;
            }
            case "targetentry": {
                this.getModel().setValue(TARGET_FIELD, null);
                break;
            }
            case "sourcefield": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                this.getModel().setValue(SOURCE_FIELD_VAL, null);
                break;
            }
            case "targetfield": {
                if (!StringUtils.isBlank((Object)newValue)) break;
                this.getModel().setValue(TARGET_FIELD_VAL, null);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Object source = evt.getSource();
        Control sourceCtl = (Control)source;
        String key = sourceCtl.getKey();
        if (TARGET_BILL.equals(key)) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParam = showParameter.getListFilterParameter();
            QFilter qFilter = new QFilter("modeltype", "=", (Object)"BillFormModel").and(new QFilter("bizappid.deploystatus", "=", (Object)"2"));
            filterParam.getQFilters().add(qFilter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (Key_btnOK.equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            EvtRuleRelationFieldMappingDto dto = new EvtRuleRelationFieldMappingDto();
            IDataModel model = this.getModel();
            dto.setSourceBill((String)model.getValue("sourcebill_id"));
            dto.setSourceEntry((String)model.getValue(SOURCE_ENTRY));
            dto.setSourceField((String)model.getValue(SOURCE_FIELD_VAL));
            dto.setTargetBill((String)model.getValue("targetbill_id"));
            dto.setTargetEntry((String)model.getValue(TARGET_ENTRY));
            dto.setTargetField((String)model.getValue(TARGET_FIELD_VAL));
            this.getView().returnDataToParent((Object)JSON.toJSONString((Object)dto));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String[] returnDataField;
        super.closedCallBack(closedCallBackEvent);
        if (null == closedCallBackEvent) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        if (SOURCE_FIELD.equals(actionId) && null != (returnDataField = (String[])closedCallBackEvent.getReturnData())) {
            this.getModel().setValue(SOURCE_FIELD_VAL, (Object)returnDataField[0]);
            this.getModel().setValue(SOURCE_FIELD, (Object)returnDataField[1]);
        }
        if (TARGET_FIELD.equals(actionId) && null != (returnDataField = (String[])closedCallBackEvent.getReturnData())) {
            this.getModel().setValue(TARGET_FIELD_VAL, (Object)returnDataField[0]);
            this.getModel().setValue(TARGET_FIELD, (Object)returnDataField[1]);
        }
    }
}

