/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.fi.v2.fah.dao.groupmerge.GroupMergeDao;
import kd.fi.v2.fah.utils.LicenseUtil;

public class FahGroupMergeRuleList
extends AbstractTreeListPlugin {
    private static final String ROOT_ID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        LicenseUtil.checkFahLicenseWithTips((IFormView)this.getView());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void initialize() {
        super.initialize();
        if (this.getTreeListView() != null && this.getTreeModel() != null && this.getTreeModel().getGroupProp() != null) {
            this.getTreeModel().getTreeFilter().clear();
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        LinkedHashSet quoteMergeRules;
        super.beforeDoOperation(args);
        FormOperate operateInfo = (FormOperate)args.getSource();
        String keyName = operateInfo.getOperateKey();
        if ("new".equals(keyName)) {
            IFormView view = this.getView();
            TreeView treeview = (TreeView)view.getControl("treeview");
            String treeNode = treeview.getTreeState().getFocusNodeId();
            if (ROOT_ID.equals(treeNode)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u5de6\u6811\u9009\u62e9\u5177\u4f53\u7684\u6838\u7b97\u76ee\u7684\u8fdb\u884c\u65b0\u589e\u3002", (String)"FahGroupMergeRuleList_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("disable".equals(keyName)) {
            Map quoteAcctRules = GroupMergeDao.getQuoteAcctRules((Object[])this.getSelectedRows().getPrimaryKeyValues());
            if (!quoteAcctRules.isEmpty()) {
                RefObject afterConfirm = new RefObject();
                if (!operateInfo.getOption().tryGetVariableValue("disableConfirm", afterConfirm)) {
                    StringBuilder message = new StringBuilder();
                    quoteAcctRules.forEach((k, v) -> message.append(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u51ed\u8bc1\u6c47\u603b\u89c4\u5219\u5df2\u88ab\u201c%2$s\u201d\u6838\u7b97\u89c4\u5219\u5173\u8054\uff0c\u786e\u8ba4\u662f\u5426\u7981\u7528\u3002", (String)"FahGroupMergeRuleList_2", (String)"fi-ai-formplugin", (Object[])new Object[0]), v, k)).append("\n"));
                    ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("disable", (IFormPlugin)this);
                    this.getView().showConfirm(message.toString(), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBack);
                    args.setCancel(true);
                }
            }
        } else if ("delete".equals(keyName) && !(quoteMergeRules = GroupMergeDao.getQuoteMergeRules((Object[])this.getSelectedRows().getPrimaryKeyValues())).isEmpty()) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u51ed\u8bc1\u6c47\u603b\u89c4\u5219\u5df2\u4f7f\u7528/\u5df2\u88ab\u5173\u8054\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"FahGroupMergeRuleList_3", (String)"fi-ai-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", quoteMergeRules)));
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        MessageBoxResult result = event.getResult();
        if ("disable".equals(event.getCallBackId()) && result == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("disableConfirm", "true");
            this.getView().invokeOperation("disable", operateOption);
        }
    }
}

