/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.ai.VchReturnData;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.cache.CacheBuildTree;
import kd.fi.ai.function.DapFunctionTypes;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.dao.event.FahEventRuleCfgDAO;
import kd.fi.v2.fah.models.event.eventrule.EvtReferenceFieldDto;

public class FahReferenceFieldEdit
extends AbstractFormPlugin {
    private static final String Key_btnOK = "btnok";
    private static final String Key_btnCancel = "btncancel";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String CUSTOM_VALUE = "customvalue";
    private static final String CUSTOM_VALUE_VAL = "customvalue_val";
    private static final String VALUE_SOURCE = "valuesource";
    private static final String VALUE_SOURCE_VAL = "valuesource_val";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel, CUSTOM_VALUE, VALUE_SOURCE});
    }

    public void afterCreateNewData(EventObject e) {
        List dataList;
        super.afterCreateNewData(e);
        String data = (String)this.getView().getFormShowParameter().getCustomParam("data");
        if (StringUtils.isNotEmpty((CharSequence)data) && !(dataList = SerializationUtils.fromJsonStringToList((String)data, EvtReferenceFieldDto.class)).isEmpty()) {
            this.getModel().deleteEntryData(ENTRY_ENTITY);
            this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, dataList.size());
            for (int i = 0; i < dataList.size(); ++i) {
                EvtReferenceFieldDto filedDto = (EvtReferenceFieldDto)dataList.get(i);
                this.getModel().setValue("entryid", (Object)filedDto.getId(), i);
                this.getModel().setValue("reffieldcfgid", (Object)filedDto.getDynExtFldValSetId(), i);
                this.getModel().setValue("name", (Object)filedDto.getFieldName(), i);
                String customValue = filedDto.getCustomValue();
                if (!StringUtils.isNotBlank((CharSequence)customValue)) continue;
                VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)customValue, VchTplExpression.class);
                this.getModel().setValue(CUSTOM_VALUE, (Object)filterObj.getExprDesc(), i);
                this.getModel().setValue(CUSTOM_VALUE_VAL, (Object)customValue, i);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Long refFieldCfgId;
        String keyName = ((FormOperate)args.getSource()).getOperateKey();
        if ("deleteentry".equals(keyName) && null != (refFieldCfgId = (Long)this.getModel().getValue("reffieldcfgid")) && 0L != refFieldCfgId) {
            HashSet<String> ids = new HashSet<String>(1);
            ids.add(String.valueOf(refFieldCfgId));
            String result = FahEventRuleCfgDAO.checkReferenceFieldIsReferenced(ids);
            if (null != result) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53c2\u8003\u5b57\u6bb5\u5df2\u88ab\u6838\u7b97\u89c4\u5219\uff1a%s \u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"FahReferenceFieldEdit_8", (String)"fi-ai-formplugin", (Object[])new Object[0]), result));
                args.setCancel(true);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        switch (ctlSource.getKey()) {
            case "btnok": {
                DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRY_ENTITY);
                if (entity.isEmpty()) {
                    this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(Collections.emptyList()));
                    this.getView().close();
                    return;
                }
                int rowIndex = 1;
                LinkedHashMap<Integer, List> error = new LinkedHashMap<Integer, List>();
                for (DynamicObject row : entity) {
                    if (StringUtils.isEmpty((CharSequence)row.getString("name"))) {
                        error.computeIfAbsent(rowIndex, t -> new ArrayList()).add(ResManager.loadKDString((String)"\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"FahReferenceFieldEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    }
                    if (StringUtils.isEmpty((CharSequence)row.getString(CUSTOM_VALUE))) {
                        error.computeIfAbsent(rowIndex, t -> new ArrayList()).add(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53d6\u503c\u4e0d\u80fd\u4e3a\u7a7a", (String)"FahReferenceFieldEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    }
                    ++rowIndex;
                }
                if (!error.isEmpty()) {
                    StringBuilder errorInfo = new StringBuilder();
                    int count = 0;
                    for (Map.Entry entry : error.entrySet()) {
                        errorInfo.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6570\u636e\u7684", (String)"FahReferenceFieldEdit_5", (String)"fi-ai-formplugin", (Object[])new Object[0]), entry.getKey()));
                        for (String info : (List)entry.getValue()) {
                            errorInfo.append(info).append("\uff0c");
                        }
                        errorInfo.deleteCharAt(errorInfo.length() - 1);
                        if (++count < error.size()) {
                            errorInfo.append("\uff1b\r\n");
                            continue;
                        }
                        errorInfo.append("\u3002\r\n");
                    }
                    this.getView().showTipNotification(errorInfo.toString());
                    return;
                }
                ArrayList<EvtReferenceFieldDto> data = new ArrayList<EvtReferenceFieldDto>(entity.size());
                String srcBillType = (String)this.getView().getFormShowParameter().getCustomParam("sourceBill");
                for (DynamicObject row : entity) {
                    EvtReferenceFieldDto fieldDto = new EvtReferenceFieldDto();
                    long entryId = row.getLong("entryid");
                    if (0L == entryId) {
                        entryId = DBServiceHelper.genLongIds((String)"t_fah_reference_field", (int)1)[0];
                    }
                    fieldDto.setId(entryId);
                    long reffFieldCfgId = row.getLong("reffieldcfgid");
                    if (0L == reffFieldCfgId) {
                        reffFieldCfgId = DBServiceHelper.genLongIds((String)"t_fah_dynextfld_valset", (int)1)[0];
                    }
                    fieldDto.setDynExtFldValSetId(reffFieldCfgId);
                    fieldDto.setSeq(Integer.valueOf(row.getInt("seq")));
                    fieldDto.setFieldName(row.getString("name"));
                    fieldDto.setCustomValue(row.getString(CUSTOM_VALUE_VAL));
                    fieldDto.setSrcBillType(srcBillType);
                    data.add(fieldDto);
                }
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(data));
                this.getView().close();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "customvalue": {
                String srcBill = (String)this.getView().getFormShowParameter().getCustomParam("sourceBill");
                if (StringUtils.isBlank((CharSequence)srcBill)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6765\u6e90\u5355\u636e\u3002", (String)"FahReferenceFieldEdit_6", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("ai_formula");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam("entitynumber", (Object)srcBill);
                this.getPageCache().put("srcMainEntityType", ((Object)((Object)this)).getClass().getSimpleName());
                this.getPageCache().put("build", srcBill);
                CacheBuildTree.setBuild((FormShowParameter)showParameter, (IPageCache)this.getPageCache());
                String funcsXML = this.getPageCache().get("functiontypes");
                if (StringUtils.isBlank((CharSequence)funcsXML)) {
                    FunctionTypes functionTypes = DapFunctionTypes.get((String)"type");
                    HashSet<String> functionTypeIds = new HashSet<String>(5);
                    functionTypeIds.add("GetMuliBaseData");
                    functionTypeIds.add("GetFieldValue");
                    functionTypeIds.add("GetSubEntryVerticalAssData");
                    functionTypeIds.add("GetACSourceBillPropertyValue");
                    functionTypeIds.add("GetSSCVoucherHandler");
                    functionTypeIds.add("GetOrgDutyByOrg");
                    FunctionTypes newfunctionTypes = new FunctionTypes();
                    newfunctionTypes.getFunctionGroups().addAll(functionTypes.getFunctionGroups());
                    for (FunctionType functionType : functionTypes.getFunctionTypes()) {
                        if (!functionTypeIds.contains(functionType.getId())) continue;
                        newfunctionTypes.getFunctionTypes().add(functionType);
                    }
                    funcsXML = FunctionTypes.serializeToXML((FunctionTypes)newfunctionTypes);
                    this.getPageCache().put("functiontypes", funcsXML);
                }
                String customValueVal = (String)this.getModel().getValue(CUSTOM_VALUE_VAL);
                showParameter.getCustomParams().put("formula", customValueVal);
                String entryNumber = (String)this.getView().getFormShowParameter().getCustomParam("entryNumber");
                if (StringUtils.isNotEmpty((CharSequence)entryNumber)) {
                    HashSet<String> entrySet = new HashSet<String>(2);
                    entrySet.add(srcBill);
                    MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)srcBill);
                    Map allEntities = mainEntityType.getAllEntities();
                    EntityType filterEntityType = (EntityType)allEntities.get(entryNumber);
                    if (filterEntityType instanceof SubEntryType) {
                        entrySet.add(filterEntityType.getName());
                        entrySet.add(filterEntityType.getParent().getName());
                    } else if (filterEntityType instanceof EntryType) {
                        entrySet.add(filterEntityType.getName());
                    }
                    showParameter.setCustomParam("entryFilterSet", (Object)SerializationUtils.serializeToBase64(entrySet));
                }
                showParameter.getCustomParams().put("functiontypes", funcsXML);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CUSTOM_VALUE));
                this.getView().showForm(showParameter);
                break;
            }
            case "valuesource": {
                String type = (String)this.getModel().getValue("type");
                if (StringUtils.isEmpty((CharSequence)type)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5b57\u6bb5\u7c7b\u578b\u3002", (String)"FahReferenceFieldEdit_7", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("fah_flex_struc_imput");
                showParameter.setCustomParam("fieldtype", (Object)type);
                if (DataValueTypeEnum.BaseProp.getCodeString().equals(type)) {
                    showParameter.setCustomParam("f7number", this.getModel().getValue(VALUE_SOURCE_VAL));
                } else if (DataValueTypeEnum.AssistProp.getCodeString().equals(type)) {
                    showParameter.setCustomParam("f7id", this.getModel().getValue(VALUE_SOURCE_VAL));
                }
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, VALUE_SOURCE));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String returnStr;
        super.closedCallBack(closedCallBackEvent);
        if (CUSTOM_VALUE.equals(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            returnStr = (String)closedCallBackEvent.getReturnData();
            if (StringUtils.isBlank((CharSequence)returnStr)) {
                this.getModel().setValue(CUSTOM_VALUE, (Object)"");
                this.getModel().setValue(CUSTOM_VALUE_VAL, (Object)"");
            } else {
                VchReturnData retData = (VchReturnData)SerializationUtils.fromJsonString((String)returnStr, VchReturnData.class);
                VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)retData.getDataStr(), VchTplExpression.class);
                this.getModel().setValue(CUSTOM_VALUE, (Object)filterObj.getExprDesc());
                this.getModel().setValue(CUSTOM_VALUE_VAL, (Object)retData.getDataStr());
            }
        }
        if (VALUE_SOURCE.equals(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            returnStr = (String)closedCallBackEvent.getReturnData();
            String valueSource = null;
            String valueSourceVal = null;
            if (StringUtils.isNotBlank((CharSequence)returnStr)) {
                Map retData = (Map)SerializationUtils.fromJsonString((String)returnStr, Map.class);
                if (DataValueTypeEnum.BaseProp.getCodeString().equals(retData.get("attDataType"))) {
                    valueSource = (String)retData.get("baseName");
                    valueSourceVal = (String)retData.get("baseNumber");
                } else if (DataValueTypeEnum.AssistProp.getCodeString().equals(retData.get("attDataType"))) {
                    valueSource = (String)retData.get("assGrpName");
                    valueSourceVal = String.valueOf(retData.get("assGrpId"));
                }
            }
            this.getModel().setValue(VALUE_SOURCE, valueSource);
            this.getModel().setValue(VALUE_SOURCE_VAL, valueSourceVal);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        IDataEntityProperty prop = e.getProperty();
        ChangeData changeData = e.getChangeSet()[0];
        switch (name = prop.getName()) {
            case "customvalue": {
                if (!StringUtils.isBlank((Object)changeData.getNewValue())) break;
                this.getModel().setValue(CUSTOM_VALUE_VAL, (Object)"");
                break;
            }
            case "valuesource": {
                if (!StringUtils.isBlank((Object)changeData.getNewValue())) break;
                this.getModel().setValue(VALUE_SOURCE_VAL, (Object)"");
                break;
            }
            case "type": {
                this.getModel().setValue(VALUE_SOURCE, (Object)"");
                this.getModel().setValue(VALUE_SOURCE_VAL, (Object)"");
                break;
            }
        }
    }
}

