/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.filter.FilterContainer;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.ai.enums.CheckBoxEnum;
import kd.fi.ai.enums.PermissonType;
import kd.fi.ai.util.ContextUtil;
import kd.fi.v2.fah.dao.event.FahRegBillDao;
import kd.fi.v2.fah.utils.FahSerializeHelper;
import kd.fi.v2.fah.utils.LicenseUtil;

public class FahRegBillList
extends AbstractListPlugin
implements BeforeFilterF7SelectListener {
    private static final String DISABLE_GEN_OR_DISPATCH_CONFIRM_CALL_BACK = "disable_gen_or_dispatch_confirm_call_back";
    private static final String DISABLE_GEN_OR_DISPATCH_CONFIRM_CALL_BACK_ID = "disable_gen_or_dispatch_confirm_call_back_id";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        LicenseUtil.checkFahLicenseWithTips((IFormView)this.getView());
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("srcbilltype")) {
            QFilter modeltypeQfilter = new QFilter("modeltype", "=", (Object)"BillFormModel");
            QFilter voucherQfilter = new QFilter("voucher", "=", (Object)CheckBoxEnum.TRUE.getValue());
            QFilter appFilter = new QFilter("bizappid.deploystatus", "=", (Object)"2");
            args.addCustomQFilter(modeltypeQfilter);
            args.addCustomQFilter(voucherQfilter);
            args.addCustomQFilter(appFilter);
        } else if (fieldName.startsWith("srcapp")) {
            QFilter appFilter = new QFilter("deploystatus", "=", (Object)"2");
            args.addCustomQFilter(appFilter);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbdisable"});
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if ("tbdisable".equals(itemKey)) {
            evt.setCancel(true);
            if (!PermissionServiceHelper.checkPermission((Long)ContextUtil.getUserId(), (String)"2FMS=8GUFGGN", (String)"fah_regbill", (String)PermissonType.DISABLE.getPermId())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5355\u636e\u63a5\u5165\u6ce8\u518c\u201d\u7684\u201c\u7981\u7528\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FahRegBillList_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                return;
            }
            List selectedIds = this.getSelectedRows().stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
            if (selectedIds.isEmpty()) {
                return;
            }
            Map idToSrcBillInfo = FahRegBillDao.queryBillInfoByIds(selectedIds);
            StringBuilder disableTips = new StringBuilder();
            LinkedList enableIds = new LinkedList();
            idToSrcBillInfo.forEach((id, dyObj) -> {
                if ("1".equals(dyObj.getString("enable"))) {
                    enableIds.add((Long)id);
                } else {
                    disableTips.append("\u201c").append(((DynamicObject)dyObj.get("srcbilltype")).getString("name")).append("\u201d");
                }
            });
            if (disableTips.length() > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e%s\u5df2\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"FahRegBillList_1", (String)"fi-ai-formplugin", (Object[])new Object[0]), disableTips));
            }
            if (enableIds.isEmpty()) {
                return;
            }
            HashMap<String, Tuple> bill2IdAndName = new HashMap<String, Tuple>();
            enableIds.forEach(id -> {
                DynamicObject srcBill = (DynamicObject)((DynamicObject)idToSrcBillInfo.get(id)).get("srcbilltype");
                bill2IdAndName.put(srcBill.getString("number"), new Tuple(id, (Object)srcBill.getString("name")));
            });
            Set hasGenOrDispatchRule = FahRegBillDao.hasGenOrDispatchRule(bill2IdAndName.keySet());
            if (hasGenOrDispatchRule.isEmpty()) {
                FahRegBillDao.updateEnable(enableIds, (String)"0");
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"FahRegBillList_3", (String)"fi-ai-formplugin", (Object[])new Object[0]), new Object[0]));
                ((BillList)this.getControl("billlistap")).refresh();
                return;
            }
            LinkedList hasGenOrDispatchIds = new LinkedList();
            LinkedList hasNotGenOrDispatchIds = new LinkedList();
            StringBuilder confirmDisableTip = new StringBuilder();
            bill2IdAndName.forEach((billType, idAndName) -> {
                if (hasGenOrDispatchRule.contains(billType)) {
                    hasGenOrDispatchIds.add(idAndName.item1);
                    confirmDisableTip.append("\u201c").append((String)idAndName.item2).append("\u201d");
                } else {
                    hasNotGenOrDispatchIds.add(idAndName.item1);
                }
            });
            if (!hasNotGenOrDispatchIds.isEmpty()) {
                FahRegBillDao.updateEnable(hasNotGenOrDispatchIds, (String)"0");
                ((BillList)this.getControl("billlistap")).refresh();
            }
            if (!hasGenOrDispatchIds.isEmpty()) {
                this.getPageCache().put(DISABLE_GEN_OR_DISPATCH_CONFIRM_CALL_BACK_ID, FahSerializeHelper.getInstance().toJSONString(hasGenOrDispatchIds));
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e%s\u5df2\u521b\u5efa\u4e8b\u4ef6\u89c4\u5219\u6216\u4e8b\u4ef6\u5206\u6d41\u89c4\u5219\uff0c\u786e\u8ba4\u7981\u7528\uff1f", (String)"FahRegBillList_2", (String)"fi-ai-formplugin", (Object[])new Object[0]), confirmDisableTip), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(DISABLE_GEN_OR_DISPATCH_CONFIRM_CALL_BACK, (IFormPlugin)this));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (DISABLE_GEN_OR_DISPATCH_CONFIRM_CALL_BACK.equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String idsStr = this.getPageCache().get(DISABLE_GEN_OR_DISPATCH_CONFIRM_CALL_BACK_ID);
            if (idsStr == null || idsStr.isEmpty()) {
                return;
            }
            LinkedList ids = (LinkedList)FahSerializeHelper.getInstance().parse(idsStr, LinkedList.class);
            if (ids.isEmpty()) {
                return;
            }
            FahRegBillDao.updateEnable((Collection)ids, (String)"0");
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"FahRegBillList_3", (String)"fi-ai-formplugin", (Object[])new Object[0]), new Object[0]));
            ((BillList)this.getControl("billlistap")).refresh();
        } else if (DISABLE_GEN_OR_DISPATCH_CONFIRM_CALL_BACK.equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Cancel) {
            this.getPageCache().remove(DISABLE_GEN_OR_DISPATCH_CONFIRM_CALL_BACK_ID);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection data = super.getData(start, limit);
                if (data.isEmpty()) {
                    return data;
                }
                for (int i = 0; i < data.size(); ++i) {
                    DynamicObject row = (DynamicObject)data.get(i);
                    String srcBill = ((DynamicObject)row.get("srcbilltype")).getString("number");
                    String orgField = row.getString("srcbillorgfield");
                    String statusField = row.getString("srcbillstatusfield");
                    String dateField = row.getString("keyfieldentry.srcbilldatefieldnum");
                    String statusKeys = row.getString("keyfieldentry.srcbillstatusval");
                    String vchWBField = row.getString("keyfieldentry.evtstatusfieldnum");
                    row.set("srcbillorgfield", (Object)FahRegBillList.this.getFieldName(srcBill, orgField));
                    row.set("srcbillstatusfield", (Object)FahRegBillList.this.getFieldName(srcBill, statusField));
                    row.set("keyfieldentry.srcbilldatefieldnum", (Object)FahRegBillList.this.getFieldName(srcBill, dateField));
                    row.set("keyfieldentry.srcbillstatusval", (Object)FahRegBillList.this.getSrcBillStatusName(srcBill, statusKeys, statusField));
                    row.set("keyfieldentry.evtstatusfieldnum", (Object)FahRegBillList.this.getFieldName(srcBill, vchWBField));
                }
                return data;
            }
        });
    }

    private String getFieldName(String sourceBill, String fieldKey) {
        if (sourceBill == null || sourceBill.isEmpty()) {
            return "";
        }
        if (fieldKey == null || fieldKey.isEmpty()) {
            return "";
        }
        MainEntityType srcBillType = MetadataServiceHelper.getDataEntityType((String)sourceBill);
        String billName = srcBillType.getDisplayName().getLocaleValue();
        Map allFields = srcBillType.getAllFields();
        if (!allFields.containsKey(fieldKey)) {
            return "";
        }
        return ((IDataEntityProperty)allFields.get(fieldKey)).getDisplayName().getLocaleValue();
    }

    private String getSrcBillStatusName(String sourceBill, String statusKey, String statusField) {
        if (sourceBill == null || sourceBill.isEmpty()) {
            return "";
        }
        if (statusKey == null || statusKey.isEmpty()) {
            return "";
        }
        MainEntityType billMainType = MetadataServiceHelper.getDataEntityType((String)sourceBill);
        if (billMainType == null) {
            return "";
        }
        DynamicProperty property = billMainType.getProperty(statusField);
        if (property == null) {
            return "";
        }
        String statusName = "";
        if (property instanceof ComboProp) {
            ComboProp prop = (ComboProp)property;
            for (ValueMapItem item : prop.getComboItems()) {
                if (!statusKey.equalsIgnoreCase(item.getValue())) continue;
                statusName = item.getName().toString();
                break;
            }
        } else if (property instanceof BooleanProp) {
            if ("1".equals(statusKey)) {
                statusName = ResManager.loadKDString((String)"\u662f", (String)"FahRegBillList_4", (String)"fi-ai-formplugin", (Object[])new Object[0]);
            } else if ("0".equals(statusKey)) {
                statusName = ResManager.loadKDString((String)"\u5426", (String)"FahRegBillList_5", (String)"fi-ai-formplugin", (Object[])new Object[0]);
            }
        }
        return statusName;
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent beforeFilterF7SelectEvent) {
        String fieldName = beforeFilterF7SelectEvent.getFieldName();
        if (fieldName.startsWith("srcbilltype")) {
            QFilter modeltypeQfilter = new QFilter("modeltype", "=", (Object)"BillFormModel");
            QFilter voucherQfilter = new QFilter("voucher", "=", (Object)CheckBoxEnum.TRUE.getValue());
            QFilter appFilter = new QFilter("bizappid.deploystatus", "=", (Object)"2");
            beforeFilterF7SelectEvent.addCustomQFilter(modeltypeQfilter);
            beforeFilterF7SelectEvent.addCustomQFilter(voucherQfilter);
            beforeFilterF7SelectEvent.addCustomQFilter(appFilter);
        } else if (fieldName.startsWith("srcapp")) {
            QFilter appFilter = new QFilter("deploystatus", "=", (Object)"2");
            beforeFilterF7SelectEvent.addCustomQFilter(appFilter);
        }
    }
}

