/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.LinkQueryPkId;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.v2.fah.constant.enums.event.BillDataProcessErrorCategoryEnum;
import kd.fi.v2.fah.dao.GenResultDao;
import kd.fi.v2.fah.utils.StringUtils;

public class FahReportList
extends AbstractListPlugin {
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        FormShowParameter paramete = this.getView().getFormShowParameter();
        String msgCode = (String)paramete.getCustomParam("msgCode");
        boolean isSkip = (Boolean)paramete.getCustomParam("isSkip");
        Long requestId = (Long)paramete.getCustomParam("requestId");
        MyListDataProvider listDataProvider = new MyListDataProvider(msgCode, isSkip, requestId);
        args.setListDataProvider((IListDataProvider)listDataProvider);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        if ("eventnumber".equals(args.getFieldName())) {
            ListShowParameter list;
            args.setCancel(true);
            ListSelectedRowCollection selectedRows = ((BillList)this.getView().getControl("billlistap")).getSelectedRows();
            LinkQueryPkIdCollection linkQueryPkIds = new LinkQueryPkIdCollection();
            for (Object pk : selectedRows.getPrimaryKeyValues()) {
                if (StringUtils.isEmpty((Object)pk)) continue;
                for (String id : String.valueOf(pk).split(",")) {
                    linkQueryPkIds.add((Object)new LinkQueryPkId((Object)Long.parseLong(id)));
                }
            }
            if (linkQueryPkIds.isEmpty()) {
                return;
            }
            if (linkQueryPkIds.size() > 1) {
                list = new ListShowParameter();
                list.setBillFormId("fah_event");
                list.setLinkQueryPkIdCollection(linkQueryPkIds);
                list.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)list);
            } else {
                list = new BillShowParameter();
                list.setFormId("fah_event");
                list.setPkId(((LinkQueryPkId)linkQueryPkIds.get(0)).getPkId());
                list.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)list);
            }
        }
    }

    private static class MyListDataProvider
    extends ListDataProvider {
        String msgCode;
        boolean isSkip;
        Long requestId;
        int count;

        public MyListDataProvider(String msgCode, boolean isSkip, Long requestId) {
            this.msgCode = msgCode;
            this.isSkip = isSkip;
            this.requestId = requestId;
            this.count = GenResultDao.getCount((boolean)isSkip, (String)msgCode, (Long)requestId);
        }

        public DynamicObjectCollection getData(int startIndex, int length) {
            DynamicObjectCollection rows = super.getData(startIndex, length);
            rows.clear();
            rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("billno", String.class, (Object)""));
            rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("eventnumber", String.class, (Object)""));
            rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("msgcode", String.class, (Object)""));
            rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("msg", String.class, (Object)""));
            rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("billid", String.class, (Object)""));
            HashSet<String> billTypes = new HashSet<String>(5);
            HashSet<Long> disPatchIds = new HashSet<Long>(5);
            HashSet<Long> billIds = new HashSet<Long>(16);
            for (Map row : GenResultDao.getDataByRequestId((boolean)this.isSkip, (String)this.msgCode, (Long)this.requestId, (int)startIndex, (int)length)) {
                DynamicObject rowData = new DynamicObject(rows.getDynamicObjectType());
                Long billId = (Long)row.get("billid");
                String billType = (String)row.get("billtype");
                billTypes.add(billType);
                billIds.add(billId);
                rowData.set("billtype", (Object)billType);
                rowData.set("billno", row.get("billno"));
                rowData.set("billid", (Object)billId);
                Long disPatchId = (Long)row.get("dispatch");
                rowData.set("dispatch", (Object)disPatchId);
                disPatchIds.add(disPatchId);
                rowData.set("msgcode", (Object)BillDataProcessErrorCategoryEnum.getBillStatusErrorByCode((String)((String)row.get("msgcode"))).getDesc().getDescription());
                rowData.set("msg", row.get("msg"));
                rows.add((Object)rowData);
            }
            Map billTypeMap = BusinessDataServiceHelper.loadFromCache((String)"bos_entityobject", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", billTypes)});
            Map disPatchMap = null;
            Map eventNumberMap = null;
            if (!this.isSkip) {
                disPatchMap = BusinessDataServiceHelper.loadFromCache((String)"fah_evt_dispatch_scheme", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", disPatchIds)});
                eventNumberMap = GenResultDao.getEventNumberByRequestId((Long)this.requestId, billTypes, billIds);
            }
            for (DynamicObject row : rows) {
                Set[] event;
                String billType = row.getString("billtype");
                long billId = row.getLong("billid");
                if (eventNumberMap != null && (event = (Set[])eventNumberMap.get(billType + billId)) != null && event.length != 0) {
                    row.set("eventnumber", (Object)String.join((CharSequence)",", event[0]));
                    row.set("id", (Object)String.join((CharSequence)",", event[1]));
                }
                if (disPatchMap != null) {
                    row.set("dispatch", disPatchMap.get(row.getLong("dispatch")));
                }
                if (billTypeMap == null) continue;
                row.set("billType", billTypeMap.get(row.getString("billType")));
            }
            return rows;
        }

        public int getRealCount() {
            return this.count;
        }

        public int getBillDataCount() {
            return this.count;
        }
    }
}

