/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.eventcenter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.VchReturnData;
import kd.fi.ai.VchTplExpression;
import kd.fi.v2.fah.dao.event.FahRegBillDao;
import kd.fi.v2.fah.models.event.mergerule.CustomSummaryFieldDto;

public class FahVchCustomSummaryMergeEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String Key_btnOK = "btnok";
    private static final String Key_btnCancel = "btncancel";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String CUSTOM_FILED = "customfiled";
    private static final String CUSTOM_FILED_VAL = "customfiledval";
    private static final String SRC_BILL = "srcbill";
    private static final String SRC_ID = "srcid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel, CUSTOM_FILED});
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(SRC_BILL);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        List dataList;
        super.afterCreateNewData(e);
        String data = (String)this.getView().getFormShowParameter().getCustomParam("data");
        if (StringUtils.isNotEmpty((CharSequence)data) && !(dataList = (List)SerializationUtils.deSerializeFromBase64((String)data)).isEmpty()) {
            this.getModel().deleteEntryData(ENTRY_ENTITY);
            this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, dataList.size());
            for (int i = 0; i < dataList.size(); ++i) {
                CustomSummaryFieldDto filedDto = (CustomSummaryFieldDto)dataList.get(i);
                this.getModel().setValue(SRC_ID, (Object)filedDto.getEntryId(), i);
                this.getModel().setValue(SRC_BILL, (Object)filedDto.getSrcBillType(), i);
                this.getModel().setValue(CUSTOM_FILED_VAL, (Object)filedDto.getCustomField(), i);
                this.getModel().setValue(CUSTOM_FILED, (Object)filedDto.getCustomFieldDesc(), i);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        switch (ctlSource.getKey()) {
            case "btnok": {
                DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRY_ENTITY);
                if (entity.isEmpty()) {
                    this.getView().returnDataToParent((Object)SerializationUtils.serializeToBase64(Collections.emptyList()));
                    this.getView().close();
                    return;
                }
                int rowIndex = 1;
                LinkedHashMap<Integer, List> error = new LinkedHashMap<Integer, List>();
                ArrayList<CustomSummaryFieldDto> data = new ArrayList<CustomSummaryFieldDto>(entity.size());
                for (DynamicObject row : entity) {
                    DynamicObject srcBill = row.getDynamicObject(SRC_BILL);
                    String customFiledVal = row.getString(CUSTOM_FILED_VAL);
                    if (null == srcBill) {
                        error.computeIfAbsent(rowIndex, t -> new ArrayList()).add(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u4e3a\u7a7a", (String)"FahVchCustomSummaryMergeEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    }
                    if (StringUtils.isEmpty((CharSequence)customFiledVal)) {
                        error.computeIfAbsent(rowIndex, t -> new ArrayList()).add(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5b57\u6bb5\u4e3a\u7a7a", (String)"FahVchCustomSummaryMergeEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    }
                    if (null != srcBill && StringUtils.isNotEmpty((CharSequence)customFiledVal)) {
                        data.add(new CustomSummaryFieldDto(Long.valueOf(row.getLong(SRC_ID)), srcBill.getString("id"), srcBill.getString("name"), customFiledVal, row.getString(CUSTOM_FILED)));
                    }
                    ++rowIndex;
                }
                if (!error.isEmpty()) {
                    StringBuilder errorInfo = new StringBuilder();
                    int count = 0;
                    for (Map.Entry entry : error.entrySet()) {
                        errorInfo.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6570\u636e\u7684", (String)"FahVchCustomSummaryMergeEdit_3", (String)"fi-ai-formplugin", (Object[])new Object[0]), entry.getKey()));
                        for (String info : (List)entry.getValue()) {
                            errorInfo.append(info).append("\uff0c");
                        }
                        errorInfo.deleteCharAt(errorInfo.length() - 1);
                        if (++count < error.size()) {
                            errorInfo.append("\uff1b\r\n");
                            continue;
                        }
                        errorInfo.append("\u3002\r\n");
                    }
                    this.getView().showTipNotification(errorInfo.toString());
                    return;
                }
                this.getView().returnDataToParent((Object)SerializationUtils.serializeToBase64(data));
                this.getView().close();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "customfiled": {
                DynamicObject srcBill = (DynamicObject)this.getModel().getValue(SRC_BILL);
                if (null == srcBill) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6765\u6e90\u5355\u636e\u3002", (String)"FahVchCustomSummaryMergeEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showCustomFiled(srcBill);
                break;
            }
        }
    }

    private void showCustomFiled(DynamicObject srcBill) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ai_expression");
        String sourceBill = srcBill.getString("id");
        showParameter.setCustomParam("build", (Object)sourceBill);
        showParameter.setCustomParam("entitynumber", (Object)sourceBill);
        showParameter.setCustomParam("isHideOperation", (Object)Boolean.TRUE);
        HashSet<String> entrySet = new HashSet<String>(1);
        if (null == sourceBill) {
            return;
        }
        entrySet.add(sourceBill);
        showParameter.setCustomParam("entryFilterSet", (Object)SerializationUtils.serializeToBase64(entrySet));
        showParameter.setCustomParam("addSpecialNodes", (Object)Boolean.FALSE);
        String expressionDesc = (String)this.getModel().getValue(CUSTOM_FILED);
        String expression = (String)this.getModel().getValue(CUSTOM_FILED_VAL);
        VchTplExpression exprObj = new VchTplExpression();
        exprObj.setExprType(ExpressionType.DynamicText);
        exprObj.setExpression(expression);
        LocaleString description = new LocaleString();
        description.put(Lang.defaultLang().toString(), (Object)expressionDesc);
        exprObj.setDescription(description);
        String exprJson = SerializationUtils.toJsonString((Object)exprObj);
        showParameter.setCustomParam("expression", (Object)exprJson);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CUSTOM_FILED);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (CUSTOM_FILED.equals(closedCallBackEvent.getActionId())) {
            this.receiveExpressionSet(closedCallBackEvent);
        }
    }

    private void receiveExpressionSet(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() != null) {
            String returnStr = (String)closedCallBackEvent.getReturnData();
            if (StringUtils.isBlank((CharSequence)returnStr)) {
                this.getModel().setValue(CUSTOM_FILED_VAL, (Object)"");
                this.getModel().setValue(CUSTOM_FILED, (Object)"");
            } else {
                VchReturnData retData = (VchReturnData)SerializationUtils.fromJsonString((String)returnStr, VchReturnData.class);
                VchTplExpression filterObj = (VchTplExpression)SerializationUtils.fromJsonString((String)retData.getDataStr(), VchTplExpression.class);
                this.getModel().setValue(CUSTOM_FILED_VAL, (Object)filterObj.getExpression());
                LocaleString localeString = filterObj.getDescription();
                if (null != localeString) {
                    String description = localeString.toString();
                    if (description.length() > 200) {
                        description = description.substring(0, 197) + "...";
                    }
                    this.getModel().setValue(CUSTOM_FILED, (Object)description);
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty prop = e.getProperty();
        ChangeData changeData = e.getChangeSet()[0];
        if (CUSTOM_FILED.equals(prop.getName()) && StringUtils.isBlank((Object)changeData.getNewValue())) {
            this.getModel().setValue(CUSTOM_FILED_VAL, (Object)"");
        }
        if (SRC_BILL.equals(prop.getName())) {
            this.getModel().setValue(SRC_ID, null);
            this.getModel().setValue(CUSTOM_FILED, (Object)"");
            this.getModel().setValue(CUSTOM_FILED_VAL, (Object)"");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (SRC_BILL.equals(key)) {
            DynamicObjectCollection entity;
            Set srcBillTypes = FahRegBillDao.getRegBillNumbers();
            if (!srcBillTypes.isEmpty() && !(entity = this.getModel().getEntryEntity(ENTRY_ENTITY)).isEmpty()) {
                srcBillTypes.removeAll(entity.stream().map(e -> e.getString("srcbill.id")).collect(Collectors.toSet()));
            }
            ListShowParameter list = (ListShowParameter)evt.getFormShowParameter();
            list.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)srcBillTypes));
        }
    }
}

