/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.extdata;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.botp.ConditionEdit;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.formula.excel.FormulaException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.util.DapEntityTypeUtil;
import kd.fi.ai.util.EntityFieldTreeOption;
import kd.fi.ai.util.EntityFieldTreeResult;
import kd.fi.ai.util.EntityTreeUtil;
import kd.fi.v2.fah.models.modeling.impl.DataModelCfg;
import kd.fi.v2.fah.utils.DataModelMetaUtils;
import kd.fi.v2.fah.utils.StringUtils;

public class FahExtDataConditionEdit
extends ConditionEdit {
    private static Log logger = LogFactory.getLog(FahExtDataConditionEdit.class);

    public void afterCreateNewData(EventObject e) {
        MainEntityType dataModel = this.getDataModel();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        boolean readEntry = Objects.equals(customParams.get("readentry"), "true");
        List filterColumns = DapEntityTypeUtil.getFilterColumns((IDataEntityType)dataModel, (boolean)false, (boolean)readEntry);
        customParams.put("treenodes", this.setFieldNodes(dataModel, readEntry));
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("ffiltergrid");
        filterGrid.setFilterColumns(filterColumns);
        super.afterCreateNewData(e);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = 1; i < 10; ++i) {
            if (stackTrace[i].toString().indexOf("kd.bos.form.control.FilterGrid.getMainEntityType") != 0) continue;
            e.setNewEntityType(this.getDataModel());
            return;
        }
    }

    public void click(EventObject evt) {
        try {
            IDataModel model = this.getModel();
            Control ctlSource = (Control)evt.getSource();
            MainEntityType type = this.getModel().getDataEntityType();
            if (!type.getName().equals("ai_condition")) {
                Field field = model.getClass().getSuperclass().getDeclaredField("mainEntityType");
                ReflectionUtils.makeAccessible((Field)field);
                field.set(model, null);
            }
            if ("btnok".equalsIgnoreCase(ctlSource.getKey())) {
                this.checkOutEntry();
            } else {
                super.click(evt);
            }
        }
        catch (Throwable e) {
            logger.error(e);
        }
    }

    private void checkOutEntry() {
        String conditonJson = "";
        CRFormula formulaObj = this.deserialize(conditonJson);
        this.getFormulaObj(formulaObj);
        try {
            String tranExpr = this.tranFormula(formulaObj);
            formulaObj.setExprTran(tranExpr);
        }
        catch (FormulaException exp) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a\u201c%s\u201d\u3002", (String)"FahExtDataConditionEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]), exp.getCause() != null ? exp.getCause().getMessage() : exp.getMessage()));
            return;
        }
        catch (Throwable exp) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a\u201c%s\u201d\u3002", (String)"FahExtDataConditionEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]), exp.getMessage()));
            return;
        }
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)formulaObj));
        this.getView().close();
    }

    private MainEntityType getDataModel() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DynamicObject dyo = (DynamicObject)DynamicObjectSerializeUtil.deserialize((String)(customParams.get("entityInfo") + ""), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fah_ext_datamodel"))[0];
        DataModelCfg extDatamodel = (DataModelCfg)SerializationUtils.deSerializeFromBase64((String)((String)customParams.get("datamodel")));
        if (StringUtils.isEmpty((Object)dyo.get("number"))) {
            dyo.set("number", (Object)"001");
        }
        return DataModelMetaUtils.getEntityTypeForDyn((DynamicObject)dyo, (DataModelCfg)extDatamodel);
    }

    protected String tranFormula(CRFormula formulaObj) {
        String tranExpr = this.tranExpression(formulaObj.getExpression());
        MainEntityType mainType = this.getDataModel();
        FilterCondition filterCondition = ((CRCondition)formulaObj).getFilterCondition();
        if (filterCondition != null && filterCondition.getFilterRow().size() > 0) {
            FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
            String[] scripts = filterBuilder.buildFilterScript();
            ArrayList<String> descs = new ArrayList<String>();
            if (StringUtils.isNotEmpty((String)scripts[1])) {
                descs.add(scripts[1]);
            }
            if (StringUtils.isNotEmpty((String)tranExpr)) {
                descs.add(tranExpr);
            }
            tranExpr = StringUtils.join((Object[])descs.toArray(), (String)ResManager.loadKDString((String)"\u4e14", (String)"FahExtDataConditionEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        }
        return tranExpr;
    }

    private String setFieldNodes(MainEntityType entityType, boolean readEntry) {
        EntityFieldTreeOption option = EntityFieldTreeOption.create();
        option.setEntityType((IDataEntityType)entityType);
        option.setReadEntryEntity(readEntry);
        option.setExprType(ExpressionType.Condition);
        option.setFieldType(null);
        EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
        TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
        return SerializationUtils.toJsonString((Object)tree);
    }
}

