/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.extdata;

import java.lang.reflect.InvocationTargetException;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.fi.ai.cache.CacheHelper;
import kd.fi.ai.cache.CacheModule;
import kd.fi.ai.cache.DistributeCache;
import kd.fi.v2.fah.constant.FormBuilderConstant;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;
import kd.fi.v2.fah.formbuilder.DynamicFormConfig;
import kd.fi.v2.fah.formbuilder.builder.DynamicFormConfigBuilder;
import kd.fi.v2.fah.formbuilder.builder.DynamicFormModelBuilder;
import kd.fi.v2.fah.utils.FahSerializeHelper;
import kd.fi.v2.fah.utils.StringUtils;

public class FahExtDataModelPVProgress
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(FahExtDataModelPVProgress.class);
    public static final String FAH_EXT_DMPV_PROGRESS = "fah_ext_dmpv_progress";
    private static final String KEY_PVPROGRESS = "pvprogress";
    private static final String KEY_TIPLABEL = "tiplabel";
    private static final String VIEW_RESULT_SUFFIX = "VIEW_RESULT";
    private static final String IS_FINISH_SUFFIX = "IS_FINISH";
    public static final String PARAM_PAGE_ID = "pageId";
    public static final String PARAM_MODEL_ID = "modelId";
    public static final String PARAM_MASTER_ID = "masterId";
    public static final String PARAM_PREVIEW_FORM_NUMBER = "preViewFormNumber";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PVPROGRESS);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PVPROGRESS);
        bar.start();
    }

    public void onProgress(ProgressEvent progressEvent) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String pageId = (String)customParams.get(PARAM_PAGE_ID);
        Long modelId = (Long)customParams.get(PARAM_MODEL_ID);
        String progressKey = pageId + modelId + KEY_PVPROGRESS;
        String finishKey = pageId + modelId + IS_FINISH_SUFFIX;
        DistributeCache disCache = CacheHelper.getDistributeCache((CacheModule)CacheModule.EXTDATAMODEL_PREVIEW);
        String progressCache = disCache.get(progressKey);
        int curProgress = 0;
        if (StringUtils.isEmpty((String)progressCache)) {
            curProgress = 1;
            disCache.put(progressKey, String.valueOf(curProgress));
            disCache.put(finishKey, "false");
            Long masterId = (Long)customParams.get(PARAM_MASTER_ID);
            ThreadPools.executeOnce((String)FAH_EXT_DMPV_PROGRESS, () -> this.asynPreViewExtDataModel(disCache, pageId, modelId, masterId));
        } else {
            String isFinish = disCache.get(finishKey);
            if ("true".equals(isFinish)) {
                this.finishPreView(disCache, pageId, modelId);
                curProgress = 100;
            } else {
                curProgress = ObjectConverterFactory.getInteger((Object)progressCache, (Integer)progressEvent.getProgress());
            }
        }
        progressEvent.setProgress(curProgress);
    }

    private void asynPreViewExtDataModel(DistributeCache disCache, String pageId, Long modelId, Long masterId) {
        DynamicFormConfig config = DynamicFormConfigBuilder.createDynamicFormConfig((Long)modelId, (String)FormBuilderConstant.BIZ_APP_ID, (boolean)false, (boolean)false);
        if (null != config) {
            DataModelDaoImpl.clearErrorMeta((String)config.getFormNumber());
            disCache.put(pageId + modelId + KEY_PVPROGRESS, String.valueOf(10));
            Map result = null;
            try {
                result = DynamicFormModelBuilder.createDynamicForm((DynamicFormConfig)config);
                if (result != null) {
                    result.put(PARAM_MASTER_ID, masterId);
                    result.put(PARAM_PREVIEW_FORM_NUMBER, config.getFormNumber());
                }
                disCache.put(pageId + modelId + KEY_PVPROGRESS, String.valueOf(99));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                logger.error((Throwable)e);
            }
            String resultJson = FahSerializeHelper.toJsonString((Object)result);
            disCache.put(pageId + modelId + VIEW_RESULT_SUFFIX, resultJson == null ? "" : resultJson);
            disCache.put(pageId + modelId + IS_FINISH_SUFFIX, "true");
        }
    }

    private void finishPreView(DistributeCache disCache, String pageId, Long modelId) {
        Label tipLabel = (Label)this.getView().getControl(KEY_TIPLABEL);
        tipLabel.setText(ResManager.loadKDString((String)"\u9884\u89c8\u6570\u636e\u52a0\u8f7d\u5b8c\u6bd5\u3002", (String)"FahExtDataModelPVProgress_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        String preViewResult = disCache.get(pageId + modelId + VIEW_RESULT_SUFFIX);
        this.getView().returnDataToParent((Object)preViewResult);
        this.clearCache(disCache, pageId, modelId);
        this.getView().close();
    }

    private void clearCache(DistributeCache disCache, String pageId, Long modelId) {
        disCache.remove(pageId + modelId + IS_FINISH_SUFFIX);
        disCache.remove(pageId + modelId + VIEW_RESULT_SUFFIX);
        disCache.remove(pageId + modelId + KEY_PVPROGRESS);
    }
}

