/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.extdata;

import java.util.EventObject;
import java.util.Objects;
import java.util.function.Consumer;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;
import kd.fi.v2.fah.utils.LicenseUtil;

public class FahExtDataModelRelation
extends AbstractFormPlugin
implements Consumer<BeforeF7ViewDetailEvent> {
    private static final String DATAMODELMASTERID = "dataModelMasterId";
    private static final String PREDATAMODELMASTERID = "preDataModelMasterId";
    private static final String PRESTATUS = "prestatus";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"datafieldshow", "predatafieldshow"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit dataModel = (BasedataEdit)this.getView().getControl("datamodel");
        dataModel.addBeforeF7ViewDetailListener((Consumer)this);
        BasedataEdit preDataModel = (BasedataEdit)this.getView().getControl("predatamodel");
        preDataModel.addBeforeF7ViewDetailListener((Consumer)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.isEdit()) {
            Long dataModelId = ((DynamicObject)this.getModel().getValue("datamodel")).getLong("masterid");
            Long preDataModelId = ((DynamicObject)this.getModel().getValue("predatamodel")).getLong("masterid");
            this.getPageCache().put(DATAMODELMASTERID, String.valueOf(dataModelId));
            this.getPageCache().put(PREDATAMODELMASTERID, String.valueOf(preDataModelId));
            this.getPageCache().put(PRESTATUS, String.valueOf(this.getModel().getValue(PRESTATUS)));
            String dataModelNumber = (String)this.getModel().getValue("datafield");
            ORM orm = ORM.create();
            DynamicObjectCollection datamodel = orm.query("fah_ext_dataentry", "id,name", new QFilter[]{new QFilter("model.masterid", "=", (Object)dataModelId).and(new QFilter("number", "=", (Object)dataModelNumber))}, "model.status desc,model.versionnum desc", 1);
            if (!datamodel.isEmpty()) {
                this.getModel().setValue("datafieldshow", (Object)(dataModelNumber + "," + ((DynamicObject)datamodel.get(0)).getString("name")));
            } else {
                this.getModel().setValue("datafieldshow", (Object)dataModelNumber);
            }
            String preDataModelNumber = (String)this.getModel().getValue("predatafield");
            DynamicObjectCollection preDatamodel = orm.query("fah_ext_dataentry", "id,name", new QFilter[]{new QFilter("model.masterid", "=", (Object)preDataModelId).and(new QFilter("number", "=", (Object)preDataModelNumber))}, "model.status desc,model.versionnum desc", 1);
            if (!preDatamodel.isEmpty()) {
                this.getModel().setValue("predatafieldshow", (Object)(preDataModelNumber + "," + ((DynamicObject)preDatamodel.get(0)).getString("name")));
            } else {
                this.getModel().setValue("predatafieldshow", (Object)preDataModelNumber);
            }
            this.getView().getModel().setDataChanged(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        IDataModel iDataModel = this.getModel();
        if ("datamodel".equals(propertyName)) {
            if (newValue != null && iDataModel.getValue("predatamodel") != null && ((DynamicObject)newValue).getLong("masterid") == ((DynamicObject)iDataModel.getValue("predatamodel")).getLong("masterid")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u6a21\u578b\u4e0e\u524d\u7f6e\u5916\u90e8\u6570\u636e\u6a21\u578b\u4e0d\u80fd\u8bbe\u7f6e\u4e3a\u540c\u4e00\u6a21\u578b\u3002", (String)"FahExtDataModelRelation_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                iDataModel.setValue("datamodel", oldValue);
            } else if (newValue == null || oldValue == null || ((DynamicObject)newValue).getLong("masterid") != ((DynamicObject)oldValue).getLong("masterid")) {
                iDataModel.setValue("datafieldshow", null);
            }
        } else if ("predatamodel".equals(propertyName)) {
            if (newValue != null && iDataModel.getValue("datamodel") != null && ((DynamicObject)newValue).getLong("masterid") == ((DynamicObject)iDataModel.getValue("datamodel")).getLong("masterid")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u6a21\u578b\u4e0e\u524d\u7f6e\u5916\u90e8\u6570\u636e\u6a21\u578b\u4e0d\u80fd\u8bbe\u7f6e\u4e3a\u540c\u4e00\u6a21\u578b\u3002", (String)"FahExtDataModelRelation_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                iDataModel.setValue("predatamodel", oldValue);
            } else if (newValue == null || oldValue == null || ((DynamicObject)newValue).getLong("masterid") != ((DynamicObject)oldValue).getLong("masterid")) {
                iDataModel.setValue("predatafieldshow", null);
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("datafieldshow".equals(key)) {
            if (this.getModel().getValue("datamodel") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5916\u90e8\u6570\u636e\u6a21\u578b\u3002", (String)"FahExtDataModelRelation_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        } else if ("predatafieldshow".equals(key) && this.getModel().getValue("predatamodel") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u524d\u7f6e\u5916\u90e8\u6570\u636e\u6a21\u578b\u3002", (String)"FahExtDataModelRelation_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operateInfo = (FormOperate)args.getSource();
        RefObject afterConfirm = new RefObject();
        if (operateInfo.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) {
            if (this.isEdit()) {
                DataModelDaoImpl.deleteEventBlock((Long)Long.parseLong(this.getPageCache().get(PREDATAMODELMASTERID)), (Long)Long.parseLong(this.getPageCache().get(DATAMODELMASTERID)), (String)this.getPageCache().get(PRESTATUS));
            }
            return;
        }
        if (operateInfo instanceof Save) {
            LicenseUtil.checkFahLicenseWithTips((IFormView)this.getView());
            Long dataModelMasterId = ((DynamicObject)this.getModel().getValue("datamodel")).getLong("masterid");
            String fieldNumber = (String)this.getModel().getValue("datafield");
            Long predataModelMasterId = ((DynamicObject)this.getModel().getValue("predatamodel")).getLong("masterid");
            String preFieldNumber = (String)this.getModel().getValue("predatafield");
            String prestatus = (String)this.getModel().getValue(PRESTATUS);
            SqlBuilder checkSql = new SqlBuilder();
            checkSql.append("select fid from t_ai_preevent where fid = ?", new Object[]{dataModelMasterId}).append(" and fpreeventclass = ?", new Object[]{predataModelMasterId}).append(" and fprestatus <> ?", new Object[]{prestatus});
            SqlBuilder excludeSql = new SqlBuilder();
            excludeSql.append(" and fentryid <> ?", new Object[]{this.getModel().getValue("id")});
            if (this.isEdit()) {
                checkSql.appendSqlBuilder(excludeSql);
            }
            try (DataSet data = DataModelDaoImpl.checkRelation((String)this.getClass().getName(), (SqlBuilder)checkSql);){
                if (data.hasNext()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u76f8\u540c\u7684\u6a21\u578b\u548c\u524d\u7f6e\u6a21\u578b\u4ec5\u652f\u6301\u914d\u7f6e\u4e00\u79cd\u72b6\u6001\u3002", (String)"FahExtDataModelRelation_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            checkSql = new SqlBuilder();
            checkSql.append("select fid from t_ai_preevent where fid = ?", new Object[]{dataModelMasterId}).append(" and fpreeventclass = ?", new Object[]{predataModelMasterId}).append(" and fevtfield = ?", new Object[]{fieldNumber}).append(" and fpreevtfield = ?", new Object[]{preFieldNumber});
            if (this.isEdit()) {
                checkSql.appendSqlBuilder(excludeSql);
            }
            data = DataModelDaoImpl.checkRelation((String)this.getClass().getName(), (SqlBuilder)checkSql);
            var12_12 = null;
            try {
                if (data.hasNext()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u6837\u7684\u5b57\u6bb5\u5173\u7cfb\u5728\u4e24\u4e2a\u6a21\u578b\u4e4b\u95f4\u4ec5\u652f\u6301\u914d\u7f6e\u4e00\u6b21\u3002", (String)"FahExtDataModelRelation_4", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            catch (Throwable throwable) {
                var12_12 = throwable;
                throw throwable;
            }
            finally {
                if (data != null) {
                    if (var12_12 != null) {
                        try {
                            data.close();
                        }
                        catch (Throwable throwable) {
                            var12_12.addSuppressed(throwable);
                        }
                    } else {
                        data.close();
                    }
                }
            }
            String fieldType = this.getFieldType(dataModelMasterId, fieldNumber);
            String preFieldType = this.getFieldType(predataModelMasterId, preFieldNumber);
            if (!Objects.equals(fieldType, preFieldType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u5b57\u6bb5\u7684\u7c7b\u578b\u9700\u8981\u6821\u9a8c\u4e00\u81f4\u3002", (String)"FahExtDataModelRelation_5", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject dataModelForMasterid = BusinessDataServiceHelper.loadSingle((String)"fah_ext_datamodel", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dataModelMasterId)});
            DynamicObject predatamodelForMasterid = BusinessDataServiceHelper.loadSingle((String)"fah_ext_datamodel", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)predataModelMasterId)});
            this.getModel().setValue("datamodel", (Object)dataModelForMasterid);
            this.getModel().setValue("predatamodel", (Object)predatamodelForMasterid);
            if (this.isEdit()) {
                String message = ResManager.loadKDString((String)"\u4fee\u6539\u5173\u7cfb\u540e\uff0c\u4f1a\u6309\u7167\u65b0\u7684\u5173\u7cfb\u8fdb\u884c\u6821\u9a8c\uff0c\u786e\u8ba4\u662f\u5426\u4fee\u6539\uff1f", (String)"FahExtDataModelRelation_6", (String)"fi-ai-formplugin", (Object[])new Object[0]);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("isEdit", (IFormPlugin)this);
                this.getView().showConfirm(message, MessageBoxOptions.OKCancel, ConfirmTypes.Wait, confirmCallBacks);
                args.setCancel(true);
            }
        }
    }

    private String getFieldType(Long dataModelMasterId, String fieldNumber) {
        SqlBuilder checkSql = new SqlBuilder();
        checkSql.append(" SELECT DISTINCT field.fdatatype fdatatype FROM t_fah_ext_modflds field", new Object[0]).append(" INNER JOIN t_ai_eventclass eventclass ON field.fmodelid =eventclass.fid", new Object[0]).append(" WHERE eventclass.fmasterid =?", new Object[]{dataModelMasterId}).append(" AND (eventclass.flatestversion = '1' AND eventclass.fstatus = 'C') ", new Object[0]).append(" AND field.fnumber =?", new Object[]{fieldNumber});
        try (DataSet data = DataModelDaoImpl.checkRelation((String)this.getClass().getName(), (SqlBuilder)checkSql);){
            if (data.hasNext()) {
                String string = (String)data.next().get("fdatatype");
                return string;
            }
            String string = "";
            return string;
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (StringUtils.equals((CharSequence)"isEdit", (CharSequence)evt.getCallBackId()) && evt.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            this.getView().invokeOperation("save", operateOption);
        }
    }

    private boolean isEdit() {
        return OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus());
    }

    public void click(EventObject evt) {
        DynamicObjectCollection dataModels;
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        IDataModel dataModel = this.getModel();
        if ("datafieldshow".equals(key)) {
            dataModels = QueryServiceHelper.query((String)"fah_ext_datamodel", (String)"id", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)((DynamicObject)dataModel.getValue("datamodel")).getLong("masterid"))}, (String)"status desc,versionnum desc", (int)1);
        } else if ("predatafieldshow".equals(key)) {
            dataModels = QueryServiceHelper.query((String)"fah_ext_datamodel", (String)"id", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)((DynamicObject)dataModel.getValue("predatamodel")).getLong("masterid"))}, (String)"status desc,versionnum desc", (int)1);
        } else {
            return;
        }
        DynamicObject extDataModel = (DynamicObject)dataModels.get(0);
        FormShowParameter param = new FormShowParameter();
        param.setFormId("fah_ext_model_select");
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "FahExtDataModelRelation"));
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("CONTROL_KEY", (Object)key);
        param.setCustomParam("datamodel", (Object)SerializationUtils.serializeToBase64((Object)DataModelDaoImpl.loadFromDBById((Long)extDataModel.getLong("id"))));
        this.getView().showForm(param);
    }

    public void closedCallBack(ClosedCallBackEvent backEvent) {
        String[] returnData;
        super.closedCallBack(backEvent);
        if ("FahExtDataModelRelation".equals(backEvent.getActionId()) && backEvent.getReturnData() != null && (returnData = (String[])SerializationUtils.fromJsonString((String)((String)backEvent.getReturnData()), String[].class)) != null) {
            this.getModel().setValue(returnData[0].substring(0, returnData[0].length() - 4), (Object)returnData[1]);
            this.getModel().setValue(returnData[0], (Object)(returnData[1] + "," + returnData[2]));
        }
    }

    @Override
    public void accept(BeforeF7ViewDetailEvent evt) {
        DynamicObjectCollection dataModels;
        evt.setCancel(true);
        Object dataModel = this.getModel().getValue(((BasedataEdit)evt.getSource()).getKey());
        Long dataModelMasterId = 0L;
        if (dataModel != null) {
            dataModelMasterId = ((DynamicObject)dataModel).getLong("masterid");
        }
        if ((dataModels = QueryServiceHelper.query((String)"fah_ext_datamodel", (String)"id", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)dataModelMasterId)}, (String)"status desc,versionnum desc", (int)1)) == null || dataModels.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u578b\u4e0d\u5b58\u5728\u3002", (String)"FahExtDataModelRelation_7", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParameter = new BillShowParameter();
        Long dataModelId = ((DynamicObject)dataModels.get(0)).getLong("id");
        showParameter.setFormId("fah_ext_datamodel");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("id", (Object)dataModelId);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

